/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;
import sun.util.locale.provider.LocaleServiceProviderPool;
import sun.util.spi.CalendarProvider;

public abstract class AuxLocaleProviderAdapter
extends LocaleProviderAdapter {
    private ConcurrentMap<Class<? extends LocaleServiceProvider>, LocaleServiceProvider> providersMap = new ConcurrentHashMap<Class<? extends LocaleServiceProvider>, LocaleServiceProvider>();
    private static Locale[] availableLocales = null;
    private static NullProvider NULL_PROVIDER = new NullProvider();

    @Override
    public <P extends LocaleServiceProvider> P getLocaleServiceProvider(Class<P> clazz) {
        LocaleServiceProvider localeServiceProvider = (LocaleServiceProvider)this.providersMap.get(clazz);
        if (localeServiceProvider == null) {
            localeServiceProvider = this.findInstalledProvider(clazz);
            this.providersMap.putIfAbsent(clazz, localeServiceProvider == null ? NULL_PROVIDER : localeServiceProvider);
        }
        return (P)localeServiceProvider;
    }

    protected abstract <P extends LocaleServiceProvider> P findInstalledProvider(Class<P> var1);

    @Override
    public BreakIteratorProvider getBreakIteratorProvider() {
        return this.getLocaleServiceProvider(BreakIteratorProvider.class);
    }

    @Override
    public CollatorProvider getCollatorProvider() {
        return this.getLocaleServiceProvider(CollatorProvider.class);
    }

    @Override
    public DateFormatProvider getDateFormatProvider() {
        return this.getLocaleServiceProvider(DateFormatProvider.class);
    }

    @Override
    public DateFormatSymbolsProvider getDateFormatSymbolsProvider() {
        return this.getLocaleServiceProvider(DateFormatSymbolsProvider.class);
    }

    @Override
    public DecimalFormatSymbolsProvider getDecimalFormatSymbolsProvider() {
        return this.getLocaleServiceProvider(DecimalFormatSymbolsProvider.class);
    }

    @Override
    public NumberFormatProvider getNumberFormatProvider() {
        return this.getLocaleServiceProvider(NumberFormatProvider.class);
    }

    @Override
    public CurrencyNameProvider getCurrencyNameProvider() {
        return this.getLocaleServiceProvider(CurrencyNameProvider.class);
    }

    @Override
    public LocaleNameProvider getLocaleNameProvider() {
        return this.getLocaleServiceProvider(LocaleNameProvider.class);
    }

    @Override
    public TimeZoneNameProvider getTimeZoneNameProvider() {
        return this.getLocaleServiceProvider(TimeZoneNameProvider.class);
    }

    @Override
    public CalendarDataProvider getCalendarDataProvider() {
        return this.getLocaleServiceProvider(CalendarDataProvider.class);
    }

    @Override
    public CalendarNameProvider getCalendarNameProvider() {
        return this.getLocaleServiceProvider(CalendarNameProvider.class);
    }

    @Override
    public CalendarProvider getCalendarProvider() {
        return this.getLocaleServiceProvider(CalendarProvider.class);
    }

    @Override
    public LocaleResources getLocaleResources(Locale locale) {
        return null;
    }

    @Override
    public Locale[] getAvailableLocales() {
        if (availableLocales == null) {
            HashSet<Locale> hashSet = new HashSet<Locale>();
            for (Class<LocaleServiceProvider> clazz : LocaleServiceProviderPool.spiClasses) {
                LocaleServiceProvider localeServiceProvider = this.getLocaleServiceProvider(clazz);
                if (localeServiceProvider == null) continue;
                hashSet.addAll(Arrays.asList(localeServiceProvider.getAvailableLocales()));
            }
            availableLocales = hashSet.toArray(new Locale[0]);
        }
        return availableLocales;
    }

    private static class NullProvider
    extends LocaleServiceProvider {
        private NullProvider() {
        }

        @Override
        public Locale[] getAvailableLocales() {
            return new Locale[0];
        }
    }
}

