/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

public class FpUtils {
    private FpUtils() {
    }

    @Deprecated
    public static int getExponent(double d) {
        return Math.getExponent(d);
    }

    @Deprecated
    public static int getExponent(float f) {
        return Math.getExponent(f);
    }

    @Deprecated
    public static double rawCopySign(double d, double d2) {
        return Math.copySign(d, d2);
    }

    @Deprecated
    public static float rawCopySign(float f, float f2) {
        return Math.copySign(f, f2);
    }

    @Deprecated
    public static boolean isFinite(double d) {
        return Double.isFinite(d);
    }

    @Deprecated
    public static boolean isFinite(float f) {
        return Float.isFinite(f);
    }

    public static boolean isInfinite(double d) {
        return Double.isInfinite(d);
    }

    public static boolean isInfinite(float f) {
        return Float.isInfinite(f);
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static boolean isNaN(float f) {
        return Float.isNaN(f);
    }

    public static boolean isUnordered(double d, double d2) {
        return FpUtils.isNaN(d) || FpUtils.isNaN(d2);
    }

    public static boolean isUnordered(float f, float f2) {
        return FpUtils.isNaN(f) || FpUtils.isNaN(f2);
    }

    public static int ilogb(double d) {
        int n = FpUtils.getExponent(d);
        switch (n) {
            case 1024: {
                if (FpUtils.isNaN(d)) {
                    return 0x40000000;
                }
                return 0x10000000;
            }
            case -1023: {
                if (d == 0.0) {
                    return -268435456;
                }
                long l = Double.doubleToRawLongBits(d);
                assert ((l &= 0xFFFFFFFFFFFFFL) != 0L);
                while (l < 0x10000000000000L) {
                    l *= 2L;
                    --n;
                }
                assert (++n >= -1074 && n < -1022);
                return n;
            }
        }
        assert (n >= -1022 && n <= 1023);
        return n;
    }

    public static int ilogb(float f) {
        int n = FpUtils.getExponent(f);
        switch (n) {
            case 128: {
                if (FpUtils.isNaN(f)) {
                    return 0x40000000;
                }
                return 0x10000000;
            }
            case -127: {
                if (f == 0.0f) {
                    return -268435456;
                }
                int n2 = Float.floatToRawIntBits(f);
                assert ((n2 &= 0x7FFFFF) != 0);
                while (n2 < 0x800000) {
                    n2 *= 2;
                    --n;
                }
                assert (++n >= -149 && n < -126);
                return n;
            }
        }
        assert (n >= -126 && n <= 127);
        return n;
    }

    @Deprecated
    public static double scalb(double d, int n) {
        return Math.scalb(d, n);
    }

    @Deprecated
    public static float scalb(float f, int n) {
        return Math.scalb(f, n);
    }

    @Deprecated
    public static double nextAfter(double d, double d2) {
        return Math.nextAfter(d, d2);
    }

    @Deprecated
    public static float nextAfter(float f, double d) {
        return Math.nextAfter(f, d);
    }

    @Deprecated
    public static double nextUp(double d) {
        return Math.nextUp(d);
    }

    @Deprecated
    public static float nextUp(float f) {
        return Math.nextUp(f);
    }

    @Deprecated
    public static double nextDown(double d) {
        return Math.nextDown(d);
    }

    @Deprecated
    public static double nextDown(float f) {
        return Math.nextDown(f);
    }

    @Deprecated
    public static double copySign(double d, double d2) {
        return StrictMath.copySign(d, d2);
    }

    @Deprecated
    public static float copySign(float f, float f2) {
        return StrictMath.copySign(f, f2);
    }

    @Deprecated
    public static double ulp(double d) {
        return Math.ulp(d);
    }

    @Deprecated
    public static float ulp(float f) {
        return Math.ulp(f);
    }

    @Deprecated
    public static double signum(double d) {
        return Math.signum(d);
    }

    @Deprecated
    public static float signum(float f) {
        return Math.signum(f);
    }
}

