/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.spi.db;

import com.sun.xml.internal.ws.spi.db.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public final class TypeInfo {
    public final QName tagName;
    public Type type;
    public final Annotation[] annotations;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean isGlobalElement = true;
    private TypeInfo parentCollectionType;
    private Type genericType;
    private boolean nillable = true;

    public TypeInfo(QName qName, Type type, Annotation ... annotationArray) {
        if (qName == null || type == null || annotationArray == null) {
            String string = "";
            if (qName == null) {
                string = "tagName";
            }
            if (type == null) {
                string = string + (string.length() > 0 ? ", type" : "type");
            }
            if (annotationArray == null) {
                string = string + (string.length() > 0 ? ", annotations" : "annotations");
            }
            throw new IllegalArgumentException("Argument(s) \"" + string + "\" can''t be null.)");
        }
        this.tagName = new QName(qName.getNamespaceURI().intern(), qName.getLocalPart().intern(), qName.getPrefix());
        this.type = type;
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            this.nillable = false;
        }
        this.annotations = annotationArray;
    }

    public <A extends Annotation> A get(Class<A> clazz) {
        for (Annotation annotation : this.annotations) {
            if (annotation.annotationType() != clazz) continue;
            return (A)((Annotation)clazz.cast(annotation));
        }
        return null;
    }

    public TypeInfo toItemType() {
        Type type = this.genericType != null ? this.genericType : this.type;
        Type type2 = Utils.REFLECTION_NAVIGATOR.getBaseClass(type, Collection.class);
        if (type2 == null) {
            return this;
        }
        return new TypeInfo(this.tagName, Utils.REFLECTION_NAVIGATOR.getTypeArgument(type2, 0), new Annotation[0]);
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public boolean isGlobalElement() {
        return this.isGlobalElement;
    }

    public void setGlobalElement(boolean bl) {
        this.isGlobalElement = bl;
    }

    public TypeInfo getParentCollectionType() {
        return this.parentCollectionType;
    }

    public void setParentCollectionType(TypeInfo typeInfo) {
        this.parentCollectionType = typeInfo;
    }

    public boolean isRepeatedElement() {
        return this.parentCollectionType != null;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type type) {
        this.genericType = type;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean bl) {
        this.nillable = bl;
    }

    public String toString() {
        return "TypeInfo: Type = " + this.type + ", tag = " + this.tagName;
    }

    public TypeInfo getItemType() {
        if (this.type instanceof Class && ((Class)this.type).isArray() && !byte[].class.equals((Object)this.type)) {
            Object object;
            Type type = ((Class)this.type).getComponentType();
            Type type2 = null;
            if (this.genericType != null && this.genericType instanceof GenericArrayType) {
                object = (GenericArrayType)this.type;
                type2 = object.getGenericComponentType();
                type = object.getGenericComponentType();
            }
            object = new TypeInfo(this.tagName, type, this.annotations);
            if (type2 != null) {
                ((TypeInfo)object).setGenericType(type2);
            }
            return object;
        }
        Type type = this.genericType != null ? this.genericType : this.type;
        Type type3 = Utils.REFLECTION_NAVIGATOR.getBaseClass(type, Collection.class);
        if (type3 != null) {
            return new TypeInfo(this.tagName, Utils.REFLECTION_NAVIGATOR.getTypeArgument(type3, 0), this.annotations);
        }
        return null;
    }
}

