/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.org.glassfish.gmbal.ManagedObjectManager;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.ws.addressing.EPRSDDocumentFilter;
import com.sun.xml.internal.ws.addressing.WSEPRExtension;
import com.sun.xml.internal.ws.api.Component;
import com.sun.xml.internal.ws.api.ComponentFeature;
import com.sun.xml.internal.ws.api.ComponentsFeature;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.Engine;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.internal.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.SyncStartForAsyncFeature;
import com.sun.xml.internal.ws.api.pipe.ThrowableContainerPropertySet;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.TubelineAssembler;
import com.sun.xml.internal.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import com.sun.xml.internal.ws.api.server.EndpointAwareCodec;
import com.sun.xml.internal.ws.api.server.EndpointComponent;
import com.sun.xml.internal.ws.api.server.EndpointReferenceExtensionContributor;
import com.sun.xml.internal.ws.api.server.LazyMOMProvider;
import com.sun.xml.internal.ws.api.server.TransportBackChannel;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.fault.SOAPFaultBuilder;
import com.sun.xml.internal.ws.model.wsdl.WSDLDirectProperties;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortProperties;
import com.sun.xml.internal.ws.model.wsdl.WSDLProperties;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.resources.HandlerMessages;
import com.sun.xml.internal.ws.server.EndpointAwareTube;
import com.sun.xml.internal.ws.server.MonitorRootService;
import com.sun.xml.internal.ws.server.ServiceDefinitionImpl;
import com.sun.xml.internal.ws.server.WSEndpointMOMProxy;
import com.sun.xml.internal.ws.util.Pool;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.wsdl.OperationDispatcher;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.w3c.dom.Element;

public class WSEndpointImpl<T>
extends WSEndpoint<T>
implements LazyMOMProvider.WSEndpointScopeChangeListener {
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.server.endpoint");
    @NotNull
    private final QName serviceName;
    @NotNull
    private final QName portName;
    protected final WSBinding binding;
    private final SEIModel seiModel;
    @NotNull
    private final Container container;
    private final WSDLPort port;
    protected final Tube masterTubeline;
    private final ServiceDefinitionImpl serviceDef;
    private final SOAPVersion soapVersion;
    private final Engine engine;
    @NotNull
    private final Codec masterCodec;
    @NotNull
    private final PolicyMap endpointPolicy;
    private final Pool<Tube> tubePool;
    private final OperationDispatcher operationDispatcher;
    @NotNull
    private ManagedObjectManager managedObjectManager;
    private boolean managedObjectManagerClosed = false;
    private final Object managedObjectManagerLock = new Object();
    private LazyMOMProvider.Scope lazyMOMProviderScope = LazyMOMProvider.Scope.STANDALONE;
    @NotNull
    private final ServerTubeAssemblerContext context;
    private Map<QName, WSEndpointReference.EPRExtension> endpointReferenceExtensions = new HashMap<QName, WSEndpointReference.EPRExtension>();
    private boolean disposed;
    private final Class<T> implementationClass;
    @NotNull
    private final WSDLProperties wsdlProperties;
    private final Set<Component> componentRegistry = new CopyOnWriteArraySet<Component>();
    private static final Logger monitoringLogger = Logger.getLogger("com.sun.xml.internal.ws.monitoring");

    /*
     * WARNING - void declaration
     */
    protected WSEndpointImpl(@NotNull QName qName, @NotNull QName qName2, WSBinding wSBinding, Container container, SEIModel sEIModel, WSDLPort wSDLPort, Class<T> clazz, @Nullable ServiceDefinitionImpl serviceDefinitionImpl, EndpointAwareTube endpointAwareTube, boolean bl, PolicyMap policyMap) {
        void var15_18;
        ComponentsFeature componentsFeature;
        ComponentFeature componentFeature;
        this.serviceName = qName;
        this.portName = qName2;
        this.binding = wSBinding;
        this.soapVersion = wSBinding.getSOAPVersion();
        this.container = container;
        this.port = wSDLPort;
        this.implementationClass = clazz;
        this.serviceDef = serviceDefinitionImpl;
        this.seiModel = sEIModel;
        this.endpointPolicy = policyMap;
        LazyMOMProvider.INSTANCE.registerEndpoint(this);
        this.initManagedObjectManager();
        if (serviceDefinitionImpl != null) {
            serviceDefinitionImpl.setOwner(this);
        }
        if ((componentFeature = wSBinding.getFeature(ComponentFeature.class)) != null) {
            switch (componentFeature.getTarget()) {
                case ENDPOINT: {
                    this.componentRegistry.add(componentFeature.getComponent());
                    break;
                }
                case CONTAINER: {
                    container.getComponents().add(componentFeature.getComponent());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if ((componentsFeature = wSBinding.getFeature(ComponentsFeature.class)) != null) {
            block10: for (ComponentFeature object2 : componentsFeature.getComponentFeatures()) {
                switch (object2.getTarget()) {
                    case ENDPOINT: {
                        this.componentRegistry.add(object2.getComponent());
                        continue block10;
                    }
                    case CONTAINER: {
                        container.getComponents().add(object2.getComponent());
                        continue block10;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        TubelineAssembler tubelineAssembler = TubelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), wSBinding.getBindingId(), container);
        assert (tubelineAssembler != null);
        this.operationDispatcher = wSDLPort == null ? null : new OperationDispatcher(wSDLPort, wSBinding, sEIModel);
        this.context = this.createServerTubeAssemblerContext(endpointAwareTube, bl);
        this.masterTubeline = tubelineAssembler.createServer(this.context);
        Codec codec = this.context.getCodec();
        if (codec instanceof EndpointAwareCodec) {
            Codec codec2 = codec.copy();
            ((EndpointAwareCodec)codec2).setEndpoint(this);
        }
        this.masterCodec = var15_18;
        this.tubePool = new Pool.TubePool(this.masterTubeline);
        endpointAwareTube.setEndpoint(this);
        this.engine = new Engine(this.toString(), container);
        this.wsdlProperties = wSDLPort == null ? new WSDLDirectProperties(qName, qName2, sEIModel) : new WSDLPortProperties(wSDLPort, sEIModel);
        HashMap<QName, WSEndpointReference.EPRExtension> hashMap = new HashMap<QName, WSEndpointReference.EPRExtension>();
        try {
            EndpointReferenceExtensionContributor[] endpointReferenceExtensionContributorArray;
            if (wSDLPort != null && (endpointReferenceExtensionContributorArray = wSDLPort.getEPR()) != null) {
                for (WSEndpointReference.EPRExtension ePRExtension : endpointReferenceExtensionContributorArray.getEPRExtensions()) {
                    hashMap.put(ePRExtension.getQName(), ePRExtension);
                }
            }
            endpointReferenceExtensionContributorArray = ServiceFinder.find(EndpointReferenceExtensionContributor.class).toArray();
            for (EndpointReferenceExtensionContributor endpointReferenceExtensionContributor : endpointReferenceExtensionContributorArray) {
                WSEndpointReference.EPRExtension ePRExtension = (WSEndpointReference.EPRExtension)hashMap.remove(endpointReferenceExtensionContributor.getQName());
                WSEndpointReference.EPRExtension ePRExtension2 = endpointReferenceExtensionContributor.getEPRExtension(this, ePRExtension);
                if (ePRExtension2 == null) continue;
                hashMap.put(ePRExtension2.getQName(), ePRExtension2);
            }
            for (WSEndpointReference.EPRExtension ePRExtension : hashMap.values()) {
                this.endpointReferenceExtensions.put(ePRExtension.getQName(), new WSEPRExtension(XMLStreamBuffer.createNewBufferFromXMLStreamReader(ePRExtension.readAsXMLStreamReader()), ePRExtension.getQName()));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
        if (!hashMap.isEmpty()) {
            serviceDefinitionImpl.addFilter(new EPRSDDocumentFilter(this));
        }
    }

    protected ServerTubeAssemblerContext createServerTubeAssemblerContext(EndpointAwareTube endpointAwareTube, boolean bl) {
        ServerPipeAssemblerContext serverPipeAssemblerContext = new ServerPipeAssemblerContext(this.seiModel, this.port, this, endpointAwareTube, bl);
        return serverPipeAssemblerContext;
    }

    protected WSEndpointImpl(@NotNull QName qName, @NotNull QName qName2, WSBinding wSBinding, Container container, SEIModel sEIModel, WSDLPort wSDLPort, Tube tube) {
        this.serviceName = qName;
        this.portName = qName2;
        this.binding = wSBinding;
        this.soapVersion = wSBinding.getSOAPVersion();
        this.container = container;
        this.endpointPolicy = null;
        this.port = wSDLPort;
        this.seiModel = sEIModel;
        this.serviceDef = null;
        this.implementationClass = null;
        this.masterTubeline = tube;
        this.masterCodec = ((BindingImpl)this.binding).createCodec();
        LazyMOMProvider.INSTANCE.registerEndpoint(this);
        this.initManagedObjectManager();
        this.operationDispatcher = wSDLPort == null ? null : new OperationDispatcher(wSDLPort, wSBinding, sEIModel);
        this.context = new ServerPipeAssemblerContext(sEIModel, wSDLPort, this, null, false);
        this.tubePool = new Pool.TubePool(tube);
        this.engine = new Engine(this.toString(), container);
        this.wsdlProperties = wSDLPort == null ? new WSDLDirectProperties(qName, qName2, sEIModel) : new WSDLPortProperties(wSDLPort, sEIModel);
    }

    public Collection<WSEndpointReference.EPRExtension> getEndpointReferenceExtensions() {
        return this.endpointReferenceExtensions.values();
    }

    @Override
    @Nullable
    public OperationDispatcher getOperationDispatcher() {
        return this.operationDispatcher;
    }

    @Override
    public PolicyMap getPolicyMap() {
        return this.endpointPolicy;
    }

    @Override
    @NotNull
    public Class<T> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    @NotNull
    public WSBinding getBinding() {
        return this.binding;
    }

    @Override
    @NotNull
    public Container getContainer() {
        return this.container;
    }

    @Override
    public WSDLPort getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public SEIModel getSEIModel() {
        return this.seiModel;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.engine.setExecutor(executor);
    }

    @Override
    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public void schedule(Packet packet, WSEndpoint.CompletionCallback completionCallback, FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        this.processAsync(packet, completionCallback, fiberContextSwitchInterceptor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAsync(final Packet packet, final WSEndpoint.CompletionCallback completionCallback, FiberContextSwitchInterceptor fiberContextSwitchInterceptor, boolean bl) {
        Container container = ContainerResolver.getDefault().enterContainer(this.container);
        try {
            packet.endpoint = this;
            packet.addSatellite(this.wsdlProperties);
            Fiber fiber = this.engine.createFiber();
            fiber.setDeliverThrowableInPacket(true);
            if (fiberContextSwitchInterceptor != null) {
                fiber.addInterceptor(fiberContextSwitchInterceptor);
            }
            final Tube tube = this.tubePool.take();
            Fiber.CompletionCallback completionCallback2 = new Fiber.CompletionCallback(){

                @Override
                public void onCompletion(@NotNull Packet packet2) {
                    ThrowableContainerPropertySet throwableContainerPropertySet = packet2.getSatellite(ThrowableContainerPropertySet.class);
                    if (throwableContainerPropertySet == null) {
                        WSEndpointImpl.this.tubePool.recycle(tube);
                    }
                    if (completionCallback != null) {
                        if (throwableContainerPropertySet != null) {
                            packet2 = WSEndpointImpl.this.createServiceResponseForException(throwableContainerPropertySet, packet2, WSEndpointImpl.this.soapVersion, packet.endpoint.getPort(), null, packet.endpoint.getBinding());
                        }
                        completionCallback.onCompletion(packet2);
                    }
                }

                @Override
                public void onCompletion(@NotNull Throwable throwable) {
                    throw new IllegalStateException();
                }
            };
            fiber.start(tube, packet, completionCallback2, this.binding.isFeatureEnabled(SyncStartForAsyncFeature.class) || !bl);
        }
        finally {
            ContainerResolver.getDefault().exitContainer(container);
        }
    }

    @Override
    public Packet createServiceResponseForException(ThrowableContainerPropertySet throwableContainerPropertySet, Packet packet, SOAPVersion sOAPVersion, WSDLPort wSDLPort, SEIModel sEIModel, WSBinding wSBinding) {
        if (throwableContainerPropertySet.isFaultCreated()) {
            return packet;
        }
        Message message = SOAPFaultBuilder.createSOAPFaultMessage(sOAPVersion, null, throwableContainerPropertySet.getThrowable());
        Packet packet2 = packet.createServerResponse(message, wSDLPort, sEIModel, wSBinding);
        throwableContainerPropertySet.setFaultMessage(message);
        throwableContainerPropertySet.setResponsePacket(packet);
        throwableContainerPropertySet.setFaultCreated(true);
        return packet2;
    }

    @Override
    public void process(Packet packet, WSEndpoint.CompletionCallback completionCallback, FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        this.processAsync(packet, completionCallback, fiberContextSwitchInterceptor, false);
    }

    @Override
    @NotNull
    public WSEndpoint.PipeHead createPipeHead() {
        return new WSEndpoint.PipeHead(){
            private final Tube tube;
            {
                this.tube = TubeCloner.clone(WSEndpointImpl.this.masterTubeline);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            public Packet process(Packet packet, WebServiceContextDelegate webServiceContextDelegate, TransportBackChannel transportBackChannel) {
                Container container = ContainerResolver.getDefault().enterContainer(WSEndpointImpl.this.container);
                try {
                    Packet packet2;
                    packet.webServiceContextDelegate = webServiceContextDelegate;
                    packet.transportBackChannel = transportBackChannel;
                    packet.endpoint = WSEndpointImpl.this;
                    packet.addSatellite(WSEndpointImpl.this.wsdlProperties);
                    Fiber fiber = WSEndpointImpl.this.engine.createFiber();
                    try {
                        packet2 = fiber.runSync(this.tube, packet);
                    }
                    catch (RuntimeException runtimeException) {
                        Message message = SOAPFaultBuilder.createSOAPFaultMessage(WSEndpointImpl.this.soapVersion, null, runtimeException);
                        packet2 = packet.createServerResponse(message, packet.endpoint.getPort(), null, packet.endpoint.getBinding());
                    }
                    Packet packet3 = packet2;
                    return packet3;
                }
                finally {
                    ContainerResolver.getDefault().exitContainer(container);
                }
            }
        };
    }

    @Override
    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.masterTubeline.preDestroy();
        block2: for (Handler handler : this.binding.getHandlerChain()) {
            for (Method method : handler.getClass().getMethods()) {
                if (method.getAnnotation(PreDestroy.class) == null) continue;
                try {
                    method.invoke(handler, new Object[0]);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, HandlerMessages.HANDLER_PREDESTROY_IGNORE(exception.getMessage()), exception);
                }
                continue block2;
            }
        }
        this.closeManagedObjectManager();
        LazyMOMProvider.INSTANCE.unregisterEndpoint(this);
    }

    @Override
    public ServiceDefinitionImpl getServiceDefinition() {
        return this.serviceDef;
    }

    @Override
    public Set<EndpointComponent> getComponentRegistry() {
        EndpointComponentSet endpointComponentSet = new EndpointComponentSet();
        for (Component component : this.componentRegistry) {
            endpointComponentSet.add(component instanceof EndpointComponentWrapper ? ((EndpointComponentWrapper)component).component : new ComponentWrapper(component));
        }
        return endpointComponentSet;
    }

    @Override
    @NotNull
    public Set<Component> getComponents() {
        return this.componentRegistry;
    }

    @Override
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String string, String string2, Element ... elementArray) {
        List<Element> list = null;
        if (elementArray != null) {
            list = Arrays.asList(elementArray);
        }
        return this.getEndpointReference(clazz, string, string2, null, list);
    }

    @Override
    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, String string, String string2, List<Element> list, List<Element> list2) {
        QName qName = null;
        if (this.port != null) {
            qName = this.port.getBinding().getPortTypeName();
        }
        AddressingVersion addressingVersion = AddressingVersion.fromSpecClass(clazz);
        return new WSEndpointReference(addressingVersion, string, this.serviceName, this.portName, qName, list, string2, list2, this.endpointReferenceExtensions.values(), null).toSpec(clazz);
    }

    @Override
    @NotNull
    public QName getPortName() {
        return this.portName;
    }

    @Override
    @NotNull
    public Codec createCodec() {
        return this.masterCodec.copy();
    }

    @Override
    @NotNull
    public QName getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initManagedObjectManager() {
        Object object = this.managedObjectManagerLock;
        synchronized (object) {
            if (this.managedObjectManager == null) {
                switch (this.lazyMOMProviderScope) {
                    case GLASSFISH_NO_JMX: {
                        this.managedObjectManager = new WSEndpointMOMProxy(this);
                        break;
                    }
                    default: {
                        this.managedObjectManager = this.obtainManagedObjectManager();
                    }
                }
            }
        }
    }

    @Override
    @NotNull
    public ManagedObjectManager getManagedObjectManager() {
        return this.managedObjectManager;
    }

    @NotNull
    ManagedObjectManager obtainManagedObjectManager() {
        MonitorRootService monitorRootService = new MonitorRootService(this);
        ManagedObjectManager managedObjectManager = monitorRootService.createManagedObjectManager(this);
        managedObjectManager.resumeJMXRegistration();
        return managedObjectManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scopeChanged(LazyMOMProvider.Scope scope) {
        Object object = this.managedObjectManagerLock;
        synchronized (object) {
            if (this.managedObjectManagerClosed) {
                return;
            }
            this.lazyMOMProviderScope = scope;
            if (this.managedObjectManager == null) {
                this.managedObjectManager = scope != LazyMOMProvider.Scope.GLASSFISH_NO_JMX ? this.obtainManagedObjectManager() : new WSEndpointMOMProxy(this);
            } else if (this.managedObjectManager instanceof WSEndpointMOMProxy && !((WSEndpointMOMProxy)this.managedObjectManager).isInitialized()) {
                ((WSEndpointMOMProxy)this.managedObjectManager).setManagedObjectManager(this.obtainManagedObjectManager());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeManagedObjectManager() {
        Object object = this.managedObjectManagerLock;
        synchronized (object) {
            if (this.managedObjectManagerClosed) {
                return;
            }
            if (this.managedObjectManager != null) {
                boolean bl = true;
                if (this.managedObjectManager instanceof WSEndpointMOMProxy && !((WSEndpointMOMProxy)this.managedObjectManager).isInitialized()) {
                    bl = false;
                }
                if (bl) {
                    try {
                        ObjectName objectName = this.managedObjectManager.getObjectName(this.managedObjectManager.getRoot());
                        if (objectName != null) {
                            monitoringLogger.log(Level.INFO, "Closing Metro monitoring root: {0}", objectName);
                        }
                        this.managedObjectManager.close();
                    }
                    catch (IOException iOException) {
                        monitoringLogger.log(Level.WARNING, "Ignoring error when closing Managed Object Manager", iOException);
                    }
                }
            }
            this.managedObjectManagerClosed = true;
        }
    }

    @Override
    @NotNull
    public ServerTubeAssemblerContext getAssemblerContext() {
        return this.context;
    }

    private static class ComponentWrapper
    implements EndpointComponent {
        private final Component component;

        public ComponentWrapper(Component component) {
            this.component = component;
        }

        public <S> S getSPI(Class<S> clazz) {
            return this.component.getSPI(clazz);
        }

        public int hashCode() {
            return this.component.hashCode();
        }

        public boolean equals(Object object) {
            return this.component.equals(object);
        }
    }

    private class EndpointComponentSet
    extends HashSet<EndpointComponent> {
        private EndpointComponentSet() {
        }

        @Override
        public Iterator<EndpointComponent> iterator() {
            final Iterator iterator = super.iterator();
            return new Iterator<EndpointComponent>(){
                private EndpointComponent last = null;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public EndpointComponent next() {
                    this.last = (EndpointComponent)iterator.next();
                    return this.last;
                }

                @Override
                public void remove() {
                    iterator.remove();
                    if (this.last != null) {
                        WSEndpointImpl.this.componentRegistry.remove(this.last instanceof ComponentWrapper ? ((ComponentWrapper)this.last).component : new EndpointComponentWrapper(this.last));
                    }
                    this.last = null;
                }
            };
        }

        @Override
        public boolean add(EndpointComponent endpointComponent) {
            boolean bl = super.add(endpointComponent);
            if (bl) {
                WSEndpointImpl.this.componentRegistry.add(new EndpointComponentWrapper(endpointComponent));
            }
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = super.remove(object);
            if (bl) {
                WSEndpointImpl.this.componentRegistry.remove(object instanceof ComponentWrapper ? ((ComponentWrapper)object).component : new EndpointComponentWrapper((EndpointComponent)object));
            }
            return bl;
        }
    }

    private static class EndpointComponentWrapper
    implements Component {
        private final EndpointComponent component;

        public EndpointComponentWrapper(EndpointComponent endpointComponent) {
            this.component = endpointComponent;
        }

        @Override
        public <S> S getSPI(Class<S> clazz) {
            return this.component.getSPI(clazz);
        }

        public int hashCode() {
            return this.component.hashCode();
        }

        public boolean equals(Object object) {
            return this.component.equals(object);
        }
    }
}

