/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyIntersector;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public final class AssertionSet
implements Iterable<PolicyAssertion>,
Comparable<AssertionSet> {
    private static final AssertionSet EMPTY_ASSERTION_SET = new AssertionSet(Collections.unmodifiableList(new LinkedList()));
    private static final Comparator<PolicyAssertion> ASSERTION_COMPARATOR = new Comparator<PolicyAssertion>(){

        @Override
        public int compare(PolicyAssertion policyAssertion, PolicyAssertion policyAssertion2) {
            if (policyAssertion.equals(policyAssertion2)) {
                return 0;
            }
            int n = PolicyUtils.Comparison.QNAME_COMPARATOR.compare(policyAssertion.getName(), policyAssertion2.getName());
            if (n != 0) {
                return n;
            }
            n = PolicyUtils.Comparison.compareNullableStrings(policyAssertion.getValue(), policyAssertion2.getValue());
            if (n != 0) {
                return n;
            }
            n = PolicyUtils.Comparison.compareBoolean(policyAssertion.hasNestedAssertions(), policyAssertion2.hasNestedAssertions());
            if (n != 0) {
                return n;
            }
            n = PolicyUtils.Comparison.compareBoolean(policyAssertion.hasNestedPolicy(), policyAssertion2.hasNestedPolicy());
            if (n != 0) {
                return n;
            }
            return Math.round(Math.signum(policyAssertion.hashCode() - policyAssertion2.hashCode()));
        }
    };
    private final List<PolicyAssertion> assertions;
    private final Set<QName> vocabulary = new TreeSet<QName>(PolicyUtils.Comparison.QNAME_COMPARATOR);
    private final Collection<QName> immutableVocabulary = Collections.unmodifiableCollection(this.vocabulary);

    private AssertionSet(List<PolicyAssertion> list) {
        assert (list != null) : LocalizationMessages.WSP_0037_PRIVATE_CONSTRUCTOR_DOES_NOT_TAKE_NULL();
        this.assertions = list;
    }

    private AssertionSet(Collection<AssertionSet> collection) {
        this.assertions = new LinkedList<PolicyAssertion>();
        for (AssertionSet assertionSet : collection) {
            this.addAll(assertionSet.assertions);
        }
    }

    private boolean add(PolicyAssertion policyAssertion) {
        if (policyAssertion == null) {
            return false;
        }
        if (this.assertions.contains(policyAssertion)) {
            return false;
        }
        this.assertions.add(policyAssertion);
        this.vocabulary.add(policyAssertion.getName());
        return true;
    }

    private boolean addAll(Collection<? extends PolicyAssertion> collection) {
        boolean bl = true;
        if (collection != null) {
            for (PolicyAssertion policyAssertion : collection) {
                bl &= this.add(policyAssertion);
            }
        }
        return bl;
    }

    Collection<PolicyAssertion> getAssertions() {
        return this.assertions;
    }

    Collection<QName> getVocabulary() {
        return this.immutableVocabulary;
    }

    boolean isCompatibleWith(AssertionSet assertionSet, PolicyIntersector.CompatibilityMode compatibilityMode) {
        boolean bl = compatibilityMode == PolicyIntersector.CompatibilityMode.LAX || this.vocabulary.equals(assertionSet.vocabulary);
        bl = bl && this.areAssertionsCompatible(assertionSet, compatibilityMode);
        bl = bl && assertionSet.areAssertionsCompatible(this, compatibilityMode);
        return bl;
    }

    private boolean areAssertionsCompatible(AssertionSet assertionSet, PolicyIntersector.CompatibilityMode compatibilityMode) {
        block0: for (PolicyAssertion policyAssertion : this.assertions) {
            if (compatibilityMode != PolicyIntersector.CompatibilityMode.STRICT && policyAssertion.isIgnorable()) continue;
            for (PolicyAssertion policyAssertion2 : assertionSet.assertions) {
                if (!policyAssertion.isCompatibleWith(policyAssertion2, compatibilityMode)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static AssertionSet createMergedAssertionSet(Collection<AssertionSet> collection) {
        if (collection == null || collection.isEmpty()) {
            return EMPTY_ASSERTION_SET;
        }
        AssertionSet assertionSet = new AssertionSet(collection);
        Collections.sort(assertionSet.assertions, ASSERTION_COMPARATOR);
        return assertionSet;
    }

    public static AssertionSet createAssertionSet(Collection<? extends PolicyAssertion> collection) {
        if (collection == null || collection.isEmpty()) {
            return EMPTY_ASSERTION_SET;
        }
        AssertionSet assertionSet = new AssertionSet((List<PolicyAssertion>)new LinkedList<PolicyAssertion>());
        assertionSet.addAll(collection);
        Collections.sort(assertionSet.assertions, ASSERTION_COMPARATOR);
        return assertionSet;
    }

    public static AssertionSet emptyAssertionSet() {
        return EMPTY_ASSERTION_SET;
    }

    @Override
    public Iterator<PolicyAssertion> iterator() {
        return this.assertions.iterator();
    }

    public Collection<PolicyAssertion> get(QName qName) {
        LinkedList<PolicyAssertion> linkedList = new LinkedList<PolicyAssertion>();
        if (this.vocabulary.contains(qName)) {
            for (PolicyAssertion policyAssertion : this.assertions) {
                if (!policyAssertion.getName().equals(qName)) continue;
                linkedList.add(policyAssertion);
            }
        }
        return linkedList;
    }

    public boolean isEmpty() {
        return this.assertions.isEmpty();
    }

    public boolean contains(QName qName) {
        return this.vocabulary.contains(qName);
    }

    @Override
    public int compareTo(AssertionSet assertionSet) {
        Object object;
        Object object2;
        if (this.equals(assertionSet)) {
            return 0;
        }
        Iterator<QName> iterator = this.getVocabulary().iterator();
        Iterator<QName> iterator2 = assertionSet.getVocabulary().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (iterator2.hasNext()) {
                object = iterator2.next();
                int n = PolicyUtils.Comparison.QNAME_COMPARATOR.compare((QName)object2, (QName)object);
                if (n == 0) continue;
                return n;
            }
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        object2 = this.getAssertions().iterator();
        object = assertionSet.getAssertions().iterator();
        while (object2.hasNext()) {
            PolicyAssertion policyAssertion = (PolicyAssertion)object2.next();
            if (object.hasNext()) {
                PolicyAssertion policyAssertion2 = (PolicyAssertion)object.next();
                int n = ASSERTION_COMPARATOR.compare(policyAssertion, policyAssertion2);
                if (n == 0) continue;
                return n;
            }
            return 1;
        }
        if (object.hasNext()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AssertionSet)) {
            return false;
        }
        AssertionSet assertionSet = (AssertionSet)object;
        boolean bl = true;
        bl = bl && this.vocabulary.equals(assertionSet.vocabulary);
        bl = bl && this.assertions.size() == assertionSet.assertions.size() && this.assertions.containsAll(assertionSet.assertions);
        return bl;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.vocabulary.hashCode();
        n = 37 * n + this.assertions.hashCode();
        return n;
    }

    public String toString() {
        return this.toString(0, new StringBuffer()).toString();
    }

    StringBuffer toString(int n, StringBuffer stringBuffer) {
        String string = PolicyUtils.Text.createIndent(n);
        String string2 = PolicyUtils.Text.createIndent(n + 1);
        stringBuffer.append(string).append("assertion set {").append(PolicyUtils.Text.NEW_LINE);
        if (this.assertions.isEmpty()) {
            stringBuffer.append(string2).append("no assertions").append(PolicyUtils.Text.NEW_LINE);
        } else {
            for (PolicyAssertion policyAssertion : this.assertions) {
                policyAssertion.toString(n + 1, stringBuffer).append(PolicyUtils.Text.NEW_LINE);
            }
        }
        stringBuffer.append(string).append('}');
        return stringBuffer;
    }
}

