/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.message.AbstractHeaderImpl;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

final class EPRHeader
extends AbstractHeaderImpl {
    private final String nsUri;
    private final String localName;
    private final WSEndpointReference epr;

    EPRHeader(QName qName, WSEndpointReference wSEndpointReference) {
        this.nsUri = qName.getNamespaceURI();
        this.localName = qName.getLocalPart();
        this.epr = wSEndpointReference;
    }

    @Override
    @NotNull
    public String getNamespaceURI() {
        return this.nsUri;
    }

    @Override
    @NotNull
    public String getLocalPart() {
        return this.localName;
    }

    @Override
    @Nullable
    public String getAttribute(@NotNull String string, @NotNull String string2) {
        try {
            XMLStreamReader xMLStreamReader = this.epr.read("EndpointReference");
            while (xMLStreamReader.getEventType() != 1) {
                xMLStreamReader.next();
            }
            return xMLStreamReader.getAttributeValue(string, string2);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new AssertionError((Object)xMLStreamException);
        }
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        return this.epr.read(this.localName);
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this.epr.writeTo(this.localName, xMLStreamWriter);
    }

    @Override
    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        try {
            Transformer transformer = XmlUtil.newTransformer();
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            if (sOAPHeader == null) {
                sOAPHeader = sOAPMessage.getSOAPPart().getEnvelope().addHeader();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLStreamWriter xMLStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(byteArrayOutputStream);
            this.epr.writeTo(this.localName, xMLStreamWriter);
            xMLStreamWriter.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Element element = documentBuilderFactory.newDocumentBuilder().parse(byteArrayInputStream).getDocumentElement();
            Node node = sOAPHeader.getOwnerDocument().importNode(element, true);
            sOAPHeader.appendChild(node);
        }
        catch (Exception exception) {
            throw new SOAPException(exception);
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        this.epr.writeTo(this.localName, contentHandler, errorHandler, true);
    }
}

