/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SimpleSoundbank;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.spi.SoundbankReader;
import sun.reflect.misc.ReflectUtil;

public final class JARSoundbankReader
extends SoundbankReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isZIP(URL uRL) {
        boolean bl = false;
        try (InputStream inputStream = uRL.openStream();){
            byte[] byArray = new byte[4];
            boolean bl2 = bl = inputStream.read(byArray) == 4;
            if (bl) {
                bl = byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        Object object;
        if (!JARSoundbankReader.isZIP(uRL)) {
            return null;
        }
        ArrayList<Soundbank> arrayList = new ArrayList<Soundbank>();
        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(new URL[]{uRL});
        InputStream inputStream = uRLClassLoader.getResourceAsStream("META-INF/services/javax.sound.midi.Soundbank");
        if (inputStream == null) {
            return null;
        }
        try {
            object = new BufferedReader(new InputStreamReader(inputStream));
            Object object2 = ((BufferedReader)object).readLine();
            while (object2 != null) {
                if (!((String)object2).startsWith("#")) {
                    try {
                        Class<?> classNotFoundException = Class.forName(((String)object2).trim(), false, uRLClassLoader);
                        if (Soundbank.class.isAssignableFrom(classNotFoundException)) {
                            Object object3 = ReflectUtil.newInstance(classNotFoundException);
                            arrayList.add((Soundbank)object3);
                        }
                    }
                    catch (ClassNotFoundException instantiationException) {
                    }
                    catch (InstantiationException illegalAccessException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                object2 = ((BufferedReader)object).readLine();
            }
        }
        finally {
            inputStream.close();
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Soundbank)arrayList.get(0);
        }
        object = new SimpleSoundbank();
        for (Soundbank soundbank : arrayList) {
            ((SimpleSoundbank)object).addAllInstruments(soundbank);
        }
        return object;
    }

    @Override
    public Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        return null;
    }

    @Override
    public Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        return this.getSoundbank(file.toURI().toURL());
    }
}

