/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.types.DataValueDescriptor;

public final class ConglomerateUtil {
    public static Properties createRawStorePropertySet(Properties properties) {
        properties = ConglomerateUtil.createUserRawStorePropertySet(properties);
        properties.put("derby.storage.reusableRecordId", "");
        return properties;
    }

    public static Properties createUserRawStorePropertySet(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("derby.storage.pageSize", "");
        properties.put("derby.storage.minimumRecordSize", "");
        properties.put("derby.storage.pageReservedSpace", "");
        properties.put("derby.storage.initialPages", "");
        return properties;
    }

    public static int[] createFormatIds(DataValueDescriptor[] dataValueDescriptorArray) {
        int[] nArray = new int[dataValueDescriptorArray.length];
        for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
            nArray[i] = dataValueDescriptorArray[i].getTypeFormatId();
        }
        return nArray;
    }

    public static int[] readFormatIdArray(int n, ObjectInput objectInput) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = FormatIdUtil.readFormatIdInteger(objectInput);
        }
        return nArray;
    }

    public static void writeFormatIdArray(int[] nArray, ObjectOutput objectOutput) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            FormatIdUtil.writeFormatIdInteger(objectOutput, nArray[i]);
        }
    }

    public static int[] createCollationIds(int n, int[] nArray) {
        int[] nArray2 = new int[n];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        } else {
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = 0;
            }
        }
        return nArray2;
    }

    public static void writeCollationIdArray(int[] nArray, ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            ++n2;
        }
        CompressedNumber.writeInt(objectOutput, n2);
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            CompressedNumber.writeInt(objectOutput, n);
            CompressedNumber.writeInt(objectOutput, nArray[n]);
        }
    }

    public static boolean readCollationIdArray(int[] nArray, ObjectInput objectInput) throws IOException {
        int n = CompressedNumber.readInt(objectInput);
        for (int i = 0; i < n; ++i) {
            int n2 = CompressedNumber.readInt(objectInput);
            nArray[n2] = CompressedNumber.readInt(objectInput);
        }
        return n > 0;
    }

    public static String debugPage(Page page, int n, boolean bl, DataValueDescriptor[] dataValueDescriptorArray) {
        return null;
    }
}

