/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropAliasConstantAction
extends DDLConstantAction {
    private SchemaDescriptor sd;
    private final String aliasName;
    private final char nameSpace;

    DropAliasConstantAction(SchemaDescriptor schemaDescriptor, String string, char c) {
        this.sd = schemaDescriptor;
        this.aliasName = string;
        this.nameSpace = c;
    }

    public String toString() {
        return "DROP ALIAS " + this.aliasName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        dataDictionary.startWriting(languageConnectionContext);
        AliasDescriptor aliasDescriptor = dataDictionary.getAliasDescriptor(this.sd.getUUID().toString(), this.aliasName, this.nameSpace);
        if (aliasDescriptor == null) {
            throw StandardException.newException("42X94", AliasDescriptor.getAliasType(this.nameSpace), this.aliasName);
        }
        this.adjustUDTDependencies(languageConnectionContext, dataDictionary, aliasDescriptor, false);
        aliasDescriptor.drop(languageConnectionContext);
    }
}

