/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.ParameterNode;

class SetRoleNode
extends MiscellaneousStatementNode {
    private String name;
    private int type;

    SetRoleNode(String string, int n, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.name = string;
        this.type = n;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public String statementToString() {
        return "SET ROLE";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetRoleConstantAction(this.name, this.type);
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.type == 1) {
            this.generateParameterValueSet(activationClassBuilder);
        }
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getMiscResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    private void generateParameterValueSet(ActivationClassBuilder activationClassBuilder) throws StandardException {
        List<ParameterNode> list = this.getCompilerContext().getParameterList();
        ParameterNode.generateParameterValueSet(activationClassBuilder, 1, list);
    }

    @Override
    int activationKind() {
        if (this.type == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }
}

