/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.util.Date;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignerUserID;

public class PGPSignatureSubpacketVector {
    SignatureSubpacket[] packets;

    PGPSignatureSubpacketVector(SignatureSubpacket[] signatureSubpacketArray) {
        this.packets = signatureSubpacketArray;
    }

    public SignatureSubpacket getSubpacket(int n) {
        for (int i = 0; i != this.packets.length; ++i) {
            if (this.packets[i].getType() != n) continue;
            return this.packets[i];
        }
        return null;
    }

    public long getIssuerKeyID() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(16);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((IssuerKeyID)signatureSubpacket).getKeyID();
    }

    public Date getSignatureCreationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(2);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((SignatureCreationTime)signatureSubpacket).getTime();
    }

    public long getSignatureExpirationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(3);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((SignatureExpirationTime)signatureSubpacket).getTime();
    }

    public long getKeyExpirationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(9);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((KeyExpirationTime)signatureSubpacket).getTime();
    }

    public int[] getPreferredHashAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(21);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferences();
    }

    public int[] getPreferredSymmetricAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(11);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferences();
    }

    public int[] getPreferredCompressionAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(22);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferences();
    }

    public int getKeyFlags() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(27);
        if (signatureSubpacket == null) {
            return 0;
        }
        return ((KeyFlags)signatureSubpacket).getFlags();
    }

    public String getSignerUserID() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(28);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((SignerUserID)signatureSubpacket).getID();
    }

    public int[] getCriticalTags() {
        int n = 0;
        for (int i = 0; i != this.packets.length; ++i) {
            if (!this.packets[i].isCritical()) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i != this.packets.length; ++i) {
            if (!this.packets[i].isCritical()) continue;
            nArray[n++] = this.packets[i].getType();
        }
        return nArray;
    }

    public int size() {
        return this.packets.length;
    }

    SignatureSubpacket[] toSubpacketArray() {
        return this.packets;
    }
}

