/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.nist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;

public class NISTNamedCurves {
    static final Hashtable objIds = new Hashtable();
    static final Hashtable curves = new Hashtable();
    static final Hashtable names = new Hashtable();

    public static X9ECParameters getByName(String string) {
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)objIds.get(string.toUpperCase());
        if (dERObjectIdentifier != null) {
            return (X9ECParameters)curves.get(dERObjectIdentifier);
        }
        return null;
    }

    public static X9ECParameters getByOID(DERObjectIdentifier dERObjectIdentifier) {
        return (X9ECParameters)curves.get(dERObjectIdentifier);
    }

    public static DERObjectIdentifier getOID(String string) {
        return (DERObjectIdentifier)objIds.get(string);
    }

    public static String getName(DERObjectIdentifier dERObjectIdentifier) {
        return (String)names.get(dERObjectIdentifier);
    }

    public static Enumeration getNames() {
        return objIds.keys();
    }

    static {
        objIds.put("B-571", SECObjectIdentifiers.sect571r1);
        objIds.put("B-409", SECObjectIdentifiers.sect409r1);
        objIds.put("B-283", SECObjectIdentifiers.sect283r1);
        objIds.put("B-233", SECObjectIdentifiers.sect233r1);
        objIds.put("B-163", SECObjectIdentifiers.sect163r2);
        objIds.put("P-521", SECObjectIdentifiers.secp521r1);
        objIds.put("P-256", SECObjectIdentifiers.secp256r1);
        objIds.put("P-224", SECObjectIdentifiers.secp224r1);
        names.put(SECObjectIdentifiers.sect571r1, "B-571");
        names.put(SECObjectIdentifiers.sect409r1, "B-409");
        names.put(SECObjectIdentifiers.sect283r1, "B-283");
        names.put(SECObjectIdentifiers.sect233r1, "B-233");
        names.put(SECObjectIdentifiers.sect163r2, "B-163");
        names.put(SECObjectIdentifiers.secp521r1, "P-521");
        names.put(SECObjectIdentifiers.secp256r1, "P-256");
        names.put(SECObjectIdentifiers.secp224r1, "P-224");
        curves.put(SECObjectIdentifiers.sect571r1, SECNamedCurves.getByName("sect571r1"));
        curves.put(SECObjectIdentifiers.sect409r1, SECNamedCurves.getByName("sect409r1"));
        curves.put(SECObjectIdentifiers.sect283r1, SECNamedCurves.getByName("sect283r1"));
        curves.put(SECObjectIdentifiers.sect233r1, SECNamedCurves.getByName("sect233r1"));
        curves.put(SECObjectIdentifiers.sect163r2, SECNamedCurves.getByName("sect163r2"));
        curves.put(SECObjectIdentifiers.secp521r1, SECNamedCurves.getByName("secp521r1"));
        curves.put(SECObjectIdentifiers.secp256r1, SECNamedCurves.getByName("secp256r1"));
        curves.put(SECObjectIdentifiers.secp224r1, SECNamedCurves.getByName("secp224r1"));
    }
}

