/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.model;

import db.DBKoneksi;
import esindo.net.model.TempPdf;
import esindo.net.model.TempPdfBupot;
import esindo.net.model.TransaksiBupot;
import esindo.net.model.ZItemTransaksi;
import esindo.net.model.ZTransaksi;
import esindo.net.model.ZTransaksiTemp;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ZDAOTransaksi {
    DBKoneksi dbkon = new DBKoneksi();
    private static final DecimalFormat decfor = new DecimalFormat("0.00");

    public void deleteTransaksiliLink(ZTransaksi obj) {
        this.deleteDetailTransaksi(obj.getId());
        this.deleteTransaksi(obj.getId());
    }

    public void deleteTransaksiliBupotLink(TransaksiBupot obj) {
        this.deleteTransaksiBupot(obj.getId());
    }

    public void deleteTransaksiliBupotLink2(TransaksiBupot obj) {
        this.deleteTransaksiBupot2(obj.getId());
    }

    public void deleteTransaksiBupot2(int id) {
        String sql = "DELETE FROM tbl3_transaksibupot2 WHERE id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, id);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteTransaksiBupot(int id) {
        String sql = "DELETE FROM tbl3_transaksibupot WHERE id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, id);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteTransaksi(int id) {
        String sql = "DELETE FROM tbl2_transaksi WHERE id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, id);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteDetailTransaksi(int transaksiid) {
        String sql = "DELETE FROM tbl2_transaksi_detail WHERE transaksi2_id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, transaksiid);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteDetailTransaksiId(int transaksiid) {
        String sql = "DELETE FROM tbl2_transaksi_detail WHERE id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, transaksiid);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteTransaksiBupotArray2(String str) {
        String[] ar;
        for (String x : ar = str.split(",")) {
            try {
                TransaksiBupot tr = this.findByNomorBupotTr2(x.trim());
                System.out.println(tr);
                this.deleteTransaksiliBupotLink2(tr);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void deleteTransaksiBupotArray(String str) {
        String[] ar;
        for (String x : ar = str.split(",")) {
            try {
                TransaksiBupot tr = this.findByNomorBupotTr(x.trim());
                System.out.println(tr);
                this.deleteTransaksiliBupotLink(tr);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void deleteTransaksiArray(String str) {
        String[] ar;
        for (String x : ar = str.split(",")) {
            try {
                ZTransaksi tr = this.findByNomorFakturNormal(x.trim());
                System.out.println(tr);
                this.deleteTransaksiliLink(tr);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void deleteDetailTransaksiArray(String str) {
        String[] ar;
        for (String x : ar = str.split(",")) {
            try {
                ZItemTransaksi tr2 = this.findByDetailIdpK(Integer.valueOf(x.trim()));
                System.out.println(tr2.getId());
                this.deleteDetailTransaksiId(tr2.getId());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public TransaksiBupot findByNomorBupotTr(String noBupot) throws SQLException {
        TransaksiBupot tr = null;
        String sql = "SELECT * FROM tbl3_transaksibupot  WHERE noBupot=? ";
        System.out.println(sql + " -- " + noBupot);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, noBupot);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new TransaksiBupot();
            tr.setId(rs.getInt("id"));
            tr.setNoBupot(rs.getString("noBupot"));
            tr.setMasaBupot(rs.getString("masaBupot"));
            tr.setJenisPajak(rs.getString("jenisPajak"));
            tr.setKodeObjekPajak(rs.getString("kodeObjekPajak"));
            tr.setObjekPajak(rs.getString("objekPajak"));
            tr.setNpwpPemotong(rs.getString("npwpPemotong"));
            tr.setNitkuPemotong(rs.getString("nitkuPemotong"));
            tr.setNamaPemotong(rs.getString("namaPemotong"));
            tr.setTglPemotongan(rs.getString("tglPemotongan"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public TransaksiBupot findByNomorBupotTr2(String noBupot) throws SQLException {
        TransaksiBupot tr = null;
        String sql = "SELECT * FROM tbl3_transaksibupot2  WHERE noBupot=? ";
        System.out.println(sql + " -- " + noBupot);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, noBupot);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new TransaksiBupot();
            tr.setId(rs.getInt("id"));
            tr.setNoBupot(rs.getString("noBupot"));
            tr.setMasaBupot(rs.getString("masaBupot"));
            tr.setJenisPajak(rs.getString("jenisPajak"));
            tr.setKodeObjekPajak(rs.getString("kodeObjekPajak"));
            tr.setObjekPajak(rs.getString("objekPajak"));
            tr.setNpwpPemotong(rs.getString("npwpPemotong"));
            tr.setNitkuPemotong(rs.getString("nitkuPemotong"));
            tr.setNamaPemotong(rs.getString("namaPemotong"));
            tr.setTglPemotongan(rs.getString("tglPemotongan"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public ZTransaksi findByNomorFakturNormal(String nofaktur) throws SQLException {
        ZTransaksi tr = null;
        String sql = "SELECT * FROM tbl2_transaksi  WHERE nomorFaktur=? ";
        System.out.println(sql + " -- " + nofaktur);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, nofaktur);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new ZTransaksi();
            tr.setId(rs.getInt("id"));
            tr.setKode(rs.getString("kdJenisTransaksi"));
            tr.setFgPengganti(rs.getString("fgPengganti"));
            tr.setNomorFaktur(rs.getString("nomorFaktur"));
            tr.setTanggal(rs.getString("tanggalFaktur"));
            tr.setNpwpPenjual(rs.getString("npwpPenjual"));
            tr.setNamaPenjual(rs.getString("namaPenjual"));
            tr.setAlamatPenjual(rs.getString("alamatPenjual"));
            tr.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
            tr.setNamaLawan(rs.getString("namaLawanTransaksi"));
            tr.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
            tr.setJumlahDPP(rs.getString("jumlahDpp"));
            tr.setJumlahPPN(rs.getString("jumlahPpn"));
            tr.setStatusApproval(rs.getString("statusApproval"));
            tr.setStatusFaktur(rs.getString("statusFaktur"));
            tr.setLinkfakturId(rs.getInt("linkfaktur_id"));
            tr.setMasaPajak(rs.getInt("masa_pajak"));
            tr.setTahunPajak(rs.getInt("tahun_pajak"));
            tr.setIsCreditable(rs.getInt("is_kredit"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public List<TempPdfBupot> loadTempdfBupotAll() {
        ArrayList<TempPdfBupot> ls = new ArrayList<TempPdfBupot>();
        String sql = "Select * from tbl_tempPdfBupot ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                TempPdfBupot obj = new TempPdfBupot();
                obj.setId(rs.getInt("id"));
                obj.setNamafile(rs.getString("namafile"));
                obj.setMasapajak(rs.getString("masapajak"));
                obj.setNobupot(rs.getString("noBupot"));
                String nitkuval = rs.getString("nitkupemotong");
                String[] nitku = nitkuval.split(" - ");
                nitkuval = nitku[0];
                obj.setNitkupemotong(nitkuval.toString());
                obj.setPathfilepdf(rs.getString("pathfilepdf"));
                obj.setJsonval(rs.getString("jsonval"));
                ls.add(obj);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public List<TempPdfBupot> loadTempdfBupotDiAll() {
        ArrayList<TempPdfBupot> ls = new ArrayList<TempPdfBupot>();
        String sql = "Select * from tbl_tempPdfBupot2 ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                TempPdfBupot obj = new TempPdfBupot();
                obj.setId(rs.getInt("id"));
                obj.setNamafile(rs.getString("namafile"));
                obj.setMasapajak(rs.getString("masapajak"));
                obj.setNobupot(rs.getString("noBupot"));
                String nitkuval = rs.getString("nitkupemotong");
                String[] nitku = nitkuval.split(" - ");
                nitkuval = nitku[0];
                obj.setNitkupemotong(nitkuval.toString());
                obj.setPathfilepdf(rs.getString("pathfilepdf"));
                obj.setJsonval(rs.getString("jsonval"));
                ls.add(obj);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public void deleteDataPdfTemp() {
        String sql = "DELETE FROM tbl_tempPdf ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteDataPdfTempSelected(String idkey) {
        String sql = "DELETE FROM tbl_tempPdf WHERE id IN ( " + idkey + " )";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteDataPdfTempBupot() {
        String sql = "DELETE FROM tbl_tempPdfBupot ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteDataPdfTempBupot2() {
        String sql = "DELETE FROM tbl_tempPdfBupot2 ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteDataPdfTempSelectedBupot(String idkey) {
        String sql = "DELETE FROM tbl_tempPdfBupot WHERE id IN ( " + idkey + " )";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteDataPdfTempSelectedBupot2(String idkey) {
        String sql = "DELETE FROM tbl_tempPdfBupot2 WHERE id IN ( " + idkey + " )";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public TableModel selectallTemp() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                switch (colIndex) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 1: {
                        return Integer.class;
                    }
                    case 0: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        model.addColumn("Selected");
        model.addColumn("Id");
        model.addColumn("Nama File");
        model.addColumn("Nama Customer");
        model.addColumn("Npwp");
        model.addColumn("No Invoice");
        model.addColumn("Tgl Invoice");
        model.addColumn("BarangJasa");
        model.addColumn("SatuanUkur");
        model.addColumn("KodeBarang");
        model.addColumn("PPn");
        model.addColumn("Dpp");
        model.addColumn("Total");
        model.addColumn("Detail");
        model.addColumn("Isjs");
        model.addColumn("Details");
        String sql = "Select * from tbl_tempPdf ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            TempPdf obj = null;
            boolean grp = false;
            String nama_group = "";
            while (rs.next()) {
                obj = new TempPdf();
                obj.setId(rs.getInt("id"));
                obj.setNamafile(rs.getString("namafile"));
                obj.setCustomer(rs.getString("customer"));
                obj.setNpwp(rs.getString("npwp"));
                obj.setNo_invoice(rs.getString("no_invoice"));
                obj.setTgl_invoice(rs.getString("tgl_invoice"));
                obj.setBarangJasa(rs.getString("barangjasa"));
                obj.setSatuanUkur(rs.getString("satuanUkur"));
                obj.setKodeBarang(rs.getString("kodeBarang"));
                obj.setVat(rs.getString("vat"));
                obj.setDpp(rs.getString("dpp"));
                obj.setTotal(rs.getString("total"));
                obj.setDetail(rs.getString("detail"));
                obj.setIsjson(rs.getString("isjson"));
                obj.setJsonval(rs.getString("jsonval"));
                boolean cek = false;
                model.addRow(new Object[]{cek, obj.getId(), obj.getNamafile(), obj.getCustomer(), obj.getNpwp(), obj.getNo_invoice(), obj.getTgl_invoice(), obj.getBarangJasa(), obj.getSatuanUkur(), obj.getKodeBarang(), obj.getVat(), obj.getDpp(), obj.getTotal(), obj.getDetail(), obj.getIsjson(), obj.getJsonval()});
            }
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public TableModel selectallTempBupot() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                switch (colIndex) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 1: {
                        return Integer.class;
                    }
                    case 0: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        model.addColumn("Selected");
        model.addColumn("Id");
        model.addColumn("Nama File");
        model.addColumn("Nomor Bupot");
        model.addColumn("Masa Pajak");
        model.addColumn("Npwp Pemotong");
        model.addColumn("Nitku Pemotong");
        model.addColumn("Details");
        String sql = "Select * from tbl_tempPdfBupot ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            TempPdfBupot obj = null;
            boolean grp = false;
            String nama_group = "";
            while (rs.next()) {
                obj = new TempPdfBupot();
                obj.setId(rs.getInt("id"));
                obj.setNamafile(rs.getString("namafile"));
                obj.setNobupot(rs.getString("nobupot"));
                obj.setMasapajak(rs.getString("masapajak"));
                obj.setNpwppemotong(rs.getString("npwppemotong"));
                obj.setNitkupemotong(rs.getString("nitkupemotong"));
                obj.setJsonval(rs.getString("jsonval"));
                boolean cek = false;
                model.addRow(new Object[]{cek, obj.getId(), obj.getNamafile(), obj.getNobupot(), obj.getMasapajak(), obj.getNpwppemotong(), obj.getNitkupemotong(), obj.getJsonval()});
            }
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public TableModel selectallTempBupot2() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                switch (colIndex) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 1: {
                        return Integer.class;
                    }
                    case 0: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        model.addColumn("Selected");
        model.addColumn("Id");
        model.addColumn("Nama File");
        model.addColumn("Nomor Bupot");
        model.addColumn("Masa Pajak");
        model.addColumn("Npwp Pemotong");
        model.addColumn("Nitku Pemotong");
        model.addColumn("Details");
        String sql = "Select * from tbl_tempPdfBupot2 ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            TempPdfBupot obj = null;
            boolean grp = false;
            String nama_group = "";
            while (rs.next()) {
                obj = new TempPdfBupot();
                obj.setId(rs.getInt("id"));
                obj.setNamafile(rs.getString("namafile"));
                obj.setNobupot(rs.getString("nobupot"));
                obj.setMasapajak(rs.getString("masapajak"));
                obj.setNpwppemotong(rs.getString("npwppemotong"));
                obj.setNitkupemotong(rs.getString("nitkupemotong"));
                obj.setJsonval(rs.getString("jsonval"));
                boolean cek = false;
                model.addRow(new Object[]{cek, obj.getId(), obj.getNamafile(), obj.getNobupot(), obj.getMasapajak(), obj.getNpwppemotong(), obj.getNitkupemotong(), obj.getJsonval()});
            }
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public void updateKtp() {
        String sql = " UPDATE TBL2_TRANSAKSI \nSET \n    jenisidpembeli = 'National ID',\n    NODOKPEMBELI =NPWPLAWANTRANSAKSI ,\n    NPWPLAWANTRANSAKSI = '0000000000000000'\nWHERE \n     (NPWPLAWANTRANSAKSI LIKE '0%' OR \n     NPWPLAWANTRANSAKSI LIKE '1%' OR \n     NPWPLAWANTRANSAKSI LIKE '2%' OR \n     NPWPLAWANTRANSAKSI LIKE '3%' OR \n     NPWPLAWANTRANSAKSI LIKE '4%' OR \n     NPWPLAWANTRANSAKSI LIKE '5%' OR \n     NPWPLAWANTRANSAKSI LIKE '6%' OR \n     NPWPLAWANTRANSAKSI LIKE '7%' OR \n     NPWPLAWANTRANSAKSI LIKE '8%' OR \n     NPWPLAWANTRANSAKSI LIKE '9%')\nAND\n    CAST(SUBSTR(TRIM(CAST(NPWPLAWANTRANSAKSI AS VARCHAR(20))), 1, 2) AS INT) > 10";
        try (PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);){
            int rows = pst.executeUpdate();
            System.out.println("Rows updated: " + rows);
        }
        catch (SQLException e) {
            System.err.println("SQL error during updateNpwpFromTr:");
            e.printStackTrace();
        }
    }

    public void updateNpwpFromTr() throws SQLException {
        String sql = "UPDATE tbl2_transaksi SET npwpLawanTransaksi = ( SELECT t2.npwp FROM tbl2_kode_wapu t2 WHERE TRIM(UPPER(tbl2_transaksi.namaLawanTransaksi)) = TRIM(UPPER(t2.namaPerusahaan)) AND tbl2_transaksi.jenisIdPembeli = 'TIN' FETCH FIRST ROW ONLY ), kdJenisTransaksi = ( SELECT t2.kode FROM tbl2_kode_wapu t2 WHERE TRIM(UPPER(tbl2_transaksi.namaLawanTransaksi)) = TRIM(UPPER(t2.namaPerusahaan)) AND tbl2_transaksi.jenisIdPembeli = 'TIN' FETCH FIRST ROW ONLY ), idTkuPembeli = ( SELECT t2.nitku FROM tbl2_kode_wapu t2 WHERE TRIM(UPPER(tbl2_transaksi.namaLawanTransaksi)) = TRIM(UPPER(t2.namaPerusahaan)) AND tbl2_transaksi.jenisIdPembeli = 'TIN' FETCH FIRST ROW ONLY ) WHERE EXISTS ( SELECT 1 FROM tbl2_kode_wapu t2 WHERE TRIM(UPPER(tbl2_transaksi.namaLawanTransaksi)) = TRIM(UPPER(t2.namaPerusahaan)) AND tbl2_transaksi.jenisIdPembeli = 'TIN' )";
        try (PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);){
            int rows = pst.executeUpdate();
            System.out.println("Rows updated: " + rows);
        }
        catch (SQLException e) {
            System.err.println("SQL error during updateNpwpFromTr:");
            e.printStackTrace();
        }
    }

    public void updateNpwpFromMaster() throws SQLException {
        String sql = "UPDATE tbl_tempPdf t1 SET npwp = (SELECT t2.npwp FROM tbl2_kode_wapu t2         WHERE TRIM(UPPER(t1.customer)) = TRIM(UPPER(t2.namaPerusahaan))), kode_tr = (SELECT t2.kode FROM tbl2_kode_wapu t2            WHERE TRIM(UPPER(t1.customer)) = TRIM(UPPER(t2.namaPerusahaan))), nitku = (SELECT t2.nitku FROM tbl2_kode_wapu t2          WHERE TRIM(UPPER(t1.customer)) = TRIM(UPPER(t2.namaPerusahaan))) WHERE EXISTS (SELECT 1 FROM tbl2_kode_wapu t2              WHERE TRIM(UPPER(t1.customer)) = TRIM(UPPER(t2.namaPerusahaan)))";
        try (PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);){
            int rows = pst.executeUpdate();
            System.out.println("Rows updated: " + rows);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void savePdfTmp(TempPdf obj) throws SQLException {
        String sql = "INSERT INTO tbl_tempPdf(tgl_invoice, no_invoice, vat, dpp, total, customer, detail, npwp, nitku, kode_tr, namafile, barangjasa, satuanUkur, kodeBarang, isjson, jsonval) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        System.out.println("[DEBUG] SQL: " + sql);
        PreparedStatement pst = null;
        try {
            pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setString(1, obj.getTgl_invoice());
            pst.setString(2, obj.getNo_invoice());
            pst.setString(3, obj.getVat());
            pst.setString(4, obj.getDpp());
            pst.setString(5, obj.getTotal());
            pst.setString(6, obj.getCustomer());
            pst.setString(7, obj.getDetail());
            pst.setString(8, obj.getNpwp());
            pst.setString(9, obj.getNitku());
            pst.setString(10, obj.getKode_tr());
            pst.setString(11, obj.getNamafile());
            pst.setString(12, obj.getBarangJasa());
            pst.setString(13, obj.getSatuanUkur());
            pst.setString(14, obj.getKodeBarang());
            pst.setString(15, obj.getIsjson());
            pst.setString(16, obj.getJsonval());
            System.out.println("[DEBUG] Executing insert with values:");
            System.out.println("  tgl_invoice  : " + obj.getTgl_invoice());
            System.out.println("  no_invoice   : " + obj.getNo_invoice());
            System.out.println("  vat          : " + obj.getVat());
            System.out.println("  dpp          : " + obj.getDpp());
            System.out.println("  total        : " + obj.getTotal());
            System.out.println("  customer     : " + obj.getCustomer());
            System.out.println("  detail       : " + obj.getDetail());
            System.out.println("  npwp         : " + obj.getNpwp());
            System.out.println("  nitku        : " + obj.getNitku());
            System.out.println("  kode_tr      : " + obj.getKode_tr());
            System.out.println("  namafile     : " + obj.getNamafile());
            System.out.println("  barangjasa   : " + obj.getBarangJasa());
            System.out.println("  satuanUkur   : " + obj.getSatuanUkur());
            System.out.println("  kodeBarang   : " + obj.getKodeBarang());
            System.out.println("  isjson       : " + obj.getIsjson());
            System.out.println("  jsonval      : " + obj.getJsonval());
            pst.executeUpdate();
            System.out.println("[DEBUG] Insert successful.");
        }
        catch (SQLException e) {
            System.err.println("[ERROR] SQL Exception: " + e.getMessage());
            throw e;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException ex) {
                    System.err.println("[ERROR] Failed to close PreparedStatement: " + ex.getMessage());
                }
            }
        }
    }

    public void savePdfTmpBupot(TempPdfBupot obj) throws SQLException {
        String sql = "INSERT INTO tbl_tempPdfBupot(nobupot, masapajak, npwppemotong, nitkupemotong, isjson, jsonval, namafile,pathfilepdf) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);){
            pst.setString(1, obj.getNobupot());
            pst.setString(2, obj.getMasapajak());
            pst.setString(3, obj.getNpwppemotong());
            pst.setString(4, obj.getNitkupemotong());
            pst.setInt(5, obj.getIsjson());
            pst.setString(6, obj.getJsonval());
            pst.setString(7, obj.getNamafile());
            pst.setString(8, obj.getPathfilepdf());
            pst.executeUpdate();
        }
    }

    public void savePdfTmpBupot2(TempPdfBupot obj) throws SQLException {
        String sql = "INSERT INTO tbl_tempPdfBupot2(nobupot, masapajak, npwppemotong, nitkupemotong, isjson, jsonval, namafile,pathfilepdf) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);){
            pst.setString(1, obj.getNobupot());
            pst.setString(2, obj.getMasapajak());
            pst.setString(3, obj.getNpwppemotong());
            pst.setString(4, obj.getNitkupemotong());
            pst.setInt(5, obj.getIsjson());
            pst.setString(6, obj.getJsonval());
            pst.setString(7, obj.getNamafile());
            pst.setString(8, obj.getPathfilepdf());
            pst.executeUpdate();
        }
    }

    public void saveTransaksiBupot(TransaksiBupot obj) throws SQLException {
        String sql = "INSERT INTO tbl3_transaksibupot(noBupot, masaBupot, sifat, jenisBukti, jenisFasilitas, jenisPajak, kodeObjekPajak, objekPajak, dpp, tarif, pajak, jenisDokumen, tglDokumen, noDokumen, npwpPemotong, nitkuPemotong, namaPemotong, tglPemotongan, npwpDipotong, nitkuDipotong, namaDipotong) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);){
            pst.setString(1, obj.getNoBupot());
            pst.setString(2, obj.getMasaBupot());
            pst.setString(3, obj.getSifat());
            pst.setString(4, obj.getJenisBukti());
            pst.setString(5, obj.getJenisFasilitas());
            pst.setString(6, obj.getJenisPajak());
            pst.setString(7, obj.getKodeObjekPajak());
            pst.setString(8, obj.getObjekPajak());
            pst.setDouble(9, obj.getDpp());
            pst.setDouble(10, obj.getTarif());
            pst.setDouble(11, obj.getPajak());
            pst.setString(12, obj.getJenisDokumen());
            pst.setString(13, obj.getTglDokumen());
            pst.setString(14, obj.getNoDokumen());
            pst.setString(15, obj.getNpwpPemotong());
            pst.setString(16, obj.getNitkuPemotong());
            pst.setString(17, obj.getNamaPemotong());
            pst.setString(18, obj.getTglPemotongan());
            pst.setString(19, obj.getNpwpDipotong());
            pst.setString(20, obj.getNitkuDipotong());
            pst.setString(21, obj.getNamaDipotong());
            pst.executeUpdate();
        }
    }

    public void saveTransaksiBupot2(TransaksiBupot obj) throws SQLException {
        String sql = "INSERT INTO tbl3_transaksibupot2(noBupot, masaBupot, sifat, jenisBukti, jenisFasilitas, jenisPajak, kodeObjekPajak, objekPajak, dpp, tarif, pajak, jenisDokumen, tglDokumen, noDokumen, npwpPemotong, nitkuPemotong, namaPemotong, tglPemotongan, npwpDipotong, nitkuDipotong, namaDipotong) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);){
            pst.setString(1, obj.getNoBupot());
            pst.setString(2, obj.getMasaBupot());
            pst.setString(3, obj.getSifat());
            pst.setString(4, obj.getJenisBukti());
            pst.setString(5, obj.getJenisFasilitas());
            pst.setString(6, obj.getJenisPajak());
            pst.setString(7, obj.getKodeObjekPajak());
            pst.setString(8, obj.getObjekPajak());
            pst.setDouble(9, obj.getDpp());
            pst.setDouble(10, obj.getTarif());
            pst.setDouble(11, obj.getPajak());
            pst.setString(12, obj.getJenisDokumen());
            pst.setString(13, obj.getTglDokumen());
            pst.setString(14, obj.getNoDokumen());
            pst.setString(15, obj.getNpwpPemotong());
            pst.setString(16, obj.getNitkuPemotong());
            pst.setString(17, obj.getNamaPemotong());
            pst.setString(18, obj.getTglPemotongan());
            pst.setString(19, obj.getNpwpDipotong());
            pst.setString(20, obj.getNitkuDipotong());
            pst.setString(21, obj.getNamaDipotong());
            pst.executeUpdate();
        }
    }

    public void saveMaster(ZTransaksi obj) throws SQLException {
        String sql = "INSERT INTO tbl2_transaksi(namaPenjual,alamatPenjual,jumlahDpp,jumlahPPn,nomorInvoice,tanggalFaktur,npwpPenjual,kdJenisTransaksi,fgPengganti,nomorFaktur,masa_pajak,tahun_pajak,npwpLawanTransaksi,namaLawanTransaksi,alamatLawanTransaksi,idTkuPenjual,jenisIdPembeli,negaraPembeli,noDokPembeli,idTkuPembeli,dokumenPendukung) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getNamaPenjual());
        pst.setString(2, obj.getAlamatPenjual());
        pst.setString(3, obj.getJumlahDPP());
        pst.setString(4, obj.getJumlahPPN());
        pst.setString(5, obj.getNoinvoice());
        pst.setString(6, obj.getTglFaktur());
        pst.setString(7, obj.getNpwpPenjual());
        pst.setString(8, obj.getKode());
        pst.setString(9, obj.getFgPengganti());
        pst.setString(10, obj.getNomorFaktur());
        pst.setInt(11, obj.getMasaPajak());
        pst.setInt(12, obj.getTahunPajak());
        pst.setString(13, obj.getNpwpLawan());
        pst.setString(14, obj.getNamaLawan());
        pst.setString(15, obj.getAlamatLawan());
        pst.setString(16, obj.getIdTkuPenjual());
        pst.setString(17, obj.getJenisIdPembeli());
        pst.setString(18, obj.getNegaraPembeli());
        pst.setString(19, obj.getNoDokumenPembeli());
        pst.setString(20, obj.getIdTkuPembeli());
        pst.setString(21, obj.getDokumenPendukung());
        pst.executeUpdate();
        ZTransaksi _tr = this.findByNomorInvoice(obj.getNoinvoice());
        obj.setId(_tr.getId());
        pst.close();
    }

    public void updateDetailTr(ZItemTransaksi obj) throws SQLException {
        String sql = "update tbl2_transaksi_detail set hargaSatuan =? ,jumlahBarang =? , hargaTotal =? ,diskon= ?, dpp =  ? ,ppn = ? ,barangJasa = ?, tarifPPn = ?, satuanUkur = ? , dppLain=?  where id = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getHargaSatuan());
        pst.setString(2, obj.getJumlahBarang());
        pst.setString(3, obj.getHargaTotal());
        pst.setString(4, obj.getDiskon());
        pst.setString(5, obj.getDpp());
        pst.setString(6, obj.getPpn());
        pst.setString(7, obj.getBarangJasa());
        pst.setString(8, obj.getSatuanPPn());
        pst.setString(9, obj.getSatuanUkur());
        pst.setString(10, obj.getDppLain());
        pst.setInt(11, obj.getId());
        pst.executeUpdate();
        pst.close();
    }

    public void updateDetailTrpk(ZItemTransaksi obj) throws SQLException {
        String sql = "update tbl2_transaksi_detail set hargaSatuan =? ,jumlahBarang =? , hargaTotal =? ,diskon= ?, dpp =  ? ,ppn = ? ,barangJasa = ?, tarifPPn = ?, satuanUkur = ? , dppLain=? , nama= ? , kodeBarang= ? where id = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getHargaSatuan());
        pst.setString(2, obj.getJumlahBarang());
        pst.setString(3, obj.getHargaTotal());
        pst.setString(4, obj.getDiskon());
        pst.setString(5, obj.getDpp());
        pst.setString(6, obj.getPpn());
        pst.setString(7, obj.getBarangJasa());
        pst.setString(8, obj.getSatuanPPn());
        pst.setString(9, obj.getSatuanUkur());
        pst.setString(10, obj.getDppLain());
        pst.setString(11, obj.getNama());
        pst.setString(12, obj.getKodeBarang());
        pst.setInt(13, obj.getId());
        pst.executeUpdate();
        pst.close();
    }

    public void saveDetailsInBulk(List<ZItemTransaksi> details) throws SQLException {
        String sql = "INSERT INTO tbl2_transaksi_detail(nama, hargaSatuan, jumlahBarang, hargaTotal, diskon, dpp, ppn, tarifPpnbm, ppnbm, transaksi2_id, nomorInvoice, barangJasa, tarifPPn, satuanUkur, dppLain,kodeBarang) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
        try (Connection conn = this.dbkon.getKoneksi();
             PreparedStatement pst = conn.prepareStatement(sql);){
            conn.setAutoCommit(false);
            for (ZItemTransaksi obj : details) {
                pst.setString(1, obj.getNama());
                pst.setString(2, obj.getHargaSatuan());
                pst.setString(3, obj.getJumlahBarang());
                pst.setString(4, obj.getHargaTotal());
                pst.setString(5, obj.getDiskon());
                pst.setString(6, obj.getDpp());
                pst.setString(7, obj.getPpn());
                pst.setString(8, obj.getTarifPpnbm());
                pst.setString(9, obj.getPpnbm());
                pst.setInt(10, obj.getTransaksiId());
                pst.setString(11, obj.getNoinvoice());
                pst.setString(12, obj.getBarangJasa());
                pst.setString(13, obj.getSatuanPPn());
                pst.setString(14, obj.getSatuanUkur());
                pst.setString(15, obj.getDppLain());
                pst.setString(16, obj.getKodeBarang());
                pst.addBatch();
            }
            pst.executeBatch();
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void saveDetail(ZItemTransaksi obj) throws SQLException {
        String sql = "INSERT INTO tbl2_transaksi_detail(nama,hargaSatuan,jumlahBarang,hargaTotal,diskon,dpp,ppn,tarifPpnbm,ppnbm,transaksi2_id,nomorInvoice,barangJasa,tarifPPn,satuanUkur,dppLain,kodeBarang) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getNama());
        pst.setString(2, obj.getHargaSatuan());
        pst.setString(3, obj.getJumlahBarang());
        pst.setString(4, obj.getHargaTotal());
        pst.setString(5, obj.getDiskon());
        pst.setString(6, obj.getDpp());
        pst.setString(7, obj.getPpn());
        pst.setString(8, obj.getTarifPpnbm());
        pst.setString(9, obj.getPpnbm());
        pst.setInt(10, obj.getTransaksiId());
        pst.setString(11, obj.getNoinvoice());
        pst.setString(12, obj.getBarangJasa());
        pst.setString(13, obj.getSatuanPPn());
        pst.setString(14, obj.getSatuanUkur());
        pst.setString(15, obj.getDppLain());
        pst.setString(16, obj.getKodeBarang());
        pst.executeUpdate();
        pst.close();
    }

    public void bulkSaveDetail(List<ZItemTransaksi> detailList) throws SQLException {
        String sql = "INSERT INTO tbl2_detail(transaksiId, noinvoice, tarifPpnbm, ppnbm, hargaSatuan, ppn, barangJasa, satuanUkur, satuanPPn) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (Connection conn = this.dbkon.getKoneksi();){
            conn.setAutoCommit(false);
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                for (ZItemTransaksi zi : detailList) {
                    pst.setInt(1, zi.getTransaksiId());
                    pst.setString(2, zi.getNoinvoice());
                    pst.setString(3, zi.getTarifPpnbm());
                    pst.setString(4, zi.getPpnbm());
                    pst.setString(5, zi.getHargaSatuan());
                    pst.setString(6, zi.getPpn());
                    pst.setString(7, zi.getBarangJasa());
                    pst.setString(8, zi.getSatuanUkur());
                    pst.setString(9, zi.getSatuanPPn());
                    pst.addBatch();
                }
                int[] affectedRecords = pst.executeBatch();
                conn.commit();
                System.out.println("Inserted " + affectedRecords.length + " detail records.");
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void save(ZTransaksiTemp obj) throws SQLException {
        String sql = "INSERT INTO tbl2_transaksi(namaPenjual,alamatPenjual,jumlahDpp,jumlahPPn,nomorInvoice,tanggalFaktur,npwpPenjual) select account as namaPenjual ,address_line_1_account  || ' ' ||  address_line_2_account || ' ' || address_line_4_account  || ' ' ||  address_line_5_account  || ' ' || city_account || ' ' ||  district  as alamatPenjual , sum(net_value_with_freight) as jumlahDpp, sum(tax_value) as jumlahPPn,invoice as nomorInvoice,invoice_date as tanggalFaktur,tax_number as npwpPenjual from tbl2_tmp_sap  group by invoice;";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.executeUpdate();
        pst.close();
    }

    public void hapusDetailId(int id) throws SQLException {
        String sql = "delete from tbl2_transaksi_detail  where id=?  ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, id);
        pst.executeUpdate();
        pst.close();
    }

    public void updateDetailBytgl(String tgl) throws SQLException {
        String sql = "UPDATE tbl2_transaksi SET jumlahDpp =  dtl.dpp,jumlahPpn =  dtl.ppn FROM (SELECT sum(dpp) AS dpp, sum(ppn) AS ppn, transaksi2_id as trId FROM tbl2_transaksi_detail GROUP BY transaksi2_id ) AS dtl WHERE tbl2_transaksi.id = dtl.trId and tbl2_transaksi.tanggalFaktur = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, tgl);
        pst.executeUpdate();
        pst.close();
    }

    public void updateDetailById(int idx) throws SQLException {
        String sql = "UPDATE tbl2_transaksi SET jumlahDpp =  dtl.dpp,jumlahPpn =  dtl.ppn FROM (SELECT sum(dpp) AS dpp, sum(ppn) AS ppn, transaksi2_id as trId FROM tbl2_transaksi_detail GROUP BY transaksi2_id ) AS dtl WHERE tbl2_transaksi.id = dtl.trId and tbl2_transaksi.id = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, idx);
        pst.executeUpdate();
        pst.close();
    }

    public void updateDetail(ZTransaksi obj) throws SQLException {
        String sql = "update tbl2_transaksi set jumlahDpp =  ? ,jumlahPpn = ?  where nomorInvoice = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getJumlahDPP());
        pst.setString(2, obj.getJumlahPPN());
        pst.setString(3, obj.getNoinvoice());
        pst.executeUpdate();
        pst.close();
    }

    public void updateKodeTransaksi(ZTransaksi obj) throws SQLException {
        String sql = "update tbl2_transaksi set kdJenisTransaksi =  ?   where id  = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getKode());
        pst.setInt(2, obj.getId());
        pst.executeUpdate();
        pst.close();
    }

    public void updateMasterByid(ZTransaksi obj) throws SQLException {
        String sql = "update tbl2_transaksi set kdJenisTransaksi =  ?,jenisIdPembeli = ? ,noDokPembeli=? ,npwpLawanTransaksi= ? ,addInfo = ? ,idTkuPembeli = ? , alamatLawanTransaksi = ? , dokumenPendukung = ?  where id  = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getKode());
        pst.setString(2, obj.getJenisIdPembeli());
        pst.setString(3, obj.getNoDokumenPembeli());
        pst.setString(4, obj.getNpwpLawan());
        pst.setString(5, obj.getAddInfo());
        pst.setString(6, obj.getIdTkuPembeli());
        pst.setString(7, obj.getAlamatLawan());
        pst.setString(8, obj.getDokumenPendukung());
        pst.setInt(9, obj.getId());
        pst.executeUpdate();
        pst.close();
    }

    public void updateMasterByRefFaktur(ZTransaksi obj) throws SQLException {
        String sql = "update tbl2_transaksi set statusFaktur =  ? ,nomorFaktur = ?  where id  = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getStatusFaktur());
        pst.setString(2, obj.getNomorFaktur());
        pst.setInt(3, obj.getId());
        pst.executeUpdate();
        pst.close();
    }

    public TableModel tableModelTransaksiBupot() {
        DefaultTableModel model = this.createModelTransaksiBupot();
        String sql = "SELECT * FROM tbl3_transaksibupot  order by id desc";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotongd = rs.getString("namaDipotong");
                model.addRow(new Object[]{linkid, tglPemotong, kodeObjekPajak, jenisPajak, noBupot, masaBupot, npwpPemotong, nitkuPemotong, namaPemotong});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiBupot2() {
        DefaultTableModel model = this.createModelTransaksiBupot2();
        String sql = "SELECT * FROM tbl3_transaksibupot2  order by id desc";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotong = rs.getString("namaDipotong");
                String email = rs.getString("email");
                model.addRow(new Object[]{linkid, tglPemotong, kodeObjekPajak, jenisPajak, noBupot, masaBupot, npwpDipotong, nitkuDipotong, namaDipotong, email});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public DefaultTableModel createModelTransaksiBupot2email() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                switch (colIndex) {
                    default: 
                }
                return false;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                }
                return String.class;
            }
        };
        model.setColumnIdentifiers(new String[]{"ID", "No Bupot", "Jenis Pajak", "Masa Pajak ", "Npwp ", "Nama ", "No Dokumen", "Email ", "Email Terkirim"});
        return model;
    }

    public TableModel tableModelKirimEmail(int bulan, int tahun) throws SQLException {
        String masaPajak = "";
        masaPajak = bulan < 10 ? "0" + bulan + "-" + tahun : bulan + "-" + tahun;
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                return String.class;
            }
        };
        tableModel.addColumn("Pilih");
        tableModel.addColumn("NO");
        tableModel.addColumn("NPWP");
        tableModel.addColumn("Nama");
        tableModel.addColumn("Email");
        tableModel.addColumn("Detail");
        String sqlMaster = "SELECT DISTINCT NPWPDIPOTONG, NAMADIPOTONG, EMAIL FROM tbl3_transaksibupot2 WHERE MASABUPOT = ?";
        int no = 0;
        try (PreparedStatement pstMaster = this.dbkon.getKoneksi().prepareStatement(sqlMaster);){
            pstMaster.setString(1, masaPajak);
            ResultSet rsMaster = pstMaster.executeQuery();
            while (rsMaster.next()) {
                String npwp = rsMaster.getString("NPWPDIPOTONG");
                String nama = rsMaster.getString("NAMADIPOTONG");
                String email = rsMaster.getString("EMAIL");
                String sqlDetail = "SELECT NOBUPOT, JENISPAJAK, MASABUPOT, NODOKUMEN FROM ESINDOMT.tbl3_transaksibupot2 WHERE MASABUPOT = ? AND NPWPDIPOTONG = ? AND NAMADIPOTONG = ? AND EMAIL = ?";
                PreparedStatement pstDetail = this.dbkon.getKoneksi().prepareStatement(sqlDetail);
                Throwable throwable = null;
                try {
                    pstDetail.setString(1, masaPajak);
                    pstDetail.setString(2, npwp);
                    pstDetail.setString(3, nama);
                    pstDetail.setString(4, email);
                    ResultSet rsDetail = pstDetail.executeQuery();
                    StringBuilder jsonBuilder = new StringBuilder();
                    jsonBuilder.append("[");
                    boolean first = true;
                    while (rsDetail.next()) {
                        if (!first) {
                            jsonBuilder.append(",");
                        }
                        jsonBuilder.append("{").append("\"NOBUPOT\":\"").append(rsDetail.getString("NOBUPOT")).append("\",").append("\"JENISPAJAK\":\"").append(rsDetail.getString("JENISPAJAK")).append("\",").append("\"MASABUPOT\":\"").append(rsDetail.getString("MASABUPOT")).append("\",").append("\"NODOKUMEN\":\"").append(rsDetail.getString("NODOKUMEN")).append("\"").append("}");
                        first = false;
                    }
                    jsonBuilder.append("]");
                    String detailJson = jsonBuilder.toString();
                    tableModel.addRow(new Object[]{false, ++no, npwp, nama, email, detailJson});
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pstDetail == null) continue;
                    if (throwable != null) {
                        try {
                            pstDetail.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pstDetail.close();
                }
            }
        }
        return tableModel;
    }

    public TableModel tableModelTransaksiBupot2masa(int bulan, int tahun) {
        DefaultTableModel model = this.createModelTransaksiBupot2email();
        String masaPajak = "";
        masaPajak = bulan < 10 ? "0" + bulan + "-" + tahun : bulan + "-" + tahun;
        String sql = "SELECT * FROM tbl3_transaksibupot2 where masaBupot='" + masaPajak + "'  order by id desc";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotong = rs.getString("namaDipotong");
                String email = rs.getString("email");
                String emailterkirim = rs.getString("emailterkirim");
                model.addRow(new Object[]{linkid, noBupot, jenisPajak, masaBupot, npwpDipotong, namaDipotong, noDokumen, email, emailterkirim});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksi() {
        DefaultTableModel model = this.createModelTransaksi();
        String sql = "SELECT id,kdJenisTransaksi as Kode,fgPengganti,nomorFaktur,tanggalFaktur,masa_pajak,tahun_pajak,namaPenjual,namaLawanTransaksi,npwpLawanTransaksi ,is_kredit,status_export,nomorInvoice,jenisIdPembeli FROM tbl2_transaksi order by id desc";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String penjual = rs.getString("namaLawanTransaksi");
                String npwplawan = rs.getString("npwpLawanTransaksi");
                int kredit = rs.getInt("is_kredit");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                String noinvoice = rs.getString("nomorInvoice");
                String jenisIdPembeli = rs.getString("jenisIdPembeli");
                model.addRow(new Object[]{linkid, kode, no, tglfaktur, masapajak, thnpajak, jenisIdPembeli + "##" + npwplawan + "##" + penjual, status_export, noinvoice});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiStatusImportKosong() {
        DefaultTableModel model = this.createModelTransaksi();
        String sql = "SELECT id,kdJenisTransaksi as Kode,fgPengganti,nomorFaktur,tanggalFaktur,masa_pajak,tahun_pajak,namaPenjual,CAST(jumlahDpp as decimal) as jumlahDPP,CAST(jumlahPpn as decimal) as jumlahPpn,CAST(jumlahPpnBm as decimal) as jumlahPpnBm,is_kredit,status_export FROM tbl2_transaksi where status_export=0";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String penjual = rs.getString("namaPenjual");
                String jmldpp = rs.getString("jumlahDPP");
                String jmlppn = rs.getString("jumlahPpn");
                String jmlppnbm = rs.getString("jumlahPpnBm");
                int kredit = rs.getInt("is_kredit");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                model.addRow(new Object[]{linkid, kode, statusFaktur, no, tglfaktur, masapajak, thnpajak, bool, penjual, Float.valueOf(Float.parseFloat(jmldpp)), Float.valueOf(Float.parseFloat(jmlppn)), Float.valueOf(Float.parseFloat(jmlppnbm)), status_export});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiXml(String nofaktur) {
        DefaultTableModel model = this.createModelTransaksiCsvPK();
        String sql = "SELECT a.id, a.kdJenisTransaksi as Kode, a.fgPengganti, a.nomorFaktur, a.tanggalFaktur, a.masa_pajak, a.tahun_pajak, a.namaLawanTransaksi, sum(b.dpp) as jumlahDpp, sum(b.ppn) as jumlahPpn, sum(b.ppnbm) as jumlahPpnBm, a.status_export, a.nomorInvoice, a.is_kredit FROM tbl2_transaksi a INNER JOIN tbl2_transaksi_detail b ON a.id = b.transaksi2_id WHERE a.nomorInvoice LIKE '%" + nofaktur + "%' GROUP BY a.id, a.kdJenisTransaksi, a.fgPengganti, a.nomorFaktur, a.tanggalFaktur, a.masa_pajak, a.tahun_pajak, a.namaLawanTransaksi, a.status_export, a.nomorInvoice, a.is_kredit";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String namaLawanTransaksi = rs.getString("namaLawanTransaksi");
                double jmldpp = rs.getDouble("jumlahDPP");
                double jmlppn = rs.getDouble("jumlahPpn");
                double jmlppnbm = rs.getDouble("jumlahPpnBm");
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                Boolean select = false;
                String noinvoice = rs.getString("nomorInvoice");
                model.addRow(new Object[]{select, kode, statusFaktur, no, tglfaktur, masapajak, thnpajak, namaLawanTransaksi, jmldpp, jmlppn, jmlppnbm, status_export, noinvoice});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiBupotNamapemotong(String nama) {
        DefaultTableModel model = this.createModelTransaksiBupot();
        String sql = "SELECT * FROM tbl3_transaksibupot where UPPER(namaPemotong) LIKE  UPPER(?) order by id desc";
        System.out.println("sql masa pajak adalah " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setString(1, "%" + nama + "%");
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotongd = rs.getString("namaDipotong");
                model.addRow(new Object[]{linkid, tglPemotong, kodeObjekPajak, jenisPajak, noBupot, masaBupot, npwpPemotong, nitkuPemotong, namaPemotong});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiBupotNamapemotong2(String nobupot) {
        DefaultTableModel model = this.createModelTransaksiBupot2();
        String sql = "SELECT * FROM tbl3_transaksibupot2 where  UPPER(namaDipotong) LIKE  UPPER(?) order by id desc";
        System.out.println("sql masa pajak adalah " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setString(1, "%" + nobupot + "%");
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotong = rs.getString("namaDipotong");
                model.addRow(new Object[]{linkid, tglPemotong, kodeObjekPajak, jenisPajak, noBupot, masaBupot, npwpDipotong, nitkuDipotong, namaDipotong});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiBupotJenisPajak(String nobupot) {
        DefaultTableModel model = this.createModelTransaksiBupot();
        String sql = "SELECT * FROM tbl3_transaksibupot where jenisPajak='" + nobupot + "'  order by id desc";
        System.out.println("sql masa pajak adalah " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotongd = rs.getString("namaDipotong");
                model.addRow(new Object[]{linkid, tglPemotong, kodeObjekPajak, jenisPajak, noBupot, masaBupot, npwpPemotong, nitkuPemotong, namaPemotong});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiBupotJenisPajak2(String nobupot) {
        DefaultTableModel model = this.createModelTransaksiBupot2();
        String sql = "SELECT * FROM tbl3_transaksibupot2 where jenisPajak='" + nobupot + "'  order by id desc";
        System.out.println("sql masa pajak adalah " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotong = rs.getString("namaDipotong");
                model.addRow(new Object[]{linkid, tglPemotong, kodeObjekPajak, jenisPajak, noBupot, masaBupot, npwpDipotong, nitkuDipotong, namaDipotong});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiBupotNoBupot(String nobupot) {
        DefaultTableModel model = this.createModelTransaksiBupot();
        String sql = "SELECT * FROM tbl3_transaksibupot where noBupot LIKE '%" + nobupot + "%'  order by id desc";
        System.out.println("sql masa pajak adalah " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotongd = rs.getString("namaDipotong");
                model.addRow(new Object[]{linkid, tglPemotong, kodeObjekPajak, jenisPajak, noBupot, masaBupot, npwpPemotong, nitkuPemotong, namaPemotong});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiBupotNoBupot2(String nobupot) {
        DefaultTableModel model = this.createModelTransaksiBupot2();
        String sql = "SELECT * FROM tbl3_transaksibupot2 where noBupot LIKE '%" + nobupot + "%'  order by id desc";
        System.out.println("sql masa pajak adalah " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotong = rs.getString("namaDipotong");
                model.addRow(new Object[]{linkid, tglPemotong, kodeObjekPajak, jenisPajak, noBupot, masaBupot, npwpDipotong, nitkuDipotong, namaDipotong});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksi(String nofaktur) {
        DefaultTableModel model = this.createModelTransaksi();
        String sql = "SELECT id,kdJenisTransaksi as Kode,fgPengganti,nomorFaktur,tanggalFaktur,masa_pajak,tahun_pajak,namaPenjual,namaLawanTransaksi,npwpLawanTransaksi,is_kredit,status_export,nomorInvoice,jenisIdPembeli FROM tbl2_transaksi WHERE nomorInvoice like '%" + nofaktur + "%'";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                int kredit = rs.getInt("is_kredit");
                String namapembeli = rs.getString("namaLawanTransaksi");
                String npwpLawan = rs.getString("npwpLawanTransaksi");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                String noinvoice = rs.getString("nomorInvoice");
                String jenisIdPembeli = rs.getString("jenisIdPembeli");
                model.addRow(new Object[]{linkid, kode, no, tglfaktur, masapajak, thnpajak, jenisIdPembeli + "##" + npwpLawan + "##" + namapembeli, status_export, noinvoice});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiTanggal(String awal, String akhir, String kodejenis, boolean sudah_export, boolean all) {
        DefaultTableModel model = this.createModelTransaksi();
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kode='" + kodejenis + "' ";
        }
        String sql = "SELECT id,kdJenisTransaksi as Kode,fgPengganti,nomorFaktur,tanggalFaktur,masa_pajak,tahun_pajak,namaPenjual,namaLawanTransaksi ,npwpLawanTransaksi, is_kredit,status_export,nomorInvoice,jenisIdPembeli FROM tbl2_transaksi  WHERE  tanggalFaktur >= '" + awal + "' AND  tanggalFaktur <= '" + akhir + "' " + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0 or status_export is null";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export + " order by id desc";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String namapembeli = rs.getString("namaLawanTransaksi");
                String npwpLawn = rs.getString("npwpLawanTransaksi");
                int kredit = rs.getInt("is_kredit");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = rs.getInt("status_export") == 1;
                String noinvoice = rs.getString("nomorInvoice");
                String jenisIdPembeli = rs.getString("jenisIdPembeli");
                model.addRow(new Object[]{linkid, kode, no, tglfaktur, masapajak, thnpajak, jenisIdPembeli + "##" + npwpLawn + "##" + namapembeli, status_export, noinvoice});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiTanggal2(String awal, String akhir, String kodejenis, boolean sudah_export, boolean all) {
        DefaultTableModel model = this.createModelTransaksiCsvPK();
        String sql1 = "SELECT a.id,a.kdJenisTransaksi as Kode,a.fgPengganti, a.nomorFaktur,a.tanggalFaktur, a.masa_pajak,a.tahun_pajak,a.namaLawanTransaksi,sum(b.dpp) as jumlahDpp,sum(b.ppn) as jumlahPpn,sum(b.ppnbm) as jumlahPpnBm,a.status_export,a.nomorInvoice,a.is_kredit FROM tbl2_transaksi a inner join  tbl2_transaksi_detail b on a.id=b.transaksi2_id ";
        String groupby = " GROUP BY b.transaksi2_id, a.id, a.kdJenisTransaksi, a.fgPengganti, a.nomorFaktur, a.tanggalFaktur, a.masa_pajak, a.tahun_pajak, a.namaLawanTransaksi, a.status_export, a.nomorInvoice, a.is_kredit ";
        String orderby = " order by a.id desc ";
        String sqljen = "";
        if (kodejenis.equalsIgnoreCase("99")) {
            sqljen = " AND a.statusFaktur='SAVED_INVALID' ";
        }
        String str_export = "";
        str_export = sudah_export ? " and a.status_export=1" : " and a.status_export IS NULL";
        if (all) {
            str_export = "";
        }
        System.out.println("sudha export " + str_export);
        String sql = " where  a.tanggalFaktur >= '" + awal + "' AND  a.tanggalFaktur <= '" + akhir + "' ";
        sql = sql1 + sql + sqljen + str_export + groupby + orderby;
        System.out.println("SQL " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String namaLawanTransaksi = rs.getString("namaLawanTransaksi");
                double jmldpp = rs.getDouble("jumlahDPP");
                double jmlppn = rs.getDouble("jumlahPpn");
                double jmlppnbm = rs.getDouble("jumlahPpnBm");
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                String noinvoice = rs.getString("nomorInvoice");
                Boolean cek = false;
                model.addRow(new Object[]{cek, kode, statusFaktur, no, tglfaktur, masapajak, thnpajak, namaLawanTransaksi, jmldpp, jmlppn, jmlppnbm, status_export, noinvoice});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public double getTotalKreditTgl(String awal, String akhir, String kodejenis, boolean sudah_export, boolean all) {
        double total = 0.0;
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total FROM tbl2_transaksi  WHERE is_kredit=1  ";
        if (!awal.equalsIgnoreCase("") && !akhir.equalsIgnoreCase("")) {
            sql = sql + " AND tgl >= '" + awal + "' AND  tgl <= '" + akhir + "'";
        }
        sql = sql + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public double getTotalKreditTgl1(String awal, String akhir, String kodejenis, boolean sudah_export, boolean all) {
        double total = 0.0;
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total FROM tbl2_transaksi WHERE is_kredit=0 ";
        if (!awal.equalsIgnoreCase("") && !akhir.equalsIgnoreCase("")) {
            sql = sql + " AND tgl >= '" + awal + "' AND  tgl <= '" + akhir + "'";
        }
        sql = sql + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public double getTotalKreditMasaPajak(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        double total = 0.0;
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total FROM tbl2_transaksi where is_kredit=1  ";
        sql = sql + " AND masa_pajak = " + awalbulan + " AND tahun_pajak = " + awaltahun + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public double getTotalKreditMasaPajak1(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        double total = 0.0;
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total  FROM tbl2_transaksi where is_kredit=0 ";
        sql = sql + " AND masa_pajak = " + awalbulan + " AND tahun_pajak = " + awaltahun + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public double getTotalKreditNoFaktur(String nofaktur) {
        double total = 0.0;
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total FROM tbl2_transaksi where is_kredit=1 AND nomorfaktur='" + nofaktur + "'";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public double getTotalKreditNofaktur1(String nofaktur) {
        double total = 0.0;
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total  FROM tbl2_transaksi where is_kredit=0 AND nomorfaktur = '" + nofaktur + "'";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public TableModel tableModelTransaksiDetail(int trans_id) {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        model.setColumnIdentifiers(new String[]{"Id", "Kode Barang/Jasa", "Nama", "Harga Satuan", "Jumlah Barang", "Diskon", "DPP", "PPn", "Tarif PPnBm", "PPnBm"});
        String sql = "SELECT id,kodeBarang,barangJasa,nomorInvoice,nama,hargaSatuan, jumlahBarang,hargaTotal,diskon, dpp,ppn,tarifPpnbm,ppnbm,satuanUkur,dppLain  FROM tbl2_transaksi_detail WHERE transaksi2_id=?  ORDER BY id";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, trans_id);
            ResultSet rs = pst.executeQuery();
            Object it = null;
            DecimalFormat df = new DecimalFormat("#0.00");
            df.setDecimalSeparatorAlwaysShown(true);
            while (rs.next()) {
                int id = rs.getInt("id");
                String barangJasa = rs.getString("barangJasa");
                String kodebarang = rs.getString("kodeBarang");
                String noinvoice = rs.getString("nomorInvoice");
                String nama = rs.getString("nama");
                String hargasatuan = df.format(rs.getDouble("hargaSatuan"));
                float jmlbarang = rs.getFloat("jumlahBarang");
                String total = rs.getString("hargaTotal");
                String diskon = df.format(rs.getDouble("diskon"));
                String dpp = df.format(rs.getDouble("dpp"));
                String ppn = df.format(rs.getDouble("ppn"));
                float tarifppnbm = rs.getFloat("tarifPpnbm");
                float ppnbm = rs.getFloat("ppnbm");
                String val = kodebarang + " ( " + barangJasa + " ) ";
                model.addRow(new Object[]{id, val, nama, hargasatuan, Float.valueOf(jmlbarang), diskon, dpp, ppn, Float.valueOf(tarifppnbm), Float.valueOf(ppnbm)});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public ResultSet loadTransaksiAwal(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) throws SQLException {
        ResultSet rs = null;
        String sqljen = "";
        if (kodejenis.equalsIgnoreCase("99")) {
            sqljen = " AND statusFaktur='SAVED_INVALID' ";
        } else if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND a.kdJenisTransaksi='" + kodejenis + "'";
        }
        String sql1 = "SELECT a.id, a.kdJenisTransaksi AS Kode, a.fgPengganti, a.nomorFaktur, a.tanggalFaktur, a.masa_pajak, a.tahun_pajak, a.namaLawanTransaksi, a.npwpLawanTransaksi, SUM(b.dpp) AS jumlahDpp, SUM(b.ppn) AS jumlahPpn, SUM(b.ppnbm) AS jumlahPpnBm, a.status_export, a.nomorInvoice, a.is_kredit, a.jenisIdPembeli FROM tbl2_transaksi a INNER JOIN tbl2_transaksi_detail b ON a.id = b.transaksi2_id ";
        String groupby = " GROUP BY a.id, a.kdJenisTransaksi, a.fgPengganti, a.nomorFaktur, a.tanggalFaktur, a.masa_pajak, a.tahun_pajak, a.namaLawanTransaksi, a.npwpLawanTransaksi, a.status_export, a.nomorInvoice, a.is_kredit, a.jenisIdPembeli ";
        String orderby = "ORDER BY a.id DESC";
        String sql = sql1 + " WHERE a.masa_pajak = " + awalbulan + " AND a.tahun_pajak = " + awaltahun;
        sql = sql + sqljen;
        if (!all) {
            sql = sudah_export ? sql + " AND a.status_export = 1 " : sql + " AND a.status_export IS NULL ";
        }
        sql = sql + groupby + orderby;
        System.out.println("SQL " + sql);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        rs = pst.executeQuery();
        return rs;
    }

    public List<ZTransaksi> loadTransaksiExport(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        ArrayList<ZTransaksi> ls = new ArrayList<ZTransaksi>();
        String sqljen = "";
        if (kodejenis.equalsIgnoreCase("99")) {
            sqljen = " AND statusFaktur='SAVED_INVALID' ";
        } else if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql1 = "SELECT * FROM tbl2_transaksi ";
        String sql = "";
        sql = sql1 + " where masa_pajak = " + awalbulan + " AND tahun_pajak = " + awaltahun;
        sql = sql + sqljen;
        String str_export = "";
        System.out.println("sudah export " + sudah_export);
        str_export = sudah_export ? " and status_export=1" : " and status_export is null ";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export + " order by nomorInvoice asc";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                ZTransaksi ts = new ZTransaksi();
                ts.setKode(rs.getString("kdJenisTransaksi"));
                ts.setNpwpPenjual(rs.getString("npwpPenjual"));
                ts.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
                ts.setAlamatPenjual(rs.getString("alamatPenjual"));
                ts.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
                ts.setNamaLawan(rs.getString("namaLawanTransaksi"));
                ts.setNomorFaktur(rs.getString("nomorFaktur"));
                ts.setTglFaktur(rs.getString("tanggalFaktur"));
                ts.setMasaPajak(rs.getInt("masa_pajak"));
                ts.setTahunPajak(rs.getInt("tahun_pajak"));
                ts.setNamaPenjual(rs.getString("namaPenjual"));
                ts.setJumlahDPP(rs.getString("jumlahDpp"));
                ts.setJumlahPPN(rs.getString("jumlahPpn"));
                ts.setJumlanPPNBM(rs.getString("jumlahPpnBm"));
                ts.setIsCreditable(rs.getInt("is_kredit"));
                ts.setFgPengganti(rs.getString("fgPengganti"));
                ts.setNoinvoice(rs.getString("nomorInvoice"));
                ts.setIdTkuPenjual(rs.getString("idTkuPenjual"));
                ts.setJenisIdPembeli(rs.getString("jenisIdPembeli"));
                ts.setNegaraPembeli(rs.getString("negaraPembeli"));
                ts.setNoDokumenPembeli(rs.getString("noDokPembeli"));
                ts.setAddInfo(rs.getString("addInfo"));
                ts.setIdTkuPembeli(rs.getString("idTkuPembeli"));
                ts.setDokumenPendukung(rs.getString("dokumenPendukung"));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public List<ZTransaksi> loadTransaksiExport2(String awal, String akhir, String kodejenis, boolean sudah_export, boolean all) {
        ArrayList<ZTransaksi> ls = new ArrayList<ZTransaksi>();
        String sqljen = "";
        if (kodejenis.equalsIgnoreCase("99")) {
            sqljen = " AND statusFaktur='SAVED_INVALID' ";
        } else if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql1 = "SELECT * FROM tbl2_transaksi ";
        String sql = "";
        sql = sql1 + " where  tanggalFaktur >= '" + awal + "' AND  tanggalFaktur <= '" + akhir + "' ";
        sql = sql + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export is null";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export + " order by nomorInvoice asc";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                ZTransaksi ts = new ZTransaksi();
                ts.setKode(rs.getString("kdJenisTransaksi"));
                ts.setNpwpPenjual(rs.getString("npwpPenjual"));
                ts.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
                ts.setAlamatPenjual(rs.getString("alamatPenjual"));
                ts.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
                ts.setNamaLawan(rs.getString("namaLawanTransaksi"));
                ts.setNomorFaktur(rs.getString("nomorFaktur"));
                ts.setTglFaktur(rs.getString("tanggalFaktur"));
                ts.setMasaPajak(rs.getInt("masa_pajak"));
                ts.setTahunPajak(rs.getInt("tahun_pajak"));
                ts.setNamaPenjual(rs.getString("namaPenjual"));
                ts.setJumlahDPP(rs.getString("jumlahDpp"));
                ts.setJumlahPPN(rs.getString("jumlahPpn"));
                ts.setJumlanPPNBM(rs.getString("jumlahPpnBm"));
                ts.setIsCreditable(rs.getInt("is_kredit"));
                ts.setFgPengganti(rs.getString("fgPengganti"));
                ts.setNoinvoice(rs.getString("nomorInvoice"));
                ts.setIdTkuPenjual(rs.getString("idTkuPenjual"));
                ts.setJenisIdPembeli(rs.getString("jenisIdPembeli"));
                ts.setNegaraPembeli(rs.getString("negaraPembeli"));
                ts.setNoDokumenPembeli(rs.getString("noDokPembeli"));
                ts.setIdTkuPembeli(rs.getString("idTkuPembeli"));
                ts.setAddInfo(rs.getString("addInfo"));
                ts.setDokumenPendukung(rs.getString("dokumenPendukung"));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public List<ZTransaksi> loadTransaksiExport3(String noinvoi) {
        ArrayList<ZTransaksi> ls = new ArrayList<ZTransaksi>();
        String sql = "SELECT  * from tbl2_transaksi  WHERE nomorFaktur like '%" + noinvoi + "%' order by nomorInvoice asc ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                ZTransaksi ts = new ZTransaksi();
                ts.setKode(rs.getString("kdJenisTransaksi"));
                ts.setNpwpPenjual(rs.getString("npwpPenjual"));
                ts.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
                ts.setAlamatPenjual(rs.getString("alamatPenjual"));
                ts.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
                ts.setNamaLawan(rs.getString("namaLawanTransaksi"));
                ts.setNomorFaktur(rs.getString("nomorFaktur"));
                ts.setTglFaktur(rs.getString("tanggalFaktur"));
                ts.setMasaPajak(rs.getInt("masa_pajak"));
                ts.setTahunPajak(rs.getInt("tahun_pajak"));
                ts.setNamaPenjual(rs.getString("namaPenjual"));
                ts.setJumlahDPP(rs.getString("jumlahDpp"));
                ts.setJumlahPPN(rs.getString("jumlahPpn"));
                ts.setJumlanPPNBM(rs.getString("jumlahPpnBm"));
                ts.setIsCreditable(rs.getInt("is_kredit"));
                ts.setFgPengganti(rs.getString("fgPengganti"));
                ts.setNoinvoice(rs.getString("nomorInvoice"));
                ts.setIdTkuPenjual(rs.getString("idTkuPenjual"));
                ts.setJenisIdPembeli(rs.getString("jenisIdPembeli"));
                ts.setNegaraPembeli(rs.getString("negaraPembeli"));
                ts.setNoDokumenPembeli(rs.getString("noDokPembeli"));
                ts.setAddInfo(rs.getString("addInfo"));
                ts.setIdTkuPembeli(rs.getString("idTkuPembeli"));
                ts.setDokumenPendukung(rs.getString("dokumenPendukung"));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public List<ZTransaksi> loadTransaksiExport4(String noinvoi) {
        ArrayList<ZTransaksi> ls = new ArrayList<ZTransaksi>();
        String sql = "SELECT  * from tbl2_transaksi  WHERE nomorInvoice IN ( " + noinvoi + " ) order by nomorInvoice asc ";
        System.out.println("xxxx " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                ZTransaksi ts = new ZTransaksi();
                ts.setKode(rs.getString("kdJenisTransaksi"));
                ts.setNpwpPenjual(rs.getString("npwpPenjual"));
                ts.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
                ts.setAlamatPenjual(rs.getString("alamatPenjual"));
                ts.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
                ts.setNamaLawan(rs.getString("namaLawanTransaksi"));
                ts.setNomorFaktur(rs.getString("nomorFaktur"));
                ts.setTglFaktur(rs.getString("tanggalFaktur"));
                ts.setMasaPajak(rs.getInt("masa_pajak"));
                ts.setTahunPajak(rs.getInt("tahun_pajak"));
                ts.setNamaPenjual(rs.getString("namaPenjual"));
                ts.setJumlahDPP(rs.getString("jumlahDpp"));
                ts.setJumlahPPN(rs.getString("jumlahPpn"));
                ts.setJumlanPPNBM(rs.getString("jumlahPpnBm"));
                ts.setIsCreditable(rs.getInt("is_kredit"));
                ts.setFgPengganti(rs.getString("fgPengganti"));
                ts.setNoinvoice(rs.getString("nomorInvoice"));
                ts.setIdTkuPenjual(rs.getString("idTkuPenjual"));
                ts.setJenisIdPembeli(rs.getString("jenisIdPembeli"));
                ts.setNegaraPembeli(rs.getString("negaraPembeli"));
                ts.setNoDokumenPembeli(rs.getString("noDokPembeli"));
                ts.setAddInfo(rs.getString("addInfo"));
                ts.setIdTkuPembeli(rs.getString("idTkuPembeli"));
                ts.setDokumenPendukung(rs.getString("dokumenPendukung"));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public DefaultTableModel createModelTransaksi() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                switch (colIndex) {
                    case 7: {
                        return true;
                    }
                }
                return false;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                    case 7: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        model.setColumnIdentifiers(new String[]{"ID", "Kode", "Nomor Invoice", "Tanggal Faktur", "Masa Pajak *", "Tahun Pajak *", "Nama Lawan Transaksi", "Status Export", "Nomor Invoice"});
        return model;
    }

    public DefaultTableModel createModelTransaksiBupot() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                switch (colIndex) {
                    default: 
                }
                return false;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                }
                return String.class;
            }
        };
        model.setColumnIdentifiers(new String[]{"ID", "Tanggal Bupot", "Kode Objek Pajak", "Jenis Pajak", "No Bupot", "Masa Pajak ", "Npwp Pemotong", "Nitku Pemotong", "Nama Pemotong"});
        return model;
    }

    public DefaultTableModel createModelTransaksiBupot2() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                switch (colIndex) {
                    default: 
                }
                return false;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                }
                return String.class;
            }
        };
        model.setColumnIdentifiers(new String[]{"ID", "Tanggal Bupot", "Kode Objek Pajak", "Jenis Pajak", "No Bupot", "Masa Pajak ", "Npwp Dipotong", "Nitku Dipotong", "Nama Dipotong", "Email "});
        return model;
    }

    public TableModel tableModelTransaksiBupotMasaPajak(int bulan, int tahun) {
        String masaPajak = "";
        masaPajak = bulan < 10 ? "0" + bulan + "-" + tahun : bulan + "-" + tahun;
        DefaultTableModel model = this.createModelTransaksiBupot();
        String sql = "SELECT * FROM tbl3_transaksibupot where masaBupot='" + masaPajak + "'  order by id desc";
        System.out.println("sql masa pajak adalah " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotongd = rs.getString("namaDipotong");
                model.addRow(new Object[]{linkid, tglPemotong, kodeObjekPajak, jenisPajak, noBupot, masaBupot, npwpPemotong, nitkuPemotong, namaPemotong});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiBupotMasaPajak2(int bulan, int tahun) {
        String masaPajak = "";
        masaPajak = bulan < 10 ? "0" + bulan + "-" + tahun : bulan + "-" + tahun;
        DefaultTableModel model = this.createModelTransaksiBupot2();
        String sql = "SELECT * FROM tbl3_transaksibupot2 where masaBupot='" + masaPajak + "'  order by id desc";
        System.out.println("sql masa pajak adalah " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String noBupot = rs.getString("noBupot");
                String masaBupot = rs.getString("masaBupot");
                String sifat = rs.getString("sifat");
                String jenisBukti = rs.getString("jenisBukti");
                String jenisFasilitas = rs.getString("jenisFasilitas");
                String jenisPajak = rs.getString("jenisPajak");
                String kodeObjekPajak = rs.getString("kodeObjekPajak");
                String objekPajak = rs.getString("objekPajak");
                String dpp = rs.getString("dpp");
                String tarif = rs.getString("tarif");
                String pajak = rs.getString("pajak");
                String jenisDokumen = rs.getString("jenisDokumen");
                String tglDokumen = rs.getString("tglDokumen");
                String noDokumen = rs.getString("noDokumen");
                String npwpPemotong = rs.getString("npwpPemotong");
                String nitkuPemotong = rs.getString("nitkuPemotong");
                String namaPemotong = rs.getString("namaPemotong");
                String tglPemotong = rs.getString("tglPemotongan");
                String npwpDipotong = rs.getString("npwpDipotong");
                String nitkuDipotong = rs.getString("nitkuDipotong");
                String namaDipotong = rs.getString("namaDipotong");
                model.addRow(new Object[]{linkid, tglPemotong, kodeObjekPajak, jenisPajak, noBupot, masaBupot, npwpDipotong, nitkuDipotong, namaDipotong});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiTanggalAwal(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        DefaultTableModel model = this.createModelTransaksi();
        try {
            ResultSet rs = this.loadTransaksiAwal(awalbulan, awaltahun, kodejenis, sudah_export, all);
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String namapembeli = rs.getString("namaLawanTransaksi");
                String npwpLawan = rs.getString("npwpLawanTransaksi");
                int kredit = rs.getInt("is_kredit");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                String noinvoice = rs.getString("nomorInvoice");
                String jenisIdPembeli = rs.getString("jenisIdPembeli");
                model.addRow(new Object[]{linkid, kode, no, tglfaktur, masapajak, thnpajak, jenisIdPembeli + "##" + npwpLawan + "##" + namapembeli, status_export, noinvoice});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return model;
    }

    public int getJumlahDataTransaksi() throws SQLException {
        int jumlah = 0;
        String sql = " Select count(id) as jumlah from tbl2_transaksi ";
        PreparedStatement ps = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            jumlah = rs.getInt("jumlah");
        }
        rs.close();
        ps.close();
        this.dbkon.closeKoneksi();
        return jumlah;
    }

    public int getJumlahDataTransaksiBupot() throws SQLException {
        int jumlah = 0;
        String sql = " Select count(id) as jumlah from tbl3_transaksibupot ";
        PreparedStatement ps = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            jumlah = rs.getInt("jumlah");
        }
        rs.close();
        ps.close();
        this.dbkon.closeKoneksi();
        return jumlah;
    }

    public int getJumlahDataTransaksiBupotFrom(int idkey) throws SQLException {
        int jumlah = 0;
        String sql = " Select count(id) as jumlah from tbl3_transaksibupot where id > " + idkey;
        PreparedStatement ps = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            jumlah = rs.getInt("jumlah");
        }
        rs.close();
        ps.close();
        this.dbkon.closeKoneksi();
        return jumlah;
    }

    public ZTransaksi findByNomorInvoice(String noinvoice) throws SQLException {
        ZTransaksi tr = null;
        String sql = "SELECT id, nomorInvoice FROM tbl2_transaksi WHERE nomorInvoice = ? FETCH FIRST 1 ROWS ONLY ";
        try (Connection conn = this.dbkon.getKoneksi();
             PreparedStatement pst = conn.prepareStatement(sql);){
            pst.setString(1, noinvoice);
            try (ResultSet rs = pst.executeQuery();){
                if (rs.next()) {
                    tr = new ZTransaksi();
                    tr.setId(rs.getInt("id"));
                    tr.setNoinvoice(rs.getString("nomorInvoice"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tr;
    }

    public TransaksiBupot findByNomorBupot(String nobupot, String jenis) throws SQLException {
        TransaksiBupot tr = null;
        String sql = "SELECT id, noBupot,jenisBukti FROM tbl3_transaksibupot WHERE noBupot = ? and jenisBukti = ? FETCH FIRST 1 ROWS ONLY ";
        try (Connection conn = this.dbkon.getKoneksi();
             PreparedStatement pst = conn.prepareStatement(sql);){
            pst.setString(1, nobupot);
            pst.setString(2, jenis);
            try (ResultSet rs = pst.executeQuery();){
                if (rs.next()) {
                    tr = new TransaksiBupot();
                    tr.setId(rs.getInt("id"));
                    tr.setNoBupot(rs.getString("noBupot"));
                    tr.setJenisBukti(rs.getString("jenisBukti"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tr;
    }

    public TransaksiBupot findByNomorBupot2(String nobupot, String jenis) throws SQLException {
        TransaksiBupot tr = null;
        String sql = "SELECT id, noBupot,jenisBukti FROM tbl3_transaksibupot2 WHERE noBupot = ? and jenisBukti = ? FETCH FIRST 1 ROWS ONLY ";
        try (Connection conn = this.dbkon.getKoneksi();
             PreparedStatement pst = conn.prepareStatement(sql);){
            pst.setString(1, nobupot);
            pst.setString(2, jenis);
            try (ResultSet rs = pst.executeQuery();){
                if (rs.next()) {
                    tr = new TransaksiBupot();
                    tr.setId(rs.getInt("id"));
                    tr.setNoBupot(rs.getString("noBupot"));
                    tr.setJenisBukti(rs.getString("jenisBukti"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tr;
    }

    public void updateEmailBupot(TransaksiBupot obj) throws SQLException {
        System.out.println("emailll " + obj.getId() + " -- " + obj.getEmail());
        String sql = "update tbl3_transaksibupot2  set email =  ?   where id  = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getEmail());
        pst.setInt(2, obj.getId());
        pst.executeUpdate();
        pst.close();
    }

    public void updateStEmailBupot(String status, String npwp, String email) throws SQLException {
        String sql = "update tbl3_transaksibupot2  set emailTerkirim =  ?    where npwpdipotong  = ? and email =? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, status);
        pst.setString(2, npwp);
        pst.setString(3, email);
        pst.executeUpdate();
        pst.close();
    }

    public ZTransaksi sumDetail(String noinvoice) throws SQLException {
        ZTransaksi tr = new ZTransaksi();
        String sql = "SELECT nomorInvoice,sum(dpp) as dpp,sum(ppn) as ppn FROM tbl2_transaksi_detail  WHERE nomorInvoice=? group by nomorInvoice";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, noinvoice);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new ZTransaksi();
            tr.setNoinvoice(rs.getString("nomorInvoice"));
            tr.setJumlahDPP(rs.getString("dpp"));
            tr.setJumlahPPN(rs.getString("ppn"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public ZItemTransaksi findByDetailTr(String noinvoice, String nama, int id) throws SQLException {
        ZItemTransaksi tr = null;
        String sql = "SELECT id,nama,transaksi2_id,nomorInvoice FROM tbl2_transaksi_detail  WHERE nomorInvoice = ? and CAST(nama AS VARCHAR(500)) = ? and transaksi2_id = ?";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, noinvoice);
        pst.setString(2, nama);
        pst.setInt(3, id);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new ZItemTransaksi();
            tr.setId(rs.getInt("id"));
            tr.setNoinvoice(rs.getString("nomorInvoice"));
            tr.setNama(rs.getString("nama"));
            tr.setTransaksiId(rs.getInt("transaksi2_id"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public ZItemTransaksi findByDetailId(int id) throws SQLException {
        ZItemTransaksi tr = new ZItemTransaksi();
        String sql = "SELECT id,nama,transaksi2_id,nomorInvoice FROM tbl2_transaksi_detail  WHERE  transaksi2_id = ?";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new ZItemTransaksi();
            tr.setId(rs.getInt("id"));
            tr.setNoinvoice(rs.getString("nomorInvoice"));
            tr.setNama(rs.getString("nama"));
            tr.setTransaksiId(rs.getInt("transaksi2_id"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public ZItemTransaksi findByDetailIdpK(int id) throws SQLException {
        ZItemTransaksi tr = new ZItemTransaksi();
        String sql = "SELECT *  FROM tbl2_transaksi_detail  WHERE id = ?";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, id);
        DecimalFormat df = new DecimalFormat("#0.00");
        df.setDecimalSeparatorAlwaysShown(true);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new ZItemTransaksi();
            tr.setId(rs.getInt("id"));
            tr.setBarangJasa(rs.getString("barangJasa"));
            tr.setHargaSatuan(df.format(rs.getDouble("hargaSatuan")));
            tr.setJumlahBarang(df.format(rs.getDouble("jumlahBarang")));
            tr.setDpp(df.format(rs.getDouble("dpp")));
            tr.setDppLain(df.format(rs.getDouble("dppLain")));
            tr.setDiskon(df.format(rs.getDouble("diskon")));
            tr.setNoinvoice(rs.getString("nomorInvoice"));
            tr.setNama(rs.getString("nama"));
            tr.setTransaksiId(rs.getInt("transaksi2_id"));
            tr.setTarifPpnbm(rs.getString("tarifPpnbm"));
            tr.setPpnbm(rs.getString("ppnbm"));
            tr.setPpn(df.format(rs.getDouble("ppn")));
            tr.setSatuanUkur(rs.getString("satuanUkur"));
            tr.setSatuanPPn(rs.getString("tarifPPn"));
            tr.setKode(rs.getString("kodeBarang"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public TransaksiBupot findTransaksiBubotDetailsId(int id) {
        TransaksiBupot ts = new TransaksiBupot();
        DefaultTableModel model = this.createModelTransaksiBupot();
        String sql = "SELECT * FROM tbl3_transaksibupot where id =" + id + " order by id desc";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                ts = new TransaksiBupot();
                ts.setId(rs.getInt("id"));
                ts.setNoBupot(rs.getString("noBupot"));
                ts.setMasaBupot(rs.getString("masaBupot"));
                ts.setSifat(rs.getString("sifat"));
                ts.setJenisBukti(rs.getString("jenisBukti"));
                ts.setJenisFasilitas(rs.getString("jenisFasilitas"));
                ts.setJenisPajak(rs.getString("jenisPajak"));
                ts.setKodeObjekPajak(rs.getString("kodeObjekPajak"));
                ts.setObjekPajak(rs.getString("objekPajak"));
                ts.setDpp(Double.valueOf(rs.getString("dpp")));
                ts.setTarif(Double.valueOf(rs.getString("tarif")));
                ts.setPajak(Double.valueOf(rs.getString("pajak")));
                ts.setJenisDokumen(rs.getString("jenisDokumen"));
                ts.setTglDokumen(rs.getString("tglDokumen"));
                ts.setNoDokumen(rs.getString("noDokumen"));
                ts.setNpwpPemotong(rs.getString("npwpPemotong"));
                ts.setNitkuPemotong(rs.getString("nitkuPemotong"));
                ts.setNamaPemotong(rs.getString("namaPemotong"));
                ts.setTglPemotongan(rs.getString("tglPemotongan"));
                ts.setNpwpDipotong(rs.getString("npwpDipotong"));
                ts.setNitkuDipotong(rs.getString("nitkuDipotong"));
                ts.setNamaDipotong(rs.getString("namaDipotong"));
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return ts;
    }

    public TransaksiBupot findTransaksiBubotDetailsId2(int id) {
        TransaksiBupot ts = new TransaksiBupot();
        DefaultTableModel model = this.createModelTransaksiBupot();
        String sql = "SELECT * FROM tbl3_transaksibupot2 where id =" + id + " order by id desc";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                ts = new TransaksiBupot();
                ts.setId(rs.getInt("id"));
                ts.setNoBupot(rs.getString("noBupot"));
                ts.setMasaBupot(rs.getString("masaBupot"));
                ts.setSifat(rs.getString("sifat"));
                ts.setJenisBukti(rs.getString("jenisBukti"));
                ts.setJenisFasilitas(rs.getString("jenisFasilitas"));
                ts.setJenisPajak(rs.getString("jenisPajak"));
                ts.setKodeObjekPajak(rs.getString("kodeObjekPajak"));
                ts.setObjekPajak(rs.getString("objekPajak"));
                ts.setDpp(Double.valueOf(rs.getString("dpp")));
                ts.setTarif(Double.valueOf(rs.getString("tarif")));
                ts.setPajak(Double.valueOf(rs.getString("pajak")));
                ts.setJenisDokumen(rs.getString("jenisDokumen"));
                ts.setTglDokumen(rs.getString("tglDokumen"));
                ts.setNoDokumen(rs.getString("noDokumen"));
                ts.setNpwpPemotong(rs.getString("npwpPemotong"));
                ts.setNitkuPemotong(rs.getString("nitkuPemotong"));
                ts.setNamaPemotong(rs.getString("namaPemotong"));
                ts.setTglPemotongan(rs.getString("tglPemotongan"));
                ts.setNpwpDipotong(rs.getString("npwpDipotong"));
                ts.setNitkuDipotong(rs.getString("nitkuDipotong"));
                ts.setNamaDipotong(rs.getString("namaDipotong"));
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return ts;
    }

    public ZTransaksi findTransaksiDetailsId(int id) throws SQLException {
        ZTransaksi ts = new ZTransaksi();
        String sql = "SELECT a.id,a.npwpPenjual,a.namaPenjual,a.noDokPembeli,a.addInfo,a.dokumenPendukung,a.kdJenisTransaksi, a.fgPengganti, a.nomorFaktur, a.tanggalFaktur, a.masa_pajak, a.tahun_pajak, a.namaLawanTransaksi,a.alamatLawanTransaksi, a.npwpLawanTransaksi, a.status_export, a.nomorInvoice, a.is_kredit, a.jenisIdPembeli, a.idTkuPembeli AS nitku, SUM(b.dpp) AS jumlahDppsum, SUM(b.ppn) AS jumlahPpnsum, SUM(b.ppnbm) AS jumlahPpnBmsum FROM tbl2_transaksi a LEFT JOIN tbl2_transaksi_detail b ON a.id = b.transaksi2_id WHERE a.id = ? GROUP BY a.id, a.npwpPenjual,a.namaPenjual,a.kdJenisTransaksi,a.noDokPembeli,a.addInfo,a.dokumenPendukung,a.fgPengganti, a.nomorFaktur, a.tanggalFaktur, a.masa_pajak, a.tahun_pajak, a.namaLawanTransaksi,a.alamatLawanTransaksi, a.npwpLawanTransaksi, a.status_export, a.nomorInvoice, a.is_kredit, a.jenisIdPembeli, a.idTkuPembeli";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ts = new ZTransaksi();
            ts.setId(rs.getInt("id"));
            ts.setKode(rs.getString("kdJenisTransaksi"));
            ts.setNpwpPenjual(rs.getString("npwpPenjual"));
            ts.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
            ts.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
            ts.setNamaLawan(rs.getString("namaLawanTransaksi"));
            ts.setNomorFaktur(rs.getString("nomorFaktur"));
            ts.setTglFaktur(rs.getString("tanggalFaktur"));
            ts.setMasaPajak(rs.getInt("masa_pajak"));
            ts.setTahunPajak(rs.getInt("tahun_pajak"));
            ts.setNamaPenjual(rs.getString("namaPenjual"));
            ts.setJumlahDPP(rs.getString("jumlahDppsum"));
            ts.setJumlahPPN(rs.getString("jumlahPpnsum"));
            ts.setJumlanPPNBM(rs.getString("jumlahPpnBmsum"));
            ts.setIsCreditable(rs.getInt("is_kredit"));
            ts.setFgPengganti(rs.getString("fgPengganti"));
            ts.setNoinvoice(rs.getString("nomorInvoice"));
            ts.setJenisIdPembeli(rs.getString("jenisIdPembeli"));
            ts.setNoDokumenPembeli(rs.getString("noDokPembeli"));
            ts.setAddInfo(rs.getString("addInfo"));
            ts.setIdTkuPembeli(rs.getString("nitku"));
            ts.setDokumenPendukung(rs.getString("dokumenPendukung"));
            System.out.println("jumlah dpp " + ts.getAlamatLawan());
        }
        rs.close();
        pst.close();
        return ts;
    }

    public ZTransaksi findTransaksiId(int id) throws SQLException {
        ZTransaksi ts = new ZTransaksi();
        String sql = "SELECT * FROM tbl2_transaksi   WHERE id = ?";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ts = new ZTransaksi();
            ts.setId(rs.getInt("id"));
            ts.setKode(rs.getString("kdJenisTransaksi"));
            ts.setNpwpPenjual(rs.getString("npwpPenjual"));
            ts.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
            ts.setAlamatPenjual(rs.getString("alamatPenjual"));
            ts.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
            ts.setNamaLawan(rs.getString("namaLawanTransaksi"));
            ts.setNomorFaktur(rs.getString("nomorFaktur"));
            ts.setTglFaktur(rs.getString("tanggalFaktur"));
            ts.setMasaPajak(rs.getInt("masa_pajak"));
            ts.setTahunPajak(rs.getInt("tahun_pajak"));
            ts.setNamaPenjual(rs.getString("namaPenjual"));
            ts.setJumlahDPP(rs.getString("jumlahDpp"));
            ts.setJumlahPPN(rs.getString("jumlahPpn"));
            ts.setJumlanPPNBM(rs.getString("jumlahPpnBm"));
            ts.setIsCreditable(rs.getInt("is_kredit"));
            ts.setFgPengganti(rs.getString("fgPengganti"));
            ts.setNoinvoice(rs.getString("nomorInvoice"));
        }
        rs.close();
        pst.close();
        return ts;
    }

    public TableModel tableModelTransaksiTanggalAwalCSVPK(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        DefaultTableModel model = this.createModelTransaksiCsvPK();
        try {
            ResultSet rs = this.loadTransaksiAwal(awalbulan, awaltahun, kodejenis, sudah_export, all);
            Object t = null;
            while (rs.next()) {
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String namaLawanTransaksi = rs.getString("namaLawanTransaksi");
                double jmldpp = rs.getDouble("jumlahDPP");
                double jmlppn = rs.getDouble("jumlahPpn");
                double jmlppnbm = rs.getDouble("jumlahPpnBm");
                Boolean status_export = false;
                Boolean cek = false;
                status_export = rs.getInt("status_export") == 1;
                String noinvoice = rs.getString("nomorInvoice");
                model.addRow(new Object[]{cek, kode, statusFaktur, no, tglfaktur, masapajak, thnpajak, namaLawanTransaksi, jmldpp, jmlppn, jmlppnbm, status_export, noinvoice});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return model;
    }

    public DefaultTableModel createModelTransaksiCsvPK() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                switch (colIndex) {
                    case 0: {
                        return true;
                    }
                    case 8: {
                        return true;
                    }
                    case 13: {
                        return true;
                    }
                }
                return false;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 8: {
                        return Float.class;
                    }
                    case 9: {
                        return Float.class;
                    }
                    case 10: {
                        return Float.class;
                    }
                    case 11: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        model.setColumnIdentifiers(new String[]{"Selected", "Kode", "Pengganti", "Nomor Faktur", "Tanggal Faktur", "Masa Pajak ", "Tahun Pajak ", "Nama Lawan Transaksi", "Jumlah DPP", "Jumlah PPN", "Jumlah PPnBm", "Status Export", "Nomor Invoice"});
        return model;
    }

    public List<ZItemTransaksi> loadTransaksiExportDetail(String no) {
        ArrayList<ZItemTransaksi> ls = new ArrayList<ZItemTransaksi>();
        String sql = "SELECT * FROM tbl2_transaksi_detail WHERE nomorInvoice = '" + no + "'";
        DecimalFormat df = new DecimalFormat("#0.00");
        df.setDecimalSeparatorAlwaysShown(true);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                ZItemTransaksi ts = new ZItemTransaksi();
                ts.setNama(rs.getString("nama"));
                ts.setNoinvoice(rs.getString("nomorInvoice"));
                ts.setKodeBarang(rs.getString("kodeBarang"));
                ts.setBarangJasa(rs.getString("barangJasa"));
                ts.setSatuanPPn(rs.getString("tarifPPn"));
                ts.setSatuanUkur(rs.getString("satuanUkur"));
                ts.setHargaSatuan(df.format(rs.getDouble("hargaSatuan")));
                ts.setJumlahBarang(df.format(rs.getDouble("jumlahBarang")));
                ts.setHargaTotal(df.format(rs.getDouble("hargaTotal")));
                ts.setDiskon(df.format(rs.getDouble("diskon")));
                ts.setDpp(df.format(rs.getDouble("dpp")));
                ts.setPpn(df.format(rs.getDouble("ppn")));
                ts.setTarifPpnbm(df.format(rs.getDouble("tarifPpnbm")));
                ts.setPpnbm(df.format(rs.getDouble("ppnbm")));
                ts.setDppLain(df.format(rs.getDouble("dppLain")));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public void updateTransaksiSudahExport(String str) throws SQLException {
        String sql = "UPDATE tbl2_transaksi SET status_export=1  WHERE nomorInvoice IN (" + str + ")";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.executeUpdate();
        pst.close();
        this.dbkon.closeKoneksi();
    }

    public List<TransaksiBupot> loadTransaksiExportXLSBupotJenis(String kata, int MODE_CARI) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

