/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.model;

import db.DBKoneksi;
import esindo.net.model.ZRefNofaktur;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.MaskFormatter;
import net.proteanit.sql.DbUtils;

public class ZDAORefNoFaktur {
    DBKoneksi dbkon = new DBKoneksi();

    public TableModel tableModel() {
        DefaultTableModel model = this.createModelTransaksi();
        String sql = "Select id,tahun,nofakturawal,nofakturakhir,tglrekam,tglupdate,aktif,nocounter, kdtransaksi,kdtahun FROM tbl2_ref_nofaktur ";
        String phoneMask = "###-##-########";
        String noawal = "";
        String noakhir = "";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            rs = pst.executeQuery();
            int no = 0;
            while (rs.next()) {
                int id = rs.getInt("id");
                int tahun = rs.getInt("tahun");
                String nofakturawal = rs.getString("nofakturawal");
                String nofakturakhir = rs.getString("nofakturakhir");
                String kdtransaksi = rs.getString("kdtransaksi");
                String kdtahun = rs.getString("kdtahun");
                String merge = kdtransaksi + "" + kdtahun + "" + nofakturawal;
                String merge2 = kdtransaksi + "" + kdtahun + "" + nofakturakhir;
                try {
                    MaskFormatter maskFormatter = new MaskFormatter(phoneMask);
                    maskFormatter.setValueContainsLiteralCharacters(false);
                    noawal = maskFormatter.valueToString(merge);
                    noakhir = maskFormatter.valueToString(merge2);
                }
                catch (ParseException ex) {
                    Logger.getLogger(ZDAORefNoFaktur.class.getName()).log(Level.SEVERE, null, ex);
                }
                String tglrekam = rs.getString("tglrekam");
                String tglupdate = rs.getString("tglupdate");
                int aktif = rs.getInt("aktif");
                String aktifStr = aktif == 1 ? "Aktif" : "Tidak Aktif";
                int nocounter = rs.getInt("nocounter");
                ++no;
                model.addRow(new Object[]{id, tahun, noawal, noakhir, tglrekam, tglupdate, aktifStr, nocounter});
            }
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelID(int idp) {
        DefaultTableModel model = this.createModelTransaksi();
        String sql = "Select a.id,a.kode,a.nama,a.alamat,a.telpon,a.npwp,a.kpp_kode FROM cabang a where a.id = ?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            pst.setInt(1, idp);
            rs = pst.executeQuery();
            int no = 0;
            while (rs.next()) {
                int id = rs.getInt("id");
                String kode = rs.getString("kode");
                String nama = rs.getString("nama");
                String alamat = rs.getString("alamat");
                String telpon = rs.getString("telpon");
                String npwp = rs.getString("npwp");
                String kodekpp = rs.getString("kpp_kode");
                ++no;
                model.addRow(new Object[]{id, kode, nama, alamat, telpon, npwp, kodekpp});
            }
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public TableModel selectall(int idper) {
        TableModel model = new DefaultTableModel();
        String sql = "Select a.id,a.kode,a.nama,a.alamat,a.telpon,a.npwp,a.kpp_kode FROM cabang a where a.perusahaan_id = ?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            pst.setInt(1, idper);
            rs = pst.executeQuery();
            model = DbUtils.resultSetToTableModel((ResultSet)rs);
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public void updateNofaktur(ZRefNofaktur obj) throws SQLException {
        String sql = "update tbl2_ref_nofaktur set nocounter =  ?   where id = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, obj.getNocounter());
        pst.setInt(2, obj.getId());
        pst.executeUpdate();
        pst.close();
    }

    public ZRefNofaktur findNofakturAktif() throws SQLException {
        ZRefNofaktur tr = new ZRefNofaktur();
        String sql = "SELECT * FROM tbl2_ref_nofaktur  WHERE aktif = 1 limit 1";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new ZRefNofaktur();
            tr.setId(rs.getInt("id"));
            tr.setTahun(rs.getInt("tahun"));
            tr.setNofakturawal(rs.getString("nofakturawal"));
            tr.setNofakturakhir(rs.getString("nofakturakhir"));
            tr.setAktif(rs.getInt("aktif"));
            tr.setNocounter(rs.getInt("nocounter"));
            tr.setKdtransaksi(rs.getString("kdtransaksi"));
            tr.setKdtahun(rs.getString("kdtahun"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public ZRefNofaktur findByIdfaktur(int id) throws SQLException {
        ZRefNofaktur tr = new ZRefNofaktur();
        String sql = "SELECT * FROM tbl2_ref_nofaktur  WHERE  id = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new ZRefNofaktur();
            tr.setId(rs.getInt("id"));
            tr.setTahun(rs.getInt("tahun"));
            tr.setNofakturawal(rs.getString("nofakturawal"));
            tr.setNofakturakhir(rs.getString("nofakturakhir"));
            tr.setAktif(rs.getInt("aktif"));
            tr.setNocounter(rs.getInt("nocounter"));
            tr.setKdtransaksi(rs.getString("kdtransaksi"));
            tr.setKdtahun(rs.getString("kdtahun"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public ZRefNofaktur findByAktif() throws SQLException {
        ZRefNofaktur tr = new ZRefNofaktur();
        String sql = "SELECT * FROM tbl2_ref_nofaktur  WHERE  aktif = 1 limit 1";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new ZRefNofaktur();
            tr.setId(rs.getInt("id"));
            tr.setTahun(rs.getInt("tahun"));
            tr.setNofakturawal(rs.getString("nofakturawal"));
            tr.setNofakturakhir(rs.getString("nofakturakhir"));
            tr.setAktif(rs.getInt("aktif"));
            tr.setNocounter(rs.getInt("nocounter"));
            tr.setKdtransaksi(rs.getString("kdtransaksi"));
            tr.setKdtahun(rs.getString("kdtahun"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public void updateRefId(ZRefNofaktur obj) throws SQLException {
        String sql = "update tbl2_ref_nofaktur set nocounter =  ? , tahun = ? , nocounter = ? , aktif =? , kdtransaksi = ? , kdtahun = ?    where id = ? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, obj.getNocounter());
        pst.setInt(2, obj.getTahun());
        pst.setInt(3, obj.getNocounter());
        pst.setInt(4, obj.getAktif());
        pst.setString(5, obj.getKdtransaksi());
        pst.setString(6, obj.getKdtahun());
        pst.setInt(7, obj.getId());
        pst.executeUpdate();
        pst.close();
    }

    public DefaultTableModel createModelTransaksi() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                switch (colIndex) {
                    default: 
                }
                return false;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    default: 
                }
                return String.class;
            }
        };
        model.setColumnIdentifiers(new String[]{"ID", "Tahun", "No Faktur Awal", "No Faktur Akhir", "Tanggal Rekam", "Tanggal Update", "Status Aktif", "No Faktur"});
        return model;
    }
}

