/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.model;

import db.DBKoneksi;
import esindo.net.model.ZKodePerusahaan;
import esindo.net.model.ZrefHeader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.proteanit.sql.DbUtils;

public class ZDAORefHeader {
    DBKoneksi dbkon = new DBKoneksi();
    private Connection con;

    public ZrefHeader findByNama(String nama) throws SQLException {
        ZrefHeader obj = new ZrefHeader();
        String sql = "Select * from tbl2_ref_header WHERE nama = ?";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, nama);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            obj = new ZrefHeader();
            obj.setId(rs.getInt("id"));
            obj.setNama(rs.getString("nama"));
            obj.setGroup_id(rs.getInt("group_id"));
        }
        rs.close();
        pst.close();
        return obj;
    }

    public ZrefHeader findByNamaGroup(String nama) throws SQLException {
        ZrefHeader obj = new ZrefHeader();
        String sql = "SELECT a.id, a.nama, a.group_id, b.nama_group AS groupname FROM tbl2_ref_header a INNER JOIN tbl2_group_header b ON a.group_id = b.id WHERE a.nama = ? ";
        try (Connection conn = this.dbkon.getKoneksi();
             PreparedStatement pst = conn.prepareStatement(sql);){
            pst.setString(1, nama);
            try (ResultSet rs = pst.executeQuery();){
                if (rs.next()) {
                    obj = new ZrefHeader();
                    obj.setId(rs.getInt("id"));
                    obj.setNama(rs.getString("nama"));
                    obj.setGroup_id(rs.getInt("group_id"));
                    obj.setGroupname(rs.getString("groupname"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public ZrefHeader findByHeaderID(int id) throws SQLException {
        ZrefHeader obj = new ZrefHeader();
        String sql = "Select * from tbl2_group_header WHERE id = ?";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            obj = new ZrefHeader();
            obj.setId(rs.getInt("id"));
            obj.setNama(rs.getString("nama_group"));
            obj.setGroup_id(rs.getInt("group_id"));
        }
        rs.close();
        pst.close();
        return obj;
    }

    public void insert(ZrefHeader obj) throws SQLException {
        String sql = "insert into  tbl2_ref_header (nama,group_id)  values (?,?) ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getNama());
        pst.setInt(2, obj.getGroup_id());
        pst.executeUpdate();
        pst.close();
    }

    public void hapusRefHeader(int id) throws SQLException {
        String sql = "delete from tbl2_ref_header  where id=?  ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, id);
        pst.executeUpdate();
        pst.close();
    }

    public void hapusRefHeaderSelected(String idkey) {
        String sql = "DELETE FROM tbl2_ref_header WHERE id IN ( " + idkey + " )";
        System.out.println("sqllnya " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ZrefHeader obj) throws SQLException {
        String sql = "UPDATE tbl2_ref_header  SET group_id=? where id=? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, obj.getGroup_id());
        pst.setInt(2, obj.getId());
        pst.executeUpdate();
        pst.close();
    }

    public DefaultComboBoxModel getComboJenis() {
        DefaultComboBoxModel<ZrefHeader> model = new DefaultComboBoxModel<ZrefHeader>();
        String sql = "SELECT id,nama_group as nama,group_id FROM tbl2_group_header where isawal =0";
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            this.con = this.dbkon.getKoneksi();
            pst = this.con.prepareStatement(sql);
            rs = pst.executeQuery();
            ZrefHeader obj = null;
            obj = new ZrefHeader();
            obj.setNama("--- Master Transaksi ---*");
            boolean cmb = false;
            model.addElement(obj);
            while (rs.next()) {
                int yes = rs.getInt("group_id");
                if (yes == 2 && !cmb) {
                    obj = new ZrefHeader();
                    obj.setNama("--- Detail Transaksi--");
                    model.addElement(obj);
                    cmb = true;
                }
                obj = new ZrefHeader();
                obj.setId(rs.getInt("id"));
                obj.setNama(rs.getString("nama"));
                model.addElement(obj);
            }
        }
        catch (SQLException ee) {
            ee.printStackTrace();
            throw new RuntimeException();
        }
        return model;
    }

    public String getComboJenisKode() {
        DefaultComboBoxModel<ZrefHeader> model = new DefaultComboBoxModel<ZrefHeader>();
        ZrefHeader obj = null;
        for (int i = 0; i < this.getKodePrsh().size(); ++i) {
            obj = new ZrefHeader();
            obj.setNama(this.getKodePrsh().get(i).toString());
            model.addElement(obj);
            System.out.println("ad " + this.getKodePrsh().get(i));
        }
        return "";
    }

    public ArrayList getKodePrsh() {
        ArrayList<String> strKode = new ArrayList<String>();
        strKode.add("02");
        strKode.add("03");
        strKode.add("07");
        return strKode;
    }

    public TableModel selectall2() {
        TableModel model = new DefaultTableModel();
        String sql = "Select a.id,a.nama,group_id from tbl2_ref_header a ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            model = DbUtils.resultSetToTableModel((ResultSet)rs);
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public TableModel selectall() {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn("Id");
        model.addColumn("Nama");
        model.addColumn("Group");
        String sql = "Select a.id,a.nama,group_id from tbl2_ref_header a ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            ZrefHeader obj = null;
            int grp = 0;
            String nama_group = "";
            while (rs.next()) {
                obj = new ZrefHeader();
                obj.setId(rs.getInt("id"));
                obj.setNama(rs.getString("nama"));
                grp = rs.getInt("group_id");
                nama_group = grp != 0 ? this.findByHeaderID(grp).getNama() : "";
                model.addRow(new Object[]{obj.getId(), obj.getNama(), nama_group});
            }
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public void insertHeader(ZrefHeader obj) throws SQLException {
        String sql = "insert into tbl2_ref_header (nama,group_id)  values (?,?) ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, obj.getGroup_id());
        pst.setString(2, obj.getNama());
        pst.executeUpdate();
        pst.close();
    }

    public void insertWapu(ZKodePerusahaan obj) throws SQLException {
        System.out.println("obj " + obj.getKode() + obj.getNpwp() + " " + obj.getNamaPerusahaan());
        String sql = "insert into  tbl2_kode_wapu(kode,npwp,namaPerusahaan,nitku,alamat)  values (?,?,?,?,?) ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getKode());
        pst.setString(2, obj.getNpwp());
        pst.setString(3, obj.getNamaPerusahaan());
        pst.setString(4, obj.getNitku());
        pst.setString(5, obj.getAlamat());
        pst.executeUpdate();
        pst.close();
    }

    public void hapusWapuSelected(String idkey) {
        String sql = "DELETE FROM tbl2_kode_wapu WHERE id IN ( " + idkey + " )";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void hapusWapu(int id) throws SQLException {
        String sql = "delete from tbl2_kode_wapu  where id=?  ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, id);
        pst.executeUpdate();
        pst.close();
    }

    public void updateWapu(ZKodePerusahaan obj) throws SQLException {
        String sql = "UPDATE tbl2_kode_wapu SET namaPerusahaan=?, kode= ?, npwp =? ,nitku = ? ,alamat = ? , unit = ? where id=? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getNamaPerusahaan());
        pst.setString(2, obj.getKode());
        pst.setString(3, obj.getNpwp());
        pst.setString(4, obj.getNitku());
        pst.setString(5, obj.getAlamat());
        pst.setString(6, obj.getUnit());
        pst.setInt(7, obj.getId());
        pst.executeUpdate();
        pst.close();
    }

    public TableModel selectAllWapu() {
        TableModel model = new DefaultTableModel();
        String sql = "Select * from tbl2_kode_wapu ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            model = DbUtils.resultSetToTableModel((ResultSet)rs);
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public TableModel selectAllWapuKon(String teks, int jenis) {
        TableModel model = new DefaultTableModel();
        String sql = "";
        sql = jenis == 1 ? "SELECT * FROM tbl2_kode_wapu WHERE UPPER(namaPerusahaan) LIKE UPPER(?)" : (jenis == 2 ? "SELECT * FROM tbl2_kode_wapu WHERE UPPER(npwp) LIKE UPPER(?)" : (jenis == 3 ? "SELECT * FROM tbl2_kode_wapu WHERE UPPER(unit) LIKE UPPER(?)" : "Select * from tbl2_kode_wapu "));
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setString(1, "%" + teks + "%");
            ResultSet rs = pst.executeQuery();
            model = DbUtils.resultSetToTableModel((ResultSet)rs);
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public ZKodePerusahaan findByIdWapu(String id) throws SQLException {
        ZKodePerusahaan obj = new ZKodePerusahaan();
        String sql = "Select * from tbl2_kode_wapu WHERE id = ?";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, id);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            obj = new ZKodePerusahaan();
            obj.setId(rs.getInt("id"));
            obj.setNamaPerusahaan(rs.getString("namaPerusahaan"));
            obj.setNpwp(rs.getString("npwp"));
            obj.setNitku(rs.getString("nitku"));
            obj.setKode(rs.getString("kode"));
        }
        rs.close();
        pst.close();
        return obj;
    }

    public ZKodePerusahaan findByNpwpWapu(String npwp) throws SQLException {
        ZKodePerusahaan obj = new ZKodePerusahaan();
        String sql = "Select * from tbl2_kode_wapu WHERE npwp = ?";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, npwp);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            obj = new ZKodePerusahaan();
            obj.setId(rs.getInt("id"));
            obj.setNamaPerusahaan(rs.getString("namaPerusahaan"));
            obj.setNpwp(rs.getString("npwp"));
            obj.setKode(rs.getString("kode"));
        }
        rs.close();
        pst.close();
        return obj;
    }

    public ZKodePerusahaan findByNamaWapu(String nama) throws SQLException {
        ZKodePerusahaan obj = new ZKodePerusahaan();
        String sql = "Select * from tbl2_kode_wapu WHERE namaPerusahaan like '%" + nama + "%'";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            obj = new ZKodePerusahaan();
            obj.setId(rs.getInt("id"));
            obj.setNamaPerusahaan(rs.getString("namaPerusahaan"));
            obj.setNpwp(rs.getString("npwp"));
            obj.setKode(rs.getString("kode"));
        }
        rs.close();
        pst.close();
        return obj;
    }

    public ZKodePerusahaan findByUnit(String nama) throws SQLException {
        ZKodePerusahaan obj = new ZKodePerusahaan();
        String sql = "Select * from tbl2_kode_wapu WHERE unit like '%" + nama + "%'";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            obj = new ZKodePerusahaan();
            obj.setId(rs.getInt("id"));
            obj.setNamaPerusahaan(rs.getString("namaPerusahaan"));
            obj.setNpwp(rs.getString("npwp"));
            obj.setKode(rs.getString("kode"));
            obj.setUnit(rs.getString("unit"));
        }
        rs.close();
        pst.close();
        return obj;
    }

    public ZKodePerusahaan findByNamaUnit(String nama, String unit) throws SQLException {
        ZKodePerusahaan obj = new ZKodePerusahaan();
        String sql = "Select * from tbl2_kode_wapu WHERE unit like '%" + nama + "%'";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            obj = new ZKodePerusahaan();
            obj.setId(rs.getInt("id"));
            obj.setNamaPerusahaan(rs.getString("namaPerusahaan"));
            obj.setNpwp(rs.getString("npwp"));
            obj.setKode(rs.getString("kode"));
            obj.setAlamat(rs.getString("alamat"));
            obj.setUnit(rs.getString("unit"));
        }
        rs.close();
        pst.close();
        return obj;
    }
}

