/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.model;

import esindo.net.gui.MDIForm;
import esindo.net.model.Transaksi;
import esindo.net.model.TransaksiHandler;
import esindo.net.model.ZRefJson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ToolGui {
    public static TableModel tableModelEfaktur(File fi) {
        DefaultTableModel model = new DefaultTableModel(){
            Class[] types = new Class[]{String.class, String.class, Boolean.class};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        Object[] judul = new String[]{"No", "Link efaktur", "Check"};
        model.setColumnIdentifiers(judul);
        try {
            FileInputStream file = new FileInputStream(fi);
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)file);
            HSSFSheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (row.getRowNum() <= 0) continue;
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    String str_link = "";
                    if (cell.getCellType() != 1) continue;
                    str_link = cell.getStringCellValue();
                    Object[] isi = new Object[]{row.getRowNum(), str_link, Boolean.TRUE};
                    model.addRow(isi);
                }
            }
            file.close();
            FileOutputStream out = new FileOutputStream(fi);
            workbook.write((OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static TableModel tableModelEfakturXLSX(File fi) {
        DefaultTableModel model = new DefaultTableModel(){
            Class[] types = new Class[]{String.class, String.class, Boolean.class};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        Object[] judul = new String[]{"No", "Link efaktur", "Check"};
        model.setColumnIdentifiers(judul);
        try {
            FileInputStream file = new FileInputStream(fi);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
            XSSFSheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (row.getRowNum() <= 0) continue;
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    String str_link = "";
                    if (cell.getCellType() != 1) continue;
                    str_link = cell.getStringCellValue();
                    Object[] isi = new Object[]{row.getRowNum(), str_link, Boolean.TRUE};
                    model.addRow(isi);
                }
            }
            file.close();
            FileOutputStream out = new FileOutputStream(fi);
            workbook.write((OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static void tableModelEfakturxx(File fi) {
        try {
            FileInputStream file = new FileInputStream(fi);
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)file);
            HSSFSheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    switch (cell.getCellType()) {
                        case 4: {
                            break;
                        }
                        case 0: {
                            break;
                        }
                    }
                }
            }
            file.close();
            FileOutputStream out = new FileOutputStream(fi);
            workbook.write((OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Transaksi downloadFakturXML(String str) throws Exception {
        Transaksi tr = null;
        String path = MDIForm.PATH_APP;
        path = path + "/esindo.xml";
        URL myURL = new URL(str);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        XMLReader xr = saxParser.getXMLReader();
        TransaksiHandler handler = new TransaksiHandler();
        xr.setContentHandler(handler);
        xr.parse(new InputSource(myURL.openStream()));
        tr = handler.getTransaksi();
        tr.setListItem(handler.getItemList());
        return tr;
    }

    public static void bacaXML(String str) {
        try {
            URL myURL = new URL(str);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xr = saxParser.getXMLReader();
            DefaultHandler handler = new DefaultHandler(){
                boolean _kdJenisTransaksi = false;
                boolean _fgPengganti = false;
                boolean _nomorFaktur = false;
                boolean _tanggalFaktur = false;
                boolean _npwpPenjual = false;
                boolean _namaPenjual = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("kdJenisTransaksi")) {
                        this._kdJenisTransaksi = true;
                    }
                    if (qName.equalsIgnoreCase("fgPengganti")) {
                        this._fgPengganti = true;
                    }
                    if (qName.equalsIgnoreCase("nomorFaktur")) {
                        this._nomorFaktur = true;
                    }
                    if (qName.equalsIgnoreCase("tanggalFaktur")) {
                        this._tanggalFaktur = true;
                    }
                    if (qName.equalsIgnoreCase("npwpPenjual")) {
                        this._npwpPenjual = true;
                    }
                    if (qName.equalsIgnoreCase("npwpPenjual")) {
                        this._npwpPenjual = true;
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this._kdJenisTransaksi) {
                        this._kdJenisTransaksi = false;
                    }
                    if (this._fgPengganti) {
                        this._fgPengganti = false;
                    }
                    if (this._nomorFaktur) {
                        this._nomorFaktur = false;
                    }
                    if (this._tanggalFaktur) {
                        this._tanggalFaktur = false;
                    }
                    if (this._npwpPenjual) {
                        this._npwpPenjual = false;
                    }
                    if (this._namaPenjual) {
                        this._namaPenjual = false;
                    }
                }
            };
            xr.setContentHandler(handler);
            xr.parse(new InputSource(myURL.openStream()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TableModel tableModelDirektoryEfaktur(File folder) {
        DefaultTableModel model = new DefaultTableModel(){
            Class[] types = new Class[]{String.class, String.class, Boolean.class};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        Object[] judul = new String[]{"No", "Link efaktur", "Check"};
        model.setColumnIdentifiers(judul);
        File[] listOfFiles = folder.listFiles();
        String str = "";
        int counter = 0;
        for (File file : listOfFiles) {
            if (!file.isFile() || !FilenameUtils.getExtension((String)file.getPath()).equalsIgnoreCase("txt")) continue;
            try {
                str = ToolGui.readFile1(file);
                if (!str.toLowerCase().contains("svc.efaktur.pajak.go.id/validasi/faktur")) continue;
                Object[] isi = new Object[]{++counter, str, Boolean.TRUE};
                model.addRow(isi);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return model;
    }

    public static String readFile1(File fin) throws IOException {
        FileInputStream fis = new FileInputStream(fin);
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        String line = "";
        line = br.readLine();
        if (line != null) {
            // empty if block
        }
        br.close();
        return line;
    }

    public static String readFile2(File fin) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(fin));
        String line = "";
        while ((line = br.readLine()) != null) {
        }
        br.close();
        return line;
    }

    public static TableModel tableModelEfakturXLSXml(File fi) {
        DefaultTableModel model = new DefaultTableModel();
        try {
            FileInputStream file = new FileInputStream(fi);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
            XSSFSheet sheet = workbook.getSheetAt(0);
            boolean isFirstRow = true;
            for (Row row : sheet) {
                if (isFirstRow) {
                    for (Cell cell : row) {
                        if (cell != null) {
                            model.addColumn(cell.getStringCellValue());
                            continue;
                        }
                        model.addColumn("Unnamed Column");
                    }
                    isFirstRow = false;
                    continue;
                }
                XSSFFormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
                Object[] rowData = new Object[model.getColumnCount()];
                block16: for (int colIndex = 0; colIndex < rowData.length; ++colIndex) {
                    Cell cell = row.getCell(colIndex, Row.CREATE_NULL_AS_BLANK);
                    if (cell == null) {
                        rowData[colIndex] = "";
                        continue;
                    }
                    int cellType = cell.getCellType();
                    switch (cellType) {
                        case 1: {
                            rowData[colIndex] = cell.getStringCellValue();
                            continue block16;
                        }
                        case 0: {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
                                Date dateValue = cell.getDateCellValue();
                                rowData[colIndex] = sdf.format(dateValue);
                                continue block16;
                            }
                            rowData[colIndex] = ToolGui.formatNumeric(cell.getNumericCellValue());
                            continue block16;
                        }
                        case 4: {
                            rowData[colIndex] = cell.getBooleanCellValue();
                            continue block16;
                        }
                        case 2: {
                            CellValue evaluatedValue = evaluator.evaluate(cell);
                            switch (evaluatedValue.getCellType()) {
                                case 1: {
                                    rowData[colIndex] = evaluatedValue.getStringValue();
                                    continue block16;
                                }
                                case 0: {
                                    rowData[colIndex] = ToolGui.formatNumeric(evaluatedValue.getNumberValue());
                                    continue block16;
                                }
                                case 4: {
                                    rowData[colIndex] = evaluatedValue.getBooleanValue();
                                    continue block16;
                                }
                            }
                            rowData[colIndex] = "";
                            continue block16;
                        }
                        default: {
                            rowData[colIndex] = "";
                        }
                    }
                }
                model.addRow(rowData);
            }
            file.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static TableModel tableModelEfakturXLSXmlEmail(File fi) {
        DefaultTableModel model = new DefaultTableModel();
        try {
            FileInputStream file = new FileInputStream(fi);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
            XSSFSheet sheet = workbook.getSheetAt(0);
            boolean isFirstRow = true;
            int idColumnIndex = -1;
            for (Row row : sheet) {
                String colName;
                if (isFirstRow) {
                    model.addColumn("Format Template");
                    for (Cell cell : row) {
                        if (cell != null) {
                            colName = cell.getStringCellValue();
                            model.addColumn(colName);
                            continue;
                        }
                        model.addColumn("Unnamed Column");
                    }
                    isFirstRow = false;
                    continue;
                }
                if (isFirstRow) {
                    model.addColumn("Format");
                    for (Cell cell : row) {
                        if (cell != null) {
                            colName = cell.getStringCellValue();
                            model.addColumn(colName);
                            if (!"id".equalsIgnoreCase(colName.trim())) continue;
                            idColumnIndex = model.getColumnCount() - 1;
                            continue;
                        }
                        model.addColumn("Unnamed Column");
                    }
                    isFirstRow = false;
                    continue;
                }
                Object[] rowData = new Object[model.getColumnCount()];
                rowData[0] = model.getColumnCount() == 9 ? "Format OK" : "Format Salah";
                block12: for (int colIndex = 1; colIndex < rowData.length; ++colIndex) {
                    Cell cell = row.getCell(colIndex - 1, Row.CREATE_NULL_AS_BLANK);
                    if (cell == null) {
                        rowData[colIndex] = "";
                        continue;
                    }
                    switch (cell.getCellType()) {
                        case 1: {
                            rowData[colIndex] = cell.getStringCellValue();
                            continue block12;
                        }
                        case 2: {
                            rowData[colIndex] = cell.getCellFormula();
                            continue block12;
                        }
                        case 0: {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
                                rowData[colIndex] = sdf.format(cell.getDateCellValue());
                                continue block12;
                            }
                            rowData[colIndex] = ToolGui.formatNumeric(cell.getNumericCellValue());
                            continue block12;
                        }
                        case 4: {
                            rowData[colIndex] = cell.getBooleanCellValue();
                            continue block12;
                        }
                        default: {
                            rowData[colIndex] = "";
                        }
                    }
                }
                model.addRow(rowData);
            }
            file.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static TableModel tableModelDataCustomer(File fi) {
        DefaultTableModel model = new DefaultTableModel();
        try {
            FileInputStream file = new FileInputStream(fi);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
            XSSFSheet sheet = workbook.getSheetAt(0);
            boolean isFirstRow = true;
            for (Row row : sheet) {
                if (isFirstRow) {
                    for (Cell cell : row) {
                        if (cell != null) {
                            model.addColumn(cell.getStringCellValue());
                            continue;
                        }
                        model.addColumn("Unnamed Column");
                    }
                    isFirstRow = false;
                    continue;
                }
                Object[] rowData = new Object[model.getColumnCount()];
                for (int colIndex = 0; colIndex < rowData.length; ++colIndex) {
                    Cell cell = row.getCell(colIndex, Row.CREATE_NULL_AS_BLANK);
                    if (cell == null) {
                        rowData[colIndex] = "";
                    } else {
                        switch (cell.getCellType()) {
                            case 1: {
                                rowData[colIndex] = cell.getStringCellValue();
                                break;
                            }
                            case 0: {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
                                    Date dateValue = cell.getDateCellValue();
                                    rowData[colIndex] = sdf.format(dateValue);
                                    System.out.println("-ddd-" + rowData[colIndex].toString());
                                    break;
                                }
                                rowData[colIndex] = ToolGui.formatNumeric(cell.getNumericCellValue());
                                break;
                            }
                            case 4: {
                                rowData[colIndex] = cell.getBooleanCellValue();
                                break;
                            }
                            case 2: {
                                rowData[colIndex] = cell.getCellFormula();
                                break;
                            }
                            default: {
                                rowData[colIndex] = "";
                            }
                        }
                    }
                    System.out.println("data customer " + rowData[colIndex]);
                }
                model.addRow(rowData);
            }
            file.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    private static String formatNumeric(double value) {
        if (value % 1.0 == 0.0) {
            return String.format("%d", (long)value);
        }
        return String.format("%.2f", value);
    }

    public static TableModel tableModelEfakturXLSXml2(File fi) {
        DefaultTableModel model = new DefaultTableModel();
        try {
            FileInputStream file = new FileInputStream(fi);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
            XSSFSheet sheet = workbook.getSheetAt(0);
            Iterator rowIterator = sheet.iterator();
            boolean isFirstRow = true;
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                if (isFirstRow) {
                    Iterator cellIterator = row.cellIterator();
                    while (cellIterator.hasNext()) {
                        Cell cell = (Cell)cellIterator.next();
                        model.addColumn(cell.getStringCellValue());
                    }
                    isFirstRow = false;
                    continue;
                }
                Object[] rowData = new Object[row.getLastCellNum()];
                Iterator cellIterator = row.cellIterator();
                int cellIndex = 0;
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    if (cell == null) {
                        rowData[cellIndex] = "-";
                        continue;
                    }
                    switch (cell.getCellType()) {
                        case 1: {
                            rowData[cellIndex] = cell.getStringCellValue();
                            break;
                        }
                        case 0: {
                            rowData[cellIndex] = cell.getNumericCellValue();
                            break;
                        }
                        case 4: {
                            rowData[cellIndex] = cell.getBooleanCellValue();
                            break;
                        }
                        default: {
                            rowData[cellIndex] = "";
                        }
                    }
                    ++cellIndex;
                }
                model.addRow(rowData);
            }
            file.close();
            FileOutputStream out = new FileOutputStream(fi);
            workbook.write((OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static TableModel tableModelCsv(File fi) {
        DefaultTableModel model = new DefaultTableModel();
        try {
            FileInputStream file = new FileInputStream(fi);
            boolean start = false;
            InputStreamReader inputStreamReader = new InputStreamReader(file);
            CSVFormat fmt = CSVFormat.DEFAULT.builder().setDelimiter(';').build();
            CSVParser csvParser = fmt.parse((Reader)inputStreamReader);
            for (CSVRecord csvRecord : csvParser) {
                if (!start) {
                    start = true;
                    for (int c = 0; c < csvRecord.size(); ++c) {
                        model.addColumn(csvRecord.get(c));
                    }
                    continue;
                }
                Vector<String> row = new Vector<String>();
                for (int c = 0; c < csvRecord.size(); ++c) {
                    row.add(csvRecord.get(c));
                }
                model.addRow(row);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Kolom Tidak Sama");
            e.printStackTrace();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Kolom Tidak Sama");
            System.out.println("Error in Parsing CSV File");
            ex.printStackTrace();
        }
        return model;
    }

    public static TableModel tableModelJson(List<ZRefJson> fi, List<ZRefJson> f2, int a) {
        int i;
        System.out.println("Jumlah Kolom " + fi.size());
        DefaultTableModel model = new DefaultTableModel();
        for (i = 0; i < f2.size(); ++i) {
            System.out.println();
            JSONObject jsonObj = new JSONObject(f2.get(i).getHaeader());
            JSONArray jsonArrObj = (JSONArray)jsonObj.get("nameheader");
            for (int ii = 0; ii < jsonArrObj.length(); ++ii) {
                model.addColumn(jsonArrObj.get(ii));
            }
        }
        for (i = 0; i < fi.size(); ++i) {
            System.out.println("Counter: " + i);
            String rawJson = fi.get(i).getHaeader();
            System.out.println("Raw JSON: " + rawJson);
            if (rawJson == null || rawJson.trim().isEmpty()) {
                System.out.println("Error: Empty or null JSON at index " + i);
                continue;
            }
            rawJson = rawJson.replace("\n", "\\n");
            System.out.println();
            JSONObject jsonObj = new JSONObject(rawJson);
            System.out.println("Names are : ");
            JSONArray jsonArrObj = (JSONArray)jsonObj.get("datas");
            Vector<Object> row = new Vector<Object>();
            for (int ii = 0; ii < jsonArrObj.length(); ++ii) {
                row.add(jsonArrObj.get(ii));
            }
            model.addRow(row);
        }
        return model;
    }

    public static DefaultTableModel loadDataClob(List<ZRefJson> list) {
        DefaultTableModel model = new DefaultTableModel();
        if (list == null || list.isEmpty()) {
            return model;
        }
        try {
            String rawJson = list.get(0).getDatajson();
            JSONObject jsonObj = new JSONObject(rawJson);
            JSONArray headers = jsonObj.getJSONArray("nameheader");
            for (int i = 0; i < headers.length(); ++i) {
                model.addColumn(headers.getString(i));
            }
            for (ZRefJson zs : list) {
                JSONObject obj = new JSONObject(zs.getDatajson());
                JSONArray datas = obj.getJSONArray("datas");
                for (int i = 0; i < datas.length(); ++i) {
                    JSONArray rowArray = datas.getJSONArray(i);
                    Vector<Object> row = new Vector<Object>();
                    for (int j = 0; j < rowArray.length(); ++j) {
                        row.add(rowArray.get(j));
                    }
                    model.addRow(row);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error parsing JSON dari CLOB: " + e.getMessage());
        }
        return model;
    }
}

