/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.model;

import esindo.net.model.ItemTransaksi;
import esindo.net.model.Transaksi;
import esindo.net.model.TransaksiBupot;
import esindo.net.model.ZDAOGroupHeader;
import esindo.net.model.ZDAOTransaksi;
import esindo.net.model.ZItemTransaksi;
import esindo.net.model.ZTransaksi;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ToolExport {
    private static List<List<HSSFCell>> cellGrid;

    public static String exportPajakMasukan(String nama_file, List<Transaksi> ls) {
        System.out.println("Eksport PM !!!!!");
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            Sheet pm = wb.createSheet("PM");
            Row headerRow = pm.createRow(0);
            Cell _fm = headerRow.createCell(0);
            _fm.setCellValue("FM");
            Cell _kd = headerRow.createCell(1);
            _kd.setCellValue("KD_JENIS_TRANSAKSI");
            Cell _fg = headerRow.createCell(2);
            _fg.setCellValue("FG_PENGGANTI");
            Cell _no = headerRow.createCell(3);
            _no.setCellValue("NOMOR_FAKTUR");
            Cell _mp = headerRow.createCell(4);
            _mp.setCellValue("MASA_PAJAK");
            Cell _thn = headerRow.createCell(5);
            _thn.setCellValue("TAHUN_PAJAK");
            Cell _tgl = headerRow.createCell(6);
            _tgl.setCellValue("TANGGAL_FAKTUR");
            Cell _npwp = headerRow.createCell(7);
            _npwp.setCellValue("NPWP");
            Cell _nm = headerRow.createCell(8);
            _nm.setCellValue("NAMA");
            Cell _al = headerRow.createCell(9);
            _al.setCellValue("ALAMAT_LENGKAP");
            Cell _dpp = headerRow.createCell(10);
            _dpp.setCellValue("JUMLAH_DPP");
            Cell _ppn = headerRow.createCell(11);
            _ppn.setCellValue("JUMLAH_PPN");
            Cell _ppnbm = headerRow.createCell(12);
            _ppnbm.setCellValue("JUMLAH_PPNBM");
            Cell _ic = headerRow.createCell(13);
            _ic.setCellValue("IS_CREDITABLE");
            int row = 1;
            for (Transaksi t : ls) {
                Row dataRow = pm.createRow(row);
                Cell dataFM = dataRow.createCell(0);
                dataFM.setCellValue("FM");
                Cell dataKD = dataRow.createCell(1);
                dataKD.setCellValue(t.getKode());
                Cell dataFG = dataRow.createCell(2);
                dataFG.setCellValue(t.getFgPengganti());
                Cell dataNF = dataRow.createCell(3);
                System.out.println(t.getNomorFaktur());
                dataNF.setCellValue(t.getNomorFaktur());
                String tgl = t.getTglFaktur();
                String[] artgl = tgl.split("/");
                Cell dataMP = dataRow.createCell(4);
                dataMP.setCellValue("" + t.getMasaPajak());
                Cell datathn = dataRow.createCell(5);
                datathn.setCellValue("" + t.getTahunPajak());
                Cell datatgl = dataRow.createCell(6);
                datatgl.setCellValue(tgl);
                Cell dataNPWP = dataRow.createCell(7);
                dataNPWP.setCellValue(t.getNpwpPenjual());
                Cell dataNama = dataRow.createCell(8);
                dataNama.setCellValue(t.getNamaPenjual());
                Cell dataAlamat = dataRow.createCell(9);
                dataAlamat.setCellValue(t.getAlamatPenjual());
                Cell dataDPP = dataRow.createCell(10);
                dataDPP.setCellValue("" + t.getJumlahDPP());
                Cell dataPPN = dataRow.createCell(11);
                dataPPN.setCellValue("" + t.getJumlahPPN());
                Cell dataPPNBM = dataRow.createCell(12);
                dataPPNBM.setCellValue("" + t.getJumlanPPNBM());
                Cell dataIC = dataRow.createCell(13);
                dataIC.setCellValue("" + t.getIsCreditable());
                ++row;
            }
            Calendar cal = Calendar.getInstance();
            String nama = "transaksi_" + cal.get(1) + cal.get(2) + cal.get(5) + cal.get(12) + ".csv";
            String outputDirPath = "D:/" + nama;
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                System.out.println(wb.getSheetAt(i).getSheetName());
            }
            cellGrid = new ArrayList<List<HSSFCell>>();
            Sheet mySheet = wb.getSheetAt(0);
            Iterator rowIter = mySheet.rowIterator();
            while (rowIter.hasNext()) {
                HSSFRow myRow = (HSSFRow)rowIter.next();
                Iterator cellIter = myRow.cellIterator();
                ArrayList<HSSFCell> cellRowList = new ArrayList<HSSFCell>();
                while (cellIter.hasNext()) {
                    HSSFCell myCell = (HSSFCell)cellIter.next();
                    cellRowList.add(myCell);
                }
                cellGrid.add(cellRowList);
            }
            File file = new File(nama_file);
            PrintStream stream = new PrintStream(file);
            for (int i = 0; i < cellGrid.size(); ++i) {
                List<HSSFCell> cellRowList = cellGrid.get(i);
                for (int j = 0; j < cellRowList.size(); ++j) {
                    HSSFCell myCell = cellRowList.get(j);
                    String stringCellValue = myCell.toString();
                    if (stringCellValue.equalsIgnoreCase("FM")) {
                        stream.print(stringCellValue + ";");
                        continue;
                    }
                    stream.print("\"" + stringCellValue + "\";");
                }
                stream.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nama_file;
    }

    public static String exportDetailTransaksiPajakMasukan(String nama_file, List<ItemTransaksi> ls) {
        System.out.println("Eksport DTPM !!!!!");
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            Sheet pm = wb.createSheet("DTPM");
            Row headerRow = pm.createRow(0);
            Cell _nofaktur = headerRow.createCell(0);
            _nofaktur.setCellValue("Nomor Faktur");
            Cell _tglfaktur = headerRow.createCell(1);
            _tglfaktur.setCellValue("Tanggal Faktur");
            Cell _npwppenjual = headerRow.createCell(2);
            _npwppenjual.setCellValue("NPWP Penjual");
            Cell _namapenjual = headerRow.createCell(3);
            _namapenjual.setCellValue("Nama Pnjual");
            Cell _alamatpenjual = headerRow.createCell(4);
            _alamatpenjual.setCellValue("Alamat Penjual");
            Cell _item = headerRow.createCell(5);
            _item.setCellValue("Item Barang");
            Cell _hsatuan = headerRow.createCell(6);
            _hsatuan.setCellValue("Harga Satuan");
            Cell _jumlah = headerRow.createCell(7);
            _jumlah.setCellValue("Jumlah Barang");
            Cell _htotal = headerRow.createCell(8);
            _htotal.setCellValue("Harga Total");
            Cell _diskon = headerRow.createCell(9);
            _diskon.setCellValue("Diskon");
            Cell _dpp = headerRow.createCell(10);
            _dpp.setCellValue("DPP");
            Cell _ppn = headerRow.createCell(11);
            _ppn.setCellValue("PPN");
            Cell _tppnbm = headerRow.createCell(12);
            _tppnbm.setCellValue("Tarif PPNBM");
            Cell _ppnbm = headerRow.createCell(13);
            _ppnbm.setCellValue("PPNBM");
            int row = 1;
            for (ItemTransaksi t : ls) {
                Row dataRow = pm.createRow(row);
                Cell dataNF = dataRow.createCell(0);
                dataNF.setCellValue("'" + t.getNomorFaktur());
                Cell datatglfaktur = dataRow.createCell(1);
                datatglfaktur.setCellValue(t.getTglFaktur());
                Cell datanpwppenjual = dataRow.createCell(2);
                datanpwppenjual.setCellValue("'" + t.getNpwpPenjual());
                Cell dataNamaPenjual = dataRow.createCell(3);
                dataNamaPenjual.setCellValue(t.getNamaPenjual());
                Cell dataAlamatPenjual = dataRow.createCell(4);
                dataAlamatPenjual.setCellValue(t.getAlamatPenjual());
                Cell dataNama = dataRow.createCell(5);
                dataNama.setCellValue(t.getNama());
                Cell dataHS = dataRow.createCell(6);
                dataHS.setCellValue(t.getHargaSatuan());
                Cell dataJB = dataRow.createCell(7);
                dataJB.setCellValue(t.getJumlahBarang());
                Cell dataHT = dataRow.createCell(8);
                dataHT.setCellValue(t.getHargaTotal());
                Cell dataDiskon = dataRow.createCell(9);
                dataDiskon.setCellValue(t.getDiskon());
                Cell dataDPP = dataRow.createCell(10);
                dataDPP.setCellValue(t.getDpp());
                Cell dataPPN = dataRow.createCell(11);
                dataPPN.setCellValue(t.getPpn());
                Cell dataTPPNBM = dataRow.createCell(12);
                dataTPPNBM.setCellValue(t.getTarifPpnbm());
                Cell dataPPNBM = dataRow.createCell(13);
                dataPPNBM.setCellValue(t.getPpnbm());
                ++row;
            }
            Calendar cal = Calendar.getInstance();
            String nama = "transaksi_detail" + cal.get(1) + cal.get(2) + cal.get(5) + cal.get(12) + ".csv";
            String outputDirPath = "D:/" + nama;
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                System.out.println(wb.getSheetAt(i).getSheetName());
            }
            cellGrid = new ArrayList<List<HSSFCell>>();
            Sheet mySheet = wb.getSheetAt(0);
            Iterator rowIter = mySheet.rowIterator();
            while (rowIter.hasNext()) {
                HSSFRow myRow = (HSSFRow)rowIter.next();
                Iterator cellIter = myRow.cellIterator();
                ArrayList<HSSFCell> cellRowList = new ArrayList<HSSFCell>();
                while (cellIter.hasNext()) {
                    HSSFCell myCell = (HSSFCell)cellIter.next();
                    cellRowList.add(myCell);
                }
                cellGrid.add(cellRowList);
            }
            File file = new File(nama_file);
            PrintStream stream = new PrintStream(file);
            for (int i = 0; i < cellGrid.size(); ++i) {
                List<HSSFCell> cellRowList = cellGrid.get(i);
                for (int j = 0; j < cellRowList.size(); ++j) {
                    HSSFCell myCell = cellRowList.get(j);
                    String stringCellValue = myCell.toString();
                    if (stringCellValue.equalsIgnoreCase("FM")) {
                        stream.print(stringCellValue + ";");
                        continue;
                    }
                    stream.print("" + stringCellValue + ";");
                }
                stream.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nama_file;
    }

    public static void echoAsCSV(Sheet sheet) {
        Row row = null;
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            row = sheet.getRow(i);
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                System.out.print("\"" + row.getCell(j) + "\";");
            }
            System.out.println();
        }
    }

    public static void convertExcelToCsv(String nama_file) throws IOException {
        try {
            cellGrid = new ArrayList<List<HSSFCell>>();
            FileInputStream myInput = new FileInputStream(nama_file);
            POIFSFileSystem myFileSystem = new POIFSFileSystem((InputStream)myInput);
            HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);
            HSSFSheet mySheet = myWorkBook.getSheetAt(0);
            Iterator rowIter = mySheet.rowIterator();
            while (rowIter.hasNext()) {
                HSSFRow myRow = (HSSFRow)rowIter.next();
                Iterator cellIter = myRow.cellIterator();
                ArrayList<HSSFCell> cellRowList = new ArrayList<HSSFCell>();
                while (cellIter.hasNext()) {
                    HSSFCell myCell = (HSSFCell)cellIter.next();
                    cellRowList.add(myCell);
                }
                cellGrid.add(cellRowList);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        File file = new File("newFile.csv");
        PrintStream stream = new PrintStream(file);
        for (int i = 0; i < cellGrid.size(); ++i) {
            List<HSSFCell> cellRowList = cellGrid.get(i);
            for (int j = 0; j < cellRowList.size(); ++j) {
                HSSFCell myCell = cellRowList.get(j);
                String stringCellValue = myCell.toString();
                stream.print(stringCellValue + ";");
            }
            stream.println("");
        }
    }

    public static String exportDetailTransaksiPajakMasukanXLSPm(String nama_file, List<ItemTransaksi> ls) {
        try {
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet pm = wb.createSheet("Excel Sheet");
            XSSFRow headerRow = pm.createRow(0);
            XSSFCell _kdjenistransaksi = headerRow.createCell(0);
            _kdjenistransaksi.setCellValue("Kode Faktur");
            XSSFCell _stspengganti = headerRow.createCell(1);
            _stspengganti.setCellValue("Faktur Pengganti");
            XSSFCell _nofaktur = headerRow.createCell(2);
            _nofaktur.setCellValue("Nomor Faktur");
            XSSFCell _tglfaktur = headerRow.createCell(3);
            _tglfaktur.setCellValue("Tanggal Faktur");
            XSSFCell _npwppenjual = headerRow.createCell(4);
            _npwppenjual.setCellValue("NPWP Penjual");
            XSSFCell _namapenjual = headerRow.createCell(5);
            _namapenjual.setCellValue("Nama Penjual");
            XSSFCell _alamatpenjual = headerRow.createCell(6);
            _alamatpenjual.setCellValue("Alamat Penjual");
            XSSFCell _item = headerRow.createCell(7);
            _item.setCellValue("Item Barang");
            XSSFCell _hsatuan = headerRow.createCell(8);
            _hsatuan.setCellValue("Harga Satuan");
            XSSFCell _jumlah = headerRow.createCell(9);
            _jumlah.setCellValue("Jumlah Barang");
            XSSFCell _diskon = headerRow.createCell(10);
            _diskon.setCellValue("Diskon");
            XSSFCell _dpp = headerRow.createCell(11);
            _dpp.setCellValue("DPP");
            XSSFCell _ppn = headerRow.createCell(12);
            _ppn.setCellValue("PPN");
            XSSFCell _ppnbm = headerRow.createCell(13);
            _ppnbm.setCellValue("PPNBM");
            XSSFCell _kodebar = headerRow.createCell(14);
            _kodebar.setCellValue("KodeBarang");
            XSSFCell _kodeinvo = headerRow.createCell(15);
            _kodeinvo.setCellValue("Kode Invoice");
            int row = 1;
            Locale locale = new Locale("en", "UK");
            String pattern = "#.00";
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            decimalFormat.applyPattern(pattern);
            Object fakturPengganti = null;
            for (ItemTransaksi t : ls) {
                XSSFRow dataRow = pm.createRow((int)((short)row));
                XSSFCell dataKF = dataRow.createCell(0);
                dataKF.setCellValue("'" + t.getKode());
                XSSFCell dataFG = dataRow.createCell(1);
                dataFG.setCellValue(t.getFakturPengganti());
                XSSFCell dataNF = dataRow.createCell(2);
                dataNF.setCellValue("'" + t.getNomorFaktur());
                XSSFCell datatglfaktur = dataRow.createCell(3);
                datatglfaktur.setCellValue(t.getTglFaktur());
                XSSFCell datanpwppenjual = dataRow.createCell(4);
                datanpwppenjual.setCellValue("'" + t.getNpwpPenjual());
                XSSFCell dataNamaPenjual = dataRow.createCell(5);
                dataNamaPenjual.setCellValue(t.getNamaPenjual());
                XSSFCell dataAlamatPenjual = dataRow.createCell(6);
                dataAlamatPenjual.setCellValue(t.getAlamatPenjual());
                XSSFCell dataNama = dataRow.createCell(7);
                dataNama.setCellValue(t.getNama());
                XSSFCell dataHS = dataRow.createCell(8);
                double hargaSatuan = Double.valueOf(t.getHargaSatuan());
                String strHargaSatuan = decimalFormat.format(hargaSatuan);
                dataHS.setCellValue(Double.parseDouble(strHargaSatuan));
                XSSFCell dataJB = dataRow.createCell(9);
                double hargaJumlahBarang = Double.valueOf(t.getJumlahBarang());
                String strJumlahBarang = decimalFormat.format(hargaJumlahBarang);
                dataJB.setCellValue(Double.parseDouble(strJumlahBarang));
                XSSFCell dataDiskon = dataRow.createCell(10);
                double hargaDiskon = Double.valueOf(t.getDiskon());
                String strHargaDiskon = decimalFormat.format(hargaDiskon);
                dataDiskon.setCellValue(Double.parseDouble(strHargaDiskon));
                XSSFCell dataDPP = dataRow.createCell(11);
                double hargaDpp = Double.valueOf(t.getDpp());
                String strHargaDpp = decimalFormat.format(hargaDpp);
                dataDPP.setCellValue(Double.parseDouble(strHargaDpp));
                XSSFCell dataPPN = dataRow.createCell(12);
                double hargaPpn = Double.valueOf(t.getPpn());
                String strHargaPpn = decimalFormat.format(hargaPpn);
                dataPPN.setCellValue(Double.parseDouble(strHargaPpn));
                XSSFCell dataPPNBM = dataRow.createCell(13);
                double hargaDataPpnbm = Double.valueOf(t.getPpnbm());
                String strHargaDataPpnbm = decimalFormat.format(hargaDataPpnbm);
                dataPPNBM.setCellValue(Double.parseDouble(strHargaDataPpnbm));
                XSSFCell kodeBar = dataRow.createCell(14);
                kodeBar.setCellValue("'" + t.getKodeBarang());
                XSSFCell kodeInvo = dataRow.createCell(15);
                kodeInvo.setCellValue("'" + t.getNoinvoice());
                ++row;
            }
            FileOutputStream fileOut = new FileOutputStream(nama_file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nama_file;
    }

    public static String exportDetailTransaksiPajakMasukanXLS(String nama_file, List<ZItemTransaksi> ls) {
        try {
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet pm = wb.createSheet("Excel SheetDetail");
            XSSFRow headerRow = pm.createRow(0);
            XSSFCell _kdjenistransaksi = headerRow.createCell(0);
            _kdjenistransaksi.setCellValue("Kode Faktur");
            XSSFCell _stspengganti = headerRow.createCell(1);
            _stspengganti.setCellValue("Nomor Invoice");
            XSSFCell _nofaktur = headerRow.createCell(2);
            _nofaktur.setCellValue("Nomor Faktur");
            XSSFCell _tglfaktur = headerRow.createCell(3);
            _tglfaktur.setCellValue("Tanggal Faktur");
            XSSFCell _npwppenjual = headerRow.createCell(4);
            _npwppenjual.setCellValue("NPWP ");
            XSSFCell _namapenjual = headerRow.createCell(5);
            _namapenjual.setCellValue("Nama ");
            XSSFCell _alamatpenjual = headerRow.createCell(6);
            _alamatpenjual.setCellValue("Alamat ");
            XSSFCell _item = headerRow.createCell(7);
            _item.setCellValue("Item Barang");
            XSSFCell _hsatuan = headerRow.createCell(8);
            _hsatuan.setCellValue("Harga Satuan");
            XSSFCell _jumlah = headerRow.createCell(9);
            _jumlah.setCellValue("Jumlah Barang");
            XSSFCell _diskon = headerRow.createCell(10);
            _diskon.setCellValue("Diskon");
            XSSFCell _dpp = headerRow.createCell(11);
            _dpp.setCellValue("DPP");
            XSSFCell _ppn = headerRow.createCell(12);
            _ppn.setCellValue("PPN");
            XSSFCell _ppnbm = headerRow.createCell(13);
            _ppnbm.setCellValue("PPNBM");
            XSSFCell _kodebar = headerRow.createCell(14);
            _kodebar.setCellValue("KodeBarang");
            int row = 1;
            Locale locale = new Locale("en", "UK");
            String pattern = "#.00";
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            decimalFormat.applyPattern(pattern);
            Object fakturPengganti = null;
            for (ZItemTransaksi t : ls) {
                XSSFRow dataRow = pm.createRow((int)((short)row));
                XSSFCell dataKF = dataRow.createCell(0);
                dataKF.setCellValue("'" + t.getKode());
                XSSFCell dataFG = dataRow.createCell(1);
                dataFG.setCellValue(t.getNoinvoice());
                XSSFCell dataNF = dataRow.createCell(2);
                dataNF.setCellValue("'" + t.getNomorFaktur());
                XSSFCell datatglfaktur = dataRow.createCell(3);
                datatglfaktur.setCellValue(t.getTglFaktur());
                XSSFCell datanpwppenjual = dataRow.createCell(4);
                datanpwppenjual.setCellValue("'" + t.getNpwpPenjual());
                XSSFCell dataNamaPenjual = dataRow.createCell(5);
                dataNamaPenjual.setCellValue(t.getNamaPenjual());
                XSSFCell dataAlamatPenjual = dataRow.createCell(6);
                dataAlamatPenjual.setCellValue(t.getAlamatPenjual());
                XSSFCell dataNama = dataRow.createCell(7);
                dataNama.setCellValue(t.getNama());
                XSSFCell dataHS = dataRow.createCell(8);
                double hargaSatuan = Double.valueOf(t.getHargaSatuan());
                String strHargaSatuan = decimalFormat.format(hargaSatuan);
                dataHS.setCellValue(Double.parseDouble(strHargaSatuan));
                XSSFCell dataJB = dataRow.createCell(9);
                double hargaJumlahBarang = Double.valueOf(t.getJumlahBarang());
                String strJumlahBarang = decimalFormat.format(hargaJumlahBarang);
                dataJB.setCellValue(Double.parseDouble(strJumlahBarang));
                XSSFCell dataDiskon = dataRow.createCell(10);
                double hargaDiskon = Double.valueOf(t.getDiskon());
                String strHargaDiskon = decimalFormat.format(hargaDiskon);
                dataDiskon.setCellValue(Double.parseDouble(strHargaDiskon));
                XSSFCell dataDPP = dataRow.createCell(11);
                double hargaDpp = Double.valueOf(t.getDpp());
                String strHargaDpp = decimalFormat.format(hargaDpp);
                dataDPP.setCellValue(Double.parseDouble(strHargaDpp));
                XSSFCell dataPPN = dataRow.createCell(12);
                double hargaPpn = Double.valueOf(t.getPpn());
                String strHargaPpn = decimalFormat.format(hargaPpn);
                dataPPN.setCellValue(Double.parseDouble(strHargaPpn));
                XSSFCell dataPPNBM = dataRow.createCell(13);
                double hargaDataPpnbm = Double.valueOf(t.getPpnbm());
                String strHargaDataPpnbm = decimalFormat.format(hargaDataPpnbm);
                dataPPNBM.setCellValue(Double.parseDouble(strHargaDataPpnbm));
                XSSFCell kodeBar = dataRow.createCell(14);
                kodeBar.setCellValue("'" + t.getKodeBarang());
                ++row;
            }
            FileOutputStream fileOut = new FileOutputStream(nama_file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nama_file;
    }

    public static String exportTransaksiBupotXLS2Email(String nama_file, List<TransaksiBupot> ls) {
        XSSFWorkbook wb = new XSSFWorkbook();
        try {
            XSSFSheet sheet = wb.createSheet("Excel Sheet");
            XSSFRow headerRow = sheet.createRow(0);
            String[] headers = new String[]{"ID", "No Bupot", "Jenis Bukti", "Masa Bupot", "NPWP", "Nama Dipotong", "No Dokumen", "Email"};
            for (int i = 0; i < headers.length; ++i) {
                XSSFCell cell = headerRow.createCell(i);
                cell.setCellValue(headers[i]);
            }
            int row = 1;
            Locale locale = new Locale("en", "UK");
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            decimalFormat.applyPattern("#.00");
            for (TransaksiBupot ts : ls) {
                XSSFRow dataRow = sheet.createRow((int)((short)row));
                dataRow.createCell(0).setCellValue((double)ts.getId().intValue());
                dataRow.createCell(1).setCellValue(ts.getNoBupot());
                dataRow.createCell(2).setCellValue(ts.getJenisBukti());
                dataRow.createCell(3).setCellValue(ts.getMasaBupot());
                dataRow.createCell(4).setCellValue(ts.getNpwpDipotong());
                dataRow.createCell(5).setCellValue(ts.getNamaDipotong());
                dataRow.createCell(6).setCellValue(ts.getNoDokumen());
                dataRow.createCell(7).setCellValue(ts.getEmail());
                ++row;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(nama_file);
            try {
                wb.write((OutputStream)fileOut);
            }
            catch (IOException ex) {
                Logger.getLogger(ToolExport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ToolExport.class.getName()).log(Level.SEVERE, null, ex);
        }
        return nama_file;
    }

    public static String exportTransaksiBupotXLS2(String nama_file, List<TransaksiBupot> ls) {
        XSSFWorkbook wb = new XSSFWorkbook();
        try {
            XSSFSheet sheet = wb.createSheet("Excel Sheet");
            XSSFRow headerRow = sheet.createRow(0);
            String[] headers = new String[]{"ID", "No Bupot", "Masa Bupot", "Sifat", "Jenis Bukti", "Jenis Fasilitas", "Jenis Pajak", "Kode Objek Pajak", "Objek Pajak", "DPP", "Tarif (%)", "Pajak", "Jenis Dokumen", "Tgl Dokumen", "No Dokumen", "NPWP Pemotong", "Nitku Pemotong", "Nama Pemotong", "Tgl Pemotongan", "NPWP Dipotong", "Nitku Dipotong", "Nama Dipotong"};
            for (int i = 0; i < headers.length; ++i) {
                XSSFCell cell = headerRow.createCell(i);
                cell.setCellValue(headers[i]);
            }
            int row = 1;
            Locale locale = new Locale("en", "UK");
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            decimalFormat.applyPattern("#.00");
            for (TransaksiBupot ts : ls) {
                XSSFRow dataRow = sheet.createRow((int)((short)row));
                dataRow.createCell(0).setCellValue((double)ts.getId().intValue());
                dataRow.createCell(1).setCellValue(ts.getNoBupot());
                dataRow.createCell(2).setCellValue(ts.getMasaBupot());
                dataRow.createCell(3).setCellValue(ts.getSifat());
                dataRow.createCell(4).setCellValue(ts.getJenisBukti());
                dataRow.createCell(5).setCellValue(ts.getJenisFasilitas());
                dataRow.createCell(6).setCellValue(ts.getJenisPajak());
                dataRow.createCell(7).setCellValue(ts.getKodeObjekPajak());
                dataRow.createCell(8).setCellValue(ts.getObjekPajak());
                double dpp = ts.getDpp();
                dataRow.createCell(9).setCellValue(Double.parseDouble(decimalFormat.format(dpp)));
                double tarif = ts.getTarif();
                dataRow.createCell(10).setCellValue(Double.parseDouble(decimalFormat.format(tarif)));
                double pajak = ts.getPajak();
                dataRow.createCell(11).setCellValue(Double.parseDouble(decimalFormat.format(pajak)));
                dataRow.createCell(12).setCellValue(ts.getJenisDokumen());
                dataRow.createCell(13).setCellValue(ts.getTglDokumen());
                dataRow.createCell(14).setCellValue(ts.getNoDokumen());
                dataRow.createCell(15).setCellValue(ts.getNpwpPemotong());
                dataRow.createCell(16).setCellValue(ts.getNitkuPemotong());
                dataRow.createCell(17).setCellValue(ts.getNamaPemotong());
                dataRow.createCell(18).setCellValue(ts.getTglPemotongan());
                dataRow.createCell(19).setCellValue(ts.getNpwpDipotong());
                dataRow.createCell(20).setCellValue(ts.getNitkuDipotong());
                dataRow.createCell(21).setCellValue(ts.getNamaDipotong());
                ++row;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(nama_file);
            try {
                wb.write((OutputStream)fileOut);
            }
            catch (IOException ex) {
                Logger.getLogger(ToolExport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ToolExport.class.getName()).log(Level.SEVERE, null, ex);
        }
        return nama_file;
    }

    public static String exportTransaksiPajakMasukanXLS2(String nama_file, List<ZTransaksi> ls, List<ZItemTransaksi> ls2) {
        XSSFCell dataNF;
        XSSFCell dataFG;
        XSSFCell dataKF;
        XSSFRow dataRow;
        Object fakturPengganti;
        DecimalFormat decimalFormat;
        String pattern;
        Locale locale;
        int row;
        XSSFCell _jumlah;
        XSSFCell _hsatuan;
        XSSFCell _item;
        XSSFCell _alamatpenjual;
        XSSFCell _namapenjual;
        XSSFCell _npwppenjual;
        XSSFCell _tglfaktur;
        XSSFCell _nofaktur;
        XSSFCell _stspengganti;
        XSSFCell _kdjenistransaksi;
        XSSFRow headerRow;
        XSSFWorkbook wb = new XSSFWorkbook();
        try {
            XSSFSheet pm = wb.createSheet("Excel Sheet");
            headerRow = pm.createRow(0);
            _kdjenistransaksi = headerRow.createCell(0);
            _kdjenistransaksi.setCellValue("Kode Jenis Transaksi");
            _stspengganti = headerRow.createCell(1);
            _stspengganti.setCellValue("Faktur Pengganti");
            _nofaktur = headerRow.createCell(2);
            _nofaktur.setCellValue("Nomor Faktur");
            _tglfaktur = headerRow.createCell(3);
            _tglfaktur.setCellValue("Masa Pajak");
            _npwppenjual = headerRow.createCell(4);
            _npwppenjual.setCellValue("Tahun Pajak");
            _namapenjual = headerRow.createCell(5);
            _namapenjual.setCellValue("Tanggal Faktur");
            _alamatpenjual = headerRow.createCell(6);
            _alamatpenjual.setCellValue("NPWP");
            _item = headerRow.createCell(7);
            _item.setCellValue("Nama Lawan");
            _hsatuan = headerRow.createCell(8);
            _hsatuan.setCellValue("Alamat Lawan");
            _jumlah = headerRow.createCell(9);
            _jumlah.setCellValue("Jumlah Dpp");
            XSSFCell _htotal = headerRow.createCell(10);
            _htotal.setCellValue("Jumlah PPn");
            XSSFCell _diskon = headerRow.createCell(11);
            _diskon.setCellValue("Jumlah PpnBm");
            XSSFCell _dpp = headerRow.createCell(12);
            _dpp.setCellValue("Dikreditkan");
            XSSFCell _statusFaktur = headerRow.createCell(13);
            _statusFaktur.setCellValue("Status Faktur");
            XSSFCell _referensi = headerRow.createCell(14);
            _referensi.setCellValue("Referensi");
            row = 1;
            locale = new Locale("en", "UK");
            pattern = "#.00";
            decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            decimalFormat.applyPattern(pattern);
            fakturPengganti = null;
            for (ZTransaksi zTransaksi : ls) {
                dataRow = pm.createRow((int)((short)row));
                dataKF = dataRow.createCell(0);
                dataKF.setCellValue("'" + zTransaksi.getKode());
                dataFG = dataRow.createCell(1);
                dataFG.setCellValue(zTransaksi.getFgPengganti());
                dataNF = dataRow.createCell(2);
                dataNF.setCellValue("'" + zTransaksi.getNomorFaktur());
                XSSFCell dataMP = dataRow.createCell(3);
                dataMP.setCellValue("" + zTransaksi.getMasaPajak());
                XSSFCell datathn = dataRow.createCell(4);
                datathn.setCellValue("" + zTransaksi.getTahunPajak());
                XSSFCell datatglfaktur = dataRow.createCell(5);
                datatglfaktur.setCellValue(zTransaksi.getTglFaktur());
                XSSFCell datanpwppenjual = dataRow.createCell(6);
                datanpwppenjual.setCellValue("'" + zTransaksi.getNpwpLawan());
                XSSFCell dataNamaPenjual = dataRow.createCell(7);
                dataNamaPenjual.setCellValue(zTransaksi.getNamaLawan());
                XSSFCell dataAlamatPenjual = dataRow.createCell(8);
                dataAlamatPenjual.setCellValue(zTransaksi.getAlamatLawan());
                XSSFCell dataDPP = dataRow.createCell(9);
                dataDPP.setCellValue("" + zTransaksi.getJumlahDPP());
                double hargaDpp = Double.valueOf(zTransaksi.getJumlahDPP());
                String strHargaDpp = decimalFormat.format(hargaDpp);
                dataDPP.setCellValue(Double.parseDouble(strHargaDpp));
                XSSFCell dataPPN = dataRow.createCell(10);
                double hargaPpn = Double.valueOf(zTransaksi.getJumlahPPN());
                String strHargaPpn = decimalFormat.format(hargaPpn);
                dataPPN.setCellValue(Double.parseDouble(strHargaPpn));
                XSSFCell dataPPNBM = dataRow.createCell(11);
                double hargaDataTPpnbm = Double.valueOf(zTransaksi.getJumlanPPNBM());
                String strHargaDataTPpnbm = decimalFormat.format(hargaDataTPpnbm);
                dataPPNBM.setCellValue(Double.parseDouble(strHargaDataTPpnbm));
                XSSFCell dataIC = dataRow.createCell(12);
                dataIC.setCellValue("" + zTransaksi.getIsCreditable());
                XSSFCell dataStatusFaktur = dataRow.createCell(13);
                dataStatusFaktur.setCellValue(zTransaksi.getStatusFaktur());
                XSSFCell dataReferensi = dataRow.createCell(14);
                dataReferensi.setCellValue(zTransaksi.getReferensi());
                ++row;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            XSSFSheet pm2 = wb.createSheet("Excel SheetDetail");
            headerRow = pm2.createRow(0);
            _kdjenistransaksi = headerRow.createCell(0);
            _kdjenistransaksi.setCellValue("Kode Faktur");
            _stspengganti = headerRow.createCell(1);
            _stspengganti.setCellValue("Nomor Invoice");
            _nofaktur = headerRow.createCell(2);
            _nofaktur.setCellValue("Nomor Faktur");
            _tglfaktur = headerRow.createCell(3);
            _tglfaktur.setCellValue("Tanggal Faktur");
            _npwppenjual = headerRow.createCell(4);
            _npwppenjual.setCellValue("NPWP ");
            _namapenjual = headerRow.createCell(5);
            _namapenjual.setCellValue("Nama ");
            _alamatpenjual = headerRow.createCell(6);
            _alamatpenjual.setCellValue("Alamat ");
            _item = headerRow.createCell(7);
            _item.setCellValue("Item Barang");
            _hsatuan = headerRow.createCell(8);
            _hsatuan.setCellValue("Harga Satuan");
            _jumlah = headerRow.createCell(9);
            _jumlah.setCellValue("Jumlah Barang");
            XSSFCell _diskon = headerRow.createCell(10);
            _diskon.setCellValue("Diskon");
            XSSFCell _dpp = headerRow.createCell(11);
            _dpp.setCellValue("DPP");
            XSSFCell _ppn = headerRow.createCell(12);
            _ppn.setCellValue("PPN");
            XSSFCell _ppnbm = headerRow.createCell(13);
            _ppnbm.setCellValue("PPNBM");
            XSSFCell _kodebar = headerRow.createCell(14);
            _kodebar.setCellValue("KodeBarang");
            row = 1;
            locale = new Locale("en", "UK");
            pattern = "#.00";
            decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            decimalFormat.applyPattern(pattern);
            fakturPengganti = null;
            for (ZItemTransaksi zItemTransaksi : ls2) {
                dataRow = pm2.createRow((int)((short)row));
                dataKF = dataRow.createCell(0);
                dataKF.setCellValue("'" + zItemTransaksi.getKode());
                dataFG = dataRow.createCell(1);
                dataFG.setCellValue(zItemTransaksi.getNoinvoice());
                dataNF = dataRow.createCell(2);
                dataNF.setCellValue("'" + zItemTransaksi.getNomorFaktur());
                XSSFCell datatglfaktur = dataRow.createCell(3);
                datatglfaktur.setCellValue(zItemTransaksi.getTglFaktur());
                XSSFCell datanpwppenjual = dataRow.createCell(4);
                datanpwppenjual.setCellValue("'" + zItemTransaksi.getNpwpPenjual());
                XSSFCell dataNamaPenjual = dataRow.createCell(5);
                dataNamaPenjual.setCellValue(zItemTransaksi.getNamaPenjual());
                XSSFCell dataAlamatPenjual = dataRow.createCell(6);
                dataAlamatPenjual.setCellValue(zItemTransaksi.getAlamatPenjual());
                XSSFCell dataNama = dataRow.createCell(7);
                dataNama.setCellValue(zItemTransaksi.getNama());
                XSSFCell dataHS = dataRow.createCell(8);
                double hargaSatuan = Double.valueOf(zItemTransaksi.getHargaSatuan());
                String strHargaSatuan = decimalFormat.format(hargaSatuan);
                dataHS.setCellValue(Double.parseDouble(strHargaSatuan));
                XSSFCell dataJB = dataRow.createCell(9);
                double hargaJumlahBarang = Double.valueOf(zItemTransaksi.getJumlahBarang());
                String strJumlahBarang = decimalFormat.format(hargaJumlahBarang);
                dataJB.setCellValue(Double.parseDouble(strJumlahBarang));
                XSSFCell dataDiskon = dataRow.createCell(10);
                double hargaDiskon = Double.valueOf(zItemTransaksi.getDiskon());
                String strHargaDiskon = decimalFormat.format(hargaDiskon);
                dataDiskon.setCellValue(Double.parseDouble(strHargaDiskon));
                XSSFCell dataDPP = dataRow.createCell(11);
                double hargaDpp = Double.valueOf(zItemTransaksi.getDpp());
                String strHargaDpp = decimalFormat.format(hargaDpp);
                dataDPP.setCellValue(Double.parseDouble(strHargaDpp));
                XSSFCell dataPPN = dataRow.createCell(12);
                double hargaPpn = Double.valueOf(zItemTransaksi.getPpn());
                String strHargaPpn = decimalFormat.format(hargaPpn);
                dataPPN.setCellValue(Double.parseDouble(strHargaPpn));
                XSSFCell dataPPNBM = dataRow.createCell(13);
                double hargaDataPpnbm = Double.valueOf(zItemTransaksi.getPpnbm());
                String strHargaDataPpnbm = decimalFormat.format(hargaDataPpnbm);
                dataPPNBM.setCellValue(Double.parseDouble(strHargaDataPpnbm));
                XSSFCell kodeBar = dataRow.createCell(14);
                kodeBar.setCellValue("'" + zItemTransaksi.getKodeBarang());
                ++row;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(nama_file);
            try {
                wb.write((OutputStream)fileOut);
            }
            catch (IOException ex) {
                Logger.getLogger(ToolExport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ToolExport.class.getName()).log(Level.SEVERE, null, ex);
        }
        return nama_file;
    }

    public static String exportTransaksiPajakMasukanXLSPm(String nama_file, List<Transaksi> ls) {
        try {
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet pm = wb.createSheet("Excel Sheet");
            XSSFRow headerRow = pm.createRow(0);
            XSSFCell _kdjenistransaksi = headerRow.createCell(0);
            _kdjenistransaksi.setCellValue("Kode Jenis Transaksi");
            XSSFCell _stspengganti = headerRow.createCell(1);
            _stspengganti.setCellValue("Faktur Pengganti");
            XSSFCell _nofaktur = headerRow.createCell(2);
            _nofaktur.setCellValue("Nomor Faktur");
            XSSFCell _tglfaktur = headerRow.createCell(3);
            _tglfaktur.setCellValue("Masa Pajak");
            XSSFCell _npwppenjual = headerRow.createCell(4);
            _npwppenjual.setCellValue("Tahun Pajak");
            XSSFCell _namapenjual = headerRow.createCell(5);
            _namapenjual.setCellValue("Tanggal Faktur");
            XSSFCell _alamatpenjual = headerRow.createCell(6);
            _alamatpenjual.setCellValue("NPWP");
            XSSFCell _item = headerRow.createCell(7);
            _item.setCellValue("Nama");
            XSSFCell _hsatuan = headerRow.createCell(8);
            _hsatuan.setCellValue("Alamat");
            XSSFCell _jumlah = headerRow.createCell(9);
            _jumlah.setCellValue("Jumlah Dpp");
            XSSFCell _htotal = headerRow.createCell(10);
            _htotal.setCellValue("Jumlah PPn");
            XSSFCell _diskon = headerRow.createCell(11);
            _diskon.setCellValue("Jumlah PpnBm");
            XSSFCell _dpp = headerRow.createCell(12);
            _dpp.setCellValue("Dikreditkan");
            XSSFCell _statusFaktur = headerRow.createCell(13);
            _statusFaktur.setCellValue("Status Faktur");
            XSSFCell _referensi = headerRow.createCell(14);
            _referensi.setCellValue("Referensi");
            int row = 1;
            Locale locale = new Locale("en", "UK");
            String pattern = "#.00";
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            decimalFormat.applyPattern(pattern);
            Object fakturPengganti = null;
            for (Transaksi t : ls) {
                XSSFRow dataRow = pm.createRow((int)((short)row));
                XSSFCell dataKF = dataRow.createCell(0);
                dataKF.setCellValue("'" + t.getKode());
                XSSFCell dataFG = dataRow.createCell(1);
                dataFG.setCellValue(t.getFgPengganti());
                XSSFCell dataNF = dataRow.createCell(2);
                dataNF.setCellValue("'" + t.getNomorFaktur());
                XSSFCell dataMP = dataRow.createCell(3);
                dataMP.setCellValue("" + t.getMasaPajak());
                XSSFCell datathn = dataRow.createCell(4);
                datathn.setCellValue("" + t.getTahunPajak());
                XSSFCell datatglfaktur = dataRow.createCell(5);
                datatglfaktur.setCellValue(t.getTglFaktur());
                XSSFCell datanpwppenjual = dataRow.createCell(6);
                datanpwppenjual.setCellValue("'" + t.getNpwpPenjual());
                XSSFCell dataNamaPenjual = dataRow.createCell(7);
                dataNamaPenjual.setCellValue(t.getNamaPenjual());
                XSSFCell dataAlamatPenjual = dataRow.createCell(8);
                dataAlamatPenjual.setCellValue(t.getAlamatPenjual());
                XSSFCell dataDPP = dataRow.createCell(9);
                dataDPP.setCellValue("" + t.getJumlahDPP());
                double hargaDpp = Double.valueOf(t.getJumlahDPP());
                String strHargaDpp = decimalFormat.format(hargaDpp);
                dataDPP.setCellValue(Double.parseDouble(strHargaDpp));
                XSSFCell dataPPN = dataRow.createCell(10);
                double hargaPpn = Double.valueOf(t.getJumlahPPN());
                String strHargaPpn = decimalFormat.format(hargaPpn);
                dataPPN.setCellValue(Double.parseDouble(strHargaPpn));
                XSSFCell dataPPNBM = dataRow.createCell(11);
                double hargaDataTPpnbm = Double.valueOf(t.getJumlanPPNBM());
                String strHargaDataTPpnbm = decimalFormat.format(hargaDataTPpnbm);
                dataPPNBM.setCellValue(Double.parseDouble(strHargaDataTPpnbm));
                XSSFCell dataIC = dataRow.createCell(12);
                dataIC.setCellValue("" + t.getIsCreditable());
                XSSFCell dataStatusFaktur = dataRow.createCell(13);
                dataStatusFaktur.setCellValue(t.getStatusFaktur());
                XSSFCell dataReferensi = dataRow.createCell(14);
                dataReferensi.setCellValue(t.getReferensi());
                ++row;
            }
            FileOutputStream fileOut = new FileOutputStream(nama_file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nama_file;
    }

    public static String exportTransaksiPajakMasukanXLS(String nama_file, List<ZTransaksi> ls) {
        try {
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet pm = wb.createSheet("Excel Sheet");
            XSSFRow headerRow = pm.createRow(0);
            XSSFCell _kdjenistransaksi = headerRow.createCell(0);
            _kdjenistransaksi.setCellValue("Kode Jenis Transaksi");
            XSSFCell _stspengganti = headerRow.createCell(1);
            _stspengganti.setCellValue("Faktur Pengganti");
            XSSFCell _nofaktur = headerRow.createCell(2);
            _nofaktur.setCellValue("Nomor Faktur");
            XSSFCell _tglfaktur = headerRow.createCell(3);
            _tglfaktur.setCellValue("Masa Pajak");
            XSSFCell _npwppenjual = headerRow.createCell(4);
            _npwppenjual.setCellValue("Tahun Pajak");
            XSSFCell _namapenjual = headerRow.createCell(5);
            _namapenjual.setCellValue("Tanggal Faktur");
            XSSFCell _alamatpenjual = headerRow.createCell(6);
            _alamatpenjual.setCellValue("NPWP");
            XSSFCell _item = headerRow.createCell(7);
            _item.setCellValue("Nama Lawan");
            XSSFCell _hsatuan = headerRow.createCell(8);
            _hsatuan.setCellValue("Alamat Lawan");
            XSSFCell _jumlah = headerRow.createCell(9);
            _jumlah.setCellValue("Jumlah Dpp");
            XSSFCell _htotal = headerRow.createCell(10);
            _htotal.setCellValue("Jumlah PPn");
            XSSFCell _diskon = headerRow.createCell(11);
            _diskon.setCellValue("Jumlah PpnBm");
            XSSFCell _dpp = headerRow.createCell(12);
            _dpp.setCellValue("Dikreditkan");
            XSSFCell _statusFaktur = headerRow.createCell(13);
            _statusFaktur.setCellValue("Status Faktur");
            XSSFCell _referensi = headerRow.createCell(14);
            _referensi.setCellValue("Referensi");
            int row = 1;
            Locale locale = new Locale("en", "UK");
            String pattern = "#.00";
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            decimalFormat.applyPattern(pattern);
            Object fakturPengganti = null;
            for (ZTransaksi t : ls) {
                XSSFRow dataRow = pm.createRow((int)((short)row));
                XSSFCell dataKF = dataRow.createCell(0);
                dataKF.setCellValue("'" + t.getKode());
                XSSFCell dataFG = dataRow.createCell(1);
                dataFG.setCellValue(t.getFgPengganti());
                XSSFCell dataNF = dataRow.createCell(2);
                dataNF.setCellValue("'" + t.getNomorFaktur());
                XSSFCell dataMP = dataRow.createCell(3);
                dataMP.setCellValue("" + t.getMasaPajak());
                XSSFCell datathn = dataRow.createCell(4);
                datathn.setCellValue("" + t.getTahunPajak());
                XSSFCell datatglfaktur = dataRow.createCell(5);
                datatglfaktur.setCellValue(t.getTglFaktur());
                XSSFCell datanpwppenjual = dataRow.createCell(6);
                datanpwppenjual.setCellValue("'" + t.getNpwpLawan());
                XSSFCell dataNamaPenjual = dataRow.createCell(7);
                dataNamaPenjual.setCellValue(t.getNamaLawan());
                XSSFCell dataAlamatPenjual = dataRow.createCell(8);
                dataAlamatPenjual.setCellValue(t.getAlamatLawan());
                XSSFCell dataDPP = dataRow.createCell(9);
                dataDPP.setCellValue("" + t.getJumlahDPP());
                double hargaDpp = Double.valueOf(t.getJumlahDPP());
                String strHargaDpp = decimalFormat.format(hargaDpp);
                dataDPP.setCellValue(Double.parseDouble(strHargaDpp));
                XSSFCell dataPPN = dataRow.createCell(10);
                double hargaPpn = Double.valueOf(t.getJumlahPPN());
                String strHargaPpn = decimalFormat.format(hargaPpn);
                dataPPN.setCellValue(Double.parseDouble(strHargaPpn));
                XSSFCell dataPPNBM = dataRow.createCell(11);
                double hargaDataTPpnbm = Double.valueOf(t.getJumlanPPNBM());
                String strHargaDataTPpnbm = decimalFormat.format(hargaDataTPpnbm);
                dataPPNBM.setCellValue(Double.parseDouble(strHargaDataTPpnbm));
                XSSFCell dataIC = dataRow.createCell(12);
                dataIC.setCellValue("" + t.getIsCreditable());
                XSSFCell dataStatusFaktur = dataRow.createCell(13);
                dataStatusFaktur.setCellValue(t.getStatusFaktur());
                XSSFCell dataReferensi = dataRow.createCell(14);
                dataReferensi.setCellValue(t.getReferensi());
                ++row;
            }
            FileOutputStream fileOut = new FileOutputStream(nama_file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nama_file;
    }

    public static String exportPajakKeluaranXml(String nama_file, List<ZTransaksi> ls) {
        System.out.println("Eksport PK !!!!!");
        ZDAOTransaksi dao = new ZDAOTransaksi();
        try {
            FileWriter writer = new FileWriter(nama_file);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<TaxInvoiceBulk  xsi:noNamespaceSchemaLocation=\"TaxInvoice.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
            int counter = 0;
            for (ZTransaksi transaksi : ls) {
                String alamatLawan = transaksi.getAlamatLawan();
                String subAlamat = null;
                if (alamatLawan != null && !alamatLawan.isEmpty()) {
                    subAlamat = alamatLawan.substring(0, Math.min(alamatLawan.length(), 50));
                    System.out.println(subAlamat);
                } else {
                    System.out.println("Alamat is empty or null.");
                }
                if (++counter == 1) {
                    writer.write("<TIN>" + transaksi.getNpwpPenjual() + "</TIN>\n");
                    writer.write("<ListOfTaxInvoice>\n");
                }
                System.out.println("tin " + transaksi.getNpwpPenjual() + " counter " + counter);
                writer.write("<TaxInvoice>\n");
                writer.write("<TaxInvoiceDate>" + transaksi.getTglFaktur().replace("/", "-") + "</TaxInvoiceDate>\n");
                writer.write("<TaxInvoiceOpt>Normal</TaxInvoiceOpt>\n");
                writer.write("<TrxCode>" + transaksi.getKode() + "</TrxCode>\n");
                if (transaksi.getKode().equalsIgnoreCase("07") || transaksi.getKode().equalsIgnoreCase("08")) {
                    writer.write("<AddInfo>" + transaksi.getAddInfo() + "</AddInfo>\n");
                    if (transaksi.getAddInfo().equalsIgnoreCase("TD.00517") || transaksi.getAddInfo().equalsIgnoreCase("TD.00518")) {
                        writer.write("<CustomDoc>" + transaksi.getDokumenPendukung() + "</CustomDoc>\n");
                    } else {
                        writer.write("<CustomDoc></CustomDoc>\n");
                    }
                } else {
                    writer.write("<AddInfo></AddInfo>\n");
                    writer.write("<CustomDoc></CustomDoc>\n");
                }
                writer.write("<CustomDocMonthYear></CustomDocMonthYear>\n");
                writer.write("<RefDesc>" + transaksi.getNoinvoice() + "</RefDesc>\n");
                writer.write("<FacilityStamp></FacilityStamp>\n");
                writer.write("<SellerIDTKU>" + transaksi.getIdTkuPenjual() + "</SellerIDTKU>\n");
                writer.write("<BuyerTin>" + transaksi.getNpwpLawan() + "</BuyerTin>\n");
                writer.write("<BuyerDocument>" + transaksi.getJenisIdPembeli() + "</BuyerDocument>\n");
                writer.write("<BuyerCountry>" + transaksi.getNegaraPembeli() + "</BuyerCountry>\n");
                writer.write("<BuyerDocumentNumber>" + transaksi.getNoDokumenPembeli() + "</BuyerDocumentNumber>\n");
                writer.write("<BuyerName>" + transaksi.getNamaLawan().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;").replace("#", "").replace(",", "") + "</BuyerName>\n");
                writer.write("<BuyerAdress>" + transaksi.getAlamatLawan().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;").replace("#", "").replace(",", "") + "</BuyerAdress>\n");
                if (transaksi.getEmailPembeli() == null || transaksi.getEmailPembeli().equalsIgnoreCase("null") || transaksi.getEmailPembeli().trim().isEmpty()) {
                    writer.write("<BuyerEmail></BuyerEmail>\n");
                } else {
                    writer.write("<BuyerEmail>" + transaksi.getEmailPembeli() + "</BuyerEmail>\n");
                }
                if (transaksi.getIdTkuPembeli() == null || transaksi.getIdTkuPembeli().trim().isEmpty()) {
                    writer.write("<BuyerIDTKU>" + transaksi.getNpwpLawan() + "000000</BuyerIDTKU>\n");
                } else {
                    writer.write("<BuyerIDTKU>" + transaksi.getNpwpLawan() + transaksi.getIdTkuPembeli() + "</BuyerIDTKU>\n");
                }
                List<ZItemTransaksi> items = dao.loadTransaksiExportDetail(transaksi.getNoinvoice());
                writer.write("<ListOfGoodService>\n");
                String hsatuan = "0";
                String hdiskon = "0";
                for (ZItemTransaksi item : items) {
                    hsatuan = Double.valueOf(item.getJumlahBarang().replace(",", ".")) > 0.0 ? item.getHargaSatuan().replace(",", ".") : "1";
                    writer.write("<GoodService>\n");
                    writer.write("<Opt>" + item.getBarangJasa() + "</Opt>\n");
                    writer.write("<Code>" + item.getKodeBarang() + "</Code>\n");
                    writer.write("<Name>" + item.getNama().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;").replace("#", "").replace(",", "") + "</Name>\n");
                    writer.write("<Unit>" + item.getSatuanUkur() + "</Unit>\n");
                    writer.write("<Price>" + item.getHargaSatuan().replace(",", ".") + "</Price>\n");
                    writer.write("<Qty>" + item.getJumlahBarang().replace(",", ".") + "</Qty>\n");
                    writer.write("<TotalDiscount>" + item.getDiskon().replace("-", "").replace(",", ".") + "</TotalDiscount>\n");
                    writer.write("<TaxBase>" + item.getDpp().replace(",", ".") + "</TaxBase>\n");
                    writer.write("<OtherTaxBase>" + item.getDppLain().replace(",", ".") + "</OtherTaxBase>\n");
                    writer.write("<VATRate>" + item.getSatuanPPn().replace(",", ".") + "</VATRate>\n");
                    writer.write("<VAT>" + item.getPpn().replace(",", ".") + "</VAT>\n");
                    writer.write("<STLGRate>" + item.getTarifPpnbm().replace(",", ".") + "</STLGRate>\n");
                    writer.write("<STLG>" + item.getPpnbm().replace(",", ".") + "</STLG>\n");
                    writer.write("</GoodService>\n");
                }
                writer.write("</ListOfGoodService>\n");
                writer.write("</TaxInvoice>\n");
            }
            writer.write("</ListOfTaxInvoice>\n");
            writer.write("</TaxInvoiceBulk>\n");
            writer.close();
            return "Export successful";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Export failed: " + e.getMessage();
        }
    }

    public String setNilai(String namaatt, String values) {
        ZDAOGroupHeader dao = new ZDAOGroupHeader();
        String val = "null";
        try {
            val = dao.findByNilaiAwal(namaatt.toString().trim()).getNilai_awal();
        }
        catch (SQLException ex) {
            Logger.getLogger(ToolExport.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (val.equalsIgnoreCase("null")) {
            val = values;
        }
        return val;
    }

    public static String exportPajakKeluaran(String nama_file, List<ZTransaksi> ls) {
        System.out.println("Eksport PK !!!!!");
        ZDAOTransaksi dao = new ZDAOTransaksi();
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            Sheet pm = wb.createSheet("PK");
            Row headerRow = pm.createRow(0);
            Row headerRow1 = pm.createRow(1);
            Row headerRow2 = pm.createRow(2);
            Cell _fm = headerRow.createCell(0);
            _fm.setCellValue("FK");
            Cell _kd = headerRow.createCell(1);
            _kd.setCellValue("KD_JENIS_TRANSAKSI");
            Cell _fg = headerRow.createCell(2);
            _fg.setCellValue("FG_PENGGANTI");
            Cell _no = headerRow.createCell(3);
            _no.setCellValue("NOMOR_FAKTUR");
            Cell _mp = headerRow.createCell(4);
            _mp.setCellValue("MASA_PAJAK");
            Cell _thn = headerRow.createCell(5);
            _thn.setCellValue("TAHUN_PAJAK");
            Cell _tgl = headerRow.createCell(6);
            _tgl.setCellValue("TANGGAL_FAKTUR");
            Cell _npwp = headerRow.createCell(7);
            _npwp.setCellValue("NPWP");
            Cell _nm = headerRow.createCell(8);
            _nm.setCellValue("NAMA");
            Cell _al = headerRow.createCell(9);
            _al.setCellValue("ALAMAT_LENGKAP");
            Cell _dpp = headerRow.createCell(10);
            _dpp.setCellValue("JUMLAH_DPP");
            Cell _ppn = headerRow.createCell(11);
            _ppn.setCellValue("JUMLAH_PPN");
            Cell _ppnbm = headerRow.createCell(12);
            _ppnbm.setCellValue("JUMLAH_PPNBM");
            Cell _idkettambah = headerRow.createCell(13);
            _idkettambah.setCellValue("ID_KETERANGAN_TAMBAHAN");
            Cell _fguangmuka = headerRow.createCell(14);
            _fguangmuka.setCellValue("FG_UANG_MUKA");
            Cell _uangmukadpp = headerRow.createCell(15);
            _uangmukadpp.setCellValue("UANG_MUKA_DPP");
            Cell _uangmukappn = headerRow.createCell(16);
            _uangmukappn.setCellValue("UANG_MUKA_PPN");
            Cell _uangmukappnbm = headerRow.createCell(17);
            _uangmukappnbm.setCellValue("UANG_MUKA_PPNBM");
            Cell _referensi = headerRow.createCell(18);
            _referensi.setCellValue("REFERENSI");
            Cell _lt = headerRow1.createCell(0);
            _lt.setCellValue("LT");
            Cell _npwp2 = headerRow1.createCell(1);
            _npwp2.setCellValue("NPWP");
            Cell _nama = headerRow1.createCell(2);
            _nama.setCellValue("NAMA");
            Cell _jalan = headerRow1.createCell(3);
            _jalan.setCellValue("JALAN");
            Cell _blok = headerRow1.createCell(4);
            _blok.setCellValue("BLOK");
            Cell _nomor = headerRow1.createCell(5);
            _nomor.setCellValue("NOMOR");
            Cell _rt = headerRow1.createCell(6);
            _rt.setCellValue("RT");
            Cell _rw = headerRow1.createCell(7);
            _rw.setCellValue("RW");
            Cell _kecamatan = headerRow1.createCell(8);
            _kecamatan.setCellValue("KECAMATAN");
            Cell _kelurahan = headerRow1.createCell(9);
            _kelurahan.setCellValue("KELURAHAN");
            Cell _kabupaten = headerRow1.createCell(10);
            _kabupaten.setCellValue("KABUPATEN");
            Cell _propinsi = headerRow1.createCell(11);
            _propinsi.setCellValue("PROPINSI");
            Cell _kodepos = headerRow1.createCell(12);
            _kodepos.setCellValue("KODE_POS");
            Cell _notelp = headerRow1.createCell(13);
            _notelp.setCellValue("NOMOR_TELEPON");
            Cell _of = headerRow2.createCell(0);
            _of.setCellValue("OF");
            Cell _kdobjek = headerRow2.createCell(1);
            _kdobjek.setCellValue("KODE_OBJEK");
            Cell _nama3 = headerRow2.createCell(2);
            _nama3.setCellValue("NAMA");
            Cell _hargasatuan = headerRow2.createCell(3);
            _hargasatuan.setCellValue("HARGA_SATUAN");
            Cell _jmlbarang = headerRow2.createCell(4);
            _jmlbarang.setCellValue("JUMLAH_BARANG");
            Cell _hargatotal = headerRow2.createCell(5);
            _hargatotal.setCellValue("HARGA_TOTAL");
            Cell _diskon = headerRow2.createCell(6);
            _diskon.setCellValue("DISKON");
            Cell _dpp1 = headerRow2.createCell(7);
            _dpp1.setCellValue("DPP");
            Cell _ppn1 = headerRow2.createCell(8);
            _ppn1.setCellValue("PPN");
            Cell _tarifppnbm = headerRow2.createCell(9);
            _tarifppnbm.setCellValue("TARIF_PPNBM");
            Cell _ppnbm1 = headerRow2.createCell(10);
            _ppnbm1.setCellValue("PPNBM");
            int row = 3;
            for (ZTransaksi t : ls) {
                Row dataRow = pm.createRow(row);
                List<ZItemTransaksi> ls2 = dao.loadTransaksiExportDetail(t.getNoinvoice());
                Cell dataFM = dataRow.createCell(0);
                dataFM.setCellValue("FK");
                Cell dataKD = dataRow.createCell(1);
                dataKD.setCellValue(t.getKode());
                Cell dataFG = dataRow.createCell(2);
                dataFG.setCellValue(t.getFgPengganti());
                Cell dataNF = dataRow.createCell(3);
                System.out.println(t.getNomorFaktur());
                String dt = t.getNomorFaktur().replace(".", "");
                dataNF.setCellValue(dt);
                String tgl = t.getTglFaktur();
                String[] artgl = tgl.split("/");
                Cell dataMP = dataRow.createCell(4);
                dataMP.setCellValue("" + t.getMasaPajak());
                Cell datathn = dataRow.createCell(5);
                datathn.setCellValue("" + t.getTahunPajak());
                Cell datatgl = dataRow.createCell(6);
                datatgl.setCellValue(tgl);
                Cell dataNPWP = dataRow.createCell(7);
                dataNPWP.setCellValue(t.getNpwpLawan());
                Cell dataNama = dataRow.createCell(8);
                dataNama.setCellValue(t.getNamaLawan());
                Cell dataAlamat = dataRow.createCell(9);
                dataAlamat.setCellValue(t.getAlamatLawan());
                Cell dataDPP = dataRow.createCell(10);
                dataDPP.setCellValue("" + t.getJumlahDPP());
                Cell dataPPN = dataRow.createCell(11);
                dataPPN.setCellValue("" + t.getJumlahPPN());
                Cell dataPPNBM = dataRow.createCell(12);
                dataPPNBM.setCellValue("" + t.getJumlanPPNBM());
                Cell dataIdKetTambahan = dataRow.createCell(13);
                dataIdKetTambahan.setCellValue("");
                Cell fgUangMuka = dataRow.createCell(14);
                fgUangMuka.setCellValue("");
                Cell uangMukaDPP = dataRow.createCell(15);
                uangMukaDPP.setCellValue("");
                Cell uangMukaPPn = dataRow.createCell(16);
                uangMukaPPn.setCellValue("");
                Cell uangMukaPPnBm = dataRow.createCell(17);
                uangMukaPPnBm.setCellValue("");
                System.out.println("SIZE Invoice " + t.getNoinvoice());
                System.out.println("SIZE " + ls2.size());
                for (ZItemTransaksi z : ls2) {
                    Row dataRow1 = pm.createRow(++row);
                    Cell dataOF = dataRow1.createCell(0);
                    dataOF.setCellValue("OF");
                    Cell dataKodeObjek = dataRow1.createCell(1);
                    dataKodeObjek.setCellValue(z.getNoinvoice());
                    Cell dataNamaDetail = dataRow1.createCell(2);
                    dataNamaDetail.setCellValue(z.getNama());
                    Cell hargaSatuan = dataRow1.createCell(3);
                    hargaSatuan.setCellValue(z.getHargaSatuan());
                    Cell jmlBarang = dataRow1.createCell(4);
                    jmlBarang.setCellValue(z.getJumlahBarang());
                    Cell hargaTotal = dataRow1.createCell(5);
                    hargaTotal.setCellValue(z.getHargaTotal());
                    Cell diskon = dataRow1.createCell(6);
                    diskon.setCellValue(z.getDiskon());
                    Cell dpp = dataRow1.createCell(7);
                    dpp.setCellValue(z.getDpp());
                    Cell ppn = dataRow1.createCell(8);
                    ppn.setCellValue(z.getPpn());
                    Cell tarifppnbM = dataRow1.createCell(9);
                    tarifppnbM.setCellValue(z.getTarifPpnbm());
                    Cell ppnbm = dataRow1.createCell(10);
                    ppnbm.setCellValue(z.getPpnbm());
                }
                ++row;
            }
            Calendar cal = Calendar.getInstance();
            String nama = "transaksi_" + cal.get(1) + cal.get(2) + cal.get(5) + cal.get(12) + ".csv";
            String outputDirPath = "D:/" + nama;
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                System.out.println(wb.getSheetAt(i).getSheetName());
            }
            cellGrid = new ArrayList<List<HSSFCell>>();
            Sheet mySheet = wb.getSheetAt(0);
            Iterator rowIter = mySheet.rowIterator();
            while (rowIter.hasNext()) {
                HSSFRow myRow = (HSSFRow)rowIter.next();
                Iterator cellIter = myRow.cellIterator();
                ArrayList<HSSFCell> cellRowList = new ArrayList<HSSFCell>();
                while (cellIter.hasNext()) {
                    HSSFCell myCell = (HSSFCell)cellIter.next();
                    cellRowList.add(myCell);
                }
                cellGrid.add(cellRowList);
            }
            File file = new File(nama_file);
            PrintStream stream = new PrintStream(file);
            for (int i = 0; i < cellGrid.size(); ++i) {
                List<HSSFCell> cellRowList = cellGrid.get(i);
                for (int j = 0; j < cellRowList.size(); ++j) {
                    HSSFCell myCell = cellRowList.get(j);
                    String stringCellValue = myCell.toString();
                    if (stringCellValue.equalsIgnoreCase("FK")) {
                        stream.print(stringCellValue + ";");
                        continue;
                    }
                    stream.print("\"" + stringCellValue + "\";");
                }
                stream.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nama_file;
    }
}

