/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.model;

import db.DBKoneksi;
import esindo.net.model.ItemTransaksi;
import esindo.net.model.JenisFaktur;
import esindo.net.model.TempPdfpm;
import esindo.net.model.Transaksi;
import esindo.net.model.TransaksiBupot;
import esindo.net.model.ZItemTransaksi;
import esindo.net.model.ZTransaksi;
import java.awt.Cursor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DAOTransaksi {
    private Cursor waitCursor = new Cursor(3);
    private Cursor defaultCursor = new Cursor(0);
    DBKoneksi dbkon = null;
    Transaksi tr = null;
    List<ItemTransaksi> itemList = new ArrayList<ItemTransaksi>();

    public DAOTransaksi() {
        this.dbkon = new DBKoneksi();
    }

    public List<ItemTransaksi> getItemList() {
        return this.itemList;
    }

    public void setItemList(List<ItemTransaksi> itemList) {
        this.itemList = itemList;
    }

    public void saveMaster(Transaksi obj) throws SQLException {
        String sql = "INSERT INTO tbl_transaksi(namaPenjual,alamatPenjual,jumlahDpp,jumlahPPn,referensi,tanggalFaktur,npwpPenjual,kdJenisTransaksi,fgPengganti,nomorFaktur,masa_pajak,tahun_pajak,npwpLawanTransaksi,namaLawanTransaksi,alamatLawanTransaksi,jumlahPpnBm) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getNamaPenjual());
        pst.setString(2, obj.getAlamatPenjual());
        pst.setString(3, obj.getJumlahDPP());
        pst.setString(4, obj.getJumlahPPN());
        pst.setString(5, obj.getNoinvoice());
        pst.setString(6, obj.getTglFaktur());
        pst.setString(7, obj.getNpwpPenjual());
        pst.setString(8, obj.getKode());
        pst.setString(9, obj.getFgPengganti());
        pst.setString(10, obj.getNomorFaktur());
        pst.setInt(11, obj.getMasaPajak());
        pst.setInt(12, obj.getTahunPajak());
        pst.setString(13, obj.getNpwpLawan());
        pst.setString(14, obj.getNamaLawan());
        pst.setString(15, obj.getAlamatLawan());
        pst.setString(16, obj.getJumlanPPNBM());
        pst.executeUpdate();
        Transaksi _tr = this.findByNomorFaktur(obj.getNomorFaktur());
        obj.setId(_tr.getId());
        pst.close();
    }

    public void saveDetail(ItemTransaksi obj) throws SQLException {
        String sql = "INSERT INTO tbl_transaksi_detail(nama,hargaSatuan,jumlahBarang,hargaTotal,diskon,dpp,ppn,tarifPpnbm,ppnbm,transaksi_id,nomorInvoice,barangJasa,tarifPPn,satuanUkur,dppLain,kodeBarang) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getNama());
        pst.setString(2, obj.getHargaSatuan());
        pst.setString(3, obj.getJumlahBarang());
        pst.setString(4, obj.getHargaTotal());
        pst.setString(5, obj.getDiskon());
        pst.setString(6, obj.getDpp());
        pst.setString(7, obj.getPpn());
        pst.setString(8, obj.getTarifPpnbm());
        pst.setString(9, obj.getPpnbm());
        pst.setInt(10, obj.getTransaksiId());
        pst.setString(11, obj.getNoinvoice());
        pst.setString(12, obj.getBarangJasa());
        pst.setString(13, obj.getSatuanPPn());
        pst.setString(14, obj.getSatuanUkur());
        pst.setString(15, obj.getDppLain());
        pst.setString(16, obj.getKodeBarang());
        pst.executeUpdate();
        pst.close();
    }

    public List<TempPdfpm> loadTempdfAll() {
        ArrayList<TempPdfpm> ls = new ArrayList<TempPdfpm>();
        String sql = "Select * from tbl_tempPdfpm ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                TempPdfpm obj = new TempPdfpm();
                obj.setId(rs.getInt("id"));
                obj.setNamafile(rs.getString("namafile"));
                obj.setCustomer(rs.getString("customer"));
                obj.setNpwp(rs.getString("npwp"));
                obj.setNo_invoice(rs.getString("no_invoice"));
                obj.setTgl_invoice(rs.getString("tgl_invoice"));
                obj.setBarangJasa(rs.getString("barangjasa"));
                obj.setSatuanUkur(rs.getString("satuanUkur"));
                obj.setNofaktur(rs.getString("nofaktur"));
                obj.setAlamat(rs.getString("alamat"));
                obj.setKodeBarang(rs.getString("kodeBarang"));
                obj.setVat(rs.getString("vat"));
                obj.setDpp(rs.getString("dpp"));
                obj.setPpnbm(rs.getString("ppnbm"));
                obj.setTotal(rs.getString("total"));
                obj.setDetail(rs.getString("detail"));
                obj.setIsjson(rs.getString("isjson"));
                obj.setJsonval(rs.getString("jsonval"));
                obj.setPathfilepdf(rs.getString("pathfilepdf"));
                ls.add(obj);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public TableModel selectallTemp() {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn("Id");
        model.addColumn("Nama File");
        model.addColumn("Nama Customer");
        model.addColumn("Npwp");
        model.addColumn("No Invoice");
        model.addColumn("Tgl Invoice");
        model.addColumn("No Faktur");
        model.addColumn("Alamat");
        model.addColumn("PPn");
        model.addColumn("Dpp");
        model.addColumn("PPnBm");
        model.addColumn("Total");
        model.addColumn("Detail");
        model.addColumn("Isjs");
        model.addColumn("Details");
        String sql = "Select * from tbl_tempPdfpm ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            TempPdfpm obj = null;
            boolean grp = false;
            String nama_group = "";
            while (rs.next()) {
                obj = new TempPdfpm();
                obj.setId(rs.getInt("id"));
                obj.setNamafile(rs.getString("namafile"));
                obj.setCustomer(rs.getString("customer"));
                obj.setNpwp(rs.getString("npwp"));
                obj.setNo_invoice(rs.getString("no_invoice"));
                obj.setTgl_invoice(rs.getString("tgl_invoice"));
                obj.setBarangJasa(rs.getString("barangjasa"));
                obj.setSatuanUkur(rs.getString("satuanUkur"));
                obj.setNofaktur(rs.getString("nofaktur"));
                obj.setAlamat(rs.getString("alamat"));
                obj.setKodeBarang(rs.getString("kodeBarang"));
                obj.setVat(rs.getString("vat"));
                obj.setDpp(rs.getString("dpp"));
                obj.setPpnbm(rs.getString("ppnbm"));
                obj.setTotal(rs.getString("total"));
                obj.setDetail(rs.getString("detail"));
                obj.setIsjson(rs.getString("isjson"));
                obj.setJsonval(rs.getString("jsonval"));
                model.addRow(new Object[]{obj.getId(), obj.getNamafile(), obj.getCustomer(), obj.getNpwp(), obj.getNo_invoice(), obj.getTgl_invoice(), obj.getNofaktur(), obj.getAlamat(), obj.getVat(), obj.getDpp(), obj.getPpnbm(), obj.getTotal(), obj.getDetail(), obj.getIsjson(), obj.getJsonval()});
            }
        }
        catch (SQLException e) {
            System.out.println("SQL Tidak Dapat Menampilkan Data Yang Dimaksud");
            e.printStackTrace();
        }
        return model;
    }

    public void deleteDataPdfTemp() {
        String sql = "DELETE FROM tbl_tempPdfpm";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void savePdfTmp(TempPdfpm obj) {
        String sql = "INSERT INTO tbl_tempPdfpm(tgl_invoice,no_invoice,vat,dpp,total,customer,detail,npwp,nitku,kode_tr,namafile,barangjasa,satuanUkur,kodeBarang,isjson,jsonval,nofaktur,alamat,ppnbm,pathfilepdf) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try (PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);){
            System.out.println("\u23f3 Menyimpan data ke tbl_tempPdfpm...");
            pst.setString(1, obj.getTgl_invoice());
            pst.setString(2, obj.getNo_invoice());
            pst.setString(3, obj.getVat());
            pst.setString(4, obj.getDpp());
            pst.setString(5, obj.getTotal());
            pst.setString(6, obj.getCustomer());
            pst.setString(7, obj.getDetail());
            pst.setString(8, obj.getNpwp());
            pst.setString(9, obj.getNitku());
            pst.setString(10, obj.getKode_tr());
            pst.setString(11, obj.getNamafile());
            pst.setString(12, obj.getBarangJasa());
            pst.setString(13, obj.getSatuanUkur());
            pst.setString(14, obj.getKodeBarang());
            pst.setString(15, obj.getIsjson());
            pst.setString(16, obj.getJsonval());
            pst.setString(17, obj.getNofaktur());
            pst.setString(18, obj.getAlamat());
            pst.setString(19, obj.getPpnbm());
            pst.setString(20, obj.getPathfilepdf());
            int affected = pst.executeUpdate();
            System.out.println("\u2705 Insert berhasil. Baris terpengaruh: " + affected);
        }
        catch (SQLException e) {
            System.err.println("\u274c Gagal menyimpan data ke tbl_tempPdfpm:");
            System.err.println("SQLState: " + e.getSQLState());
            System.err.println("ErrorCode: " + e.getErrorCode());
            System.err.println("Message: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception ex) {
            System.err.println("\u274c Terjadi kesalahan umum:");
            ex.printStackTrace();
        }
    }

    public void savePdfTmpold(TempPdfpm obj) throws SQLException {
        System.out.println("tessss ");
        String sql = "INSERT INTO tbl_tempPdfpm(tgl_invoice,no_invoice,vat,dpp,total,customer,detail,npwp,nitku,kode_tr,namafile,barangjasa,satuanUkur,kodeBarang,isjson,jsonval,nofaktur,alamat) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getTgl_invoice());
        pst.setString(2, obj.getNo_invoice());
        pst.setString(3, obj.getVat());
        pst.setString(4, obj.getDpp());
        pst.setString(5, obj.getTotal());
        pst.setString(6, obj.getCustomer());
        pst.setString(7, obj.getDetail());
        pst.setString(8, obj.getNpwp());
        pst.setString(9, obj.getNitku());
        pst.setString(10, obj.getKode_tr());
        pst.setString(11, obj.getNamafile());
        pst.setString(12, obj.getBarangJasa());
        pst.setString(13, obj.getSatuanUkur());
        pst.setString(14, obj.getKodeBarang());
        pst.setString(15, obj.getIsjson());
        pst.setString(16, obj.getJsonval());
        pst.setString(17, obj.getNofaktur());
        pst.setString(18, obj.getAlamat());
        pst.executeUpdate();
        pst.close();
    }

    public void save(Transaksi obj) throws SQLException {
        String sql = "INSERT INTO tbl_transaksi (kdJenisTransaksi,fgPengganti,nomorFaktur,tanggalFaktur,npwpPenjual,namaPenjual,alamatPenjual,npwpLawanTransaksi,namaLawanTransaksi,alamatLawanTransaksi,jumlahDpp,jumlahPpn,jumlahPpnBm,statusApproval,statusFaktur,linkfaktur_id,tgl,masa_pajak,tahun_pajak,is_kredit,status_export,referensi)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getKode());
        pst.setString(2, obj.getFgPengganti());
        pst.setString(3, obj.getNomorFaktur());
        pst.setString(4, obj.getTanggal());
        pst.setString(5, obj.getNpwpPenjual());
        pst.setString(6, obj.getNamaPenjual());
        pst.setString(7, obj.getAlamatPenjual());
        pst.setString(8, obj.getNpwpLawan());
        pst.setString(9, obj.getNamaLawan());
        pst.setString(10, obj.getAlamatLawan());
        pst.setString(11, obj.getJumlahDPP());
        pst.setString(12, obj.getJumlahPPN());
        pst.setString(13, obj.getJumlanPPNBM());
        pst.setString(14, obj.getStatusApproval());
        pst.setString(15, obj.getStatusFaktur());
        pst.setInt(16, obj.getLinkfakturId());
        String[] _ar_tgl = obj.getTanggalSQL().split("-");
        pst.setString(17, obj.getTanggalSQL());
        obj.setMasaPajak(Integer.parseInt(_ar_tgl[1]));
        obj.setTahunPajak(Integer.parseInt(_ar_tgl[0]));
        obj.setIsCreditable(1);
        if (obj.getKode().equals("07") || obj.getKode().equals("08")) {
            obj.setIsCreditable(0);
        }
        pst.setInt(18, obj.getMasaPajak());
        pst.setInt(19, obj.getTahunPajak());
        pst.setInt(20, obj.getIsCreditable());
        obj.setIsStatusExport(0);
        pst.setInt(21, obj.getIsStatusExport());
        pst.setString(22, obj.getReferensi());
        System.out.println(obj.getReferensi());
        pst.executeUpdate();
        Transaksi _tr = this.findByNomorFaktur(obj.getNomorFaktur());
        obj.setId(_tr.getId());
        pst.close();
    }

    public int getLastInsert() {
        return 0;
    }

    public TableModel tableModelTransaksi() {
        DefaultTableModel model = this.createModelTransaksi();
        String sql = "SELECT linkfaktur_id,kdJenisTransaksi as Kode,fgPengganti,nomorFaktur,tanggalFaktur,masa_pajak,tahun_pajak,namaPenjual,jumlahDpp  as jumlahDPP,jumlahPpn  as jumlahPpn,jumlahPpnBm  as jumlahPpnBm,is_kredit,status_export FROM tbl_transaksi";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("linkfaktur_id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String penjual = rs.getString("namaPenjual");
                String jmldpp = rs.getString("jumlahDPP");
                String jmlppn = rs.getString("jumlahPpn");
                String jmlppnbm = rs.getString("jumlahPpnBm");
                int kredit = rs.getInt("is_kredit");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                model.addRow(new Object[]{linkid, kode, statusFaktur, no, tglfaktur, masapajak, thnpajak, bool, penjual, jmldpp, jmlppn, jmlppnbm, status_export});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiStatusImportKosong() {
        DefaultTableModel model = this.createModelTransaksi();
        String sql = "SELECT linkfaktur_id,kdJenisTransaksi as Kode,fgPengganti,nomorFaktur,tanggalFaktur,masa_pajak,tahun_pajak,namaPenjual,CAST(jumlahDpp as decimal) as jumlahDPP,CAST(jumlahPpn as decimal) as jumlahPpn,CAST(jumlahPpnBm as decimal) as jumlahPpnBm,is_kredit,status_export FROM tbl_transaksi where status_export=0";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("linkfaktur_id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String penjual = rs.getString("namaPenjual");
                String jmldpp = rs.getString("jumlahDPP");
                String jmlppn = rs.getString("jumlahPpn");
                String jmlppnbm = rs.getString("jumlahPpnBm");
                int kredit = rs.getInt("is_kredit");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                model.addRow(new Object[]{linkid, kode, statusFaktur, no, tglfaktur, masapajak, thnpajak, bool, penjual, jmldpp, jmlppn, jmlppnbm, status_export});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksi(String nofaktur) {
        DefaultTableModel model = this.createModelTransaksi();
        String sql = "SELECT linkfaktur_id,kdJenisTransaksi as Kode,fgPengganti,nomorFaktur,tanggalFaktur,masa_pajak,tahun_pajak,namaPenjual,CAST(jumlahDpp as decimal) as jumlahDPP,CAST(jumlahPpn as decimal) as jumlahPpn,CAST(jumlahPpnBm as decimal) as jumlahPpnBm,is_kredit,status_export FROM tbl_transaksi WHERE nomorFaktur like '%" + nofaktur + "%'";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("linkfaktur_id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String penjual = rs.getString("namaPenjual");
                String jmldpp = rs.getString("jumlahDPP");
                String jmlppn = rs.getString("jumlahPpn");
                String jmlppnbm = rs.getString("jumlahPpnBm");
                int kredit = rs.getInt("is_kredit");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                model.addRow(new Object[]{linkid, kode, statusFaktur, no, tglfaktur, masapajak, thnpajak, bool, penjual, jmldpp, jmlppn, jmlppnbm, status_export});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableModelTransaksiTanggal(String awal, String akhir, String kodejenis, boolean sudah_export, boolean all) {
        DefaultTableModel model = this.createModelTransaksi();
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kode='" + kodejenis + "' ";
        }
        String sql = "SELECT linkfaktur_id,kdJenisTransaksi as Kode,fgPengganti,nomorFaktur,tanggalFaktur,masa_pajak,tahun_pajak,namaPenjual,CAST(jumlahDpp as decimal) as jumlahDPP,CAST(jumlahPpn as decimal) as jumlahPpn,CAST(jumlahPpnBm as decimal) as jumlahPpnBm,is_kredit,status_export FROM tbl_transaksi  WHERE  tanggalFaktur >= '" + awal + "' AND  tanggalFaktur <= '" + akhir + "' " + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        System.out.println("SQL " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("linkfaktur_id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String penjual = rs.getString("namaPenjual");
                String jmldpp = rs.getString("jumlahDPP");
                String jmlppn = rs.getString("jumlahPpn");
                String jmlppnbm = rs.getString("jumlahPpnBm");
                int kredit = rs.getInt("is_kredit");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = rs.getInt("status_export") == 1;
                model.addRow(new Object[]{linkid, kode, statusFaktur, no, tglfaktur, masapajak, thnpajak, bool, penjual, jmldpp, jmlppn, jmlppnbm, status_export});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public double getTotalKreditTgl(String awal, String akhir, String kodejenis, boolean sudah_export, boolean all) {
        double total = 0.0;
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total FROM tbl_transaksi  WHERE is_kredit=1  ";
        if (!awal.equalsIgnoreCase("") && !akhir.equalsIgnoreCase("")) {
            sql = sql + " AND tgl >= '" + awal + "' AND  tgl <= '" + akhir + "'";
        }
        sql = sql + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public double getTotalKreditTgl1(String awal, String akhir, String kodejenis, boolean sudah_export, boolean all) {
        double total = 0.0;
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total FROM tbl_transaksi WHERE is_kredit=0 ";
        if (!awal.equalsIgnoreCase("") && !akhir.equalsIgnoreCase("")) {
            sql = sql + " AND tgl >= '" + awal + "' AND  tgl <= '" + akhir + "'";
        }
        sql = sql + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public double getTotalKreditMasaPajak(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        double total = 0.0;
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total FROM tbl_transaksi where is_kredit=1  ";
        sql = sql + " AND masa_pajak = " + awalbulan + " AND tahun_pajak = " + awaltahun + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        System.out.println(sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public double getTotalKreditMasaPajak1(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        double total = 0.0;
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total  FROM tbl_transaksi where is_kredit=0 ";
        sql = sql + " AND masa_pajak = " + awalbulan + " AND tahun_pajak = " + awaltahun + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public double getTotalKreditNoFaktur(String nofaktur) {
        double total = 0.0;
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total FROM tbl_transaksi where is_kredit=1 AND nomorfaktur='" + nofaktur + "'";
        System.out.println(sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
            System.out.println(total);
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public double getTotalKreditNofaktur1(String nofaktur) {
        double total = 0.0;
        String sql = "SELECT CAST(sum(jumlahPpn) as decimal) as total  FROM tbl_transaksi where is_kredit=0 AND nomorfaktur = '" + nofaktur + "'";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                total = rs.getDouble("total");
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return total;
    }

    public ResultSet loadTransaksiAwal(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) throws SQLException {
        ResultSet rs = null;
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kode='" + kodejenis + "'";
        }
        String sql1 = "SELECT linkfaktur_id,kdJenisTransaksi as Kode,fgPengganti,nomorFaktur,tanggalFaktur,masa_pajak,tahun_pajak,namaPenjual,jumlahDpp  as jumlahDPP,jumlahPpn  as jumlahPpn,jumlahPpnBm  as jumlahPpnBm,is_kredit,status_export FROM tbl_transaksi ";
        String sql = "";
        sql = sql1 + " where masa_pajak = " + awalbulan + " and tahun_pajak = " + awaltahun;
        sql = sql + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        System.out.println(sql);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        rs = pst.executeQuery();
        return rs;
    }

    public List<Transaksi> loadTransaksiExport(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        ArrayList<Transaksi> ls = new ArrayList<Transaksi>();
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql1 = "SELECT * FROM tbl_transaksi ";
        String sql = "";
        sql = sql1 + " where masa_pajak = " + awalbulan + " AND tahun_pajak = " + awaltahun;
        sql = sql + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                Transaksi ts = new Transaksi();
                ts.setKode(rs.getString("kdJenisTransaksi"));
                ts.setNpwpPenjual(rs.getString("npwpPenjual"));
                ts.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
                ts.setAlamatPenjual(rs.getString("alamatPenjual"));
                ts.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
                ts.setNomorFaktur(rs.getString("nomorFaktur"));
                ts.setTglFaktur(rs.getString("tanggalFaktur"));
                ts.setMasaPajak(rs.getInt("masa_pajak"));
                ts.setTahunPajak(rs.getInt("tahun_pajak"));
                ts.setNamaPenjual(rs.getString("namaPenjual"));
                ts.setJumlahDPP(rs.getString("jumlahDpp"));
                ts.setJumlahPPN(rs.getString("jumlahPpn"));
                ts.setJumlanPPNBM(rs.getString("jumlahPpnBm"));
                ts.setIsCreditable(rs.getInt("is_kredit"));
                ts.setFgPengganti(rs.getString("fgPengganti"));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ItemTransaksi> loadTransaksiExportDetailFakturPm(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        ArrayList<ItemTransaksi> ls = new ArrayList<ItemTransaksi>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT b.referensi,a.nama, a.hargaSatuan, a.jumlahBarang, a.hargaTotal, a.diskon, ").append("a.dpp, a.ppn, a.tarifPpnbm, a.ppnbm, a.kodeBarang, ").append("b.kdJenisTransaksi, b.fgPengganti, b.nomorFaktur, b.tanggalFaktur, ").append("b.npwpPenjual, b.namaPenjual, b.alamatPenjual ").append("FROM tbl_transaksi_detail a ").append("INNER JOIN tbl_transaksi b ON a.transaksi_id = b.id ").append("WHERE b.masa_pajak = ").append(awalbulan).append(" AND b.tahun_pajak = ").append(awaltahun);
        if (!"00".equalsIgnoreCase(kodejenis)) {
            sql.append(" AND b.kdjenistransaksi = '").append(kodejenis).append("'");
        }
        if (!all) {
            if (sudah_export) {
                sql.append(" AND b.status_export = 1");
            } else {
                sql.append(" AND b.status_export = 0");
            }
        }
        sql.append(" ORDER BY b.masa_pajak");
        try (PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql.toString());
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                ItemTransaksi ts = new ItemTransaksi();
                ts.setKode(rs.getString("kdJenisTransaksi"));
                ts.setFakturPengganti(rs.getString("fgPengganti"));
                ts.setNomorFaktur(rs.getString("nomorFaktur"));
                ts.setNama(rs.getString("nama"));
                ts.setTglFaktur(rs.getString("tanggalFaktur"));
                ts.setNpwpPenjual(rs.getString("npwpPenjual"));
                ts.setNamaPenjual(rs.getString("namaPenjual"));
                ts.setAlamatPenjual(rs.getString("alamatPenjual"));
                ts.setHargaSatuan(rs.getString("hargaSatuan"));
                ts.setJumlahBarang(rs.getString("jumlahBarang"));
                ts.setHargaTotal(rs.getString("hargaTotal"));
                ts.setDiskon(rs.getString("diskon"));
                ts.setDpp(rs.getString("dpp"));
                ts.setPpn(rs.getString("ppn"));
                ts.setTarifPpnbm(rs.getString("tarifPpnbm"));
                ts.setPpnbm(rs.getString("ppnbm"));
                ts.setKodeBarang(rs.getString("kodeBarang"));
                ts.setNoinvoice(rs.getString("referensi"));
                ls.add(ts);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.dbkon.closeKoneksi();
        }
        return ls;
    }

    public List<ZItemTransaksi> loadTransaksiExportDetailFaktur(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        ArrayList<ZItemTransaksi> ls = new ArrayList<ZItemTransaksi>();
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND b.kdjenistransaksi='" + kodejenis + "'";
        }
        String sql1 = "SELECT a.nama, a.ppn, a.kodeBarang, a.hargaSatuan, a.jumlahBarang, a.hargaTotal, a.diskon, a.dpp, a.tarifPpnbm, a.ppnbm, b.kdJenisTransaksi, b.fgPengganti, b.nomorFaktur, b.tanggalFaktur, b.npwpPenjual, b.namaPenjual, b.namaLawanTransaksi, b.alamatLawanTransaksi, b.npwpLawanTransaksi, b.alamatPenjual, b.nomorInvoice FROM tbl2_transaksi_detail a INNER JOIN tbl2_transaksi b ON a.transaksi2_id = b.id ";
        sql1 = sql1 + " where masa_pajak = " + awalbulan + " AND tahun_pajak = " + awaltahun;
        sql1 = sql1 + sqljen;
        String str_export = " ";
        str_export = sudah_export ? " and status_export=1" : " and status_export is null";
        if (all) {
            str_export = " ";
        }
        sql1 = sql1 + str_export + " ORDER BY b.masa_pajak ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql1);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                ZItemTransaksi ts = new ZItemTransaksi();
                ts.setKode(rs.getString("kdJenisTransaksi"));
                ts.setFakturPengganti(rs.getString("fgPengganti"));
                ts.setNomorFaktur(rs.getString("nomorFaktur"));
                ts.setNoinvoice(rs.getString("nomorInvoice"));
                ts.setNama(rs.getString("nama"));
                ts.setTglFaktur(rs.getString("tanggalFaktur"));
                ts.setNpwpPenjual(rs.getString("npwpLawanTransaksi"));
                ts.setNamaPenjual(rs.getString("namaLawanTransaksi"));
                ts.setAlamatPenjual(rs.getString("alamatLawanTransaksi"));
                ts.setHargaSatuan(rs.getString("hargaSatuan"));
                ts.setJumlahBarang(rs.getString("jumlahBarang"));
                ts.setHargaTotal(rs.getString("hargaTotal"));
                ts.setDiskon(rs.getString("diskon"));
                ts.setDpp(rs.getString("dpp"));
                ts.setPpn(rs.getString("ppn"));
                ts.setTarifPpnbm(rs.getString("tarifPpnbm"));
                ts.setPpnbm(rs.getString("ppnbm"));
                ts.setKodeBarang(rs.getString("kodeBarang"));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public DefaultTableModel createModelTransaksi() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                switch (colIndex) {
                    case 7: {
                        return true;
                    }
                    case 12: {
                        return true;
                    }
                }
                return false;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                    case 7: {
                        return Boolean.class;
                    }
                    case 9: {
                        return Float.class;
                    }
                    case 10: {
                        return Float.class;
                    }
                    case 11: {
                        return Float.class;
                    }
                    case 12: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        model.setColumnIdentifiers(new String[]{"ID Link", "Kode", "Pengganti", "Nomor Faktur", "Tanggal Faktur", "Masa Pajak *", "Tahun Pajak *", "Dikreditkan *", "Nama Penjual", "Jumlah DPP", "Jumlah PPN", "Jumlah PPnBm", "Status Export"});
        return model;
    }

    public TableModel tableModelTransaksiTanggalAwal(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        DefaultTableModel model = this.createModelTransaksi();
        try {
            ResultSet rs = this.loadTransaksiAwal(awalbulan, awaltahun, kodejenis, sudah_export, all);
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("linkfaktur_id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String penjual = rs.getString("namaPenjual");
                String jmldpp = rs.getString("jumlahDPP");
                String jmlppn = rs.getString("jumlahPpn");
                String jmlppnbm = rs.getString("jumlahPpnBm");
                int kredit = rs.getInt("is_kredit");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                model.addRow(new Object[]{linkid, kode, statusFaktur, no, tglfaktur, masapajak, thnpajak, bool, penjual, jmldpp, jmlppn, jmlppnbm, status_export});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return model;
    }

    public void saveAllItem(int transid) throws SQLException {
        for (ItemTransaksi obj : this.itemList) {
            obj.setTransaksiId(transid);
            this.saveItem(obj);
        }
    }

    public void saveItem(ItemTransaksi obj) throws SQLException {
        String sql = "INSERT INTO tbl_transaksi_detail (nama,hargaSatuan,jumlahBarang,hargaTotal,diskon,dpp,ppn,tarifPpnbm,ppnbm,transaksi_id) VALUES (?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getNama());
        pst.setString(2, obj.getHargaSatuan());
        pst.setString(3, obj.getJumlahBarang());
        pst.setString(4, obj.getHargaTotal());
        pst.setString(5, obj.getDiskon());
        pst.setString(6, obj.getDpp());
        pst.setString(7, obj.getPpn());
        pst.setString(8, obj.getTarifPpnbm());
        pst.setString(9, obj.getPpnbm());
        pst.setInt(10, obj.getTransaksiId());
        pst.executeUpdate();
        pst.close();
    }

    public Transaksi findByNomorFakturs(String noinvoice) throws SQLException {
        Transaksi tr = null;
        String sql = "SELECT id, nomorFaktur FROM tbl_transaksi WHERE nomorFaktur = ? FETCH FIRST 1 ROWS ONLY";
        try (Connection conn = this.dbkon.getKoneksi();
             PreparedStatement pst = conn.prepareStatement(sql);){
            pst.setString(1, noinvoice);
            try (ResultSet rs = pst.executeQuery();){
                if (rs.next()) {
                    tr = new Transaksi();
                    tr.setId(rs.getInt("id"));
                    tr.setNomorFaktur(rs.getString("nomorFaktur"));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tr;
    }

    public Transaksi findByNomorFaktur(String nofaktur) throws SQLException {
        Transaksi tr = null;
        String sql = "SELECT * FROM tbl_transaksi  WHERE nomorFaktur=?";
        System.out.println(sql + " -- " + nofaktur);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, nofaktur);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new Transaksi();
            tr.setId(rs.getInt("id"));
            tr.setKode(rs.getString("kdJenisTransaksi"));
            tr.setFgPengganti(rs.getString("fgPengganti"));
            tr.setNomorFaktur(rs.getString("nomorFaktur"));
            tr.setTanggal(rs.getString("tanggalFaktur"));
            tr.setNpwpPenjual(rs.getString("npwpPenjual"));
            tr.setNamaPenjual(rs.getString("namaPenjual"));
            tr.setAlamatPenjual(rs.getString("alamatPenjual"));
            tr.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
            tr.setNamaLawan(rs.getString("namaLawanTransaksi"));
            tr.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
            tr.setJumlahDPP(rs.getString("jumlahDpp"));
            tr.setJumlahPPN(rs.getString("jumlahPpn"));
            tr.setStatusApproval(rs.getString("statusApproval"));
            tr.setStatusFaktur(rs.getString("statusFaktur"));
            tr.setLinkfakturId(rs.getInt("linkfaktur_id"));
            tr.setMasaPajak(rs.getInt("masa_pajak"));
            tr.setTahunPajak(rs.getInt("tahun_pajak"));
            tr.setIsCreditable(rs.getInt("is_kredit"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public TableModel tableModelTransaksiDetail(int trans_id) {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        model.setColumnIdentifiers(new String[]{"Id", "Nama", "Harga Satuan", "Jumlah Barang", "Harga Total", "Diskon", "DPP", "PPn", "Tarif PPnBm", "PPnBm"});
        String sql = "SELECT id,nama,hargaSatuan, jumlahBarang,hargaTotal,diskon, dpp,ppn,tarifPpnbm,ppnbm  FROM tbl_transaksi_detail WHERE transaksi_id=?  ORDER BY id";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, trans_id);
            ResultSet rs = pst.executeQuery();
            Object it = null;
            while (rs.next()) {
                int id = rs.getInt("id");
                String nama = rs.getString("nama");
                float hargasatuan = rs.getFloat("hargaSatuan");
                float jmlbarang = rs.getFloat("jumlahBarang");
                float total = rs.getFloat("hargaTotal");
                float diskon = rs.getFloat("diskon");
                float dpp = rs.getFloat("dpp");
                float ppn = rs.getFloat("ppn");
                float tarifppnbm = rs.getFloat("tarifPpnbm");
                float ppnbm = rs.getFloat("ppnbm");
                model.addRow(new Object[]{id, nama, Float.valueOf(hargasatuan), Float.valueOf(jmlbarang), Float.valueOf(total), Float.valueOf(diskon), Float.valueOf(dpp), Float.valueOf(ppn), Float.valueOf(tarifppnbm), Float.valueOf(ppnbm)});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public void updateMasaPajak(Transaksi obj) throws SQLException {
        String sql = "UPDATE tbl_transaksi SET masa_pajak=?, tahun_pajak=? , is_kredit=? WHERE  nomorFaktur=? AND fgPengganti=? ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, obj.getMasaPajak());
        pst.setInt(2, obj.getTahunPajak());
        pst.setInt(3, obj.getIsCreditable());
        pst.setString(4, obj.getNomorFaktur());
        pst.setString(5, obj.getFgPengganti());
        if (obj.isValidUpdate()) {
            pst.executeUpdate();
        }
        pst.close();
    }

    public void updateMasaPajakMassal(Transaksi obj) throws SQLException {
        String sql = "UPDATE tbl_transaksi SET masa_pajak=?, tahun_pajak=? , is_kredit=? WHERE fgPengganti=? AND nomorFaktur=?  ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, obj.getMasaPajak());
        pst.setInt(2, obj.getTahunPajak());
        pst.setInt(3, obj.getIsCreditable());
        pst.setString(4, obj.getFgPengganti());
        pst.setString(5, obj.getNomorFaktur());
        if (obj.isValidUpdate()) {
            pst.executeUpdate();
        }
        pst.close();
    }

    public void updateMasaPajakMassalPengganti(Transaksi obj) throws SQLException {
        String sql = "UPDATE tbl_transaksi SET masa_pajak=?, tahun_pajak=? , is_kredit=? WHERE fgPengganti=? AND nomorFaktur=?  ";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, obj.getMasaPajak());
        pst.setInt(2, obj.getTahunPajak());
        pst.setInt(3, obj.getIsCreditable());
        pst.setString(4, obj.getFgPengganti());
        pst.setString(5, obj.getNomorFaktur());
        System.out.println(obj.getFgPengganti() + " " + obj.getNomorFaktur());
        pst.executeUpdate();
        pst.close();
    }

    public DefaultComboBoxModel getJenisFaktur() {
        DefaultComboBoxModel<JenisFaktur> model = new DefaultComboBoxModel<JenisFaktur>();
        String sql = "SELECT * FROM tbl_jenis_efaktur ORDER BY kode";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            JenisFaktur item = null;
            while (rs.next()) {
                item = new JenisFaktur();
                item.setKode(rs.getString("kode"));
                item.setNama(rs.getString("nama"));
                model.addElement(item);
            }
        }
        catch (SQLException ee) {
            ee.printStackTrace();
        }
        return model;
    }

    public void updateMasaPajakKredit(TableModel model) {
        for (int row = 0; row < model.getRowCount(); ++row) {
            System.out.println(model.getValueAt(row, 4));
            String _nofaktur = model.getValueAt(row, 3).toString();
            String _fgpengganti = model.getValueAt(row, 2).toString();
            int _mp = Integer.parseInt(model.getValueAt(row, 5).toString());
            int _thn = Integer.parseInt(model.getValueAt(row, 6).toString());
            boolean bool = (Boolean)model.getValueAt(row, 7);
            boolean bool1 = (Boolean)model.getValueAt(row, 12);
            this.updateTransaksi(_fgpengganti, _nofaktur, _mp, _thn, bool, bool1);
            System.out.println();
        }
    }

    public void updateTransaksi(String pengganti, String nofaktur, int mp, int thn, boolean kredit, boolean status_export) {
        String sql = "UPDATE tbl_transaksi SET masa_pajak=?,tahun_pajak=?,is_kredit=?,status_export=?  WHERE nomorfaktur=? AND fgPengganti=? ";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, mp);
            pst.setInt(2, thn);
            int _kredit = kredit ? 1 : 0;
            pst.setInt(3, _kredit);
            int _statusexport = status_export ? 1 : 0;
            pst.setInt(4, _statusexport);
            pst.setString(5, nofaktur);
            pst.setString(6, pengganti);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException ee) {
            ee.printStackTrace();
        }
    }

    public int getJumlahDataCsv() throws SQLException {
        int jumlah = 0;
        String sql = " Select count(id) as jumlah from tbl_transaksi ";
        PreparedStatement ps = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            jumlah = rs.getInt("jumlah");
        }
        rs.close();
        ps.close();
        this.dbkon.closeKoneksi();
        return jumlah;
    }

    public void updateTransaksiSudahExport(String str) throws SQLException {
        String sql = "UPDATE tbl_transaksi SET status_export=1  WHERE fgpengganti || nomorFaktur IN (" + str + ")";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.executeUpdate();
        pst.close();
        this.dbkon.closeKoneksi();
    }

    public void deleteDetailTransaksi(int transaksiid) {
        String sql = "DELETE FROM tbl_transaksi_detail WHERE transaksi_id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, transaksiid);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteTransaksi(int id) {
        String sql = "DELETE FROM tbl_transaksi WHERE id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, id);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteLink(int id) {
        String sql = "DELETE FROM tbl_linkfaktur WHERE id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, id);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteTransaksiliLink(Transaksi obj) {
        this.deleteDetailTransaksi(obj.getId());
        this.deleteTransaksi(obj.getId());
        this.deleteLink(obj.getLinkfakturId());
    }

    public void deleteTransaksiArray(String str) {
        String[] ar;
        for (String x : ar = str.split(",")) {
            try {
                Transaksi tr = this.findByNomorFakturNormal(x.trim());
                System.out.println(tr);
                this.deleteTransaksiliLink(tr);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public int findTransaksiId(String nomor) throws SQLException {
        String sql = "SELECT id FROM tbl_transaksi  WHERE fgPengganti || nomorFaktur=? ";
        int id = 0;
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, nomor);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            id = rs.getInt("id");
        }
        rs.close();
        pst.close();
        return id;
    }

    public Transaksi findNomorFakturNormal(String nofaktur) throws SQLException {
        Transaksi tr = null;
        String sql = "SELECT * FROM tbl_transaksi  WHERE nomorFaktur=? AND fgPengganti=0 ";
        System.out.println(sql + " -- " + nofaktur);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, nofaktur);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new Transaksi();
            tr.setId(rs.getInt("id"));
            tr.setKode(rs.getString("kdJenisTransaksi"));
            tr.setFgPengganti(rs.getString("fgPengganti"));
            tr.setNomorFaktur(rs.getString("nomorFaktur"));
            tr.setTanggal(rs.getString("tanggalFaktur"));
            tr.setNpwpPenjual(rs.getString("npwpPenjual"));
            tr.setNamaPenjual(rs.getString("namaPenjual"));
            tr.setAlamatPenjual(rs.getString("alamatPenjual"));
            tr.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
            tr.setNamaLawan(rs.getString("namaLawanTransaksi"));
            tr.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
            tr.setJumlahDPP(rs.getString("jumlahDpp"));
            tr.setJumlahPPN(rs.getString("jumlahPpn"));
            tr.setStatusApproval(rs.getString("statusApproval"));
            tr.setStatusFaktur(rs.getString("statusFaktur"));
            tr.setLinkfakturId(rs.getInt("linkfaktur_id"));
            tr.setMasaPajak(rs.getInt("masa_pajak"));
            tr.setTahunPajak(rs.getInt("tahun_pajak"));
            tr.setIsCreditable(rs.getInt("is_kredit"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public Transaksi findNomorFakturPenggantiDouble(String nofaktur) throws SQLException {
        Transaksi tr = null;
        String sql = "SELECT * FROM tbl_transaksi  WHERE nomorFaktur=? AND fgPengganti=1 ";
        System.out.println(sql + " -- " + nofaktur);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, nofaktur);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new Transaksi();
            tr.setId(rs.getInt("id"));
            tr.setKode(rs.getString("kdJenisTransaksi"));
            tr.setFgPengganti(rs.getString("fgPengganti"));
            tr.setNomorFaktur(rs.getString("nomorFaktur"));
            tr.setTanggal(rs.getString("tanggalFaktur"));
            tr.setNpwpPenjual(rs.getString("npwpPenjual"));
            tr.setNamaPenjual(rs.getString("namaPenjual"));
            tr.setAlamatPenjual(rs.getString("alamatPenjual"));
            tr.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
            tr.setNamaLawan(rs.getString("namaLawanTransaksi"));
            tr.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
            tr.setJumlahDPP(rs.getString("jumlahDpp"));
            tr.setJumlahPPN(rs.getString("jumlahPpn"));
            tr.setStatusApproval(rs.getString("statusApproval"));
            tr.setStatusFaktur(rs.getString("statusFaktur"));
            tr.setLinkfakturId(rs.getInt("linkfaktur_id"));
            tr.setMasaPajak(rs.getInt("masa_pajak"));
            tr.setTahunPajak(rs.getInt("tahun_pajak"));
            tr.setIsCreditable(rs.getInt("is_kredit"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public Transaksi findByNomorFakturFgPengganti(String fgpengganti, String nofaktur) throws SQLException {
        Transaksi tr = null;
        String sql = "SELECT * FROM tbl_transaksi  WHERE fgPengganti=? AND nomorFaktur=? ";
        System.out.println(sql + " -- " + nofaktur);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, fgpengganti);
        pst.setString(2, nofaktur);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new Transaksi();
            tr.setId(rs.getInt("id"));
            tr.setKode(rs.getString("kdJenisTransaksi"));
            tr.setFgPengganti(rs.getString("fgPengganti"));
            tr.setNomorFaktur(rs.getString("nomorFaktur"));
            tr.setTanggal(rs.getString("tanggalFaktur"));
            tr.setNpwpPenjual(rs.getString("npwpPenjual"));
            tr.setNamaPenjual(rs.getString("namaPenjual"));
            tr.setAlamatPenjual(rs.getString("alamatPenjual"));
            tr.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
            tr.setNamaLawan(rs.getString("namaLawanTransaksi"));
            tr.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
            tr.setJumlahDPP(rs.getString("jumlahDpp"));
            tr.setJumlahPPN(rs.getString("jumlahPpn"));
            tr.setStatusApproval(rs.getString("statusApproval"));
            tr.setStatusFaktur(rs.getString("statusFaktur"));
            tr.setLinkfakturId(rs.getInt("linkfaktur_id"));
            tr.setMasaPajak(rs.getInt("masa_pajak"));
            tr.setTahunPajak(rs.getInt("tahun_pajak"));
            tr.setIsCreditable(rs.getInt("is_kredit"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public Transaksi findByNomorFakturNormal(String nofaktur) throws SQLException {
        Transaksi tr = null;
        String sql = "SELECT * FROM tbl_transaksi  WHERE fgPengganti || nomorFaktur=? ";
        System.out.println(sql + " -- " + nofaktur);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, nofaktur);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            tr = new Transaksi();
            tr.setId(rs.getInt("id"));
            tr.setKode(rs.getString("kdJenisTransaksi"));
            tr.setFgPengganti(rs.getString("fgPengganti"));
            tr.setNomorFaktur(rs.getString("nomorFaktur"));
            tr.setTanggal(rs.getString("tanggalFaktur"));
            tr.setNpwpPenjual(rs.getString("npwpPenjual"));
            tr.setNamaPenjual(rs.getString("namaPenjual"));
            tr.setAlamatPenjual(rs.getString("alamatPenjual"));
            tr.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
            tr.setNamaLawan(rs.getString("namaLawanTransaksi"));
            tr.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
            tr.setJumlahDPP(rs.getString("jumlahDpp"));
            tr.setJumlahPPN(rs.getString("jumlahPpn"));
            tr.setStatusApproval(rs.getString("statusApproval"));
            tr.setStatusFaktur(rs.getString("statusFaktur"));
            tr.setLinkfakturId(rs.getInt("linkfaktur_id"));
            tr.setMasaPajak(rs.getInt("masa_pajak"));
            tr.setTahunPajak(rs.getInt("tahun_pajak"));
            tr.setIsCreditable(rs.getInt("is_kredit"));
        }
        rs.close();
        pst.close();
        return tr;
    }

    public List<Transaksi> loadTransaksiExportXLS(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        ArrayList<Transaksi> ls = new ArrayList<Transaksi>();
        String sqljen = "";
        if (!kodejenis.equalsIgnoreCase("00")) {
            sqljen = " AND kdjenistransaksi='" + kodejenis + "'";
        }
        String sql1 = "SELECT * FROM tbl_transaksi ";
        String sql = "";
        sql = sql1 + " where masa_pajak = " + awalbulan + " AND tahun_pajak = " + awaltahun;
        sql = sql + sqljen;
        String str_export = "";
        str_export = sudah_export ? " and status_export=1" : " and status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                Transaksi ts = new Transaksi();
                ts.setKode(rs.getString("kdJenisTransaksi"));
                ts.setNpwpPenjual(rs.getString("npwpPenjual"));
                ts.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
                ts.setAlamatPenjual(rs.getString("alamatPenjual"));
                ts.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
                ts.setNomorFaktur(rs.getString("nomorFaktur"));
                ts.setTglFaktur(rs.getString("tanggalFaktur"));
                ts.setMasaPajak(rs.getInt("masa_pajak"));
                ts.setTahunPajak(rs.getInt("tahun_pajak"));
                ts.setNamaPenjual(rs.getString("namaPenjual"));
                ts.setJumlahDPP(rs.getString("jumlahDpp"));
                ts.setJumlahPPN(rs.getString("jumlahPpn"));
                ts.setJumlanPPNBM(rs.getString("jumlahPpnBm"));
                ts.setIsCreditable(rs.getInt("is_kredit"));
                ts.setFgPengganti(rs.getString("fgPengganti"));
                ts.setStatusFaktur(rs.getString("statusFaktur"));
                ts.setReferensi(rs.getString("referensi"));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public List<TransaksiBupot> loadTransaksiExportXLSBupotJenis(String data, int jenis) {
        String sql = "";
        ArrayList<TransaksiBupot> ls = new ArrayList<TransaksiBupot>();
        if (jenis == 5) {
            sql = "SELECT * FROM tbl3_transaksibupot where namaPemotong LIKE '%" + data + "%'  order by id desc";
        } else if (jenis == 6) {
            sql = "SELECT * FROM tbl3_transaksibupot where jenisPajak='" + data + "'  order by id desc";
        } else if (jenis == 7) {
            sql = "SELECT * FROM tbl3_transaksibupot where noBupot LIKE '%" + data + "%'  order by id desc";
        } else {
            String masaPajak = "";
            masaPajak = Integer.valueOf(data) < 10 ? "0" + data + "-" + jenis : data + "-" + jenis;
            sql = "SELECT * FROM tbl3_transaksibupot where masaBupot='" + masaPajak + "'  order by id desc";
        }
        System.out.println("sqlll di export " + sql);
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                TransaksiBupot ts = new TransaksiBupot();
                ts.setId(rs.getInt("id"));
                ts.setNoBupot(rs.getString("noBupot"));
                ts.setMasaBupot(rs.getString("masaBupot"));
                ts.setSifat(rs.getString("sifat"));
                ts.setJenisBukti(rs.getString("jenisBukti"));
                ts.setJenisFasilitas(rs.getString("jenisFasilitas"));
                ts.setJenisPajak(rs.getString("jenisPajak"));
                ts.setKodeObjekPajak(rs.getString("kodeObjekPajak"));
                ts.setObjekPajak(rs.getString("objekPajak"));
                ts.setDpp(Double.valueOf(rs.getString("dpp")));
                ts.setTarif(Double.valueOf(rs.getString("tarif")));
                ts.setPajak(Double.valueOf(rs.getString("pajak")));
                ts.setJenisDokumen(rs.getString("jenisDokumen"));
                ts.setTglDokumen(rs.getString("tglDokumen"));
                ts.setNoDokumen(rs.getString("noDokumen"));
                ts.setNpwpPemotong(rs.getString("npwpPemotong"));
                ts.setNitkuPemotong(rs.getString("nitkuPemotong"));
                ts.setNamaPemotong(rs.getString("namaPemotong"));
                ts.setTglPemotongan(rs.getString("tglPemotongan"));
                ts.setNpwpDipotong(rs.getString("npwpDipotong"));
                ts.setNitkuDipotong(rs.getString("nitkuDipotong"));
                ts.setNamaDipotong(rs.getString("namaDipotong"));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public List<TransaksiBupot> loadTransaksiExportXLSBupotJenis2(String data, int jenis) {
        String sql = "";
        ArrayList<TransaksiBupot> ls = new ArrayList<TransaksiBupot>();
        if (jenis == 5) {
            sql = "SELECT * FROM tbl3_transaksibupot2 where namaDipotong LIKE '%" + data + "%'   order by id desc";
        } else if (jenis == 6) {
            sql = "SELECT * FROM tbl3_transaksibupot2 where jenisPajak='" + data + "'  order by id desc";
        } else if (jenis == 7) {
            sql = "SELECT * FROM tbl3_transaksibupot2 where noBupot LIKE '%" + data + "%'  order by id desc";
        } else {
            String masaPajak = "";
            masaPajak = Integer.valueOf(data) < 10 ? "0" + data + "-" + jenis : data + "-" + jenis;
            sql = "SELECT * FROM tbl3_transaksibupot2 where masaBupot='" + masaPajak + "'  order by id desc";
        }
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                TransaksiBupot ts = new TransaksiBupot();
                ts.setId(rs.getInt("id"));
                ts.setNoBupot(rs.getString("noBupot"));
                ts.setMasaBupot(rs.getString("masaBupot"));
                ts.setSifat(rs.getString("sifat"));
                ts.setJenisBukti(rs.getString("jenisBukti"));
                ts.setJenisFasilitas(rs.getString("jenisFasilitas"));
                ts.setJenisPajak(rs.getString("jenisPajak"));
                ts.setKodeObjekPajak(rs.getString("kodeObjekPajak"));
                ts.setObjekPajak(rs.getString("objekPajak"));
                ts.setDpp(Double.valueOf(rs.getString("dpp")));
                ts.setTarif(Double.valueOf(rs.getString("tarif")));
                ts.setPajak(Double.valueOf(rs.getString("pajak")));
                ts.setJenisDokumen(rs.getString("jenisDokumen"));
                ts.setTglDokumen(rs.getString("tglDokumen"));
                ts.setNoDokumen(rs.getString("noDokumen"));
                ts.setNpwpPemotong(rs.getString("npwpPemotong"));
                ts.setNitkuPemotong(rs.getString("nitkuPemotong"));
                ts.setNamaPemotong(rs.getString("namaPemotong"));
                ts.setTglPemotongan(rs.getString("tglPemotongan"));
                ts.setNpwpDipotong(rs.getString("npwpDipotong"));
                ts.setNitkuDipotong(rs.getString("nitkuDipotong"));
                ts.setNamaDipotong(rs.getString("namaDipotong"));
                ts.setEmail(rs.getString("email"));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    public List<TransaksiBupot> loadTransaksiExportXLSBupot(int bulan, int tahun, String kodejenis, boolean sudah_export, boolean all) {
        ArrayList<TransaksiBupot> ls = new ArrayList<TransaksiBupot>();
        String masaPajak = "";
        masaPajak = bulan < 10 ? "0" + bulan + "-" + tahun : bulan + "-" + tahun;
        String sql = "SELECT * FROM tbl3_transaksibupot where masaBupot='" + masaPajak + "'  order by id desc";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                TransaksiBupot ts = new TransaksiBupot();
                ts.setId(rs.getInt("id"));
                ts.setNoBupot(rs.getString("noBupot"));
                ts.setMasaBupot(rs.getString("masaBupot"));
                ts.setSifat(rs.getString("sifat"));
                ts.setJenisBukti(rs.getString("jenisBukti"));
                ts.setJenisFasilitas(rs.getString("jenisFasilitas"));
                ts.setJenisPajak(rs.getString("jenisPajak"));
                ts.setKodeObjekPajak(rs.getString("kodeObjekPajak"));
                ts.setObjekPajak(rs.getString("objekPajak"));
                ts.setDpp(Double.valueOf(rs.getString("dpp")));
                ts.setTarif(Double.valueOf(rs.getString("tarif")));
                ts.setPajak(Double.valueOf(rs.getString("pajak")));
                ts.setJenisDokumen(rs.getString("jenisDokumen"));
                ts.setTglDokumen(rs.getString("tglDokumen"));
                ts.setNoDokumen(rs.getString("noDokumen"));
                ts.setNpwpPemotong(rs.getString("npwpPemotong"));
                ts.setNitkuPemotong(rs.getString("nitkuPemotong"));
                ts.setNamaPemotong(rs.getString("namaPemotong"));
                ts.setTglPemotongan(rs.getString("tglPemotongan"));
                ts.setNpwpDipotong(rs.getString("npwpDipotong"));
                ts.setNitkuDipotong(rs.getString("nitkuDipotong"));
                ts.setNamaDipotong(rs.getString("namaDipotong"));
                ls.add(ts);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbkon.closeKoneksi();
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZTransaksi> loadTransaksiExportXLSout(int awalbulan, int awaltahun, String kodejenis, boolean sudah_export, boolean all) {
        ArrayList<ZTransaksi> ls = new ArrayList<ZTransaksi>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append("a.id, a.kdJenisTransaksi, a.npwpPenjual, a.npwpLawanTransaksi, ").append("a.alamatPenjual, a.alamatLawanTransaksi, a.namaLawanTransaksi, ").append("a.nomorFaktur, a.tanggalFaktur, a.masa_pajak, a.tahun_pajak, ").append("a.namaPenjual, a.is_kredit, a.fgPengganti, a.statusFaktur, a.nomorInvoice, ").append("SUM(b.dpp) AS jumlahDppsum, SUM(b.ppn) AS jumlahPpnsum, SUM(b.ppnbm) AS jumlahPpnBmsum ").append("FROM tbl2_transaksi a ").append("LEFT JOIN tbl2_transaksi_detail b ON a.id = b.transaksi2_id ").append("WHERE a.masa_pajak = ? AND a.tahun_pajak = ?");
        if (!"00".equalsIgnoreCase(kodejenis)) {
            sql.append(" AND a.kdjenistransaksi = ?");
        }
        if (!all) {
            if (sudah_export) {
                sql.append(" AND a.status_export = 1");
            } else {
                sql.append(" AND a.status_export IS NULL");
            }
        }
        sql.append(" GROUP BY ").append("a.id, a.kdJenisTransaksi, a.npwpPenjual, a.npwpLawanTransaksi, ").append("a.alamatPenjual, a.alamatLawanTransaksi, a.namaLawanTransaksi, ").append("a.nomorFaktur, a.tanggalFaktur, a.masa_pajak, a.tahun_pajak, ").append("a.namaPenjual, a.is_kredit, a.fgPengganti, a.statusFaktur, a.nomorInvoice");
        try (PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql.toString());){
            int paramIndex = 1;
            pst.setInt(paramIndex++, awalbulan);
            pst.setInt(paramIndex++, awaltahun);
            if (!"00".equalsIgnoreCase(kodejenis)) {
                pst.setString(paramIndex++, kodejenis);
            }
            try (ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    ZTransaksi ts = new ZTransaksi();
                    ts.setKode(rs.getString("kdJenisTransaksi"));
                    ts.setNpwpPenjual(rs.getString("npwpPenjual"));
                    ts.setNpwpLawan(rs.getString("npwpLawanTransaksi"));
                    ts.setAlamatPenjual(rs.getString("alamatPenjual"));
                    ts.setAlamatLawan(rs.getString("alamatLawanTransaksi"));
                    ts.setNamaLawan(rs.getString("namaLawanTransaksi"));
                    ts.setNomorFaktur(rs.getString("nomorFaktur"));
                    ts.setTglFaktur(rs.getString("tanggalFaktur"));
                    ts.setMasaPajak(rs.getInt("masa_pajak"));
                    ts.setTahunPajak(rs.getInt("tahun_pajak"));
                    ts.setNamaPenjual(rs.getString("namaPenjual"));
                    ts.setJumlahDPP(rs.getString("jumlahDppsum"));
                    ts.setJumlahPPN(rs.getString("jumlahPpnsum"));
                    ts.setJumlanPPNBM(rs.getString("jumlahPpnBmsum"));
                    ts.setIsCreditable(rs.getInt("is_kredit"));
                    ts.setFgPengganti(rs.getString("fgPengganti"));
                    ts.setStatusFaktur(rs.getString("statusFaktur"));
                    ts.setReferensi(rs.getString("nomorInvoice"));
                    ls.add(ts);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.dbkon.closeKoneksi();
        }
        return ls;
    }

    public ResultSet loadTransaksiAllCSV(boolean sudah_export, boolean all) throws SQLException {
        ResultSet rs = null;
        String sql = "SELECT linkfaktur_id,kdJenisTransaksi as Kode,fgPengganti,nomorFaktur,tanggalFaktur,masa_pajak,tahun_pajak,namaPenjual,CAST(jumlahDpp as decimal) as jumlahDPP,CAST(jumlahPpn as decimal) as jumlahPpn,CAST(jumlahPpnBm as decimal) as jumlahPpnBm,is_kredit,status_export FROM tbl_transaksi ";
        String str_export = "";
        str_export = sudah_export ? " where status_export=1" : " where status_export=0";
        if (all) {
            str_export = "";
        }
        sql = sql + str_export;
        System.out.println(sql);
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        rs = pst.executeQuery();
        return rs;
    }

    public TableModel tableModelTransaksiAllCSV(boolean sudah_export, boolean all) {
        DefaultTableModel model = this.createModelTransaksi();
        try {
            ResultSet rs = this.loadTransaksiAllCSV(sudah_export, all);
            Object t = null;
            while (rs.next()) {
                int linkid = rs.getInt("linkfaktur_id");
                String kode = rs.getString("kode");
                String statusFaktur = rs.getString("fgPengganti");
                String no = rs.getString("nomorFaktur");
                String tglfaktur = rs.getString("tanggalFaktur");
                String masapajak = rs.getString("masa_pajak");
                String thnpajak = rs.getString("tahun_pajak");
                String penjual = rs.getString("namaPenjual");
                String jmldpp = rs.getString("jumlahDPP");
                String jmlppn = rs.getString("jumlahPpn");
                String jmlppnbm = rs.getString("jumlahPpnBm");
                int kredit = rs.getInt("is_kredit");
                Boolean bool = false;
                bool = kredit == 1;
                Boolean status_export = false;
                status_export = rs.getInt("status_export") == 1;
                model.addRow(new Object[]{linkid, kode, statusFaktur, no, tglfaktur, masapajak, thnpajak, bool, penjual, jmldpp, jmlppn, jmlppnbm, status_export});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return model;
    }

    public int getJumlahDataTransaksi() throws SQLException {
        int jumlah = 0;
        String sql = " Select count(id) as jumlah from tbl_transaksi ";
        PreparedStatement ps = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            jumlah = rs.getInt("jumlah");
        }
        rs.close();
        ps.close();
        this.dbkon.closeKoneksi();
        return jumlah;
    }
}

