/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.model;

import db.DBKoneksi;
import esindo.net.model.LinkFaktur;
import esindo.net.model.LinkFakturError;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DAOLinkFaktur {
    DBKoneksi dbkon = new DBKoneksi();

    public void save(LinkFaktur obj) throws SQLException {
        String sql = "INSERT INTO tbl_linkfaktur (link,tgl_input,status) VALUES (?,current_date,0)";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getLink());
        pst.executeUpdate();
        pst.close();
    }

    public TableModel tableModel(boolean sudah_download) {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        model.setColumnIdentifiers(new String[]{"ID", "Link", "Tanggal Input"});
        String sql = "SELECT * FROM tbl_linkfaktur ";
        sql = sudah_download ? sql + " WHERE id IN (SELECT linkfaktur_id FROM tbl_transaksi)" : sql + " WHERE id NOT IN (SELECT linkfaktur_id FROM tbl_transaksi)";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object lk = null;
            String tgl = "";
            while (rs.next()) {
                int id = rs.getInt("id");
                String link = rs.getString("link");
                tgl = rs.getString("tgl_input");
                model.addRow(new Object[]{id, link, tgl});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public void delete(int id) {
        String sql = "DELETE FROM tbl_linkfaktur WHERE id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, id);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update_status(int id, int status) {
        String sql = "UPDATE FROM tbl_linkfaktur SET status=? WHERE id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, status);
            pst.setInt(2, id);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void deleteStatusTidakValid() {
        String sql = "DELETE FROM tbl_linkfaktur WHERE status=2";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(String idin) {
        String sql = "DELETE FROM tbl_linkfaktur WHERE id in (" + idin + ")";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public TableModel tableModelURL(String url) {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        model.setColumnIdentifiers(new String[]{"ID", "Link", "Tanggal Input"});
        String sql = "SELECT * FROM tbl_linkfaktur Where link like '%" + url + "%' AND id IN (SELECT linkfaktur_id FROM tbl_transaksi)";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object lk = null;
            String tgl = "";
            while (rs.next()) {
                int id = rs.getInt("id");
                String link = rs.getString("link");
                tgl = rs.getString("tgl_input");
                model.addRow(new Object[]{id, link, tgl});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public void saveError(LinkFakturError obj) throws SQLException {
        String sql = "INSERT INTO tbl_linkerrordownload(link_id,link,status_error,tgl_input) VALUES (?,?,?,current_date)";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setInt(1, obj.getLinkId());
        pst.setString(2, obj.getLink());
        pst.setString(3, obj.getStatuserror());
        pst.executeUpdate();
        pst.close();
    }

    public TableModel tableModelError() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        model.setColumnIdentifiers(new String[]{"ID", "ID Link", "Link", "Status Error", "Tanggal Input"});
        String sql = "SELECT id,link_id,link,status_error,tgl_input FROM tbl_linkerrordownload";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object lk = null;
            String tgl = "";
            while (rs.next()) {
                int iderror = rs.getInt("id");
                int id = rs.getInt("link_id");
                String link = rs.getString("link");
                String status = rs.getString("status_error");
                tgl = rs.getString("tgl_input");
                model.addRow(new Object[]{iderror, id, link, status, tgl});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public LinkFaktur findByUrl(String url) throws SQLException {
        LinkFaktur lf = null;
        String sql = "SELECT * FROM tbl_linkfaktur  WHERE link=?";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, url);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            lf = new LinkFaktur();
            lf.setId(rs.getInt("id"));
            lf.setLink(rs.getString("link"));
            lf.setTglInput(rs.getString("tgl_input"));
            lf.setStatus(rs.getInt("status"));
        }
        rs.close();
        pst.close();
        return lf;
    }

    public void deleteError(int id) {
        String sql = "DELETE FROM tbl_linkerrordownload WHERE id=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setInt(1, id);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteError(String idin) {
        String sql = "DELETE FROM tbl_linkerrordownload WHERE id in (" + idin + ")";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

