/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.model;

import com.opencsv.CSVReader;
import db.DBKoneksi;
import esindo.net.model.LawanTransaksi;
import esindo.net.model.Proxy;
import java.io.FileReader;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DAOLawanTransaksi {
    DBKoneksi dbkon = new DBKoneksi();

    public TableModel tableModelLawanTR() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        model.setColumnIdentifiers(new String[]{"NPWP", "Nama", "Alamat", "Email", "Kontak", "Telepon"});
        String sql = "SELECT npwp,nama,coalesce(jalan,'-') || ' ' || ' blok ' ||  coalesce(blok,'-') || ' ' || coalesce(nomor,'-')  || ' RT/RW ' || coalesce(rt,'-') || '/' ||  coalesce(rw,'-') || ' ' || coalesce(kelurahan,'-') as alamat,email,kontak,telpon FROM tbl_lawan_transaksi";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            Object lt = null;
            while (rs.next()) {
                String npwp = rs.getString("npwp");
                String nama = rs.getString("nama");
                String alamat = rs.getString("alamat");
                String email = rs.getString("email");
                String kontak = rs.getString("kontak");
                String telepon = rs.getString("telpon");
                model.addRow(new Object[]{npwp, nama, alamat, email, kontak, telepon});
            }
        }
        catch (SQLException e) {
            System.out.println("ERROR " + sql);
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableFromImport(String stfile) {
        DefaultTableModel model = new DefaultTableModel(){
            Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        Object[] judul = new String[]{"No", "NPWP", "Lawan Transaksi", "JALAN", "BLOK", "NOMOR", "RT", "RW", "KECAMATAN", "KELURAHAN", "KABUPATEN", "PROPINSI", "KODEPOS", "TELPON"};
        model.setColumnIdentifiers(judul);
        try {
            String[] nextLine;
            CSVReader reader = new CSVReader((Reader)new FileReader(stfile));
            int counter = 0;
            while ((nextLine = reader.readNext()) != null) {
                if (counter > 0) {
                    Object[] isi = new Object[]{String.valueOf(counter), nextLine[1], nextLine[2], nextLine[3], nextLine[4], nextLine[5], nextLine[6], nextLine[7], nextLine[8], nextLine[9], nextLine[10], nextLine[11], nextLine[12], nextLine[13]};
                    model.addRow(isi);
                }
                ++counter;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public TableModel tableKosong() {
        DefaultTableModel model = new DefaultTableModel(){
            Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        Object[] judul = new String[]{"No", "NPWP", "Lawan Transaksi", "JALAN", "BLOK", "NOMOR", "RT", "RW", "KECAMATAN", "KELURAHAN", "KABUPATEN", "PROPINSI", "KODEPOS", "TELPON"};
        model.setColumnIdentifiers(judul);
        return model;
    }

    public void simpanDataImport(TableModel model) {
        LawanTransaksi obj = null;
        for (int i = 0; i < model.getRowCount(); ++i) {
            System.out.println(model.getValueAt(i, 1));
            obj = this.findByPK(model.getValueAt(i, 1).toString());
            System.out.println(obj);
            if (obj != null) continue;
            obj = new LawanTransaksi();
            obj.setNpwp(model.getValueAt(i, 1).toString());
            obj.setNama(model.getValueAt(i, 2).toString());
            obj.setJalan(model.getValueAt(i, 3).toString());
            obj.setBlok(model.getValueAt(i, 4).toString());
            obj.setNomor(model.getValueAt(i, 5).toString());
            obj.setRt(model.getValueAt(i, 6).toString());
            obj.setRw(model.getValueAt(i, 7).toString());
            obj.setKecamatan(model.getValueAt(i, 8).toString());
            obj.setKelurahan(model.getValueAt(i, 9).toString());
            obj.setKabupaten(model.getValueAt(i, 10).toString());
            obj.setPropinsi(model.getValueAt(i, 11).toString());
            obj.setKodepos(model.getValueAt(i, 12).toString());
            obj.setTelpon(model.getValueAt(i, 13).toString());
            obj.setKontak("-");
            obj.setEmail("-");
            System.out.println("NPWP BARU " + obj.getNpwp());
            try {
                this.save(obj);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public LawanTransaksi findByPK(String pk) {
        LawanTransaksi obj = null;
        String sql = "SELECT * FROM tbl_lawan_transaksi WHERE npwp=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setString(1, pk);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                obj = new LawanTransaksi();
                obj.setNpwp(rs.getString("npwp"));
                obj.setNama(rs.getString("nama"));
                obj.setEmail(rs.getString("email"));
                obj.setKontak(rs.getString("kontak"));
                obj.setTelpon(rs.getString("telpon"));
                obj.setJalan(rs.getString("jalan"));
                obj.setNomor(rs.getString("nomor"));
                obj.setBlok(rs.getString("blok"));
                obj.setRt(rs.getString("rt"));
                obj.setRw(rs.getString("rw"));
                obj.setKelurahan(rs.getString("kelurahan"));
                obj.setKecamatan(rs.getString("kecamatan"));
                obj.setKabupaten(rs.getString("kabupaten"));
                obj.setPropinsi(rs.getString("propinsi"));
                obj.setKodepos(rs.getString("kodepos"));
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public void save(LawanTransaksi obj) throws SQLException {
        String sql = "INSERT INTO tbl_lawan_transaksi (npwp,nama,email,kontak,jalan,blok,nomor,rt,rw,kelurahan,kecamatan,kabupaten,propinsi,telpon,kodepos) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getNpwp());
        pst.setString(2, obj.getNama());
        pst.setString(3, obj.getEmail());
        pst.setString(4, obj.getKontak());
        pst.setString(5, obj.getJalan());
        pst.setString(6, obj.getBlok());
        pst.setString(7, obj.getNomor());
        pst.setString(8, obj.getRt());
        pst.setString(9, obj.getRw());
        pst.setString(10, obj.getKelurahan());
        pst.setString(11, obj.getKecamatan());
        pst.setString(12, obj.getKabupaten());
        pst.setString(13, obj.getPropinsi());
        pst.setString(14, obj.getTelpon());
        pst.setString(15, obj.getKodepos());
        pst.executeUpdate();
        pst.close();
    }

    public void update(LawanTransaksi obj) throws SQLException {
        String sql = "UPDATE tbl_lawan_transaksi  SET nama=?,email=?,kontak=?, jalan=?,blok=?,nomor=?,rt=?,rw=?,kelurahan=?,kecamatan=?,kabupaten=?,propinsi=?,telpon=?,kodepos=? WHERE npwp=?";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getNama());
        pst.setString(2, obj.getEmail());
        pst.setString(3, obj.getKontak());
        pst.setString(4, obj.getJalan());
        pst.setString(5, obj.getBlok());
        pst.setString(6, obj.getNomor());
        pst.setString(7, obj.getRt());
        pst.setString(8, obj.getRw());
        pst.setString(9, obj.getKelurahan());
        pst.setString(10, obj.getKecamatan());
        pst.setString(11, obj.getKabupaten());
        pst.setString(12, obj.getPropinsi());
        pst.setString(13, obj.getTelpon());
        pst.setString(14, obj.getKodepos());
        pst.setString(15, obj.getNpwp());
        pst.executeUpdate();
        pst.close();
    }

    public Proxy getAktifProxy() throws SQLException {
        Proxy obj = null;
        String sql = "SELECT * FROM tbl_proxy  WHERE aktif=1";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            obj = new Proxy();
            obj.setIP(rs.getString("ip"));
            obj.setUsername(rs.getString("username"));
            obj.setPassword(rs.getString("password"));
            obj.setPort(rs.getInt("port"));
            obj.setAktif(rs.getInt("aktif"));
        }
        return obj;
    }

    public void delete(String npwp) {
        String sql = "DELETE FROM tbl_lawan_transaksi WHERE NPWP=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setString(1, npwp);
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

