/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.model;

import db.DBKoneksi;
import esindo.net.model.LawanTransaksi;
import esindo.net.model.SetingEmail;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.io.FilenameUtils;

public class DAOKirimEmail {
    DBKoneksi dbkon = new DBKoneksi();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LawanTransaksi findLawanTRByPK(String pk) {
        LawanTransaksi obj = null;
        String sql = "SELECT * FROM tbl_lawan_transaksi WHERE npwp=?";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            pst.setString(1, pk);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                obj = new LawanTransaksi();
                obj.setNpwp(rs.getString("npwp"));
                obj.setNama(rs.getString("nama"));
                obj.setEmail(rs.getString("email"));
                obj.setKontak(rs.getString("kontak"));
                obj.setTelpon(rs.getString("telpon"));
                obj.setJalan(rs.getString("jalan"));
                obj.setNomor(rs.getString("nomor"));
                obj.setBlok(rs.getString("blok"));
                obj.setRt(rs.getString("rt"));
                obj.setRw(rs.getString("rw"));
                obj.setKelurahan(rs.getString("kelurahan"));
                obj.setKecamatan(rs.getString("kecamatan"));
                obj.setKabupaten(rs.getString("kabupaten"));
                obj.setPropinsi(rs.getString("propinsi"));
                obj.setKodepos(rs.getString("kodepos"));
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.dbkon.closeKoneksi();
        }
        return obj;
    }

    public TableModel tableModelFileEfaktur(File folder) {
        DefaultTableModel model = new DefaultTableModel(){
            Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.class};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        Object[] judul = new String[]{"No", "NPWP", "Perusahaan", "Email", "File", "Check"};
        model.setColumnIdentifiers(judul);
        File[] listOfFiles = folder.listFiles();
        String str = "";
        int counter = 0;
        for (File file : listOfFiles) {
            if (!file.isFile() || !FilenameUtils.getExtension((String)file.getPath()).equalsIgnoreCase("pdf")) continue;
            try {
                str = file.getName();
                String[] ar_str = str.split("-");
                System.out.println("NPWP " + str + "--->" + ar_str[2]);
                LawanTransaksi obj = this.findLawanTRByPK(ar_str[2]);
                if (obj == null) continue;
                Object[] isi = new Object[]{++counter, ar_str[2], obj.getNama(), obj.getEmail(), str, Boolean.TRUE};
                model.addRow(isi);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return model;
    }

    public void save(SetingEmail obj) throws SQLException {
        String sqldel = "DELETE FROM tbl_seting_email";
        PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sqldel);
        pst.executeUpdate();
        String sql = "INSERT INTO tbl_seting_email (pengirim,jabatan_pengirim,email,email_pass,header_email,body_email,footer_email,bcc_email,smtp_host,smtp_port,subject_email,email_pengirim,cc_email) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        pst = this.dbkon.getKoneksi().prepareStatement(sql);
        pst.setString(1, obj.getPengirim());
        pst.setString(2, obj.getJabatanPengirim());
        pst.setString(3, obj.getEmail());
        pst.setString(4, obj.getEmailPassword());
        pst.setString(5, obj.getHeader());
        pst.setString(6, obj.getBody());
        pst.setString(7, obj.getFooter());
        pst.setString(8, obj.getBccEmail());
        pst.setString(9, obj.getSmptHost());
        pst.setString(10, obj.getSmptPort());
        pst.setString(11, obj.getSubjectEmail());
        pst.setString(12, obj.getEmailpengirim());
        pst.setString(13, obj.getCcEmail());
        pst.executeUpdate();
        pst.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SetingEmail getSetingEmail() {
        SetingEmail obj = null;
        String sql = "SELECT * FROM tbl_seting_email";
        try {
            PreparedStatement pst = this.dbkon.getKoneksi().prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                obj = new SetingEmail();
                obj.setPengirim(rs.getString("pengirim"));
                obj.setJabatanPengirim(rs.getString("jabatan_pengirim"));
                obj.setEmail(rs.getString("email"));
                obj.setEmailPassword(rs.getString("email_pass"));
                obj.setBccEmail(rs.getString("bcc_email"));
                obj.setSmptHost(rs.getString("smtp_host"));
                obj.setSmptPort(rs.getString("smtp_port"));
                obj.setHeader(rs.getString("header_email"));
                obj.setBody(rs.getString("body_email"));
                obj.setFooter(rs.getString("footer_email"));
                obj.setSubjectEmail(rs.getString("subject_email"));
                obj.setEmailpengirim(rs.getString("email_pengirim"));
                obj.setCcEmail(rs.getString("cc_email"));
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.dbkon.closeKoneksi();
        }
        return obj;
    }

    public void sentMail(LawanTransaksi obj, String file_attach) throws AddressException, MessagingException {
        final SetingEmail objset = this.getSetingEmail();
        System.out.println("EMAIL PASS " + objset.getEmailPassword());
        System.out.println("Pengirim Email " + objset.getEmail());
        Properties properties = new Properties();
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.host", objset.getSmptHost());
        properties.put("mail.smtp.port", objset.getSmptPort());
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.starttls.enable", "false");
        properties.put("mail.user", objset.getEmail());
        properties.put("mail.password", objset.getEmailPassword());
        properties.setProperty("mail.smtp.socketFactory.fallback", "true");
        properties.setProperty("mail.smtp.socketFactory.port", objset.getSmptPort());
        properties.put("mail.debug", "true");
        properties.put("mail.store.protocol", "pop3");
        System.out.println("Pengirim Email " + objset.getEmail());
        Authenticator auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(objset.getEmail(), objset.getEmailPassword());
            }
        };
        Session session = Session.getInstance((Properties)properties, (Authenticator)auth);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(objset.getEmailpengirim()));
        InternetAddress[] toAddresses = new InternetAddress[]{new InternetAddress(obj.getEmail())};
        InternetAddress[] myBccList = InternetAddress.parse((String)objset.getBccEmail());
        InternetAddress[] myCcList = InternetAddress.parse((String)objset.getCcEmail());
        msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        msg.setRecipients(Message.RecipientType.BCC, (Address[])myBccList);
        msg.setRecipients(Message.RecipientType.CC, (Address[])myCcList);
        msg.setSubject(objset.getSubjectEmail());
        msg.setSentDate(new Date());
        MimeBodyPart _pesan = new MimeBodyPart();
        _pesan.setText(objset.getHeader() + "\n" + objset.getBody() + "\n" + objset.getFooter());
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)_pesan);
        MimeBodyPart _attach = new MimeBodyPart();
        FileDataSource source = new FileDataSource(file_attach.trim());
        _attach.setDataHandler(new DataHandler((DataSource)source));
        _attach.setFileName(source.getName());
        multipart.addBodyPart((BodyPart)_attach);
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
        File f = new File(file_attach);
        String absolutePath = f.getAbsolutePath();
        String parent_path = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
        System.out.println("PATH ASAL " + parent_path);
        File dir = new File(parent_path + File.separator + "sudah_kirim");
        System.out.println("PATH TUJUAN " + dir.getPath());
        if (!dir.exists()) {
            this.mkdir(parent_path, "sudah_kirim");
            System.out.println("BUAT FOLDER " + parent_path + "\\sudah_kirim");
        }
        f.renameTo(new File(dir.getPath() + File.separator + source.getName()));
    }

    public static void sendEmailWithAttachments(String host, String port, final String userName, final String password, String toAddress, String subject, String message, String[] attachFiles) throws AddressException, MessagingException {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", host);
        properties.put("mail.smtp.port", port);
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.starttls.enable", "true");
        properties.put("mail.user", userName);
        properties.put("mail.password", password);
        Authenticator auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password);
            }
        };
        Session session = Session.getInstance((Properties)properties, (Authenticator)auth);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(userName));
        InternetAddress[] toAddresses = new InternetAddress[]{new InternetAddress(toAddress)};
        msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)message, "text/html");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (attachFiles != null && attachFiles.length > 0) {
            for (String filePath : attachFiles) {
                MimeBodyPart attachPart = new MimeBodyPart();
                try {
                    attachPart.attachFile(filePath);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                multipart.addBodyPart((BodyPart)attachPart);
            }
        }
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }

    public boolean mkdir(String parentDirectory, String directoryName) {
        String fullDirectoryPath = parentDirectory + File.separator + directoryName;
        File directory = new File(fullDirectoryPath);
        return directory.mkdir();
    }

    public void sentMail(String file_attach, String Email2, final SetingEmail objset, int bln, int thn) throws AddressException, MessagingException {
        System.out.println("EMAIL PASS " + objset.getEmailPassword());
        System.out.println("Pengirim Email " + objset.getEmail());
        Properties properties = new Properties();
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.host", objset.getSmptHost());
        properties.put("mail.smtp.port", objset.getSmptPort());
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.starttls.enable", "true");
        properties.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");
        properties.put("mail.smtp.ssl.trust", objset.getSmptHost());
        properties.put("mail.user", objset.getEmail());
        properties.put("mail.password", objset.getEmailPassword());
        Authenticator auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(objset.getEmail(), objset.getEmailPassword());
            }
        };
        Session session = Session.getInstance((Properties)properties, (Authenticator)auth);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(objset.getEmailpengirim()));
        InternetAddress[] toAddresses = new InternetAddress[]{new InternetAddress(Email2)};
        msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        String bulandata = Integer.toString(bln);
        if (bln <= 9) {
            bulandata = "0" + bulandata;
        }
        msg.setSubject(objset.getSubjectEmail() + " " + bln + " - " + thn);
        msg.setSentDate(new Date());
        MimeBodyPart _pesan = new MimeBodyPart();
        _pesan.setText(objset.getHeader() + "\n" + objset.getBody() + "\n" + objset.getFooter());
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)_pesan);
        MimeBodyPart _attach = new MimeBodyPart();
        FileDataSource source = new FileDataSource(file_attach.trim());
        _attach.setDataHandler(new DataHandler((DataSource)source));
        _attach.setFileName(source.getName());
        multipart.addBodyPart((BodyPart)_attach);
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }

    public void sentMailWithData(List<Map<String, Object>> masterList, String Email2, final SetingEmail objset, int bln, int thn) throws AddressException, MessagingException {
        Properties properties = new Properties();
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.host", objset.getSmptHost());
        properties.put("mail.smtp.port", objset.getSmptPort());
        properties.put("mail.smtp.auth", "true");
        properties.put("mail.smtp.starttls.enable", "true");
        properties.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");
        properties.put("mail.smtp.ssl.trust", objset.getSmptHost());
        properties.put("mail.user", objset.getEmail());
        properties.put("mail.password", objset.getEmailPassword());
        Authenticator auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(objset.getEmail(), objset.getEmailPassword());
            }
        };
        Session session = Session.getInstance((Properties)properties, (Authenticator)auth);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(objset.getEmailpengirim()));
        msg.setRecipients(Message.RecipientType.TO, (Address[])new InternetAddress[]{new InternetAddress(Email2)});
        String bulandata = bln < 10 ? "0" + bln : String.valueOf(bln);
        msg.setSubject(objset.getSubjectEmail() + " " + bulandata + " - " + thn);
        msg.setSentDate(new Date());
        StringBuilder htmlBody = new StringBuilder();
        htmlBody.append("<html><body>");
        htmlBody.append("<h3>").append(objset.getHeader()).append("</h3>");
        htmlBody.append("<p>").append(objset.getBody()).append("</p>");
        for (Map<String, Object> master : masterList) {
            htmlBody.append("<h4>NPWP: ").append(master.get("NPWP")).append(" - ").append(master.get("Nama")).append(" - ").append(master.get("Email")).append("</h4>");
            htmlBody.append("<table border='1' cellpadding='5' cellspacing='0'>");
            htmlBody.append("<tr style='background-color:#f2f2f2;'>").append("<th>No</th><th>No Bukti Potong</th><th>Jenis Pajak</th><th>Masa</th><th>No Dokumen</th>").append("</tr>");
            int no = 1;
            List details = (List)master.get("Detail");
            for (Map detail : details) {
                htmlBody.append("<tr>").append("<td>").append(no++).append("</td>").append("<td>").append(detail.get("NOBUPOT")).append("</td>").append("<td>").append(detail.get("JENISPAJAK")).append("</td>").append("<td>").append(detail.get("MASABUPOT")).append("</td>").append("<td>").append(detail.get("NODOKUMEN")).append("</td>").append("</tr>");
            }
            htmlBody.append("</table><br>");
        }
        htmlBody.append("<p>").append(objset.getFooter()).append("</p>");
        htmlBody.append("</body></html>");
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)htmlBody.toString(), "text/html; charset=utf-8");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)bodyPart);
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }
}

