/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.model;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class BacaBarcode {
    public static String readQRCode(String filePath, String charset, Map hintMap) throws FileNotFoundException, IOException, NotFoundException {
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(ImageIO.read(new FileInputStream(filePath)))));
        Result qrCodeResult = new MultiFormatReader().decode(binaryBitmap, hintMap);
        return qrCodeResult.getText();
    }

    public static void createImage(PDFPage page, String destination) throws IOException {
        Rectangle rect = new Rectangle(0, 0, (int)page.getBBox().getWidth(), (int)page.getBBox().getHeight());
        BufferedImage bufferedImage = new BufferedImage(rect.width, rect.height, 1);
        Image image = page.getImage(rect.width, rect.height, rect, null, true, true);
        Graphics2D bufImageGraphics = bufferedImage.createGraphics();
        bufImageGraphics.drawImage(image, 0, 0, null);
        ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(destination));
    }

    public static void generateImage(File folder) throws IOException {
        Logger logger = Logger.getLogger((String)"MyLog");
        Object fh = null;
        SimpleDateFormat format = new SimpleDateFormat("YYYY-M-d_HH-mm-ss");
        File[] listOfFilesPdf = folder.listFiles();
        String str = "";
        int counter = 1;
        for (File file : listOfFilesPdf) {
            if (!file.isFile() || !FilenameUtils.getExtension((String)file.getPath()).equalsIgnoreCase("pdf")) continue;
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            FileChannel channel = raf.getChannel();
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            PDFFile pdf = new PDFFile(buf);
            String namaFile = null;
            if (file.getName().indexOf(".") > 0) {
                namaFile = file.getName().substring(0, file.getName().lastIndexOf("."));
            }
            if (pdf.getNumPages() < 1) {
                JOptionPane.showMessageDialog(null, file.getName() + " Format Salah, Ada File PDF Hasil Scan");
                System.out.println(file.getName() + " Format Salah, Ada File PDF Hasil Scan");
                logger.info((Object)(file.getName() + " Format Salah, Ada File PDF Hasil Scan"));
            } else {
                for (int i = 1; i <= pdf.getNumPages(); ++i) {
                    BacaBarcode.createImage(pdf.getPage(i), folder.getAbsolutePath() + "\\" + namaFile + "_" + i + ".png");
                }
            }
            ++counter;
        }
    }

    public static TableModel tableModelDirektoryEfaktur(File folder) {
        Logger logger = Logger.getLogger((String)"MyLog");
        String filePath = "";
        String charset = "UTF-8";
        HashMap<DecodeHintType, ErrorCorrectionLevel> hintMap = new HashMap<DecodeHintType, ErrorCorrectionLevel>();
        hintMap.put(DecodeHintType.TRY_HARDER, ErrorCorrectionLevel.L);
        DefaultTableModel model = new DefaultTableModel(){
            Class[] types = new Class[]{String.class, String.class, Boolean.class};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        Object[] judul = new String[]{"No", "Link efaktur", "Check"};
        model.setColumnIdentifiers(judul);
        File[] listOfFiles = folder.listFiles();
        String str = "";
        int counter = 0;
        for (File file : listOfFiles) {
            if (!file.isFile() || !FilenameUtils.getExtension((String)file.getPath()).equalsIgnoreCase("png")) continue;
            try {
                try {
                    str = BacaBarcode.readQRCode(file.getAbsolutePath(), charset, hintMap);
                    if (str.toLowerCase().contains("svc.efaktur.pajak.go.id/validasi/faktur")) {
                        Object[] isi = new Object[]{++counter, str, Boolean.TRUE};
                        model.addRow(isi);
                        System.out.println("OK -->" + str);
                        continue;
                    }
                    System.out.println("TIDAK OK -->" + str);
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                    logger.info((Object)(file.getName() + " Tidak Ada Barcode Atau Barcode Tidak Terbaca "));
                }
                catch (NotFoundException ex) {
                    ex.printStackTrace();
                    logger.info((Object)(file.getName() + " Tidak Ada Barcode Atau Barcode Tidak Terbaca "));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return model;
    }
}

