/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressMonitor {
    int total;
    int current = -1;
    boolean indeterminate;
    int milliSecondsToWait = 500;
    String status;
    private Vector listeners = new Vector();
    private ChangeEvent ce = new ChangeEvent(this);

    public ProgressMonitor(int total, boolean indeterminate, int milliSecondsToWait) {
        this.total = total;
        this.indeterminate = indeterminate;
        this.milliSecondsToWait = milliSecondsToWait;
    }

    public ProgressMonitor(int total, boolean indeterminate) {
        this.total = total;
        this.indeterminate = indeterminate;
    }

    public int getTotal() {
        return this.total;
    }

    public void start(String status) {
        if (this.current != -1) {
            throw new IllegalStateException("not started yet");
        }
        this.status = status;
        this.current = 0;
        this.fireChangeEvent();
    }

    public int getMilliSecondsToWait() {
        return this.milliSecondsToWait;
    }

    public int getCurrent() {
        return this.current;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setCurrent(String status, int current) {
        if (current == -1) {
            throw new IllegalStateException("not started yet");
        }
        this.current = current;
        if (status != null) {
            this.status = status;
        }
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangeEvent() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(this.ce);
        }
    }
}

