/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import esindo.net.gui.ProgressMonitor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressDialog
extends JDialog
implements ChangeListener {
    JLabel statusLabel = new JLabel();
    JProgressBar progressBar = new JProgressBar();
    ProgressMonitor monitor;

    public ProgressDialog(Frame owner, ProgressMonitor monitor) throws HeadlessException {
        super(owner, "Progress", true);
        this.init(monitor);
    }

    public ProgressDialog(Dialog owner, ProgressMonitor monitor) throws HeadlessException {
        super(owner);
        this.init(monitor);
    }

    private void init(ProgressMonitor monitor) {
        this.monitor = monitor;
        this.progressBar = new JProgressBar(0, monitor.getTotal());
        if (monitor.isIndeterminate()) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setValue(monitor.getCurrent());
        }
        this.statusLabel.setText(monitor.getStatus());
        JPanel contents = (JPanel)this.getContentPane();
        contents.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contents.add((Component)this.statusLabel, "North");
        contents.add(this.progressBar);
        this.setDefaultCloseOperation(0);
        monitor.addChangeListener(this);
    }

    @Override
    public void stateChanged(final ChangeEvent ce) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.stateChanged(ce);
                }
            });
            return;
        }
        if (this.monitor.getCurrent() != this.monitor.getTotal()) {
            this.statusLabel.setText(this.monitor.getStatus());
            if (!this.monitor.isIndeterminate()) {
                this.progressBar.setValue(this.monitor.getCurrent());
            }
        } else {
            this.dispose();
        }
    }
}

