/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.tika.Tika;

public class InvoicePDFjob {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(InvoicePDFjob::createAndShowGUI);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Invoice PDF Reader");
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 400);
        frame.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        JButton openButton = new JButton("Open Invoice PDF");
        openButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            int result = fileChooser.showOpenDialog(frame);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String extractedData = InvoicePDFjob.extractInvoiceData(selectedFile);
                textArea.setText(extractedData);
            }
        });
        frame.add((Component)new JScrollPane(textArea), "Center");
        frame.add((Component)openButton, "South");
        frame.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractInvoiceData(File file) {
        try (PDDocument document = PDDocument.load((File)file);){
            PDFTextStripper stripper = new PDFTextStripper();
            String text = stripper.getText(document);
            Tika tika = new Tika();
            String text2 = tika.parseToString(file);
            String invoiceNumber = InvoicePDFjob.extractRegex(text, "Invoice No[:\\s]*(\\d+)");
            String date = InvoicePDFjob.extractRegex(text, "Date[:\\s]*(\\d{2}\\.\\d{2}\\.\\d{4})");
            String patterndy = "(?i)(Ppn\\s*-?\\s*\\d+\\s*%|VAT\\s*\\d+\\s*%)\\s+([\\d.,]+)\\s+([\\d.,]+)";
            String vat22 = InvoicePDFjob.extractVATFromVertical(text, 3);
            String dpp2 = InvoicePDFjob.extractVATFromVertical(text, 4);
            String vat = InvoicePDFjob.extractVAT(text, patterndy, 3);
            String base = InvoicePDFjob.extractVAT(text, patterndy, 2);
            String dynamicPattern = "(?i)(Net\\s*Total|Total)[:\\s]*([$\u20acRp]?\\s*[\\d.,]+)";
            String amnt = InvoicePDFjob.extractValue(text, dynamicPattern);
            String billingPattern = "(?i)Billing Name(?:\\s*\\(.*?\\))?[:\\s]*([\\w.,&\\- ]+)";
            String customerName = InvoicePDFjob.extractValueCus(text, billingPattern);
            String patternr = "(?i)JOB SITE NAME:\\s*([\\w\\s.,-]+),\\s*(?:PART ORDER NO:(\\d+)\\s*([\\d.,]+)\\s*)+((?:[\\w\\s()#xX.-]+\\n?)+)\\s*Total";
            String pattern = "(?i)JOB SITE NAME:\\s*([\\w\\s.,-]+)\\s*(?:PART ORDER NO:(\\d+)\\s*([\\d.,]+)\\s*)+([\\s\\S]+?)\\s*(?:(?:\\d{1,3}(?:[.,]\\d{3})+(?:[.,]\\d{2})?)\\s*)*\\s*(?:Total|PT\\.\\s*KONE)";
            String detail = InvoicePDFjob.detailJob(text, pattern);
            String string = "Extracted Invoice Details:\nInvoice Number: " + invoiceNumber + "\nDate: " + date + "\nvat: " + vat22 + "\ndpp: " + dpp2 + "\nttl : " + amnt + "\nnama pembeli : " + customerName + "\ndetailss : " + InvoicePDFjob.extractDetailBarang(text) + "\ndetail product : " + detail + "\n (text) " + text2 + "\n";
            return string;
        }
        catch (Exception e) {
            return "Error reading PDF: " + e.getMessage();
        }
    }

    public static String extractVATFromVertical(String text, int pil) {
        String pattern = "(?i)(?:Ppn|VAT%)\\s*\\n\\s*\\d{1,2}[.,]\\d{2}\\s*%\\s*\\n\\s*([\\d.,]+)\\s*\\n\\s*([\\d.,]+)\\s*\\n\\s*([\\d.,]+)";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String total = matcher.group(1).trim();
            String base = matcher.group(2).trim();
            String vat = matcher.group(3).trim();
            System.out.println("pppp " + base + " " + vat + " dpp " + total);
            if (pil == 2) {
                return InvoicePDFjob.normalizeNumber(base);
            }
            if (pil == 4) {
                return InvoicePDFjob.normalizeNumber(total);
            }
            return InvoicePDFjob.normalizeNumber(vat);
        }
        return "not found";
    }

    public static String extractDetailBarang(String text) {
        int totalIndex;
        String lastHarga;
        int lastIndex;
        ArrayList<String> namaList = new ArrayList<String>();
        ArrayList<String> hargaList = new ArrayList<String>();
        Pattern partPattern = Pattern.compile("PART ORDER NO:(\\d+)\\s+([\\d.,]+)");
        Matcher partMatcher = partPattern.matcher(text);
        while (partMatcher.find()) {
            namaList.add("PART ORDER NO:" + partMatcher.group(1));
            hargaList.add(partMatcher.group(2));
        }
        String detail = "";
        if (!hargaList.isEmpty() && (lastIndex = text.indexOf(lastHarga = (String)hargaList.get(hargaList.size() - 1))) != -1 && (totalIndex = (detail = text.substring(lastIndex + lastHarga.length()).trim()).toLowerCase().indexOf("total")) != -1) {
            detail = detail.substring(0, totalIndex).trim();
        }
        StringBuilder result = new StringBuilder("detail\n");
        for (int i = 0; i < namaList.size(); ++i) {
            result.append("  nama :  ").append((String)namaList.get(i)).append("\n");
            result.append("  Harga:  ").append((String)hargaList.get(i)).append("\n");
            if (i == namaList.size() - 1) {
                result.append("  detail  : ").append(detail).append("\n\n");
                continue;
            }
            result.append("  detail  : ''\n\n");
        }
        return result.toString();
    }

    public static String extractDetailBarangs(String text) {
        int totalIndex;
        ArrayList<String> namaList = new ArrayList<String>();
        ArrayList<String> hargaList = new ArrayList<String>();
        Pattern partPattern = Pattern.compile("PART ORDER NO:(\\d+)\\s+([\\d.,]+)");
        Matcher partMatcher = partPattern.matcher(text);
        while (partMatcher.find()) {
            namaList.add("PART ORDER NO:" + partMatcher.group(1));
            hargaList.add(partMatcher.group(2));
        }
        String detail = "";
        int lastIndex = text.lastIndexOf((String)hargaList.get(hargaList.size() - 1));
        if (lastIndex != -1 && (totalIndex = (detail = text.substring(lastIndex + ((String)hargaList.get(hargaList.size() - 1)).length()).trim()).toLowerCase().indexOf("total")) != -1) {
            detail = detail.substring(0, totalIndex).trim();
        }
        StringBuilder result = new StringBuilder("detail\n");
        for (int i = 0; i < namaList.size(); ++i) {
            result.append("  nama :  ").append((String)namaList.get(i)).append("\n");
            result.append("  Harga:  ").append((String)hargaList.get(i)).append("\n");
            if (i == namaList.size() - 1) {
                result.append("  detail  : ").append(detail).append("\n\n");
                continue;
            }
            result.append("  detail  : ''\n\n");
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String extractStructuredDetail(String text) {
        void var7_9;
        String[] lines = text.split("\\r?\\n");
        ArrayList items = new ArrayList();
        Pattern orderPattern = Pattern.compile("PART ORDER NO:(\\d+)\\s+([\\d,.]+)");
        ArrayList<String> detailsBuffer = new ArrayList<String>();
        String[] stringArray = lines;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String line = stringArray[var7_9];
            Matcher matcher = orderPattern.matcher(line.trim());
            if (matcher.find()) {
                LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
                item.put("nama", "PART ORDER NO:" + matcher.group(1));
                item.put("harga", matcher.group(2));
                item.put("detail", "");
                items.add(item);
            } else if (!line.trim().toLowerCase().startsWith("total") && !line.trim().isEmpty()) {
                detailsBuffer.add(line.trim());
            }
            ++var7_9;
        }
        if (!items.isEmpty() && !detailsBuffer.isEmpty()) {
            Map lastItem = (Map)items.get(items.size() - 1);
            lastItem.put("detail", String.join((CharSequence)" ", detailsBuffer));
        }
        StringBuilder result = new StringBuilder();
        result.append("detail\n");
        for (Map map : items) {
            result.append("  nama : ").append((String)map.get("nama")).append("\n");
            result.append("  Harga: ").append((String)map.get("harga")).append("\n");
            result.append("  detail  : ").append((String)map.get("detail")).append("\n\n");
        }
        return result.toString();
    }

    public static String detailJobs(String text, String partt) {
        Pattern r = Pattern.compile(partt);
        Matcher m = r.matcher(text);
        StringBuilder result = new StringBuilder();
        if (m.find()) {
            result.append("JOB SITE NAME: ").append(m.group(1)).append("\n");
            Pattern partOrderPattern = Pattern.compile("PART ORDER NO:(\\d+)\\s*([\\d.,]+)");
            Matcher partOrderMatcher = partOrderPattern.matcher(text);
            result.append("Part Orders:\n");
            while (partOrderMatcher.find()) {
                result.append("  - ").append(partOrderMatcher.group(1)).append(" : ").append(partOrderMatcher.group(2)).append("\n");
            }
            result.append("Detail Produk:\n").append(m.group(4).trim()).append("\n");
        } else {
            result.append("Data tidak ditemukan.");
        }
        return result.toString();
    }

    public static String detailJob(String text, String partt) {
        Pattern r = Pattern.compile(partt);
        Matcher m = r.matcher(text);
        StringBuilder result = new StringBuilder();
        if (m.find()) {
            result.append("{\n");
            result.append("  \"jobSiteName\": \"").append(m.group(1)).append("\",\n");
            Pattern partOrderPattern = Pattern.compile("PART ORDER NO:(\\d+)\\s*([\\d.,]+)");
            Matcher partOrderMatcher = partOrderPattern.matcher(text);
            result.append("  \"partOrders\": [\n");
            while (partOrderMatcher.find()) {
                result.append("    {\n").append("      \"partOrderNo\": \"").append(partOrderMatcher.group(1)).append("\",\n").append("      \"harga\": \"").append(partOrderMatcher.group(2)).append("\"\n").append("    },\n");
            }
            if (result.charAt(result.length() - 2) == ',') {
                result.setLength(result.length() - 2);
                result.append("\n  ],\n");
            } else {
                result.append("  ],\n");
            }
            result.append("  \"detailProduk\": \"").append(m.group(4).trim()).append("\"\n");
            result.append("}");
        } else {
            result.append("{ \"message\": \"Data tidak ditemukan.\" }");
        }
        return result.toString();
    }

    public static String detailDataProduc(String text, String patternss) {
        Pattern pattern = Pattern.compile(patternss);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String buildingName;
            String dpDescription = matcher.group(1) != null ? matcher.group(1) : "Not Found";
            String dpAmount = matcher.group(2) != null ? matcher.group(2) : "Not Found";
            String projectName = matcher.group(3) != null ? matcher.group(3).trim() : "Not Found";
            System.out.println("dp " + matcher.group(2) + " des " + dpDescription);
            String description = matcher.group(4) != null ? matcher.group(4).trim() : "Not Found";
            String startDate = matcher.group(5) != null ? matcher.group(5) : "Not Found";
            String endDate = matcher.group(6) != null ? matcher.group(6) : "Not Found";
            String amount = matcher.group(7) != null ? matcher.group(7) : "Not Found";
            String elevatorCount = matcher.group(8) != null ? matcher.group(8) : "Not Found";
            String string = buildingName = matcher.group(9) != null ? matcher.group(9).trim() : "Not Found";
            if (!dpAmount.equals("Not Found")) {
                System.out.println("Description: " + dpDescription);
                System.out.println("Down Payment Amount: " + dpAmount);
                System.out.println("Project Name: " + projectName);
                return dpDescription + " untuk project " + projectName;
            }
            System.out.println("Description: " + description);
            System.out.println("Start Date: " + startDate);
            System.out.println("End Date: " + endDate);
            System.out.println("Amount: " + amount);
            System.out.println("Servicing Details: " + elevatorCount + " Elevator " + buildingName);
            return description + " " + startDate + " " + endDate + " For servicing of " + elevatorCount + " Elevator " + buildingName;
        }
        return "not found";
    }

    public static String extractValueCus(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String extractedValue = matcher.group(1).trim();
            return extractedValue;
        }
        return "not found";
    }

    public static String extractValue(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String label = matcher.group(1).trim();
            String amount = matcher.group(2).trim();
            return amount;
        }
        return "not found";
    }

    public static String extractVAT(String text, String pattern, int pil) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String vatType = matcher.group(1).trim();
            String baseAmountRaw = matcher.group(2).trim();
            String vatAmountRaw = matcher.group(3).trim();
            if (pil == 2) {
                return InvoicePDFjob.normalizeNumber(baseAmountRaw);
            }
            return InvoicePDFjob.normalizeNumber(vatAmountRaw);
        }
        return "not found";
    }

    private static String extractRegex(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1) : "Not Found";
    }

    private static String normalizeNumber(String input) {
        boolean hasDotDecimal;
        boolean hasCommaDecimal = input.contains(",") && input.lastIndexOf(",") > input.lastIndexOf(".");
        boolean bl = hasDotDecimal = input.contains(".") && input.lastIndexOf(".") > input.lastIndexOf(",");
        if (hasCommaDecimal) {
            input = input.replaceAll("\\.", "").replace(",", ".");
        } else if (hasDotDecimal) {
            input = input.replaceAll(",", "");
        }
        double number = Double.parseDouble(input);
        DecimalFormat df = new DecimalFormat("##.00", DecimalFormatSymbols.getInstance(Locale.US));
        return df.format(number);
    }

    public static String standardizeDecimal(String amount) {
        if (amount == null || amount.isEmpty()) {
            return "0.00";
        }
        try {
            double value = Double.parseDouble(amount.replace(",", "."));
            return String.format("%.2f", value);
        }
        catch (NumberFormatException e) {
            return "Invalid amount";
        }
    }
}

