/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class InvoicePDFReader {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(InvoicePDFReader::createAndShowGUI);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Invoice PDF Reader");
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 400);
        frame.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        JButton openButton = new JButton("Open Invoice PDF");
        openButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            int result = fileChooser.showOpenDialog(frame);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String extractedData = InvoicePDFReader.extractInvoiceData(selectedFile);
                textArea.setText(extractedData);
            }
        });
        frame.add((Component)new JScrollPane(textArea), "Center");
        frame.add((Component)openButton, "South");
        frame.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractInvoiceData(File file) {
        try (PDDocument document = PDDocument.load((File)file);){
            PDFTextStripper stripper = new PDFTextStripper();
            String text = stripper.getText(document);
            String invoiceNumber = InvoicePDFReader.extractRegex(text, "Invoice No[:\\s]*(\\d+)");
            String date = InvoicePDFReader.extractRegex(text, "Date[:\\s]*(\\d{2}\\.\\d{2}\\.\\d{4})");
            String patterndy = "(?i)(Ppn-\\d+\\s?%|VAT\\s*\\d+\\s?%)\\s+([\\d.,]+)\\s+([\\d.,]+)";
            String vat = InvoicePDFReader.extractVAT(text, patterndy, 3);
            String base = InvoicePDFReader.extractVAT(text, patterndy, 2);
            String dynamicPattern = "(?i)(Net\\s*Total|Total)[:\\s]*([$\u20acRp]?\\s*[\\d.,]+)";
            String amnt = InvoicePDFReader.extractValue(text, dynamicPattern);
            String billingPattern = "(?i)Billing Name(?:\\s*\\(.*?\\))?[:\\s]*([\\w.,&\\- ]+)";
            String customerName = InvoicePDFReader.extractValueCus(text, billingPattern);
            String combinedPattern2 = "(?i)Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*(Tagihan\\s*(?:Down\\s*Payment|Installment)\\s*\\(\\d+,?\\d*%\\)(?:\\s*Month\\s*\\d+)?\\s*untuk\\s*Pemasangan\\s*Elevator\\s*[^\\d]+?)\\s*([\\d.,]+)\\s*(?:\\(\\s*Untuk\\s*(?:Proyek|Project)\\s*([\\w\\s&-]+(?:\\s+[\\w\\s&-]+)*)?)\\)?|Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*([\\w\\s%.,()-]+?)\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*([\\d.,]+)\\s*(?:For servicing of\\s*(\\d+)\\s*Elevator\\s*(.*))?";
            String combinedPatternd = "(?i)Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*(Tagihan\\s*(?:Down\\s*Payment|Installment|Material\\s*on\\s*Site)\\s*(?:\\(\\d+,?\\d*%\\))?(?:\\s*Month\\s*\\d+)?\\s*untuk\\s*[^\\d]+?)\\s*([\\d.,]+)\\s*(?:\\(\\s*Untuk\\s*(?:Proyek|Project)\\s*([\\w\\s&-]+(?:\\s+[\\w\\s&-]+)*)?)\\)?|Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*([\\w\\s%.,()-]+?)\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*([\\d.,]+)\\s*(?:For servicing of\\s*(\\d+)\\s*Elevator\\s*(.*))?";
            String combinedPattern = "(?i)Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*(Tagihan\\s*(?:Down\\s*Payment|Installment|Material\\s*on\\s*Site|VO)\\s*(?:\\(\\d+,?\\d*%\\))?(?:\\s*Month\\s*\\d+)?\\s*untuk\\s*[^\\d]+?)\\s*([\\d.,]+)\\s*(?:\\(\\s*Untuk\\s*(?:Proyek|Project)\\s*([\\w\\s&-]+(?:\\s+[\\w\\s&-]+)*)?)\\)?|Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*([\\w\\s%.,()-]+?)\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*([\\d.,]+)\\s*(?:For servicing of\\s*(\\d+)\\s*Elevator\\s*(.*))?";
            System.out.println("textt -- " + text);
            String detail = InvoicePDFReader.detailDataProduc(text, combinedPattern);
            String string = "Extracted Invoice Details:\nInvoice Number: " + invoiceNumber + "\nDate: " + date + "\nvat: " + vat + "\ndpp: " + base + "\nttl : " + amnt + "\nnama pembeli : " + customerName + "\ndetail product : " + detail + "\n (text) " + text + "\n";
            return string;
        }
        catch (Exception e) {
            return "Error reading PDF: " + e.getMessage();
        }
    }

    public static String detailDataProduc(String text, String patternss) {
        Pattern pattern = Pattern.compile(patternss);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String buildingName;
            String dpDescription = matcher.group(1) != null ? matcher.group(1) : "Not Found";
            String dpAmount = matcher.group(2) != null ? matcher.group(2) : "Not Found";
            String projectName = matcher.group(3) != null ? matcher.group(3).trim() : "Not Found";
            System.out.println("dp " + matcher.group(2) + " des " + dpDescription);
            String description = matcher.group(4) != null ? matcher.group(4).trim() : "Not Found";
            String startDate = matcher.group(5) != null ? matcher.group(5) : "Not Found";
            String endDate = matcher.group(6) != null ? matcher.group(6) : "Not Found";
            String amount = matcher.group(7) != null ? matcher.group(7) : "Not Found";
            String elevatorCount = matcher.group(8) != null ? matcher.group(8) : "Not Found";
            String string = buildingName = matcher.group(9) != null ? matcher.group(9).trim() : "Not Found";
            if (!dpAmount.equals("Not Found")) {
                System.out.println("Description: " + dpDescription);
                System.out.println("Down Payment Amount: " + dpAmount);
                System.out.println("Project Name: " + projectName);
                return dpDescription + " untuk project " + projectName;
            }
            System.out.println("Description: " + description);
            System.out.println("Start Date: " + startDate);
            System.out.println("End Date: " + endDate);
            System.out.println("Amount: " + amount);
            System.out.println("Servicing Details: " + elevatorCount + " Elevator " + buildingName);
            return description + " " + startDate + " " + endDate + " For servicing of " + elevatorCount + " Elevator " + buildingName;
        }
        return "not found";
    }

    public static String extractValueCus(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String extractedValue = matcher.group(1).trim();
            return extractedValue;
        }
        return "not found";
    }

    public static String extractValue(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String label = matcher.group(1).trim();
            String amount = matcher.group(2).trim();
            return amount;
        }
        return "not found";
    }

    public static String extractVAT(String text, String pattern, int pil) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String vatType = matcher.group(1).trim();
            String baseAmountRaw = matcher.group(2).trim();
            String vatAmountRaw = matcher.group(3).trim();
            if (pil == 2) {
                return baseAmountRaw;
            }
            return vatAmountRaw;
        }
        return "not found";
    }

    private static String extractRegex(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1) : "Not Found";
    }
}

