/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.tika.Tika;

public class InvoicePDFPm {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(InvoicePDFPm::createAndShowGUI);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Invoice PDF Reader");
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 400);
        frame.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        JButton openButton = new JButton("Open Invoice PDF");
        openButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            int result = fileChooser.showOpenDialog(frame);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String extractedData = InvoicePDFPm.extractInvoiceData(selectedFile);
                textArea.setText(extractedData);
            }
        });
        frame.add((Component)new JScrollPane(textArea), "Center");
        frame.add((Component)openButton, "South");
        frame.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractInvoiceData(File file) {
        try (PDDocument document = PDDocument.load((File)file);){
            PDFTextStripper stripper = new PDFTextStripper();
            String text = stripper.getText(document);
            Tika tika = new Tika();
            String texteks = tika.parseToString(file);
            String regex = "(\\d+)\\s+(\\d{6})\\s+([\\s\\S]*?)Rp ([\\d\\.]+,\\d{2}) x ([\\d\\.]+,[\\d\\.]+) [^=\\n]+[\\s\\S]*?= Rp ([\\d\\.]+,\\d{2})[\\s\\S]*?= Rp ([\\d\\.]+,\\d{2})\\s+([\\d\\.]+,\\d{2})";
            String detail = InvoicePDFPm.detailPrdk(text, regex);
            String master = InvoicePDFPm.headerInfo(text);
            String masterBeli = InvoicePDFPm.headerPembeli(text);
            String string = InvoicePDFPm.extractTotalInfo(text) + "--" + InvoicePDFPm.extractTanggalDanReferensi(text) + "-----" + master + "---" + masterBeli + "----" + detail + " -------- " + texteks + " -------- " + text;
            return string;
        }
        catch (Exception e) {
            return "Error reading PDF: " + e.getMessage();
        }
    }

    public static String sumTotal(String text, String pattern, int pil) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(text);
        if (m.find()) {
            System.out.println("DP %: " + m.group(1));
            System.out.println("Total Item Net Value: " + m.group(2));
            System.out.println("DP Value: " + m.group(3));
            System.out.println("Total Value: " + m.group(4));
            System.out.println("VAT: " + m.group(5));
            System.out.println("Total Balance: " + m.group(5));
            String baseAmountRaw = m.group(3);
            String baseVat = m.group(4);
            String baseTotal = m.group(5);
            String dp = m.group(1);
            if (pil == 1) {
                return dp;
            }
            if (pil == 4) {
                return InvoicePDFPm.normalizeNumber(baseAmountRaw);
            }
            if (pil == 5) {
                return InvoicePDFPm.normalizeNumber(baseVat);
            }
            if (pil == 6) {
                return InvoicePDFPm.normalizeNumber(baseTotal);
            }
            return "-";
        }
        return "not found";
    }

    public static String extractTotalInfo(String text) {
        StringBuilder result = new StringBuilder();
        Pattern pattern = Pattern.compile("Harga Jual / Penggantian / Uang Muka / Termin\\s+([\\d\\.]+,\\d{2})\\s*Dikurangi Potongan Harga\\s+([\\d\\.]+,\\d{2})\\s*Dikurangi Uang Muka yang telah diterima\\s*([\\d\\.]+,\\d{2})?\\s*Dasar Pengenaan Pajak\\s+([\\d\\.]+,\\d{2})\\s*Jumlah PPN .*?\\s+([\\d\\.]+,\\d{2})\\s*Jumlah PPnBM .*?\\s+([\\d\\.]+,\\d{2})", 10);
        Matcher matcher = pattern.matcher(text);
        result.append("=== INFORMASI TOTAL ===\n");
        if (matcher.find()) {
            result.append("  - Harga Jual / Termin: ").append(matcher.group(1)).append("\n");
            result.append("  - Potongan Harga: ").append(matcher.group(2)).append("\n");
            String uangMuka = matcher.group(3) != null ? matcher.group(3) : "0,00";
            result.append("  - Uang Muka Diterima: ").append(uangMuka).append("\n");
            result.append("  - Dasar Pengenaan Pajak: ").append(matcher.group(4)).append("\n");
            result.append("  - Jumlah PPN: ").append(matcher.group(5)).append("\n");
            result.append("  - Jumlah PPnBM: ").append(matcher.group(6)).append("\n");
        } else {
            result.append("  - Data tidak ditemukan\n");
        }
        result.append("========================\n");
        return result.toString();
    }

    public static String extractTanggalDanReferensi(String text) {
        StringBuilder result = new StringBuilder();
        Pattern tanggalPattern = Pattern.compile(",\\s*(\\d{1,2}\\s+[A-Za-z]+\\s+\\d{4})");
        Pattern referensiPattern = Pattern.compile("\\(Referensi:\\s*(\\d+)\\)");
        Matcher tanggalMatcher = tanggalPattern.matcher(text);
        Matcher referensiMatcher = referensiPattern.matcher(text);
        result.append("=== INFORMASI TANGGAL & REFERENSI ===\n");
        if (tanggalMatcher.find()) {
            String tanggalAsli = tanggalMatcher.group(1).replaceAll("\\s+", " ").trim();
            String tanggalFormatted = InvoicePDFPm.formatTanggal(tanggalAsli);
            result.append("  - Tanggal: ").append(tanggalFormatted).append("\n");
        } else {
            result.append("  - Tanggal: Tidak ditemukan\n");
        }
        if (referensiMatcher.find()) {
            result.append("  - Referensi: ").append(referensiMatcher.group(1)).append("\n");
        } else {
            result.append("  - Referensi: Tidak ditemukan\n");
        }
        result.append("=====================================\n");
        return result.toString();
    }

    private static String formatTanggal(String input) {
        try {
            SimpleDateFormat originalFormat = new SimpleDateFormat("d MMMM yyyy", new Locale("id"));
            Date date = originalFormat.parse(input);
            SimpleDateFormat targetFormat = new SimpleDateFormat("d.MM.yyyy");
            return targetFormat.format(date);
        }
        catch (ParseException e) {
            return input;
        }
    }

    public static String[] headerInfoAr(String text) {
        String nama = "-";
        String alamat = "-";
        String nitku = "-";
        String npwp = "-";
        String nomorFaktur = "-";
        Pattern alamatDanNitkuPattern = Pattern.compile("Alamat:\\s*([\\s\\S]*?)#([^\\s]+)\\s*Kode dan Nomor Seri Faktur Pajak", 8);
        Matcher matcherAlamatNitku = alamatDanNitkuPattern.matcher(text);
        Pattern fakturPattern = Pattern.compile("Kode dan Nomor Seri Faktur Pajak:\\s*(\\d+)");
        Pattern namaPattern = Pattern.compile("Nama\\s*:\\s*(.*)");
        Pattern npwpPattern = Pattern.compile("NPWP\\s*:\\s*(\\d+)");
        Matcher mFaktur = fakturPattern.matcher(text);
        Matcher mNama = namaPattern.matcher(text);
        Matcher mNpwp = npwpPattern.matcher(text);
        if (matcherAlamatNitku.find()) {
            alamat = matcherAlamatNitku.group(1).replaceAll("\\s+", " ").trim();
            nitku = matcherAlamatNitku.group(2).trim();
        }
        if (mFaktur.find()) {
            nomorFaktur = mFaktur.group(1);
        }
        if (mNama.find()) {
            nama = mNama.group(1).trim();
        }
        if (mNpwp.find()) {
            npwp = mNpwp.group(1).trim();
        }
        return new String[]{nama, alamat, nitku, npwp, nomorFaktur};
    }

    public static String headerPembeli(String text) {
        StringBuilder result = new StringBuilder();
        result.append("=== INFORMASI PEMBELI ===\n");
        Pattern pembeliBlockPattern = Pattern.compile("Pembeli Barang Kena Pajak/Penerima Jasa Kena Pajak:\\s*Nama\\s*:\\s*(.*?)\\s*Alamat\\s*:\\s*([\\s\\S]*?)\\s*#(\\d+)\\s*NPWP\\s*:\\s*(\\d+)", 8);
        Matcher mPembeli = pembeliBlockPattern.matcher(text);
        if (mPembeli.find()) {
            String nama = mPembeli.group(1).replaceAll("\\s+", " ").trim();
            String alamat = mPembeli.group(2).replaceAll("\\s+", " ").trim();
            String nitku = mPembeli.group(3).trim();
            String npwp = mPembeli.group(4).trim();
            result.append("  - Nama customer: ").append(nama).append("\n");
            result.append("  - Alamat: ").append(alamat).append("\n");
            result.append("  - Nitku: ").append(nitku).append("\n");
            result.append("  - NPWP: ").append(npwp).append("\n");
        } else {
            result.append("  Data pembeli tidak ditemukan.\n");
        }
        result.append("========================\n");
        return result.toString();
    }

    public static String headerInfo(String text) {
        StringBuilder result = new StringBuilder();
        Pattern pattern = Pattern.compile("Alamat:\\s*([\\s\\S]*?)#([^\\s]+)\\s*Kode dan Nomor Seri Faktur Pajak", 8);
        Matcher matcher = pattern.matcher(text);
        Pattern fakturPattern = Pattern.compile("Kode dan Nomor Seri Faktur Pajak:\\s*(\\d+)");
        Pattern namaPattern = Pattern.compile("Nama\\s*:\\s*(.*)");
        Pattern alamatPattern = Pattern.compile("Alamat\\s*:\\s*([\\s\\S]*?)NPWP");
        Pattern npwpPattern = Pattern.compile("NPWP\\s*:\\s*(\\d+)");
        Pattern mNamaPembeli = Pattern.compile("Pembeli.*?Nama\\s*:\\s*(.*?)\\s*Alamat", 32);
        Matcher matcherNama = mNamaPembeli.matcher(text);
        Matcher mFaktur = fakturPattern.matcher(text);
        Matcher mNama = namaPattern.matcher(text);
        Matcher mAlamat = alamatPattern.matcher(text);
        Matcher mNpwp = npwpPattern.matcher(text);
        Object namaPembeli = null;
        result.append("=== INFORMASI NASTER ===\n");
        if (matcher.find()) {
            String alamat = matcher.group(1).replaceAll("\\s+", " ").trim();
            String nitku = matcher.group(2).trim();
            result.append("  - Alamat: ").append(alamat).append("\n");
            result.append("  - Nitku: ").append(nitku).append("\n");
        } else {
            result.append("  - Alamat dan Nitku: Tidak ditemukan\n");
        }
        if (mFaktur.find()) {
            result.append("  - Nomor Seri Faktur Pajak: ").append(mFaktur.group(1)).append("\n");
        }
        if (mNama.find()) {
            result.append("  - Nama PKP: ").append(mNama.group(1)).append("\n");
        }
        if (mNama.find()) {
            result.append("  - Nama customer: ").append(mNama.group(1)).append("\n");
        }
        if (mNpwp.find()) {
            result.append("  - NPWP: ").append(mNpwp.group(1)).append("\n");
        }
        if (matcherNama.find()) {
            result.append("  - Nama customer: ").append(matcherNama.group(1).trim()).append("\n");
        }
        result.append("========================\n");
        return result.toString();
    }

    public static String extractAddressAndNitku(String text) {
        StringBuilder result = new StringBuilder();
        Pattern pattern = Pattern.compile("Alamat:\\s*([\\s\\S]*?)#([^\\s]+)\\s*Kode dan Nomor Seri Faktur Pajak", 8);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String alamat = matcher.group(1).replaceAll("\\s+", " ").trim();
            String nitku = matcher.group(2).trim();
            result.append("  - Alamat: ").append(alamat).append("\n");
            result.append("  - Nitku: ").append(nitku).append("\n");
        } else {
            result.append("  - Alamat dan Nitku: Tidak ditemukan\n");
        }
        return result.toString();
    }

    public static String detailPrdk(String text, String patternss) {
        Pattern r = Pattern.compile(patternss, 8);
        Matcher m = r.matcher(text);
        StringBuilder result = new StringBuilder();
        while (m.find()) {
            result.append(">> Group 1 (Line): ").append(m.group(1)).append("\n");
            result.append(">> Group 2 (Kode): ").append(m.group(2)).append("\n");
            result.append(">> Group 3 (Deskripsi): ").append(m.group(3).replaceAll("\\s+", " ").trim()).append("\n");
            result.append(">> Group 4 (Harga Satuan): ").append(m.group(4)).append("\n");
            result.append(">> Group 5 (Qty): ").append(m.group(5)).append("\n");
            result.append(">> Group 6 (Potongan): ").append(m.group(6)).append("\n");
            result.append(">> Group 7 (PPnBM): ").append(m.group(7)).append("\n");
            result.append(">> Group 8 (Net Value): ").append(m.group(8)).append("\n\n");
        }
        return result.toString();
    }

    public static String detailPrdks(String text, String patternss) {
        Pattern r = Pattern.compile(patternss);
        Matcher m = r.matcher(text);
        StringBuilder result = new StringBuilder();
        while (m.find()) {
            result.append("  - Line: ").append(m.group(1)).append("\n");
            result.append("  - deskripsi: ").append(m.group(3).replaceAll("\\s+", " ").trim()).append("\n");
            result.append("  - qty: ").append(m.group(4).replaceAll("[^\\d]", "")).append("\n");
            result.append("  - net price: ").append(m.group(6)).append("\n");
            result.append("  - netvalue: ").append(m.group(8)).append("\n\n\n");
            System.out.println();
        }
        return result.toString();
    }

    public static String detailDataProducHt(String text, String patternss) {
        Pattern r = Pattern.compile(patternss);
        Matcher prodMatcher = r.matcher(text);
        StringBuilder result = new StringBuilder();
        boolean found = false;
        Matcher m = Pattern.compile(patternss).matcher(text);
        while (m.find()) {
            System.out.println("\u2714 Match ditemukan!");
            for (int i = 1; i <= m.groupCount(); ++i) {
                System.out.println("Group " + i + ": " + m.group(i));
            }
        }
        while (prodMatcher.find()) {
            found = true;
            result.append("  - Line: ").append(prodMatcher.group(1)).append("\n");
            result.append("    Code: ").append(prodMatcher.group(2)).append("\n");
            result.append("    Desc: ").append(prodMatcher.group(3)).append("\n");
            result.append("    Qty: ").append(prodMatcher.group(4).replaceAll("[^\\d]", "")).append(" ").append(prodMatcher.group(5)).append("\n");
            result.append("    Net Price: ").append(prodMatcher.group(6)).append("\n");
            result.append("    Tax: ").append(prodMatcher.group(7)).append("\n");
            result.append("    Net Value: ").append(prodMatcher.group(8)).append("\n\n");
        }
        if (!found) {
            result.append("Data tidak ditemukan.");
        }
        return result.toString();
    }

    public static String detailDataProduc(String text, String patternss) {
        Pattern pattern = Pattern.compile(patternss);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String buildingName;
            String dpDescription = matcher.group(1) != null ? matcher.group(1) : "Not Found";
            String dpAmount = matcher.group(2) != null ? matcher.group(2) : "Not Found";
            String projectName = matcher.group(3) != null ? matcher.group(3).trim() : "Not Found";
            System.out.println("dp " + matcher.group(2) + " des " + dpDescription);
            String description = matcher.group(4) != null ? matcher.group(4).trim() : "Not Found";
            String startDate = matcher.group(5) != null ? matcher.group(5) : "Not Found";
            String endDate = matcher.group(6) != null ? matcher.group(6) : "Not Found";
            String amount = matcher.group(7) != null ? matcher.group(7) : "Not Found";
            String elevatorCount = matcher.group(8) != null ? matcher.group(8) : "Not Found";
            String string = buildingName = matcher.group(9) != null ? matcher.group(9).trim() : "Not Found";
            if (!dpAmount.equals("Not Found")) {
                System.out.println("Description: " + dpDescription);
                System.out.println("Down Payment Amount: " + dpAmount);
                System.out.println("Project Name: " + projectName);
                return dpDescription + " untuk project " + projectName;
            }
            System.out.println("Description: " + description);
            System.out.println("Start Date: " + startDate);
            System.out.println("End Date: " + endDate);
            System.out.println("Amount: " + amount);
            System.out.println("Servicing Details: " + elevatorCount + " Elevator " + buildingName);
            return description + " " + startDate + " " + endDate + " For servicing of " + elevatorCount + " Elevator " + buildingName;
        }
        return "not found";
    }

    public static String extractValueCus(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String extractedValue = matcher.group(1).trim();
            return extractedValue;
        }
        return "not found";
    }

    public static String extractValue(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String label = matcher.group(1).trim();
            String amount = matcher.group(2).trim();
            return amount;
        }
        return "not found";
    }

    public static String extractVAT(String text, String pattern, int pil) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String vatType = matcher.group(1).trim();
            String baseAmountRaw = matcher.group(2).trim();
            String vatAmountRaw = matcher.group(3).trim();
            if (pil == 2) {
                return InvoicePDFPm.normalizeNumber(baseAmountRaw);
            }
            return InvoicePDFPm.normalizeNumber(vatAmountRaw);
        }
        return "not found";
    }

    private static String normalizeNumber(String input) {
        boolean hasDotDecimal;
        boolean hasCommaDecimal = input.contains(",") && input.lastIndexOf(",") > input.lastIndexOf(".");
        boolean bl = hasDotDecimal = input.contains(".") && input.lastIndexOf(".") > input.lastIndexOf(",");
        if (hasCommaDecimal) {
            input = input.replaceAll("\\.", "").replace(",", ".");
        } else if (hasDotDecimal) {
            input = input.replaceAll(",", "");
        }
        double number = Double.parseDouble(input);
        DecimalFormat df = new DecimalFormat("##.00", DecimalFormatSymbols.getInstance(Locale.US));
        return df.format(number);
    }

    private static String extractRegex(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1) : "Not Found";
    }

    private static String extractRegexInvoice(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(text);
        if (m.find()) {
            return m.group(1) != null ? m.group(1) : m.group(2);
        }
        return "not found";
    }
}

