/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.tika.Tika;

public class InvoicePDFHilti {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(InvoicePDFHilti::createAndShowGUI);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Invoice PDF Reader");
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 400);
        frame.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        JButton openButton = new JButton("Open Invoice PDF");
        openButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            int result = fileChooser.showOpenDialog(frame);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String extractedData = InvoicePDFHilti.extractInvoiceData(selectedFile);
                textArea.setText(extractedData);
            }
        });
        frame.add((Component)new JScrollPane(textArea), "Center");
        frame.add((Component)openButton, "South");
        frame.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractInvoiceData(File file) {
        try (PDDocument document = PDDocument.load((File)file);){
            PDFTextStripper stripper = new PDFTextStripper();
            String text = stripper.getText(document);
            Tika tika = new Tika();
            String texteks = tika.parseToString(file);
            String patternInvoice = "(?i)(?:DP\\s*\\d+%\\s*Invoice\\s*(\\d+))|(?:Invoice:\\s*(\\d+))";
            String patternTgl = "\\b(\\d{2}/\\d{2}/\\d{4})\\b";
            String patternCus = "(?i)(Billing Name|Account Address)(?:\\s*\\(.*?\\))?[:\\s]*([\\w.,&\\- ]+)";
            String patternVAT = "Your VAT Reg. Number:\\s*(\\S+)";
            String patternSummary = "(?i)Total Item Net Value\\s+\\n?\\s*([\\d.,]+) IDR\\s*\\n?\\s*\\(?([\\d.,]+) IDR\\)?\\s*\\n?\\s*([\\d.,]+) IDR\\s*\\n?\\s*([\\d.,]+) IDR\\s*\\n?\\s*([\\d.,]+) IDR";
            String pattern = "(?i)Total Item Net Value\\s+DP\\s*(\\d+)%\\s+(?:Total Value\\s+)?(?:Value Added Tax \\(\\%\\)\\s+)?(?:Total\\s+)?(?:Total Balance\\s+)?([\\d.,]+) IDR\\s+\\(?([\\d.,]+) IDR\\)?\\s+([\\d.,]+) IDR\\s+([\\d.,]+) IDR";
            String invoiceNumber = InvoicePDFHilti.extractRegexInvoice(text, patternInvoice);
            String date = InvoicePDFHilti.extractRegex(text, patternTgl);
            String customerName = InvoicePDFHilti.extractValue(text, patternCus);
            String vatNumber = InvoicePDFHilti.extractRegex(text, patternVAT);
            String dpp = InvoicePDFHilti.sumTotal(text, pattern, 4);
            String vatt = InvoicePDFHilti.sumTotal(text, pattern, 5);
            String ttll = InvoicePDFHilti.sumTotal(text, pattern, 6);
            String jmldp = InvoicePDFHilti.sumTotal(text, pattern, 1);
            String patterndy = "(?i)(Ppn-\\d+\\s?%|VAT\\s*\\d+\\s?%)\\s+([\\d.,]+)\\s+([\\d.,]+)";
            String vat = InvoicePDFHilti.extractVAT(text, patterndy, 3);
            String base = InvoicePDFHilti.extractVAT(text, patterndy, 2);
            String dynamicPattern = "(?i)(Net\\s*Total|Total)[:\\s]*([$\u20acRp]?\\s*[\\d.,]+)";
            String amnt = InvoicePDFHilti.extractValue(text, dynamicPattern);
            String combinedPattern = "(?i)Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*(Tagihan\\s*(?:Down\\s*Payment|Installment|Material\\s*on\\s*Site|VO|Progress)\\s*(?:\\(\\d+,?\\d*%\\))?(?:\\s*Month\\s*\\d+)?\\s*[\\w\\s&-]+?)\\s*([\\d.,]+)\\s*(?:\\(\\s*Untuk\\s*(?:Proyek|Project)\\s*([\\w\\s&-]+(?:\\s+[\\w\\s&-]+)*)?)\\)?|Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*([\\w\\s%.,()-]+?)\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*([\\d.,]+)\\s*(?:For servicing of\\s*(\\d+)\\s*Elevator\\s*(.*))?";
            String detail = InvoicePDFHilti.detailDataProduc(text, combinedPattern);
            String productRegex = "(?m)(\\d+)\\s+(\\d+)\\s+(.*?)\\s+([\\d\u00a0]+)\\s+(Each|Meter)\\s+([\\d.,]+)\\s+IDR\\s*/\\s*\\d+\\s+Each\\s*(\\d{1,2}\\s?%)\\s+([\\d.,]+)";
            String productRegex3 = "(?m)(\\d+)\\s+\\d+\\s+(.*?)\\s+([\\d\u00a0]+)\\s+(?:Each|Meter)\\s+([\\d.,]+)\\s+IDR\\s*/\\s*\\d+\\s+Each\\s*\\d{1,2}\\s?%\\s+([\\d.,]+)";
            String productRegex22 = "(?m)(\\d+)\\s+\\d+\\s+(.*?)\\s+([\\d\u00a0]+)\\s+(?:Each|Meter)?\\s*([\\d.,]+)\\s+IDR\\s*/\\s*\\d+\\s+(?:Each|Meter)?\\s*\\d{1,2}\\s?%\\s+([\\d.,]+)";
            String productRegex4 = "(?s)(\\d+)\\s+\\d+\\s+(.*?)\\s+([\\d\u00a0]+)\\s+(?:Each|Meter)?\\s*([\\d.,]+)\\s+IDR\\s*/\\s*\\d+\\s+(?:Each|Meter)\\s*\\d{1,2}\\s?%\\s+([\\d.,]+)";
            String detailht = InvoicePDFHilti.detailDataProducHt(text, productRegex);
            String productRegex2 = "(?s)(\\d+)\\s+(\\d{5,7})\\s+(.*?)\\s+(\\d+[\\d\\u00A0]*)\\s+(Each|Meter)\\s+([\\d.,]+)\\s+IDR\\s*/\\s*\\d+\\s+(?:Each|Meter).*?(\\d{1,2}\\s?%)\\s+([\\d.,]+)";
            String detail2 = InvoicePDFHilti.detailPrdk(text, productRegex2);
            String string = "Extracted Invoice Details:\nInvoice Number: " + invoiceNumber + "\nDate: " + date + "\nnama pembeli : " + customerName + "\nvat number: " + vatNumber + "\nvat hilti: " + vatt + "\ndpp hilti: " + dpp + "\nttl  hilti: " + ttll + "\njml dp: " + jmldp + "\nvat: " + vat + "\ndpp: " + base + "\nttl : " + amnt + "\ndetail product : " + detail2 + "\n\n\n------------------------ \n\nttl : " + texteks + "\n\n\n------------------------ \n\n (text) " + text + "\n";
            return string;
        }
        catch (Exception e) {
            return "Error reading PDF: " + e.getMessage();
        }
    }

    public static String sumTotal(String text, String pattern, int pil) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(text);
        if (m.find()) {
            System.out.println("DP %: " + m.group(1));
            System.out.println("Total Item Net Value: " + m.group(2));
            System.out.println("DP Value: " + m.group(3));
            System.out.println("Total Value: " + m.group(4));
            System.out.println("VAT: " + m.group(5));
            System.out.println("Total Balance: " + m.group(5));
            String baseAmountRaw = m.group(3);
            String baseVat = m.group(4);
            String baseTotal = m.group(5);
            String dp = m.group(1);
            if (pil == 1) {
                return dp;
            }
            if (pil == 4) {
                return InvoicePDFHilti.normalizeNumber(baseAmountRaw);
            }
            if (pil == 5) {
                return InvoicePDFHilti.normalizeNumber(baseVat);
            }
            if (pil == 6) {
                return InvoicePDFHilti.normalizeNumber(baseTotal);
            }
            return "-";
        }
        return "not found";
    }

    public static String detailPrdk(String text, String patternss) {
        Pattern r = Pattern.compile(patternss);
        Matcher m = r.matcher(text);
        StringBuilder result = new StringBuilder();
        while (m.find()) {
            result.append("  - Line: ").append(m.group(1)).append("\n");
            result.append("  - deskripsi: ").append(m.group(3).replaceAll("\\s+", " ").trim()).append("\n");
            result.append("  - qty: ").append(m.group(4).replaceAll("[^\\d]", "")).append("\n");
            result.append("  - net price: ").append(m.group(6)).append("\n");
            result.append("  - netvalue: ").append(m.group(8)).append("\n\n\n");
            System.out.println();
        }
        return result.toString();
    }

    public static String detailDataProducHt(String text, String patternss) {
        Pattern r = Pattern.compile(patternss);
        Matcher prodMatcher = r.matcher(text);
        StringBuilder result = new StringBuilder();
        boolean found = false;
        Matcher m = Pattern.compile(patternss).matcher(text);
        while (m.find()) {
            System.out.println("\u2714 Match ditemukan!");
            for (int i = 1; i <= m.groupCount(); ++i) {
                System.out.println("Group " + i + ": " + m.group(i));
            }
        }
        while (prodMatcher.find()) {
            found = true;
            result.append("  - Line: ").append(prodMatcher.group(1)).append("\n");
            result.append("    Code: ").append(prodMatcher.group(2)).append("\n");
            result.append("    Desc: ").append(prodMatcher.group(3)).append("\n");
            result.append("    Qty: ").append(prodMatcher.group(4).replaceAll("[^\\d]", "")).append(" ").append(prodMatcher.group(5)).append("\n");
            result.append("    Net Price: ").append(prodMatcher.group(6)).append("\n");
            result.append("    Tax: ").append(prodMatcher.group(7)).append("\n");
            result.append("    Net Value: ").append(prodMatcher.group(8)).append("\n\n");
        }
        if (!found) {
            result.append("Data tidak ditemukan.");
        }
        return result.toString();
    }

    public static String detailDataProduc(String text, String patternss) {
        Pattern pattern = Pattern.compile(patternss);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String buildingName;
            String dpDescription = matcher.group(1) != null ? matcher.group(1) : "Not Found";
            String dpAmount = matcher.group(2) != null ? matcher.group(2) : "Not Found";
            String projectName = matcher.group(3) != null ? matcher.group(3).trim() : "Not Found";
            System.out.println("dp " + matcher.group(2) + " des " + dpDescription);
            String description = matcher.group(4) != null ? matcher.group(4).trim() : "Not Found";
            String startDate = matcher.group(5) != null ? matcher.group(5) : "Not Found";
            String endDate = matcher.group(6) != null ? matcher.group(6) : "Not Found";
            String amount = matcher.group(7) != null ? matcher.group(7) : "Not Found";
            String elevatorCount = matcher.group(8) != null ? matcher.group(8) : "Not Found";
            String string = buildingName = matcher.group(9) != null ? matcher.group(9).trim() : "Not Found";
            if (!dpAmount.equals("Not Found")) {
                System.out.println("Description: " + dpDescription);
                System.out.println("Down Payment Amount: " + dpAmount);
                System.out.println("Project Name: " + projectName);
                return dpDescription + " untuk project " + projectName;
            }
            System.out.println("Description: " + description);
            System.out.println("Start Date: " + startDate);
            System.out.println("End Date: " + endDate);
            System.out.println("Amount: " + amount);
            System.out.println("Servicing Details: " + elevatorCount + " Elevator " + buildingName);
            return description + " " + startDate + " " + endDate + " For servicing of " + elevatorCount + " Elevator " + buildingName;
        }
        return "not found";
    }

    public static String extractValueCus(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String extractedValue = matcher.group(1).trim();
            return extractedValue;
        }
        return "not found";
    }

    public static String extractValue(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String label = matcher.group(1).trim();
            String amount = matcher.group(2).trim();
            return amount;
        }
        return "not found";
    }

    public static String extractVAT(String text, String pattern, int pil) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String vatType = matcher.group(1).trim();
            String baseAmountRaw = matcher.group(2).trim();
            String vatAmountRaw = matcher.group(3).trim();
            if (pil == 2) {
                return InvoicePDFHilti.normalizeNumber(baseAmountRaw);
            }
            return InvoicePDFHilti.normalizeNumber(vatAmountRaw);
        }
        return "not found";
    }

    private static String normalizeNumber(String input) {
        boolean hasDotDecimal;
        boolean hasCommaDecimal = input.contains(",") && input.lastIndexOf(",") > input.lastIndexOf(".");
        boolean bl = hasDotDecimal = input.contains(".") && input.lastIndexOf(".") > input.lastIndexOf(",");
        if (hasCommaDecimal) {
            input = input.replaceAll("\\.", "").replace(",", ".");
        } else if (hasDotDecimal) {
            input = input.replaceAll(",", "");
        }
        double number = Double.parseDouble(input);
        DecimalFormat df = new DecimalFormat("##.00", DecimalFormatSymbols.getInstance(Locale.US));
        return df.format(number);
    }

    private static String extractRegex(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1) : "Not Found";
    }

    private static String extractRegexInvoice(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(text);
        if (m.find()) {
            return m.group(1) != null ? m.group(1) : m.group(2);
        }
        return "not found";
    }
}

