/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.tika.Tika;

public class InvoicePDF2 {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(InvoicePDF2::createAndShowGUI);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Invoice PDF Reader");
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 400);
        frame.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        JButton openButton = new JButton("Open Invoice PDF");
        openButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            int result = fileChooser.showOpenDialog(frame);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String extractedData = InvoicePDF2.extractInvoiceData(selectedFile);
                textArea.setText(extractedData);
            }
        });
        frame.add((Component)new JScrollPane(textArea), "Center");
        frame.add((Component)openButton, "South");
        frame.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractInvoiceData(File file) {
        try (PDDocument document = PDDocument.load((File)file);){
            PDFTextStripper stripper = new PDFTextStripper();
            String text = stripper.getText(document);
            Tika tika = new Tika();
            String text2 = tika.parseToString(file);
            String invoiceNumber = InvoicePDF2.extractRegex(text, "Invoice No[:\\s]*(\\d+)");
            String date = InvoicePDF2.extractRegex(text, "Date[:\\s]*(\\d{2}\\.\\d{2}\\.\\d{4})");
            String patternNew = "(?i)VAT%\\s*\\n\\s*\\d{1,2}[.,]\\d{2}\\s*\\n\\s*([\\d.,]+)\\s*\\n\\s*([\\d.,]+)\\s*\\n\\s*([\\d.,]+)";
            String vat22 = InvoicePDF2.extractVATFromVertical(text, 3);
            String dpp2 = InvoicePDF2.extractVATFromVertical(text, 4);
            String patterndy = "(?i)(Ppn-\\d+\\s?%|VAT\\s*\\d+\\s?%)\\s+([\\d.,]+)\\s+([\\d.,]+)";
            String vat = InvoicePDF2.extractVAT(text, patterndy, 3);
            String base = InvoicePDF2.extractVAT(text, patterndy, 2);
            String dynamicPattern = "(?i)(Net\\s*Total|Total)[:\\s]*([$\u20acRp]?\\s*[\\d.,]+)";
            String amnt = InvoicePDF2.extractValue(text, dynamicPattern);
            String billingPattern = "(?i)Billing Name(?:\\s*\\(.*?\\))?[:\\s]*([\\w.,&\\- ]+)";
            String customerName = InvoicePDF2.extractValueCus(text, billingPattern);
            String combinedPattern2 = "(?i)Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*(Tagihan\\s*(?:Down\\s*Payment|Installment)\\s*\\(\\d+,?\\d*%\\)(?:\\s*Month\\s*\\d+)?\\s*untuk\\s*Pemasangan\\s*Elevator\\s*[^\\d]+?)\\s*([\\d.,]+)\\s*(?:\\(\\s*Untuk\\s*(?:Proyek|Project)\\s*([\\w\\s&-]+(?:\\s+[\\w\\s&-]+)*)?)\\)?|Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*([\\w\\s%.,()-]+?)\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*([\\d.,]+)\\s*(?:For servicing of\\s*(\\d+)\\s*Elevator\\s*(.*))?";
            String combinedPatternda = "(?i)Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*(Tagihan\\s*(?:Down\\s*Payment|Installment|Material\\s*on\\s*Site)\\s*(?:\\(\\d+,?\\d*%\\))?(?:\\s*Month\\s*\\d+)?\\s*untuk\\s*[^\\d]+?)\\s*([\\d.,]+)\\s*\\(\\s*Untuk\\s+([^)]+)\\)|Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*([\\w\\s%.,()-]+?)\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*([\\d.,]+)\\s*(?:For servicing of\\s*(\\d+)\\s*Elevator\\s*(.*))?";
            String combinedPattern = "(?i)Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*(Tagihan\\s*.*?)(?=\\s*[\\d.,]+)\\s*([\\d.,]+)\\s*\\(\\s*Untuk\\s+([^)]+)\\)|Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*([\\w\\s%.,()-]+?)\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*([\\d.,]+)\\s*(?:For servicing of\\s*(\\d+)\\s*(Elevator|Escalator|Lift|Esca\\s*vator)\\s*(.*))?";
            String combinedPatterns = "(?i)Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*(Tagihan\\s*(?:Down\\s*Payment|Installment|Material\\s*on\\s*Site|VO|Progress|BL)\\s*(?:\\(\\d+,?\\d*%\\))?(?:\\s*Month\\s*\\d+)?\\s*[\\w\\s&().,%:-]+?)\\s*([\\d.,]+)\\s*(?:\\(\\s*Untuk\\s*(?:Proyek|Project)\\s*([\\w\\s&().,%:-]+(?:\\s+[\\w\\s&().,%:-]+)*)?)\\)?|Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*([\\w\\s%.,()-]+?)\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*([\\d.,]+)\\s*(?:For servicing of\\s*(\\d+)\\s*Elevator\\s*(.*))?";
            String detail = InvoicePDF2.detailDataProduc(text2, combinedPattern);
            String string = "Extracted Invoice Details:\nInvoice Number: " + invoiceNumber + "\nDate: " + date + "\nVAT: " + vat22 + "\nDPP: " + dpp2 + "\nTotal: " + amnt + "\nMaintenance: " + InvoicePDF2.extractMaintenance(text) + "\nMaintenance (alt): " + InvoicePDF2.extractMaintenancer(text) + "\nNama Pembeli: " + customerName + "\nTagihan  gabung " + InvoicePDF2.cekValue(text) + "\nDetail Produk: " + detail + "\n(Raw Text): " + text + "\n(Raw Text): " + text2 + "\n";
            return string;
        }
        catch (Exception e) {
            return "Error reading PDF: " + e.getMessage();
        }
    }

    public static String extractTagihanKonvensional(String text) {
        String patternStr = "(?i)Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*(Tagihan\\s*.*?)(?=\\s*[\\d.,]+)\\s*([\\d.,]+)\\s*\\(\\s*Untuk\\s+([^)]+)\\)";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String keterangan = matcher.group(1).trim();
            String amount = matcher.group(2).trim();
            String untuk = matcher.group(3).trim();
            return "Tipe: Konvensional\nKeterangan: " + keterangan + "\nAmount: " + amount + "\nUntuk: " + untuk;
        }
        return "false";
    }

    public static String cekValue(String text) {
        if (InvoicePDF2.extractTagihanKonvensional(text).equalsIgnoreCase("false")) {
            return InvoicePDF2.extractMaintenancer(text);
        }
        return InvoicePDF2.extractTagihanKonvensional(text);
    }

    public static String extractTagihanMaintenance(String text) {
        String patternStr = "(?i)Amount(?:\\(Jumlah\\))?\\s*\\(IDR\\)\\s*([\\w\\s%.,()/:-]+?)\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*(\\d{2}\\.\\d{2}\\.\\d{4})?\\s*([\\d.,]+)\\s*(?:For servicing of\\s*(\\d+)\\s*(Elevator|Escalator|Lift|Esca\\s*vator)\\s*(.*))?";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String deskripsi = matcher.group(1) != null ? matcher.group(1).trim() : "Not Found";
            String tanggalMulai = matcher.group(2) != null ? matcher.group(2).trim() : "Not Found";
            String tanggalAkhir = matcher.group(3) != null ? matcher.group(3).trim() : "Not Found";
            String amount = matcher.group(4) != null ? matcher.group(4).trim() : "Not Found";
            String jumlahUnit = matcher.group(5) != null ? matcher.group(5).trim() : "Not Found";
            String jenisUnit = matcher.group(6) != null ? matcher.group(6).trim() : "Not Found";
            String lokasi = matcher.group(7) != null ? matcher.group(7).trim() : "Not Found";
            return "Tipe: Maintenance\nDeskripsi: " + deskripsi + "\nTanggal: " + tanggalMulai + " - " + tanggalAkhir + "\nAmount: " + amount + "\nJumlah Unit: " + jumlahUnit + "\nJenis Unit: " + jenisUnit + "\nLokasi: " + lokasi;
        }
        return "false";
    }

    public static String extractMaintenanceWithoutAmount(String text) {
        String patternStr = "(?i)(Maintenance[\\s\\S]*?)Total";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String maintenanceText = matcher.group(1).trim();
            maintenanceText = maintenanceText.replaceAll("\\b\\d{1,3}(?:[.,]\\d{3})*(?:[.,]\\d{2})\\b", "").trim();
            maintenanceText = maintenanceText.replaceAll("(?m)^[ \t]*\r?\n", "");
            return maintenanceText;
        }
        return "Tidak ditemukan.";
    }

    public static String extractMaintenancer(String text) {
        String patternStr = "(?i)(Maintenance[\\s\\S]*?)\\s+(\\d{1,3}(?:[.,]\\d{3})*(?:[.,]\\d{2}))\\s*\\n([\\s\\S]*?)\\s*Total";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String maintenanceDetail = matcher.group(1).trim();
            String amount = matcher.group(2).trim();
            String servicingDetail = matcher.group(3).trim();
            return "Detail: " + maintenanceDetail + " " + servicingDetail + " | Amount: " + amount;
        }
        return "Tidak ditemukan.";
    }

    public static String extractMaintenancey(String text) {
        String patternStr = "(?i)(Maintenance[\\s\\S]*?)(?=\\s*\\d{1,3}(?:[.,]\\d{3})*(?:[.,]\\d{2})?\\s*Total)\\s*\\d{1,3}(?:[.,]\\d{3})*(?:[.,]\\d{2})?\\s*Total";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String maintenanceText = matcher.group(1).trim();
            return maintenanceText;
        }
        return "Tidak ditemukan.";
    }

    public static String extractMaintenancex(String text) {
        String patternStr = "(?i)(Maintenance[\\s\\S]*?)\\s*(\\d{1,3}(?:[.,]\\d{3})+(?:[.,]\\d{2}))\\s*[\\s\\S]*?Total";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String maintenanceDetail = matcher.group(1).trim();
            String amount = matcher.group(2).trim();
            return "Detail: " + maintenanceDetail + " | Amount: " + amount;
        }
        return "Tidak ditemukan.";
    }

    public static String extractMaintenance(String text) {
        String patternStr = "(?i)(Maintenance[\\s\\S]*?)\\s*(?:\\d{1,3}(?:[.,]\\d{3})*(?:[.,]\\d{2})?\\s*)*Total";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String maintenanceText = matcher.group(1).trim();
            return maintenanceText;
        }
        return "Tidak ditemukan.";
    }

    public static String extractMaintenance3(String text) {
        String patternStr = "(?i)(Maintenance[\\s\\S]*?)Total";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String maintenanceText = matcher.group(1).trim();
            maintenanceText = maintenanceText.replaceAll("\\d{1,3}(?:[.,]\\d{3})*(?:[.,]\\d{2})?", "").trim();
            maintenanceText = maintenanceText.replaceAll("(?m)^[ \t]*\r?\n", "");
            return maintenanceText;
        }
        return "Tidak ditemukan.";
    }

    public static String extractMaintenance2(String text) {
        String patternStr = "(?i)(Maintenance(?:(?!\\d{1,3}(?:[.,]\\d{3})*(?:[.,]\\d{2})?).)*?)Total";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String maintenanceText = matcher.group(1).trim();
            return maintenanceText;
        }
        return "Tidak ditemukan.";
    }

    public static String maintenance(String text) {
        Pattern pattern = Pattern.compile("(?i)(Maintenance[\\w\\s.,:/()-]*?)\\s*(?:For servicing of\\s*(\\d+)\\s*(Elevator|Escalator|Lift|Esca\\s*vator)\\s*(.*))?");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String maintenanceDesc = matcher.group(1) != null ? matcher.group(1).trim() : "Not Found";
            String jumlahUnit = matcher.group(2) != null ? matcher.group(2).trim() : "Not Found";
            String jenisUnit = matcher.group(3) != null ? matcher.group(3).trim() : "Not Found";
            String lokasi = matcher.group(4) != null ? matcher.group(4).trim() : "Not Found";
            System.out.println("Maintenance: " + maintenanceDesc);
            System.out.println("Jumlah Unit: " + jumlahUnit);
            System.out.println("Jenis: " + jenisUnit);
            System.out.println("Lokasi: " + lokasi);
            return "Maintenance: " + maintenanceDesc + " | Jumlah Unit: " + jumlahUnit + " | Jenis: " + jenisUnit + " | Lokasi: " + lokasi;
        }
        return "Tidak ditemukan.";
    }

    public static String detailDataProduc(String text, String patternss) {
        Pattern pattern = Pattern.compile(patternss);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String buildingName;
            String dpDescription = matcher.group(1) != null ? matcher.group(1) : "Not Found";
            String dpAmount = matcher.group(2) != null ? matcher.group(2) : "Not Found";
            String projectName = matcher.group(3) != null ? matcher.group(3).trim() : "Not Found";
            System.out.println("dp " + matcher.group(2) + " des " + dpDescription);
            String description = matcher.group(4) != null ? matcher.group(4).trim() : "Not Found";
            String startDate = matcher.group(5) != null ? matcher.group(5) : "Not Found";
            String endDate = matcher.group(6) != null ? matcher.group(6) : "Not Found";
            String amount = matcher.group(7) != null ? matcher.group(7) : "Not Found";
            String elevatorCount = matcher.group(8) != null ? matcher.group(8) : "Not Found";
            String jenis = matcher.group(9) != null ? matcher.group(9).trim() : "Not Found";
            String string = buildingName = matcher.group(10) != null ? matcher.group(10).trim() : "Not Found";
            if (!dpAmount.equals("Not Found")) {
                System.out.println("Description: " + dpDescription);
                System.out.println("Down Payment Amount: " + dpAmount);
                System.out.println("Project Name: " + projectName);
                return dpDescription + " ( untuk  " + projectName + " )";
            }
            System.out.println("Description: " + description);
            System.out.println("Start Date: " + startDate);
            System.out.println("End Date: " + endDate);
            System.out.println("Amount: " + amount);
            System.out.println("Servicing Details: " + elevatorCount + jenis + buildingName);
            return description + " " + startDate + " " + endDate + " For servicing of " + elevatorCount + " " + jenis + " " + buildingName;
        }
        return "not found";
    }

    public static String extractValueCus(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String extractedValue = matcher.group(1).trim();
            return extractedValue;
        }
        return "not found";
    }

    public static String extractValue(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String label = matcher.group(1).trim();
            String amount = matcher.group(2).trim();
            return amount;
        }
        return "not found";
    }

    public static String extractVATFromVertical2(String text, int pil) {
        String patternID = "(?i)VAT\\s*\\d{1,2}[.,]\\d{2}\\s*%\\s*(?:\\n|\\s)*([\\d\\.]+,[\\d]{2})(?:\\n|\\s)*([\\d\\.]+,[\\d]{2})(?:\\n|\\s)*([\\d\\.]+,[\\d]{2})";
        String patternus = "(?i)VAT%\\s*\\d{1,2}[.,]\\d{2}\\s*\\n+\\s*([\\d.,]+)\\s*\\n+\\s*([\\d.,]+)\\s*\\n+\\s*([\\d.,]+)";
        String patternid = "(?i)VAT\\s*\\d{1,2}[.,]\\d{2}\\s*%\\s*([\\d.,]+)\\s*\\n+\\s*([\\d.,]+)\\s*\\n+\\s*([\\d.,]+)";
        Pattern pattern = Pattern.compile(patternid);
        Matcher matcher = pattern.matcher(text);
        boolean isIDFormat = matcher.find();
        System.out.println("cek value idformat " + isIDFormat);
        if (!isIDFormat) {
            pattern = Pattern.compile(patternus);
            matcher = pattern.matcher(text);
        }
        if (matcher.find()) {
            String total = matcher.group(1).trim();
            String base = matcher.group(2).trim();
            String vat = matcher.group(3).trim();
            System.out.println("cek total " + total + " base " + base + " vattnyaa " + vat);
            if (pil == 2) {
                return InvoicePDF2.normalizeNumber2(base);
            }
            if (pil == 4) {
                return InvoicePDF2.normalizeNumber2(total);
            }
            return InvoicePDF2.normalizeNumber2(vat);
        }
        return "not found";
    }

    private static String normalizeNumber2(String input) {
        if (input.contains(",")) {
            return input.replace(".", "").replace(",", ".");
        }
        return input.replace(",", "");
    }

    public static String extractVATFromVertical(String text, int pil) {
        String pattern = "(?i)VAT%\\s*\\d{1,2}[.,]\\d{2}\\s*\\n+\\s*([\\d.,]+)\\s*\\n+\\s*([\\d.,]+)\\s*\\n+\\s*([\\d.,]+)";
        String patternID = "(?i)VAT\\s*\\d{1,2}[.,]\\d{2}\\s*%\\s*(?:\\n|\\s)*([\\d\\.]+,[\\d]{2})(?:\\n|\\s)*([\\d\\.]+,[\\d]{2})(?:\\n|\\s)*([\\d\\.]+,[\\d]{2})";
        String patternid = "(?i)VAT\\s*\\d{1,2}[.,]\\d{2}\\s*%\\s*([\\d.,]+)\\s*\\n+\\s*([\\d.,]+)\\s*\\n+\\s*([\\d.,]+)";
        String patternCombined = "(?i)VAT%?\\s*\\d{1,2}[.,]\\d{2}\\s*%?\\s*(?:\\n+\\s*)?([\\d.,]+)\\s*\\n+\\s*([\\d.,]+)\\s*\\n+\\s*([\\d.,]+)";
        Pattern regex = Pattern.compile(patternCombined);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String total = matcher.group(1).trim();
            String base = matcher.group(2).trim();
            String vat = matcher.group(3).trim();
            System.out.println("pppp " + base + " " + vat + " dpp " + total);
            if (pil == 2) {
                return InvoicePDF2.normalizeNumber(base);
            }
            if (pil == 4) {
                return InvoicePDF2.normalizeNumber(total);
            }
            return InvoicePDF2.normalizeNumber(vat);
        }
        return "not found";
    }

    public static String extractVAT(String text, String pattern, int pil) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String vatType = matcher.group(1).trim();
            String baseAmountRaw = matcher.group(2).trim();
            String vatAmountRaw = matcher.group(3).trim();
            if (pil == 2) {
                return InvoicePDF2.normalizeNumber(baseAmountRaw);
            }
            return InvoicePDF2.normalizeNumber(vatAmountRaw);
        }
        return "not found";
    }

    private static String normalizeNumber(String input) {
        boolean hasDotDecimal;
        boolean hasCommaDecimal = input.contains(",") && input.lastIndexOf(",") > input.lastIndexOf(".");
        boolean bl = hasDotDecimal = input.contains(".") && input.lastIndexOf(".") > input.lastIndexOf(",");
        if (hasCommaDecimal) {
            input = input.replaceAll("\\.", "").replace(",", ".");
        } else if (hasDotDecimal) {
            input = input.replaceAll(",", "");
        }
        double number = Double.parseDouble(input);
        DecimalFormat df = new DecimalFormat("##.00", DecimalFormatSymbols.getInstance(Locale.US));
        return df.format(number);
    }

    private static String extractRegex(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1) : "Not Found";
    }
}

