/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.tika.Tika;

public class InvoiceJKP {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(InvoiceJKP::createAndShowGUI);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Invoice PDF Reader");
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 400);
        frame.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        JButton openButton = new JButton("Open Invoice PDF");
        openButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            int result = fileChooser.showOpenDialog(frame);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String extractedData = InvoiceJKP.extractInvoiceData(selectedFile);
                textArea.setText(extractedData);
            }
        });
        frame.add((Component)new JScrollPane(textArea), "Center");
        frame.add((Component)openButton, "South");
        frame.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractInvoiceData(File file) {
        try (PDDocument document = PDDocument.load((File)file);){
            PDFTextStripper stripper = new PDFTextStripper();
            String text = stripper.getText(document);
            Tika tika = new Tika();
            String text2 = tika.parseToString(file);
            String pattern = "(?i)JOB SITE NAME:\\s*([\\w\\s.,-]+)\\s*(?:PART ORDER NO:(\\d+)\\s*([\\d.,]+)\\s*)+([\\s\\S]+?)\\s*(?:(?:\\d{1,3}(?:[.,]\\d{3})+(?:[.,]\\d{2})?)\\s*)*\\s*(?:Total|PT\\.\\s*KONE)";
            String detail = InvoiceJKP.detailJob(text, pattern);
            Map<String, String> info = InvoiceJKP.extractInvoiceInfo(text);
            Map<String, String> infoSum = InvoiceJKP.extractSummary(text);
            String date = InvoiceJKP.extractFormattedInvoiceDate(text);
            Map<String, String> info2 = InvoiceJKP.extractKwitansiInfoJKP(text);
            Map<String, String> invoJkpall = InvoiceJKP.extractFullInvoiceInfoJKPCap(text);
            Map<String, String> invoJkpSewa = InvoiceJKP.extractInvoiceSewaCap(text);
            Map<String, String> invoJkpAdm = InvoiceJKP.extractInvoiceADM(text);
            String string = "Extracted Invoice Details:\nJenis: " + invoJkpall.get("jenis") + "\nTanggal: " + invoJkpall.get("tanggal") + "\nNo Invoice: " + invoJkpall.get("noInvoice") + "\nCustomer: " + invoJkpall.get("customer") + "\nNo DN: " + invoJkpall.get("noDN") + "\nDetail Invoice: " + invoJkpall.get("detailInvoice") + "\nPPN: " + invoJkpall.get("ppn") + "\nDPP: " + invoJkpall.get("dpp") + "\nTotal: " + invoJkpall.get("total") + "\n================= \nExtracted Invoice Details (Sewa):\nJenis: " + invoJkpSewa.get("jenis") + "\nTanggal: " + invoJkpSewa.getOrDefault("tanggal", "-") + "\nNo Invoice: " + invoJkpSewa.getOrDefault("noInvoice", "-") + "\nCustomer: " + invoJkpSewa.getOrDefault("customer", "-") + "\nNo DN: " + invoJkpSewa.getOrDefault("noDN", "-") + "\nDetail Invoice: " + invoJkpSewa.getOrDefault("detailInvoice", "-") + "\nPPN: " + invoJkpSewa.getOrDefault("ppn", "-") + "\nDPP: " + invoJkpSewa.getOrDefault("dpp", "-") + "\nTotal: " + invoJkpSewa.getOrDefault("total", "-") + "\n================= \nExtracted Invoice Details (ADM):\nJenis: " + invoJkpAdm.get("jenis") + "\nTanggal: " + invoJkpAdm.getOrDefault("tanggal", "-") + "\nNo Invoice: " + invoJkpAdm.getOrDefault("noInvoice", "-") + "\nCustomer: " + invoJkpAdm.getOrDefault("customer", "-") + "\nNo DN: " + invoJkpAdm.getOrDefault("noDN", "-") + "\nDetail Invoice: " + invoJkpAdm.getOrDefault("detailInvoice", "-") + "\nPPN: " + invoJkpAdm.getOrDefault("ppn", "-") + "\nDPP: " + invoJkpAdm.getOrDefault("dpp", "-") + "\nTotal: " + invoJkpAdm.getOrDefault("total", "-") + "\n================= \nInvoice Number2: " + info2.get("noInvoice") + "\nInvoice tgl 2: " + info2.get("tanggal") + "\nInvoice cus 2: " + info2.get("customer") + "\nInvoice Number: " + info.get("invoiceNo") + "\nDate: " + date + "\nsub ttl : " + infoSum.get("subTotal") + "\ndiscount : " + infoSum.get("discount") + "\nvat: " + infoSum.get("vat") + "\ndpp: " + infoSum.get("dpp") + "\ngrand ttl : " + infoSum.get("grandTotal") + "\nnama pembeli : " + info.get("customer") + "\ndetailss : " + InvoiceJKP.extractDetailBarang(text) + "\nDtail " + InvoiceJKP.detailTransaksiToJsonV2(text) + "\ndetail product : " + detail + "\n (text) " + text + "\n";
            return string;
        }
        catch (Exception e) {
            return "Error reading PDF: " + e.getMessage();
        }
    }

    public static Map<String, String> extractFullInvoiceInfo(String text) {
        Pattern totalPattern;
        Matcher mTotal;
        Pattern ppnDppPattern;
        Matcher mPpnDpp;
        Pattern detailPattern;
        Matcher mDetail;
        Pattern dnPattern;
        Matcher mDn;
        Pattern customerPattern;
        Matcher mCustomer;
        Pattern tanggalInvoicePattern;
        Matcher mTanggalInvoice;
        HashMap<String, String> data = new HashMap<String, String>();
        if (text.toLowerCase().contains("service")) {
            data.put("jenis", "service");
        }
        if ((mTanggalInvoice = (tanggalInvoicePattern = Pattern.compile("(\\d{2}-[A-Za-z]{3}-\\d{4})\\s*(\\d{5}/KWS/\\w+/\\d{4})")).matcher(text)).find()) {
            data.put("tanggal", mTanggalInvoice.group(1).trim());
            data.put("noInvoice", mTanggalInvoice.group(2).trim());
        }
        if ((mCustomer = (customerPattern = Pattern.compile("(\\d{5}/KWS/\\w+/\\d{4})\\s*\\n\\s*([A-Z0-9][^\n\r]+)")).matcher(text)).find()) {
            data.put("customer", mCustomer.group(2).trim());
        }
        if ((mDn = (dnPattern = Pattern.compile("(DS\\d{9,})")).matcher(text)).find()) {
            data.put("noDN", mDn.group(1).trim());
        }
        if ((mDetail = (detailPattern = Pattern.compile("(MKLT\\S+\\s+[A-Za-z]+\\s+\\d{4})")).matcher(text)).find()) {
            data.put("detailInvoice", mDetail.group(1).trim());
        }
        if ((mPpnDpp = (ppnDppPattern = Pattern.compile("(?i)MKLT\\S+\\s+[A-Za-z]+\\s+\\d{4}\\s*\\n\\s*([\\d,.]+)(?:\\s*\\n[\\d,.]+){3}\\s*\\n\\s*([\\d,.]+)")).matcher(text)).find()) {
            data.put("ppn", mPpnDpp.group(1).trim());
            data.put("dpp", mPpnDpp.group(2).trim());
        }
        if ((mTotal = (totalPattern = Pattern.compile("Total\\s+([\\d,.]+)")).matcher(text)).find()) {
            data.put("total", mTotal.group(1).trim());
        }
        return data;
    }

    public static String convertDateFormat(String inputDate) {
        try {
            SimpleDateFormat originalFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
            SimpleDateFormat targetFormat = new SimpleDateFormat("dd-MM-yyyy");
            Date date = originalFormat.parse(inputDate);
            return targetFormat.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return inputDate;
        }
    }

    public static Map<String, String> extractFullInvoiceInfoJKPCap(String text) {
        Pattern totalPattern;
        Matcher mTotal;
        Pattern ppnPattern;
        Matcher mPpn;
        Pattern dppPattern;
        Matcher mDpp;
        Pattern detailPattern;
        Matcher mDetail;
        Pattern tglPattern;
        Matcher mTgl;
        Pattern dnPattern;
        Matcher mDn;
        Pattern customerPattern;
        Matcher mCustomer;
        Pattern invoicePattern;
        Matcher mInvoice;
        HashMap<String, String> data = new HashMap<String, String>();
        if (text.toLowerCase().contains("service")) {
            data.put("jenis", "service");
        }
        if ((mInvoice = (invoicePattern = Pattern.compile("No\\s+Kwitansi\\s*:\\s*(\\d{5}/KWS/\\w+/\\d{4})")).matcher(text)).find()) {
            data.put("noInvoice", mInvoice.group(1).trim());
        }
        if ((mCustomer = (customerPattern = Pattern.compile("Kepada\\s*:\\s*(.+)")).matcher(text)).find()) {
            data.put("customer", mCustomer.group(1).trim());
        }
        if ((mDn = (dnPattern = Pattern.compile("No\\s+DN\\s*:\\s*(DS\\d+)")).matcher(text)).find()) {
            data.put("noDN", mDn.group(1).trim());
        }
        if ((mTgl = (tglPattern = Pattern.compile("Jakarta,\\s*(\\d{2}-[A-Za-z]{3}-\\d{4})")).matcher(text)).find()) {
            String rawTanggal = mTgl.group(1).trim();
            data.put("tanggal", InvoiceJKP.convertDateFormat(rawTanggal));
        }
        if ((mDetail = (detailPattern = Pattern.compile("(Service Charge\\s+[A-Z0-9.-]+\\s+[A-Za-z]+\\s+\\d{4})")).matcher(text)).find()) {
            data.put("detailInvoice", mDetail.group(1).trim());
        }
        if ((mDpp = (dppPattern = Pattern.compile("Service[^\\n\\r]+\\s+(\\d{1,3}(?:[.,]\\d{3})+)")).matcher(text)).find()) {
            data.put("dpp", mDpp.group(1).trim());
        }
        if ((mPpn = (ppnPattern = Pattern.compile("PPN\\s*\\d+%\\s+(\\d{1,3}(?:[.,]\\d{3})+)")).matcher(text)).find()) {
            data.put("ppn", mPpn.group(1).trim());
        }
        if ((mTotal = (totalPattern = Pattern.compile("Total\\s+(\\d{1,3}(?:[.,]\\d{3})+)")).matcher(text)).find()) {
            data.put("total", mTotal.group(1).trim());
        }
        return data;
    }

    public static Map<String, String> extractFullInvoiceInfoJKP(String text) {
        Pattern totalPattern;
        Matcher mTotal;
        Pattern detailPattern;
        Matcher mDetail;
        Pattern dnPattern;
        Matcher mDn;
        Pattern customerPattern;
        Matcher mCustomer;
        Pattern tanggalInvoicePattern;
        Matcher mTanggalInvoice;
        HashMap<String, String> data = new HashMap<String, String>();
        if (text.toLowerCase().contains("service")) {
            data.put("jenis", "service");
        }
        if ((mTanggalInvoice = (tanggalInvoicePattern = Pattern.compile("(\\d{2}-[A-Za-z]{3}-\\d{4})\\s*(\\d{5}/KWS/\\w+/\\d{4})")).matcher(text)).find()) {
            String rawTanggal = mTanggalInvoice.group(1).trim();
            data.put("tanggal", InvoiceJKP.convertDateFormat(rawTanggal));
            data.put("noInvoice", mTanggalInvoice.group(2).trim());
        }
        if ((mCustomer = (customerPattern = Pattern.compile("(\\d{5}/KWS/\\w+/\\d{4})\\s*\\n\\s*([A-Z0-9][^\\n\\r]+)")).matcher(text)).find()) {
            data.put("customer", mCustomer.group(2).trim());
        }
        if ((mDn = (dnPattern = Pattern.compile("(DS\\d{9,})")).matcher(text)).find()) {
            data.put("noDN", mDn.group(1).trim());
        }
        if ((mDetail = (detailPattern = Pattern.compile("([A-Z0-9./-]+\\s+[A-Za-z]+\\s+\\d{4})")).matcher(text)).find()) {
            String detailInvoice = mDetail.group(1).trim();
            data.put("detailInvoice", detailInvoice);
            int end = mDetail.end();
            String afterDetail = text.substring(end);
            Pattern angkaPattern = Pattern.compile("\\d{1,3}(?:[.,]\\d{3})*(?:[.,]\\d+)?|\\d+(?:[.,]\\d+)?");
            Matcher mAngka = angkaPattern.matcher(afterDetail);
            ArrayList<String> angkaList = new ArrayList<String>();
            while (mAngka.find()) {
                angkaList.add(mAngka.group().trim());
            }
            System.out.println("Angka yang ditemukan: " + angkaList);
            if (!angkaList.isEmpty()) {
                data.put("ppn", (String)angkaList.get(0));
            } else {
                data.put("ppn", "-");
            }
            if (angkaList.size() >= 1) {
                data.put("dpp", (String)angkaList.get(angkaList.size() - 1));
            }
        }
        if ((mTotal = (totalPattern = Pattern.compile("Total\\s+([\\d,.]+)")).matcher(text)).find()) {
            data.put("total", mTotal.group(1).trim());
        }
        return data;
    }

    public static Map<String, String> extractInvoiceSewaCap(String text) {
        Pattern totalPattern;
        Matcher mTotal;
        Pattern ppnPattern;
        Matcher mPpn;
        Pattern dppPattern;
        Matcher mDpp;
        Pattern detailPattern;
        Matcher mDetail;
        Pattern tanggalPattern;
        Matcher mTanggal;
        Pattern noInvoicePattern;
        Matcher mNoInvoice;
        Pattern unitPattern;
        Matcher mUnit;
        Pattern customerPattern;
        Matcher mCustomer;
        HashMap<String, String> data = new HashMap<String, String>();
        if (text.toLowerCase().contains("sewa")) {
            data.put("jenis", "sewa");
        }
        if ((mCustomer = (customerPattern = Pattern.compile("Nama\\s*:\\s*\\n\\s*Unit\\s*:\\s*\\n\\s*(.+)")).matcher(text)).find()) {
            data.put("customer", mCustomer.group(1).trim());
        }
        if ((mUnit = (unitPattern = Pattern.compile("Unit\\s*:\\s*\\n\\s*.+\\n\\s*(MKLT\\S+)")).matcher(text)).find()) {
            data.put("unit", mUnit.group(1).trim());
        }
        if ((mNoInvoice = (noInvoicePattern = Pattern.compile("(\\d+/((RT-JKP/)?)[A-Z]+/\\d{4})")).matcher(text)).find()) {
            data.put("noInvoice", mNoInvoice.group(1).trim());
        }
        if ((mTanggal = (tanggalPattern = Pattern.compile("(\\d{1,2}-[A-Za-z]+-\\d{4})")).matcher(text)).find()) {
            data.put("tanggal", InvoiceJKP.convertDateFormatLongMonth(mTanggal.group(1).trim()));
        }
        if ((mDetail = (detailPattern = Pattern.compile("(Sewa\\s+[^\\n]*\\([^\\n]*\\)?)", 2)).matcher(text)).find()) {
            data.put("detailInvoice", mDetail.group(1).trim());
        }
        if ((mDpp = (dppPattern = Pattern.compile("Sewa\\s+[^\\n(]*\\(?[^\\n)]*\\)?\\s*\\n\\s*([\\d,.]+)", 2)).matcher(text)).find()) {
            data.put("dpp", mDpp.group(1).trim());
        }
        if ((mPpn = (ppnPattern = Pattern.compile("PPN\\s*\\n\\s*([\\d,.]+)")).matcher(text)).find()) {
            data.put("ppn", mPpn.group(1).trim());
        }
        if ((mTotal = (totalPattern = Pattern.compile("Total\\s*([\\d,.]+)")).matcher(text)).find()) {
            data.put("total", mTotal.group(1).trim());
        }
        return data;
    }

    public static Map<String, String> extractInvoiceADM(String text) {
        Pattern totalPattern;
        Matcher mTotal;
        Pattern ppnPattern;
        Matcher mPpn;
        Pattern dppPattern;
        Matcher mDpp;
        Pattern unitPattern;
        Matcher mUnit;
        Pattern customerPattern;
        Matcher mCustomer;
        HashMap<String, String> data = new HashMap<String, String>();
        if (text == null) {
            return data;
        }
        if ((text = text.replace("\r", "")).toLowerCase().contains("biaya admin")) {
            data.put("jenis", "adm");
        }
        Pattern pKepadaSame = Pattern.compile("(?i)Kepada\\s*:?\\s*([^\\n]*)");
        Matcher mKepadaSame = pKepadaSame.matcher(text);
        String customer = null;
        if (mKepadaSame.find()) {
            String grp = mKepadaSame.group(1).trim();
            if (!grp.isEmpty() && !grp.matches("(?i)^(Unit|No|Tanggal|Keterangan|Jumlah|$).*")) {
                customer = grp;
            } else {
                String[] lines;
                int pos = mKepadaSame.end();
                for (String l : lines = text.substring(pos).split("\\n")) {
                    String s = l.trim();
                    if (s.length() == 0 || s.matches("(?i)^(Unit|No|Tanggal|Keterangan|Jumlah|PPN|Total).*")) continue;
                    customer = s;
                    break;
                }
            }
        } else {
            Pattern alt = Pattern.compile("\\n\\s*([A-Z][A-Za-z .'-]{2,})\\s*\\n\\s*MKLT", 2);
            Matcher ma = alt.matcher(text);
            if (ma.find()) {
                customer = ma.group(1).trim();
            }
        }
        if (customer != null) {
            data.put("customer", customer);
        }
        if ((mCustomer = (customerPattern = Pattern.compile("(?i)\\d{3,}/ADM-OWR/[A-Z]+/\\d{4}\\s*\\n([^\\n]+)\\nMKLT")).matcher(text)).find()) {
            data.put("customer", mCustomer.group(1).trim());
        }
        if ((mUnit = (unitPattern = Pattern.compile("(?i)Unit\\s*:?\\s*\\n?\\s*(MKLT\\S+)")).matcher(text)).find()) {
            data.put("unit", mUnit.group(1).trim());
        } else {
            Pattern pMklt = Pattern.compile("(MKLT\\S+)", 2);
            Matcher mm = pMklt.matcher(text);
            if (mm.find()) {
                data.put("unit", mm.group(1).trim());
            }
        }
        Pattern noInvoicePattern = Pattern.compile("(\\d{2,}/ADM-OWR/[A-Z]+/\\d{4})", 2);
        Matcher mNoInvoice = noInvoicePattern.matcher(text);
        if (mNoInvoice.find()) {
            data.put("noInvoice", mNoInvoice.group(1).trim());
        } else {
            Pattern fallbackNo = Pattern.compile("(\\d{2,}/[A-Z0-9\\-]+/[A-Z]+/\\d{4})", 2);
            Matcher mf = fallbackNo.matcher(text);
            if (mf.find()) {
                data.put("noInvoice", mf.group(1).trim());
            }
        }
        Pattern tanggalPattern = Pattern.compile("(\\d{1,2}-[A-Za-z]+-\\d{4})");
        Matcher mTanggal = tanggalPattern.matcher(text);
        if (mTanggal.find()) {
            data.put("tanggal", InvoiceJKP.convertDateFormatLongMonth(mTanggal.group(1).trim()));
        }
        Pattern detailPattern = Pattern.compile("(?i)(Biaya\\s+Admin[^\\n]*)");
        Matcher mDetail = detailPattern.matcher(text);
        Integer detailEndPos = null;
        if (mDetail.find()) {
            String det = mDetail.group(1).trim();
            det = det.replaceAll("\\s+[\\d.,]+\\s*$", "").trim();
            data.put("detailInvoice", det);
            detailEndPos = mDetail.end();
        }
        if ((mDpp = (dppPattern = Pattern.compile("(?i)Biaya\\s+Admin[\\s\\S]*?(\\d{1,3}(?:[.,]\\d{3})+(?:[.,]\\d+)?)")).matcher(text)).find()) {
            data.put("dpp", mDpp.group(1).trim());
        }
        if ((mPpn = (ppnPattern = Pattern.compile("(?i)PPN\\s*[:%]?\\s*(?:\\d+%\\s*)?\\s*([\\d]{1,3}(?:[.,]\\d{3})*(?:[.,]\\d+)?)")).matcher(text)).find()) {
            data.put("ppn", mPpn.group(1).trim());
        }
        if ((mTotal = (totalPattern = Pattern.compile("(?i)Total\\s*[:]?\\s*([\\d]{1,3}(?:[.,]\\d{3})*(?:[.,]\\d+)?)")).matcher(text)).find()) {
            data.put("total", mTotal.group(1).trim());
        } else {
            Pattern lastNum = Pattern.compile("([\\d]{1,3}(?:[.,]\\d{3})*(?:[.,]\\d+)?)(?![\\s\\S]*[\\d{1,3}(?:[.,]\\d{3})*(?:[.,]\\d+)?])");
            Pattern numAll = Pattern.compile("([\\d]{1,3}(?:[.,]\\d{3})*(?:[.,]\\d+)?)");
            Matcher mAll = numAll.matcher(text);
            String last = null;
            while (mAll.find()) {
                last = mAll.group(1);
            }
            if (last != null) {
                data.put("total", last);
            }
        }
        return data;
    }

    private static String convertDateFormatLongMonth(String rawDate) {
        HashMap<String, String> monthMap = new HashMap<String, String>();
        monthMap.put("January", "01");
        monthMap.put("February", "02");
        monthMap.put("March", "03");
        monthMap.put("April", "04");
        monthMap.put("May", "05");
        monthMap.put("June", "06");
        monthMap.put("July", "07");
        monthMap.put("August", "08");
        monthMap.put("September", "09");
        monthMap.put("October", "10");
        monthMap.put("November", "11");
        monthMap.put("December", "12");
        for (String month : monthMap.keySet()) {
            if (!rawDate.contains(month)) continue;
            String[] parts = rawDate.split("-");
            return String.format("%02d-%s-%s", Integer.parseInt(parts[0]), monthMap.get(month), parts[2]);
        }
        return rawDate;
    }

    public static Map<String, String> extractInvoiceSewa(String text) {
        Pattern detailPatternSewa;
        Matcher mDetailSewa;
        Pattern tanggalPattern;
        Matcher mTanggal;
        Pattern noInvoicePattern;
        Matcher mNoInvoice;
        HashMap<String, String> data = new HashMap<String, String>();
        Pattern customerNamePattern = Pattern.compile("KWITANSI\\s*(\\w+)Nama");
        Matcher mCustomerName = customerNamePattern.matcher(text);
        if (mCustomerName.find()) {
            data.put("customer", mCustomerName.group(1).trim());
        }
        if ((mNoInvoice = (noInvoicePattern = Pattern.compile("No\\s+(\\d+\\/RT-JKP\\/III\\/\\d{4})")).matcher(text)).find()) {
            data.put("noInvoice", mNoInvoice.group(1).trim());
        }
        if ((mTanggal = (tanggalPattern = Pattern.compile("(\\d{1,2}-[A-Za-z]+-\\d{4})")).matcher(text)).find()) {
            String rawTanggal = mTanggal.group(1).trim();
            data.put("tanggal", InvoiceJKP.convertDateFormatLongMonth(rawTanggal));
        }
        if ((mDetailSewa = (detailPatternSewa = Pattern.compile("Sewa\\s+[^\\n\\r]*\\([^\\)]+\\)")).matcher(text)).find()) {
            String detailInvoice = mDetailSewa.group().trim();
            data.put("detailInvoice", detailInvoice);
            String afterDetail = text.substring(mDetailSewa.end());
            Pattern angkaPattern = Pattern.compile("\\d{1,3}(?:[.,]\\d{3})*(?:[.,]\\d+)?|\\d+(?:[.,]\\d+)?");
            Matcher mAngka = angkaPattern.matcher(afterDetail);
            ArrayList<String> angkaList = new ArrayList<String>();
            while (mAngka.find()) {
                angkaList.add(mAngka.group().trim());
            }
            if (!angkaList.isEmpty()) {
                data.put("ppn", (String)angkaList.get(0));
                data.put("dpp", (String)angkaList.get(angkaList.size() - 1));
            } else {
                data.put("ppn", "-");
                data.put("dpp", "-");
            }
        }
        return data;
    }

    public static List<Map<String, String>> extractDetailTransaksi(String text) {
        ArrayList<Map<String, String>> listBarang = new ArrayList<Map<String, String>>();
        String pattern = "(\\d+)\\s+(\\d{1,2}(?:\\.\\d{2,3}){1,2})\\s+-\\s+([\\s\\S]+?)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\w+)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        while (matcher.find()) {
            LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
            item.put("no", matcher.group(1));
            item.put("kode", matcher.group(2));
            item.put("nama", matcher.group(3).replaceAll("\\s+", " ").trim());
            item.put("qty", matcher.group(4));
            item.put("satuan", matcher.group(5));
            item.put("harga", matcher.group(6));
            item.put("diskon", matcher.group(7));
            item.put("vat", matcher.group(8));
            item.put("total", matcher.group(9));
            listBarang.add(item);
        }
        return listBarang;
    }

    public static Map<String, String> extractSummary(String text) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String pattern = "(?i)Sub Total\\s*:\\s*([\\d.,]+)\\s*Discount\\s*:\\s*([\\d.,]+)\\s*DPP\\s*:\\s*([\\d.,]+)\\s*VAT\\s*:\\s*([\\d.,]+)\\s*Other Tax\\s*:\\s*([\\d.,]+)\\s*Grand Total\\s*:\\s*([\\d.,]+)";
        Pattern regex = Pattern.compile(pattern, 34);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            result.put("subTotal", matcher.group(1));
            result.put("discount", matcher.group(2));
            result.put("dpp", matcher.group(3));
            result.put("vat", matcher.group(4));
            result.put("otherTax", matcher.group(5));
            result.put("grandTotal", matcher.group(6));
        }
        return result;
    }

    public static Map<String, String> extractInvoiceInfo(String text) {
        HashMap<String, String> data = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("Company\\s*:\\s*(.*?)\\n(.*?)(?=Customer\\s*:)Customer\\s*:\\s*(.*?)\\n(.*?)(?=Product Sales Invoice)Product Sales Invoice\\s*\\nNo\\s*:\\s*(\\S+)", 34);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            data.put("company", matcher.group(1).trim());
            data.put("alamatCompany", matcher.group(2).replaceAll("\\s*\n\\s*", " ").trim());
            data.put("customer", matcher.group(3).trim());
            data.put("alamatCustomer", matcher.group(4).replaceAll("\\s*\n\\s*", " ").trim());
            data.put("invoiceNo", matcher.group(5).trim());
        }
        return data;
    }

    public static Map<String, String> extractKwitansiInfoJKP(String text) {
        HashMap<String, String> data = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("(\\d{2}-[A-Za-z]{3}-\\d{4})\\s*(\\d{5}/KWS/\\w+/\\d{4})\\s*([A-Z0-9][^\n\r]*)\\s+(DS\\d{9,})", 10);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            data.put("tanggal", matcher.group(1).trim());
            data.put("noInvoice", matcher.group(2).trim());
            data.put("customer", matcher.group(3).trim());
            data.put("noDN", matcher.group(4).trim());
        }
        return data;
    }

    public static String extractVATFromVertical(String text, int pil) {
        String pattern = "(?i)(?:Ppn|VAT%)\\s*\\n\\s*\\d{1,2}[.,]\\d{2}\\s*%\\s*\\n\\s*([\\d.,]+)\\s*\\n\\s*([\\d.,]+)\\s*\\n\\s*([\\d.,]+)";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String total = matcher.group(1).trim();
            String base = matcher.group(2).trim();
            String vat = matcher.group(3).trim();
            System.out.println("pppp " + base + " " + vat + " dpp " + total);
            if (pil == 2) {
                return InvoiceJKP.normalizeNumber(base);
            }
            if (pil == 4) {
                return InvoiceJKP.normalizeNumber(total);
            }
            return InvoiceJKP.normalizeNumber(vat);
        }
        return "not found";
    }

    public static String extractDetailBarang(String text) {
        int totalIndex;
        String lastHarga;
        int lastIndex;
        ArrayList<String> namaList = new ArrayList<String>();
        ArrayList<String> hargaList = new ArrayList<String>();
        Pattern partPattern = Pattern.compile("PART ORDER NO:(\\d+)\\s+([\\d.,]+)");
        Matcher partMatcher = partPattern.matcher(text);
        while (partMatcher.find()) {
            namaList.add("PART ORDER NO:" + partMatcher.group(1));
            hargaList.add(partMatcher.group(2));
        }
        String detail = "";
        if (!hargaList.isEmpty() && (lastIndex = text.indexOf(lastHarga = (String)hargaList.get(hargaList.size() - 1))) != -1 && (totalIndex = (detail = text.substring(lastIndex + lastHarga.length()).trim()).toLowerCase().indexOf("total")) != -1) {
            detail = detail.substring(0, totalIndex).trim();
        }
        StringBuilder result = new StringBuilder("detail\n");
        for (int i = 0; i < namaList.size(); ++i) {
            result.append("  nama :  ").append((String)namaList.get(i)).append("\n");
            result.append("  Harga:  ").append((String)hargaList.get(i)).append("\n");
            if (i == namaList.size() - 1) {
                result.append("  detail  : ").append(detail).append("\n\n");
                continue;
            }
            result.append("  detail  : ''\n\n");
        }
        return result.toString();
    }

    public static String extractDetailBarangs(String text) {
        int totalIndex;
        ArrayList<String> namaList = new ArrayList<String>();
        ArrayList<String> hargaList = new ArrayList<String>();
        Pattern partPattern = Pattern.compile("PART ORDER NO:(\\d+)\\s+([\\d.,]+)");
        Matcher partMatcher = partPattern.matcher(text);
        while (partMatcher.find()) {
            namaList.add("PART ORDER NO:" + partMatcher.group(1));
            hargaList.add(partMatcher.group(2));
        }
        String detail = "";
        int lastIndex = text.lastIndexOf((String)hargaList.get(hargaList.size() - 1));
        if (lastIndex != -1 && (totalIndex = (detail = text.substring(lastIndex + ((String)hargaList.get(hargaList.size() - 1)).length()).trim()).toLowerCase().indexOf("total")) != -1) {
            detail = detail.substring(0, totalIndex).trim();
        }
        StringBuilder result = new StringBuilder("detail\n");
        for (int i = 0; i < namaList.size(); ++i) {
            result.append("  nama :  ").append((String)namaList.get(i)).append("\n");
            result.append("  Harga:  ").append((String)hargaList.get(i)).append("\n");
            if (i == namaList.size() - 1) {
                result.append("  detail  : ").append(detail).append("\n\n");
                continue;
            }
            result.append("  detail  : ''\n\n");
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String extractStructuredDetail(String text) {
        void var7_9;
        String[] lines = text.split("\\r?\\n");
        ArrayList items = new ArrayList();
        Pattern orderPattern = Pattern.compile("PART ORDER NO:(\\d+)\\s+([\\d,.]+)");
        ArrayList<String> detailsBuffer = new ArrayList<String>();
        String[] stringArray = lines;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String line = stringArray[var7_9];
            Matcher matcher = orderPattern.matcher(line.trim());
            if (matcher.find()) {
                LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
                item.put("nama", "PART ORDER NO:" + matcher.group(1));
                item.put("harga", matcher.group(2));
                item.put("detail", "");
                items.add(item);
            } else if (!line.trim().toLowerCase().startsWith("total") && !line.trim().isEmpty()) {
                detailsBuffer.add(line.trim());
            }
            ++var7_9;
        }
        if (!items.isEmpty() && !detailsBuffer.isEmpty()) {
            Map lastItem = (Map)items.get(items.size() - 1);
            lastItem.put("detail", String.join((CharSequence)" ", detailsBuffer));
        }
        StringBuilder result = new StringBuilder();
        result.append("detail\n");
        for (Map map : items) {
            result.append("  nama : ").append((String)map.get("nama")).append("\n");
            result.append("  Harga: ").append((String)map.get("harga")).append("\n");
            result.append("  detail  : ").append((String)map.get("detail")).append("\n\n");
        }
        return result.toString();
    }

    public static String detailJobs(String text, String partt) {
        Pattern r = Pattern.compile(partt);
        Matcher m = r.matcher(text);
        StringBuilder result = new StringBuilder();
        if (m.find()) {
            result.append("JOB SITE NAME: ").append(m.group(1)).append("\n");
            Pattern partOrderPattern = Pattern.compile("PART ORDER NO:(\\d+)\\s*([\\d.,]+)");
            Matcher partOrderMatcher = partOrderPattern.matcher(text);
            result.append("Part Orders:\n");
            while (partOrderMatcher.find()) {
                result.append("  - ").append(partOrderMatcher.group(1)).append(" : ").append(partOrderMatcher.group(2)).append("\n");
            }
            result.append("Detail Produk:\n").append(m.group(4).trim()).append("\n");
        } else {
            result.append("Data tidak ditemukan.");
        }
        return result.toString();
    }

    public static String detailTransaksiToJsonV2(String text) {
        StringBuilder result = new StringBuilder();
        result.append("{\n");
        result.append("  \"listBarang\": [\n");
        text = text.replaceAll("(?m)(\\d+)\\s+(\\d{4,})\\s+-\\s+(.+?)\\n([\\w\\s&/\\-]+)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\w+)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})", "$1 $2 - $3 $4 $5 $6 $7 $8 $9 $10");
        Pattern pattern = Pattern.compile("(\\d+)\\s+([\\d.]+)\\s+-\\s+([\\w\\s&\\-/]+?)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\w+)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})");
        Matcher matcher = pattern.matcher(text);
        boolean found = false;
        while (matcher.find()) {
            found = true;
            result.append("    {\n").append("      \"no\": \"").append(matcher.group(1)).append("\",\n").append("      \"kodeProduk\": \"").append(matcher.group(2)).append("\",\n").append("      \"namaProduk\": \"").append(matcher.group(3).replaceAll("\\s+", " ").trim()).append("\",\n").append("      \"qty\": \"").append(matcher.group(4).replace(".", "").replace(",", ".").trim()).append("\",\n").append("      \"satuan\": \"").append(matcher.group(5).trim()).append("\",\n").append("      \"harga\": \"").append(matcher.group(6).replace(".", "").replace(",", ".").trim()).append("\",\n").append("      \"diskon\": \"").append(matcher.group(7).replace(".", "").replace(",", ".").trim()).append("\",\n").append("      \"vat\": \"").append(matcher.group(8).replace(".", "").replace(",", ".").trim()).append("\",\n").append("      \"otherTax\": \"").append(matcher.group(9).replace(".", "").replace(",", ".").trim()).append("\",\n").append("      \"total\": \"").append(matcher.group(10).replace(".", "").replace(",", ".").trim()).append("\"\n").append("    },\n");
        }
        if (found) {
            result.setLength(result.length() - 2);
            result.append("\n");
        }
        result.append("  ],\n");
        Pattern subtotalPattern = Pattern.compile("(?i)Sub Total\\s*:\\s*([\\d.,]+)");
        Matcher subtotalMatcher = subtotalPattern.matcher(text);
        String subTotal = subtotalMatcher.find() ? subtotalMatcher.group(1) : null;
        Pattern discountPattern = Pattern.compile("(?i)Discount\\s*:\\s*([\\d.,]+)");
        Matcher discountMatcher = discountPattern.matcher(text);
        String discount = discountMatcher.find() ? discountMatcher.group(1) : null;
        result.append("  \"subTotal\": ").append(subTotal != null ? "\"" + subTotal + "\"" : "null").append(",\n");
        result.append("  \"discount\": ").append(discount != null ? "\"" + discount + "\"" : "null").append("\n");
        result.append("}");
        return result.toString();
    }

    public static String detailTransaksiToJsonV22(String text) {
        StringBuilder result = new StringBuilder();
        result.append("{\n");
        result.append("  \"listBarang\": [\n");
        text = text.replaceAll("(?m)(\\d+)\\s+(\\d{4,})\\s+-\\s+(.+?)\\n([\\w\\s&/\\-]+)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\w+)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})", "$1 $2 - $3 $4 $5 $6 $7 $8 $9 $10");
        Pattern pattern = Pattern.compile("(\\d+)\\s+([\\d.]+)\\s+-\\s+([\\w\\s&\\-/]+?)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\w+)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})");
        Matcher matcher = pattern.matcher(text);
        boolean found = false;
        while (matcher.find()) {
            found = true;
            result.append("    {\n").append("      \"no\": \"").append(matcher.group(1)).append("\",\n").append("      \"kodeProduk\": \"").append(matcher.group(2)).append("\",\n").append("      \"namaProduk\": \"").append(matcher.group(3).replaceAll("\\s+", " ").trim()).append("\",\n").append("      \"qty\": \"").append(matcher.group(4).replaceAll(".", "").replace(",", ".").trim()).append("\",\n").append("      \"satuan\": \"").append(matcher.group(5).replaceAll(".", "").replace(",", ".").trim()).append("\",\n").append("      \"harga\": \"").append(matcher.group(6).replaceAll(".", "").replace(",", ".").trim()).append("\",\n").append("      \"diskon\": \"").append(matcher.group(7).replaceAll(".", "").replace(",", ".").trim()).append("\",\n").append("      \"vat\": \"").append(matcher.group(8).replaceAll(".", "").replace(",", ".").trim()).append("\",\n").append("      \"otherTax\": \"").append(matcher.group(9).replaceAll(".", "").replace(",", ".").trim()).append("\",\n").append("      \"total\": \"").append(matcher.group(10).replaceAll(".", "").replace(",", ".").trim()).append("\"\n").append("    },\n");
        }
        if (found) {
            result.setLength(result.length() - 2);
            result.append("\n");
        }
        result.append("  ],\n");
        Pattern subtotalPattern = Pattern.compile("(?i)Sub Total\\s*:\\s*([\\d.,]+)");
        Matcher subtotalMatcher = subtotalPattern.matcher(text);
        if (subtotalMatcher.find()) {
            result.append("  \"subTotal\": \"").append(subtotalMatcher.group(1)).append("\"\n");
        } else {
            result.append("  \"subTotal\": null\n");
        }
        Pattern discountPattern = Pattern.compile("(?i)Discount\\s*:\\s*([\\d.,]+)");
        Matcher discountMatcher = discountPattern.matcher(text);
        if (discountMatcher.find()) {
            result.append("  \"discount\": \"").append(discountMatcher.group(1)).append("\"\n");
        } else {
            result.append("  \"discount\": null\n");
        }
        result.append("}");
        return result.toString();
    }

    public static String extractFormattedInvoiceDate(String text) {
        Pattern pattern = Pattern.compile("(?i)Invoice Date\\s*:\\s*(\\d{2}/[A-Za-z]{3}/\\d{4})");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String rawDate = matcher.group(1);
            try {
                SimpleDateFormat inputFormat = new SimpleDateFormat("dd/MMM/yyyy", Locale.ENGLISH);
                SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date date = inputFormat.parse(rawDate);
                return outputFormat.format(date);
            }
            catch (ParseException e) {
                return "Invalid date format";
            }
        }
        return "not found";
    }

    public static String detailTransaksiToJsonV2old(String text) {
        StringBuilder result = new StringBuilder();
        result.append("{\n");
        result.append("  \"partOrders\": [\n");
        text = text.replaceAll("(?m)^\\d+\\s+(\\d+[.\\d]+)\\s+-\\s+([^\\n]+)\\n([^\\d\\n]+)", "$1 - $2 $3");
        Pattern pattern = Pattern.compile("(\\d+)\\s+([\\d.]+)\\s+-\\s+([\\w\\s&-]+?)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\w+)\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})\\s+(\\d{1,3}(?:\\.\\d{3})*,\\d{2})");
        Matcher matcher = pattern.matcher(text);
        boolean found = false;
        while (matcher.find()) {
            found = true;
            result.append("    {\n").append("      \"no\": \"").append(matcher.group(1)).append("\",\n").append("      \"kodeProduk\": \"").append(matcher.group(2)).append("\",\n").append("      \"namaProduk\": \"").append(matcher.group(3).replaceAll("\\s+", " ").trim()).append("\",\n").append("      \"qty\": \"").append(matcher.group(4)).append("\",\n").append("      \"satuan\": \"").append(matcher.group(5)).append("\",\n").append("      \"harga\": \"").append(matcher.group(6)).append("\",\n").append("      \"diskon\": \"").append(matcher.group(7)).append("\",\n").append("      \"vat\": \"").append(matcher.group(8)).append("\",\n").append("      \"total\": \"").append(matcher.group(9)).append("\"\n").append("    },\n");
        }
        if (found) {
            result.setLength(result.length() - 2);
            result.append("\n");
        }
        result.append("  ]\n");
        result.append("}");
        return result.toString();
    }

    public static String detailJob(String text, String partt) {
        Pattern r = Pattern.compile(partt);
        Matcher m = r.matcher(text);
        StringBuilder result = new StringBuilder();
        if (m.find()) {
            result.append("{\n");
            result.append("  \"jobSiteName\": \"").append(m.group(1)).append("\",\n");
            Pattern partOrderPattern = Pattern.compile("PART ORDER NO:(\\d+)\\s*([\\d.,]+)");
            Matcher partOrderMatcher = partOrderPattern.matcher(text);
            result.append("  \"partOrders\": [\n");
            while (partOrderMatcher.find()) {
                result.append("    {\n").append("      \"partOrderNo\": \"").append(partOrderMatcher.group(1)).append("\",\n").append("      \"harga\": \"").append(partOrderMatcher.group(2)).append("\"\n").append("    },\n");
            }
            if (result.charAt(result.length() - 2) == ',') {
                result.setLength(result.length() - 2);
                result.append("\n  ],\n");
            } else {
                result.append("  ],\n");
            }
            result.append("  \"detailProduk\": \"").append(m.group(4).trim()).append("\"\n");
            result.append("}");
        } else {
            result.append("{ \"message\": \"Data tidak ditemukan.\" }");
        }
        return result.toString();
    }

    public static String detailDataProduc(String text, String patternss) {
        Pattern pattern = Pattern.compile(patternss);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String buildingName;
            String dpDescription = matcher.group(1) != null ? matcher.group(1) : "Not Found";
            String dpAmount = matcher.group(2) != null ? matcher.group(2) : "Not Found";
            String projectName = matcher.group(3) != null ? matcher.group(3).trim() : "Not Found";
            System.out.println("dp " + matcher.group(2) + " des " + dpDescription);
            String description = matcher.group(4) != null ? matcher.group(4).trim() : "Not Found";
            String startDate = matcher.group(5) != null ? matcher.group(5) : "Not Found";
            String endDate = matcher.group(6) != null ? matcher.group(6) : "Not Found";
            String amount = matcher.group(7) != null ? matcher.group(7) : "Not Found";
            String elevatorCount = matcher.group(8) != null ? matcher.group(8) : "Not Found";
            String string = buildingName = matcher.group(9) != null ? matcher.group(9).trim() : "Not Found";
            if (!dpAmount.equals("Not Found")) {
                System.out.println("Description: " + dpDescription);
                System.out.println("Down Payment Amount: " + dpAmount);
                System.out.println("Project Name: " + projectName);
                return dpDescription + " untuk project " + projectName;
            }
            System.out.println("Description: " + description);
            System.out.println("Start Date: " + startDate);
            System.out.println("End Date: " + endDate);
            System.out.println("Amount: " + amount);
            System.out.println("Servicing Details: " + elevatorCount + " Elevator " + buildingName);
            return description + " " + startDate + " " + endDate + " For servicing of " + elevatorCount + " Elevator " + buildingName;
        }
        return "not found";
    }

    public static String extractValueCus(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String extractedValue = matcher.group(1).trim();
            return extractedValue;
        }
        return "not found";
    }

    public static String extractValue(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String label = matcher.group(1).trim();
            String amount = matcher.group(2).trim();
            return amount;
        }
        return "not found";
    }

    public static String extractVAT(String text, String pattern, int pil) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String vatType = matcher.group(1).trim();
            String baseAmountRaw = matcher.group(2).trim();
            String vatAmountRaw = matcher.group(3).trim();
            if (pil == 2) {
                return InvoiceJKP.normalizeNumber(baseAmountRaw);
            }
            return InvoiceJKP.normalizeNumber(vatAmountRaw);
        }
        return "not found";
    }

    private static String extractRegex(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1) : "Not Found";
    }

    private static String normalizeNumber(String input) {
        boolean hasDotDecimal;
        boolean hasCommaDecimal = input.contains(",") && input.lastIndexOf(",") > input.lastIndexOf(".");
        boolean bl = hasDotDecimal = input.contains(".") && input.lastIndexOf(".") > input.lastIndexOf(",");
        if (hasCommaDecimal) {
            input = input.replaceAll("\\.", "").replace(",", ".");
        } else if (hasDotDecimal) {
            input = input.replaceAll(",", "");
        }
        double number = Double.parseDouble(input);
        DecimalFormat df = new DecimalFormat("##.00", DecimalFormatSymbols.getInstance(Locale.US));
        return df.format(number);
    }

    public static String standardizeDecimal(String amount) {
        if (amount == null || amount.isEmpty()) {
            return "0.00";
        }
        try {
            double value = Double.parseDouble(amount.replace(",", "."));
            return String.format("%.2f", value);
        }
        catch (NumberFormatException e) {
            return "Invalid amount";
        }
    }
}

