/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.tika.Tika;
import org.json.JSONObject;

public class InvoiceBupot {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(InvoiceBupot::createAndShowGUI);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Invoice PDF Reader");
        frame.setDefaultCloseOperation(3);
        frame.setSize(600, 400);
        frame.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        JButton openButton = new JButton("Open Invoice PDF");
        openButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            int result = fileChooser.showOpenDialog(frame);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String extractedData = InvoiceBupot.extractInvoiceData(selectedFile);
                textArea.setText(extractedData);
            }
        });
        frame.add((Component)new JScrollPane(textArea), "Center");
        frame.add((Component)openButton, "South");
        frame.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractInvoiceData(File file) {
        try (PDDocument document = PDDocument.load((File)file);){
            PDFTextStripper stripper = new PDFTextStripper();
            String text = stripper.getText(document);
            Tika tika = new Tika();
            String text2 = tika.parseToString(file);
            String regex = "(\\S+)\\s+(\\d{2}-\\d{4})\\s+(FINAL|TIDAK FINAL)\\s+(NORMAL|PEMBETULAN)";
            String bupot = InvoiceBupot.extractValueBupot(text, regex);
            String detailBupot = InvoiceBupot.extractValueDetailBupot(text);
            String identitasBupot = InvoiceBupot.extractIdentitasBupot(text);
            String jenisDokumen = InvoiceBupot.extractDokumen(text);
            System.out.println("Bupot " + bupot);
            JSONObject json = new JSONObject(bupot);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = json.getString(key);
                System.out.println(key + " :: " + value);
            }
            String string = "Extracted Invoice Details:\nIdentitas bupot " + identitasBupot + "\nbupot: " + bupot + "\n jenis dokumen " + jenisDokumen + "\ndetail bupot: " + detailBupot + "\n(Raw Text): " + text + "\n";
            return string;
        }
        catch (Exception e) {
            return "Error reading PDF: " + e.getMessage();
        }
    }

    public static String extractValueBupot(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String nobupot = matcher.group(1).trim();
            String masa = matcher.group(2).trim();
            String sifat = matcher.group(3).trim();
            String jenis = matcher.group(4).trim();
            System.out.println("Nomor Bukti : " + nobupot);
            System.out.println("Masa Pajak  : " + masa);
            System.out.println("Sifat       : " + sifat);
            System.out.println("Jenis Bukti : " + jenis);
            return "{\n  \"nomorBupot\": \"" + nobupot + "\",\n  \"masaPajak\": \"" + masa + "\",\n  \"sifat\": \"" + sifat + "\",\n  \"jenisBukti\": \"" + jenis + "\"\n}";
        }
        return "not found";
    }

    public static String extractValueBupot2(String text, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String nobupot = matcher.group(1).trim();
            String masa = matcher.group(2).trim();
            String sifat = matcher.group(3).trim();
            String jenis = matcher.group(4).trim();
            System.out.println("Nomor Bukti     : " + matcher.group(1));
            System.out.println("Masa Pajak      : " + matcher.group(2));
            System.out.println("Sifat           : " + matcher.group(3));
            System.out.println("Jenis Bukti     : " + matcher.group(4));
            return "NomorBupot " + nobupot + " masa pajak " + masa + " sifat " + sifat + " jenis " + jenis;
        }
        return "not found";
    }

    public static String extractDokumenold(String text) {
        String pattern = "Jenis Dokumen\\s*:\\s*(.*?)\\s+Tanggal\\s*:\\s*(.*?)\\s+B\\.9\\s+Nomor Dokumen\\s*:\\s*(\\d+)";
        Pattern regex = Pattern.compile(pattern, 32);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String jenisDokumen = matcher.group(1).trim();
            String tanggal = matcher.group(2).trim();
            String nomorDokumen = matcher.group(3).trim();
            return "{\n  \"jenisDokumen\": \"" + jenisDokumen + "\",\n  \"tanggal\": \"" + tanggal + "\",\n  \"nomorDokumen\": \"" + nomorDokumen + "\"\n}";
        }
        return "{}";
    }

    public static String extractDokumen(String text) {
        String pattern = "Jenis Dokumen\\s*:\\s*(.*?)\\s+Tanggal\\s*:\\s*(.*?)\\s+B\\.9\\s+Nomor Dokumen\\s*:\\s*(.*?)\\s+B\\.10";
        Pattern regex = Pattern.compile(pattern, 32);
        Matcher matcher = regex.matcher(text);
        if (matcher.find()) {
            String jenisDokumen = matcher.group(1).trim();
            String tanggal = matcher.group(2).trim();
            String nomorDokumen = matcher.group(3).trim();
            return "{\n  \"jenisDokumen\": \"" + jenisDokumen + "\",\n  \"tanggal\": \"" + tanggal + "\",\n  \"nomorDokumen\": \"" + nomorDokumen + "\"\n}";
        }
        return "{}";
    }

    public static String extractIdentitasBupot(String text) {
        String npwp = "";
        String nitku = "";
        String namaPemotong = "";
        String tanggal = "";
        String namaPenandatangan = "";
        Matcher m = Pattern.compile("C\\.1\\s+NPWP\\s*/\\s*NIK\\s*:\\s*(\\d+)").matcher(text);
        if (m.find()) {
            npwp = m.group(1).trim();
        }
        if ((m = Pattern.compile("C\\.2[\\s\\S]*?:\\s*(\\d+)\\s*-\\s*(.+)").matcher(text)).find()) {
            nitku = m.group(1).trim() + " - " + m.group(2).trim();
        }
        if ((m = Pattern.compile("C\\.3\\s+NAMA PEMOTONG[\\s\\S]*?:\\s*(.+)").matcher(text)).find()) {
            namaPemotong = m.group(1).trim();
        }
        if ((m = Pattern.compile("C\\.4\\s+TANGGAL\\s*:\\s*(.+)").matcher(text)).find()) {
            tanggal = m.group(1).trim();
        }
        if ((m = Pattern.compile("C\\.5\\s+NAMA PENANDATANGAN\\s*:\\s*(.+)").matcher(text)).find()) {
            namaPenandatangan = m.group(1).trim();
        }
        return "{\n  \"npwp\": \"" + npwp + "\",\n  \"nitku\": \"" + nitku + "\",\n  \"namaPemotong\": \"" + namaPemotong + "\",\n  \"tanggal\": \"" + tanggal + "\",\n  \"namaPenandatangan\": \"" + namaPenandatangan + "\"\n}";
    }

    public static String extractValueDetailBupot(String text) {
        Pattern tablePattern;
        Matcher tableMatcher;
        Matcher pphMatcher;
        String jenisFasil = "";
        String jenisPPh = "";
        Matcher fasilitasMatcher = Pattern.compile("(?m)^B\\.1\\s+Jenis\\s+Fasilitas\\s*:\\s*(.+)$").matcher(text);
        if (fasilitasMatcher.find()) {
            jenisFasil = fasilitasMatcher.group(1).trim();
        }
        if ((pphMatcher = Pattern.compile("(?m)^B\\.2\\s+Jenis\\s+PPh\\s*:\\s*(.+)$").matcher(text)).find()) {
            jenisPPh = pphMatcher.group(1).trim();
        }
        if ((tableMatcher = (tablePattern = Pattern.compile("(\\d{2}-\\d{3}-\\d{2})\\s+([\\s\\S]*?)\\s+(\\d{1,3}(?:\\.\\d{3})*)\\s+(\\d+(?:[.,]\\d+)?)\\s+(\\d{1,3}(?:\\.\\d{3})*)")).matcher(text)).find()) {
            String kodeObjek = tableMatcher.group(1).trim();
            String objekPajak = tableMatcher.group(2).replaceAll("\\s+", " ").trim();
            String dpp = tableMatcher.group(3).trim();
            String tarif = tableMatcher.group(4).trim();
            String pajak = tableMatcher.group(5).trim();
            return "{\n  \"jenisFasilitas\": \"" + jenisFasil + "\",\n  \"jenisPPh\": \"" + jenisPPh + "\",\n  \"kodeObjekPajak\": \"" + kodeObjek + "\",\n  \"objekPajak\": \"" + objekPajak + "\",\n  \"dpp\": \"" + dpp + "\",\n  \"tarif\": \"" + tarif + "\",\n  \"pajakPenghasilan\": \"" + pajak + "\"\n}";
        }
        return "{}";
    }

    private static String extractRegex(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1) : "Not Found";
    }
}

