/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import esindo.net.gui.MDIForm;
import esindo.net.gui.TransaksiForm;
import esindo.net.model.DAOTransaksi;
import esindo.net.model.Transaksi;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.joda.time.DateTime;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;

public class FormUbahTerpilih
extends JDialog {
    private Transaksi tra = null;
    private MDIForm mdi = null;
    private DAOTransaksi daotrans = null;
    private TransaksiForm parent = null;
    private String ids;
    private Cursor waitCursor = new Cursor(3);
    private Cursor defaultCursor = new Cursor(0);
    private JButton btnExit;
    private JButton btnSimpan;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JLabel lbltesting;
    private JRadioButton radioTidak;
    private JRadioButton radioYa;
    private JTextField txtMasaPajak;
    private JTextField txtTahunPajak;

    public FormUbahTerpilih(TransaksiForm parent, boolean modal) {
        this.parent = parent;
        this.initComponents();
        this.daotrans = new DAOTransaksi();
        this.setTitle("UBAH MASA PAJAK");
    }

    public Transaksi getTra() {
        return this.tra;
    }

    public void setTra(Transaksi tra) {
        this.tra = tra;
        this.isiForm();
    }

    public String getIds() {
        return this.ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
        this.lbltesting.setText(ids);
        this.lbltesting.setVisible(false);
    }

    public MDIForm getMdi() {
        return this.mdi;
    }

    public void setMdi(MDIForm mdi) {
        this.mdi = mdi;
    }

    private void isiForm() {
        this.lbltesting.setText(this.getIds());
        this.txtMasaPajak.setText("" + this.tra.getMasaPajak());
        this.txtTahunPajak.setText("" + this.tra.getTahunPajak());
        if (this.tra.getIsCreditable() == 1) {
            this.radioYa.setSelected(true);
        } else {
            this.radioTidak.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.txtMasaPajak = new JTextField();
        this.txtTahunPajak = new JTextField();
        this.radioYa = new JRadioButton();
        this.radioTidak = new JRadioButton();
        this.btnSimpan = new JButton();
        this.btnExit = new JButton();
        this.lbltesting = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 0)));
        this.jLabel1.setFont(new Font("Arial Unicode MS", 1, 14));
        this.jLabel1.setText("Faktur Pajak");
        this.jLabel6.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel6.setText("Masa Pajak");
        this.jLabel7.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel7.setText("Tahun Pajak");
        this.jLabel8.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel8.setText("Dapat Di Kreditkan");
        this.txtMasaPajak.setFont(new Font("Arial Unicode MS", 0, 11));
        this.txtMasaPajak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUbahTerpilih.this.txtMasaPajakActionPerformed(evt);
            }
        });
        this.txtTahunPajak.setFont(new Font("Arial Unicode MS", 0, 11));
        this.buttonGroup1.add(this.radioYa);
        this.radioYa.setFont(new Font("Arial Unicode MS", 0, 11));
        this.radioYa.setSelected(true);
        this.radioYa.setText("Ya");
        this.buttonGroup1.add(this.radioTidak);
        this.radioTidak.setFont(new Font("Arial Unicode MS", 0, 11));
        this.radioTidak.setText("Tidak");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7).addComponent(this.jLabel6).addComponent(this.jLabel8)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtMasaPajak).addComponent(this.txtTahunPajak, -1, 80, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioYa).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radioTidak))).addContainerGap(69, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel1).addGap(111, 111, 111)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.txtMasaPajak, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.txtTahunPajak, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.radioYa).addComponent(this.radioTidak)).addContainerGap(36, Short.MAX_VALUE)));
        this.btnSimpan.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnSimpan.setText("Simpan");
        this.btnSimpan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUbahTerpilih.this.btnSimpanActionPerformed(evt);
            }
        });
        this.btnExit.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnExit.setText("Exit");
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUbahTerpilih.this.btnExitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnSimpan, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnExit, -2, 92, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbltesting, -2, 61, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.lbltesting, -2, 15, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSimpan, -2, 33, -2).addComponent(this.btnExit, -2, 33, -2))).addContainerGap()));
        this.pack();
    }

    private void txtMasaPajakActionPerformed(ActionEvent evt) {
    }

    private void btnSimpanActionPerformed(ActionEvent evt) {
        this.setCursor(this.waitCursor);
        boolean data_valid = true;
        int masa_pajak = 0;
        int tahun_pajak = 0;
        try {
            masa_pajak = Integer.parseInt(this.txtMasaPajak.getText().trim());
            tahun_pajak = Integer.parseInt(this.txtTahunPajak.getText().trim());
        }
        catch (Exception e) {
            data_valid = false;
            JOptionPane.showMessageDialog(this.rootPane, "Data Masa Pajak atau Tahun Pajak Harus Angka !!");
            this.setCursor(this.defaultCursor);
        }
        String[] str = this.lbltesting.getText().trim().split(",");
        System.out.println("---------------------------");
        int jumlah_terupdate = 0;
        boolean jumlah_terupdate_pengganti = false;
        int jumlah_data = str.length;
        try {
            for (String s : str) {
                System.out.println("NOFAKTUR " + s);
                Transaksi ta = this.daotrans.findByNomorFakturNormal(s.trim());
                System.out.println("TA !!! " + ta + "TGL " + ta.getTglFakturSQL());
                System.out.println(ta.getFgPengganti() + "-" + ta.getNomorFaktur() + "-" + ta.getNpwpPenjual());
                boolean iskredit = false;
                if (ta == null) continue;
                iskredit = this.radioYa.isSelected();
                this.cekTransaksiValidUpdate(ta, masa_pajak, tahun_pajak, iskredit);
                System.out.println("LAKUKAN UPDATE " + s);
                if (ta.isValidUpdate()) {
                    ++jumlah_terupdate;
                }
                this.daotrans.updateMasaPajakMassal(ta);
            }
            if (jumlah_terupdate > 0) {
                int jum_melebihi_masa = jumlah_data - jumlah_terupdate;
                JOptionPane.showMessageDialog(this.rootPane, "DATA TERUPDATE SEJUMLAH " + jumlah_terupdate + "\n TIDAK TERUPDATE MELEBIHI MASA " + jum_melebihi_masa);
                if (this.parent.MODE_CARI == 1) {
                    this.parent.goCariSatu();
                } else if (this.parent.MODE_CARI == 2) {
                    this.parent.setCariDua(masa_pajak, tahun_pajak);
                    this.parent.goCariDua();
                } else {
                    this.parent.refreshData();
                }
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this.rootPane, "Data Masa Pajak atau Tahun Pajak TIDAK VALID !! ");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.setCursor(this.defaultCursor);
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static int selisihBulan(DateTime awal, DateTime akhir) {
        Months d = Months.monthsBetween((ReadableInstant)awal, (ReadableInstant)akhir);
        return d.getMonths();
    }

    public void cekTransaksiValidUpdate(Transaksi tra, int masa_pajak, int tahun_pajak, boolean iskredit) {
        DateTime awal = new DateTime((Object)tra.getTglFakturSQL());
        DateTime akhir = null;
        try {
            akhir = new DateTime(tahun_pajak, masa_pajak, awal.getDayOfMonth(), 0, 0, 0);
        }
        catch (IllegalFieldValueException e) {
            this.setCursor(this.defaultCursor);
            akhir = new DateTime(tahun_pajak, masa_pajak, 28, 0, 0, 0);
            akhir = new DateTime(tahun_pajak, masa_pajak, akhir.dayOfMonth().getMaximumValue(), 0, 0, 0);
        }
        if (tra.getFgPengganti().equals("0")) {
            if (FormUbahTerpilih.selisihBulan(awal, akhir) >= 0 && FormUbahTerpilih.selisihBulan(awal, akhir) <= 3) {
                tra.setMasaPajak(masa_pajak);
                tra.setTahunPajak(tahun_pajak);
                if (iskredit) {
                    tra.setIsCreditable(1);
                } else {
                    tra.setIsCreditable(0);
                }
                tra.setValidUpdate(true);
            }
        } else {
            tra.setMasaPajak(masa_pajak);
            tra.setTahunPajak(tahun_pajak);
            if (iskredit) {
                tra.setIsCreditable(1);
            } else {
                tra.setIsCreditable(0);
            }
            tra.setValidUpdate(true);
        }
    }
}

