/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import esindo.net.gui.MDIForm;
import esindo.net.gui.TransaksiForm;
import esindo.net.model.DAOTransaksi;
import esindo.net.model.Transaksi;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.joda.time.DateTime;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;

public class FormUbahMasaPajak
extends JDialog {
    private Transaksi tra = null;
    private MDIForm mdi = null;
    private DAOTransaksi daotrans = null;
    private TransaksiForm parent = null;
    private JButton btnExit;
    private JButton btnSimpan;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JLabel lblNPWP;
    private JLabel lblNamaPenjual;
    private JLabel lblNoFaktur;
    private JLabel lblTanggal;
    private JRadioButton radioTidak;
    private JRadioButton radioYa;
    private JTextField txtMasaPajak;
    private JTextField txtTahunPajak;

    public FormUbahMasaPajak(TransaksiForm parent, boolean modal) {
        this.parent = parent;
        this.initComponents();
        this.daotrans = new DAOTransaksi();
        this.setTitle("UBAH MASA PAJAK");
    }

    public Transaksi getTra() {
        return this.tra;
    }

    public void setTra(Transaksi tra) {
        this.tra = tra;
        this.isiForm();
    }

    public MDIForm getMdi() {
        return this.mdi;
    }

    public void setMdi(MDIForm mdi) {
        this.mdi = mdi;
    }

    private void isiForm() {
        this.lblNoFaktur.setText(this.tra.getNomorFaktur());
        this.lblNPWP.setText(this.tra.getNpwpPenjual());
        this.lblNamaPenjual.setText(this.tra.getNamaPenjual());
        this.lblTanggal.setText(this.tra.getTanggal());
        this.txtMasaPajak.setText("" + this.tra.getMasaPajak());
        this.txtTahunPajak.setText("" + this.tra.getTahunPajak());
        if (this.tra.getIsCreditable() == 1) {
            this.radioYa.setSelected(true);
        } else {
            this.radioTidak.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.lblNoFaktur = new JLabel();
        this.lblNPWP = new JLabel();
        this.lblNamaPenjual = new JLabel();
        this.lblTanggal = new JLabel();
        this.txtMasaPajak = new JTextField();
        this.txtTahunPajak = new JTextField();
        this.radioYa = new JRadioButton();
        this.radioTidak = new JRadioButton();
        this.btnSimpan = new JButton();
        this.btnExit = new JButton();
        this.jPanel1.setBorder(new SoftBevelBorder(1));
        this.jLabel1.setFont(new Font("Arial Unicode MS", 1, 14));
        this.jLabel1.setText("Faktur Pajak");
        this.jLabel2.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel2.setText("No.Faktur     :");
        this.jLabel3.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel3.setText("NPWP Penjual :");
        this.jLabel4.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel4.setText("Nama Penjual :");
        this.jLabel5.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel5.setText("Tanggal :");
        this.jLabel6.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel6.setText("Masa Pajak :");
        this.jLabel7.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel7.setText("Tahun Pajak : ");
        this.jLabel8.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel8.setText("Dapat Di Kreditkan :");
        this.lblNoFaktur.setFont(new Font("Arial Unicode MS", 0, 14));
        this.lblNoFaktur.setText("jLabel9");
        this.lblNPWP.setFont(new Font("Arial Unicode MS", 0, 14));
        this.lblNPWP.setText("jLabel10");
        this.lblNamaPenjual.setFont(new Font("Arial Unicode MS", 0, 14));
        this.lblNamaPenjual.setText("jLabel11");
        this.lblTanggal.setFont(new Font("Arial Unicode MS", 0, 14));
        this.lblTanggal.setText("jLabel12");
        this.txtMasaPajak.setFont(new Font("Arial Unicode MS", 0, 11));
        this.txtMasaPajak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUbahMasaPajak.this.txtMasaPajakActionPerformed(evt);
            }
        });
        this.txtTahunPajak.setFont(new Font("Arial Unicode MS", 0, 11));
        this.buttonGroup1.add(this.radioYa);
        this.radioYa.setFont(new Font("Arial Unicode MS", 0, 11));
        this.radioYa.setSelected(true);
        this.radioYa.setText("Ya");
        this.buttonGroup1.add(this.radioTidak);
        this.radioTidak.setFont(new Font("Arial Unicode MS", 0, 11));
        this.radioTidak.setText("Tidak");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel8).addComponent(this.jLabel7)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.radioYa).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radioTidak)).addComponent(this.lblNamaPenjual, -1, 234, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtTahunPajak, GroupLayout.Alignment.LEADING, -1, 44, Short.MAX_VALUE).addComponent(this.txtMasaPajak, GroupLayout.Alignment.LEADING)).addComponent(this.lblTanggal, -1, -1, Short.MAX_VALUE).addComponent(this.lblNPWP, -1, -1, Short.MAX_VALUE).addComponent(this.lblNoFaktur, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(220, Short.MAX_VALUE).addComponent(this.jLabel1).addGap(217, 217, 217)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.lblNoFaktur)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.lblNPWP)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.lblNamaPenjual)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5, -2, 23, -2).addComponent(this.lblTanggal)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.txtMasaPajak, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.txtTahunPajak, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioYa).addComponent(this.radioTidak))).addContainerGap(22, Short.MAX_VALUE)));
        this.btnSimpan.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnSimpan.setText("Simpan");
        this.btnSimpan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUbahMasaPajak.this.btnSimpanActionPerformed(evt);
            }
        });
        this.btnExit.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnExit.setText("Exit");
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUbahMasaPajak.this.btnExitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnSimpan, -2, 97, -2).addGap(18, 18, 18).addComponent(this.btnExit, -2, 92, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnSimpan, -1, 33, Short.MAX_VALUE).addComponent(this.btnExit, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void txtMasaPajakActionPerformed(ActionEvent evt) {
    }

    private void btnSimpanActionPerformed(ActionEvent evt) {
        DateTime awal;
        boolean data_valid = true;
        String fpPengganti = this.tra.getFgPengganti();
        int masa_pajak = 0;
        int tahun_pajak = 0;
        try {
            masa_pajak = Integer.parseInt(this.txtMasaPajak.getText().trim());
            tahun_pajak = Integer.parseInt(this.txtTahunPajak.getText().trim());
        }
        catch (Exception e) {
            data_valid = false;
            JOptionPane.showMessageDialog(this.rootPane, "Data Masa Pajak atau Tahun Pajak Harus Angka !!");
        }
        if (this.radioYa.isSelected()) {
            this.tra.setIsCreditable(1);
        }
        if (this.radioTidak.isSelected()) {
            this.tra.setIsCreditable(0);
        }
        if (fpPengganti.equals("0")) {
            awal = new DateTime((Object)this.tra.getTglFakturSQL());
            DateTime akhir = null;
            try {
                akhir = new DateTime(tahun_pajak, masa_pajak, awal.getDayOfMonth(), 0, 0, 0);
            }
            catch (IllegalFieldValueException e) {
                this.txtMasaPajak.setText("" + this.tra.getMasaPajak());
                akhir = new DateTime(tahun_pajak, masa_pajak, 28, 0, 0, 0);
                akhir = new DateTime(tahun_pajak, masa_pajak, akhir.dayOfMonth().getMaximumValue(), 0, 0, 0);
            }
            if (FormUbahMasaPajak.selisihBulan(awal, akhir) < 0 || FormUbahMasaPajak.selisihBulan(awal, akhir) > 3) {
                data_valid = false;
                JOptionPane.showMessageDialog(this.parent, "Masa Pajak harus lebih besar dari  Tanggal Pajak atau Maksimal 3 Bulan ", "MASA PAJAK TIDAK VALID", 2);
                this.txtMasaPajak.setText("" + this.tra.getMasaPajak());
                this.txtTahunPajak.setText("" + this.tra.getTahunPajak());
            }
        } else {
            awal = new DateTime((Object)this.tra.getTglFakturSQL());
            DateTime akhir = null;
            try {
                akhir = new DateTime(tahun_pajak, masa_pajak, awal.getDayOfMonth(), 0, 0, 0);
            }
            catch (IllegalFieldValueException e) {
                this.txtMasaPajak.setText("" + this.tra.getMasaPajak());
                akhir = new DateTime(tahun_pajak, masa_pajak, 28, 0, 0, 0);
                akhir = new DateTime(tahun_pajak, masa_pajak, akhir.dayOfMonth().getMaximumValue(), 0, 0, 0);
            }
            data_valid = true;
            JOptionPane.showMessageDialog(this.parent, "Masa Pajak yang diubah adalah Faktur Pajak Pengganti ", " ", 2);
        }
        if (data_valid) {
            try {
                this.tra.setMasaPajak(masa_pajak);
                this.tra.setTahunPajak(tahun_pajak);
                this.tra.setValidUpdate(true);
                this.daotrans.updateMasaPajak(this.tra);
                JOptionPane.showMessageDialog(this.rootPane, "DATA TERSIMPAN");
                this.parent.updateDetail(this.tra);
                this.dispose();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.parent.MODE_CARI == 1) {
            this.parent.goCariSatu();
        } else if (this.parent.MODE_CARI == 2) {
            this.parent.setCariDua(masa_pajak, tahun_pajak);
            this.parent.goCariDua();
        } else {
            this.parent.refreshData();
        }
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static int selisihBulan(DateTime awal, DateTime akhir) {
        Months d = Months.monthsBetween((ReadableInstant)awal, (ReadableInstant)akhir);
        return d.getMonths();
    }
}

