/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import esindo.net.gui.MDIForm;
import esindo.net.gui.ZRefHeader;
import esindo.net.model.DAOTransaksi;
import esindo.net.model.Transaksi;
import esindo.net.model.ZDAOGroupHeader;
import esindo.net.model.ZDAORefNoFaktur;
import esindo.net.model.ZGroupHeader;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.joda.time.DateTime;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;

public class FormUbahFaktur
extends JDialog {
    private Transaksi tra = null;
    private MDIForm mdi = null;
    private DAOTransaksi daotrans = null;
    private ZDAORefNoFaktur daoref = null;
    private ZDAOGroupHeader daogrp = null;
    private ZRefHeader parent = null;
    private String ids;
    private Cursor waitCursor = new Cursor(3);
    private Cursor defaultCursor = new Cursor(0);
    private JButton btnExit;
    private JButton btnSimpan;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel6;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JLabel lbltesting;
    private JTextField txtAttrPjk;
    private JTextField txtNilaiAwal;

    public FormUbahFaktur(ZRefHeader parent, boolean modal) {
        this.parent = parent;
        this.initComponents();
        this.daotrans = new DAOTransaksi();
        this.daoref = new ZDAORefNoFaktur();
        this.daogrp = new ZDAOGroupHeader();
        this.setTitle("UBAH REF NO FAKTUR");
    }

    public Transaksi getTra() {
        return this.tra;
    }

    public void setTra(Transaksi tra) {
        this.tra = tra;
        this.isiForm();
    }

    public String getIds() {
        return this.ids;
    }

    public void setFormNew() {
        this.btnSimpan.setVisible(false);
        this.txtNilaiAwal.setEnabled(false);
    }

    public void setIds(String ids) {
        this.ids = ids;
        this.lbltesting.setText(ids);
        this.lbltesting.setVisible(false);
        try {
            ZGroupHeader obj = this.daogrp.findByIdGroupHeader(Integer.parseInt(ids.trim()));
            this.txtNilaiAwal.setText(String.valueOf(obj.getNilai_awal()));
            this.txtAttrPjk.setText(obj.getNama_group());
        }
        catch (SQLException ex) {
            Logger.getLogger(FormUbahFaktur.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public MDIForm getMdi() {
        return this.mdi;
    }

    public void setMdi(MDIForm mdi) {
        this.mdi = mdi;
    }

    private void isiForm() {
        this.lbltesting.setText(this.getIds());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.txtNilaiAwal = new JTextField();
        this.jLabel9 = new JLabel();
        this.txtAttrPjk = new JTextField();
        this.btnSimpan = new JButton();
        this.btnExit = new JButton();
        this.lbltesting = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 0)));
        this.jLabel1.setFont(new Font("Arial Unicode MS", 1, 14));
        this.jLabel1.setText("Set Nilai Awal Efaktur");
        this.jLabel6.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel6.setText("Attribute Efaktur");
        this.txtNilaiAwal.setFont(new Font("Arial Unicode MS", 0, 11));
        this.txtNilaiAwal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUbahFaktur.this.txtNilaiAwalActionPerformed(evt);
            }
        });
        this.jLabel9.setFont(new Font("Arial Unicode MS", 0, 14));
        this.jLabel9.setText("Nilai Awal");
        this.txtAttrPjk.setFont(new Font("Arial Unicode MS", 0, 11));
        this.txtAttrPjk.setEnabled(false);
        this.txtAttrPjk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUbahFaktur.this.txtAttrPjkActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel9, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.txtNilaiAwal, -2, 177, -2).addComponent(this.txtAttrPjk, -2, 178, -2)).addContainerGap(66, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.jLabel6).addGap(12, 12, 12)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtAttrPjk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.txtNilaiAwal, -2, 51, -2)).addContainerGap(77, Short.MAX_VALUE)));
        this.btnSimpan.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnSimpan.setText("Simpan");
        this.btnSimpan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUbahFaktur.this.btnSimpanActionPerformed(evt);
            }
        });
        this.btnExit.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnExit.setText("Exit");
        this.btnExit.setPreferredSize(new Dimension(67, 23));
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormUbahFaktur.this.btnExitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lbltesting, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnSimpan, -2, 97, -2).addGap(18, 18, 18).addComponent(this.btnExit, -2, 97, -2)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lbltesting, -2, 15, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnExit, -2, 33, -2).addComponent(this.btnSimpan, -2, 33, -2))).addContainerGap()));
        this.btnExit.getAccessibleContext().setAccessibleDescription("");
        this.pack();
    }

    private void btnSimpanActionPerformed(ActionEvent evt) {
        this.setCursor(this.waitCursor);
        ZGroupHeader zr = new ZGroupHeader();
        zr.setId(Integer.valueOf(this.ids.trim()));
        zr.setNilai_awal(this.txtNilaiAwal.getText().trim());
        try {
            this.daogrp.updateGroupHeader(zr);
            JOptionPane.showMessageDialog(this.rootPane, "DATA SUKSES DI UBAH ");
            this.parent.refreshTabel();
            this.dispose();
        }
        catch (SQLException ex) {
            Logger.getLogger(FormUbahFaktur.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setCursor(this.defaultCursor);
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void txtAttrPjkActionPerformed(ActionEvent evt) {
    }

    private void txtNilaiAwalActionPerformed(ActionEvent evt) {
    }

    public static int selisihBulan(DateTime awal, DateTime akhir) {
        Months d = Months.monthsBetween((ReadableInstant)awal, (ReadableInstant)akhir);
        return d.getMonths();
    }

    public void cekTransaksiValidUpdate(Transaksi tra, int masa_pajak, int tahun_pajak, boolean iskredit) {
        DateTime awal = new DateTime((Object)tra.getTglFakturSQL());
        DateTime akhir = null;
        try {
            akhir = new DateTime(tahun_pajak, masa_pajak, awal.getDayOfMonth(), 0, 0, 0);
        }
        catch (IllegalFieldValueException e) {
            this.setCursor(this.defaultCursor);
            akhir = new DateTime(tahun_pajak, masa_pajak, 28, 0, 0, 0);
            akhir = new DateTime(tahun_pajak, masa_pajak, akhir.dayOfMonth().getMaximumValue(), 0, 0, 0);
        }
        if (tra.getFgPengganti().equals("0")) {
            if (FormUbahFaktur.selisihBulan(awal, akhir) >= 0 && FormUbahFaktur.selisihBulan(awal, akhir) <= 3) {
                tra.setMasaPajak(masa_pajak);
                tra.setTahunPajak(tahun_pajak);
                if (iskredit) {
                    tra.setIsCreditable(1);
                } else {
                    tra.setIsCreditable(0);
                }
                tra.setValidUpdate(true);
            }
        } else {
            tra.setMasaPajak(masa_pajak);
            tra.setTahunPajak(tahun_pajak);
            if (iskredit) {
                tra.setIsCreditable(1);
            } else {
                tra.setIsCreditable(0);
            }
            tra.setValidUpdate(true);
        }
    }
}

