/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import esindo.net.gui.ColumnMapping;
import esindo.net.gui.DetailBarang2;
import esindo.net.gui.Faktur2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class EFakturXlsxImporter
extends JFrame {
    private JTable tableFaktur;
    private JTable tableDetail;
    private ArrayList<Faktur2> fakturList = new ArrayList();
    private JLabel lblCount;
    private List<ColumnMapping> mappings = Arrays.asList(new ColumnMapping("NAMA", "nama", "header"), new ColumnMapping("NIK", "nik", "header"), new ColumnMapping("ALAMAT", "alamat", "header"), new ColumnMapping("EMAIL", "email", "header"), new ColumnMapping("UNIT", "unit", "header"), new ColumnMapping("NO. KW", "nomorKw", "header"), new ColumnMapping("TGL KW", "tglKw", "header"), new ColumnMapping("KETERANGAN", "keterangan", "header"), new ColumnMapping("DPP", "dpp", "detail"), new ColumnMapping("DPP Nilai Lain", "dppNilaiLain", "detail"), new ColumnMapping("PPN", "ppn", "detail"), new ColumnMapping("TOTAL", "total", "detail"), new ColumnMapping("HargaSatuan", "hargaSatuan", "detail"));

    public EFakturXlsxImporter() {
        this.setTitle("Import e-Faktur XLSX");
        this.setSize(1000, 600);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(0));
        JButton btnImport = new JButton("Import XLSX");
        btnImport.addActionListener(e -> this.importXLSX());
        this.lblCount = new JLabel("Jumlah Data: 0");
        topPanel.add(btnImport);
        topPanel.add(this.lblCount);
        this.add((Component)topPanel, "North");
        this.tableFaktur = new JTable(new DefaultTableModel(new String[]{"Nama", "NIK", "Alamat", "No KW", "Tanggal", "Keterangan", "DPP", "PPN", "Total"}, 0));
        JScrollPane scrollFaktur = new JScrollPane(this.tableFaktur);
        this.tableDetail = new JTable(new DefaultTableModel(new String[]{"DPP", "DPP Nilai Lain", "PPN", "Total", "Harga Satuan"}, 0));
        JScrollPane scrollDetail = new JScrollPane(this.tableDetail);
        JSplitPane splitPane = new JSplitPane(0, scrollFaktur, scrollDetail);
        splitPane.setDividerLocation(300);
        this.add((Component)splitPane, "Center");
        this.tableFaktur.getSelectionModel().addListSelectionListener(e -> {
            int idx = this.tableFaktur.getSelectedRow();
            if (idx >= 0) {
                this.showDetail(idx);
            }
        });
    }

    private void importXLSX() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showOpenDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            this.parseXLSX(file);
            this.refreshFakturTable();
        }
    }

    private void parseXLSX(File file) {
        this.fakturList.clear();
        try (FileInputStream fis = new FileInputStream(file);
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);){
            Sheet sheet = workbook.getSheetAt(0);
            Iterator rows = sheet.iterator();
            Row headerRow = (Row)rows.next();
            HashMap<String, Integer> colIndex = new HashMap<String, Integer>();
            for (int i = 0; i < headerRow.getLastCellNum(); ++i) {
                Cell c = headerRow.getCell(i);
                if (c == null) continue;
                String colName = c.getStringCellValue().trim();
                colIndex.put(colName, i);
            }
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                String nomorKwTemp = this.getCellString(row.getCell(((Integer)colIndex.get("NO. KW")).intValue()));
                Faktur2 f = this.fakturList.stream().filter(x -> x.nomorKw.equals(nomorKwTemp)).findFirst().orElse(null);
                if (f == null) {
                    f = new Faktur2();
                    f.nomorKw = nomorKwTemp;
                    this.fakturList.add(f);
                }
                DetailBarang2 d = new DetailBarang2();
                for (ColumnMapping m : this.mappings) {
                    int idx = colIndex.getOrDefault(m.excelColumn, -1);
                    if (idx < 0) continue;
                    String val = this.getCellString(row.getCell(idx));
                    if (m.group.equals("header")) {
                        switch (m.attribute) {
                            case "nama": {
                                f.nama = val;
                                break;
                            }
                            case "nik": {
                                f.nik = val;
                                break;
                            }
                            case "alamat": {
                                f.alamat = val;
                                break;
                            }
                            case "email": {
                                f.email = val;
                                break;
                            }
                            case "unit": {
                                f.unit = val;
                                break;
                            }
                            case "tglKw": {
                                f.tglKw = val;
                                break;
                            }
                            case "keterangan": {
                                f.keterangan = val;
                            }
                        }
                        continue;
                    }
                    if (!m.group.equals("detail")) continue;
                    switch (m.attribute) {
                        case "dpp": {
                            d.dpp = Double.valueOf(val);
                            break;
                        }
                        case "dppNilaiLain": {
                            d.dppNilaiLain = Double.valueOf(val);
                            break;
                        }
                        case "ppn": {
                            d.ppn = Double.valueOf(val);
                            break;
                        }
                        case "total": {
                            d.total = Double.valueOf(val);
                            break;
                        }
                        case "hargaSatuan": {
                            d.hargaSatuan = Double.valueOf(val);
                        }
                    }
                }
                f.details.add(d);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error parsing XLSX: " + e.getMessage());
        }
    }

    private String getCellString(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 1: {
                return cell.getStringCellValue().trim();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return new SimpleDateFormat("dd/MM/yyyy").format(cell.getDateCellValue());
                }
                DecimalFormat df = new DecimalFormat("#.##");
                return EFakturXlsxImporter.formatNumeric(cell.getNumericCellValue());
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 2: {
                FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                return this.getCellString(evaluator.evaluateInCell(cell));
            }
            case 3: {
                return "";
            }
        }
        return "";
    }

    private static String formatNumeric(double value) {
        if (value % 1.0 == 0.0) {
            return String.format("%d", (long)value);
        }
        System.out.println("decilamannn " + value);
        return String.format("%.2f", value);
    }

    private double parseDoubleSafe(String s) {
        try {
            if (s == null || s.isEmpty()) {
                return 0.0;
            }
            s = s.replace(".", "").replace(",", ".");
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private void refreshFakturTable() {
        DefaultTableModel model = (DefaultTableModel)this.tableFaktur.getModel();
        model.setRowCount(0);
        for (Faktur2 f : this.fakturList) {
            model.addRow(new Object[]{f.nama, f.nik, f.alamat, f.nomorKw, f.tglKw, f.keterangan, f.dpp, f.ppn, f.total});
        }
        this.lblCount.setText("Jumlah Data: " + this.fakturList.size());
    }

    private void showDetail(int idx) {
        DefaultTableModel model = (DefaultTableModel)this.tableDetail.getModel();
        model.setRowCount(0);
        for (DetailBarang2 d : this.fakturList.get((int)idx).details) {
            model.addRow(new Object[]{d.dpp, d.dppNilaiLain, d.ppn, d.total, d.hargaSatuan});
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new EFakturXlsxImporter().setVisible(true));
    }
}

