/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import esindo.net.gui.DetailBarang;
import esindo.net.gui.Faktur;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class EFakturImporter
extends JFrame {
    private JTable tableFaktur;
    private JTable tableDetail;
    private ArrayList<Faktur> fakturList = new ArrayList();
    private JLabel lblJumlah;

    public EFakturImporter() {
        this.setTitle("Import e-Faktur CSV");
        this.setSize(900, 600);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(0));
        JButton btnImport = new JButton("Import CSV");
        btnImport.addActionListener(e -> this.importCSV());
        this.lblJumlah = new JLabel("Jumlah Transaksi: 0");
        topPanel.add(btnImport);
        topPanel.add(this.lblJumlah);
        this.add((Component)topPanel, "North");
        this.tableFaktur = new JTable(new DefaultTableModel(new String[]{"Kode Transaksi", "Nomor Faktur", "Tanggal", "NPWP", "Nama", "DPP", "PPN", "Referensi"}, 0));
        JScrollPane scrollFaktur = new JScrollPane(this.tableFaktur);
        this.tableDetail = new JTable(new DefaultTableModel(new String[]{"Kode Objek", "Nama Barang", "Qty", "Harga Satuan", "Diskon", "DPP", "PPN"}, 0));
        JScrollPane scrollDetail = new JScrollPane(this.tableDetail);
        JSplitPane splitPane = new JSplitPane(0, scrollFaktur, scrollDetail);
        splitPane.setDividerLocation(300);
        this.add((Component)splitPane, "Center");
        this.tableFaktur.getSelectionModel().addListSelectionListener(e -> {
            int idx = this.tableFaktur.getSelectedRow();
            if (idx >= 0) {
                this.showDetail(idx);
            }
        });
    }

    private void importCSV() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showOpenDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            this.parseCSV(file);
            this.refreshFakturTable();
            this.updateJumlah();
        }
    }

    private void updateJumlah() {
        this.lblJumlah.setText("Jumlah Transaksi: " + this.fakturList.size());
    }

    private void parseCSV(File file) {
        this.fakturList.clear();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            Faktur currentFaktur = null;
            while ((line = br.readLine()) != null) {
                String[] cols = line.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
                String type = cols[0].replace("\"", "").trim();
                if (line.contains("NOMOR_FAKTUR")) continue;
                if (type.equals("FK")) {
                    currentFaktur = new Faktur();
                    currentFaktur.kdTransaksi = this.safeStr(cols, 1);
                    currentFaktur.nomorFaktur = this.safeStr(cols, 3);
                    currentFaktur.tanggalFaktur = this.safeStr(cols, 6);
                    currentFaktur.npwp = this.safeStr(cols, 7);
                    currentFaktur.nama = this.safeStr(cols, 8);
                    currentFaktur.alamat = this.safeStr(cols, 9);
                    currentFaktur.jumlahDpp = this.parseDoubleSafe(this.safeStr(cols, 10));
                    currentFaktur.jumlahPpn = this.parseDoubleSafe(this.safeStr(cols, 11));
                    currentFaktur.referensi = this.safeStr(cols, 18);
                    this.fakturList.add(currentFaktur);
                    continue;
                }
                if (!type.equals("OF") || currentFaktur == null) continue;
                DetailBarang d = new DetailBarang();
                d.kodeObjek = this.safeStr(cols, 1);
                d.namaBarang = this.safeStr(cols, 2);
                d.hargaSatuan = this.parseDoubleSafe(this.safeStr(cols, 3));
                d.jumlahBarang = this.parseIntSafe(this.safeStr(cols, 4));
                d.hargaTotal = this.parseDoubleSafe(this.safeStr(cols, 5));
                d.diskon = this.parseDoubleSafe(this.safeStr(cols, 6));
                d.dpp = this.parseDoubleSafe(this.safeStr(cols, 7));
                d.ppn = this.parseDoubleSafe(this.safeStr(cols, 8));
                currentFaktur.details.add(d);
                System.out.println("doublee " + this.formatDouble(d.hargaSatuan) + " -- " + d.hargaSatuan);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error parsing: " + e.getMessage());
        }
    }

    private String formatDouble(double val) {
        DecimalFormat df = new DecimalFormat("#,###.##");
        df.setMaximumFractionDigits(2);
        df.setGroupingUsed(true);
        return df.format(val);
    }

    private String safeStr(String[] cols, int idx) {
        if (idx >= cols.length) {
            return "";
        }
        return cols[idx].replace("\"", "").trim();
    }

    private double parseDoubleSafe(String s) {
        try {
            if (s == null || s.isEmpty()) {
                return 0.0;
            }
            s = s.replace(".", "");
            s = s.replace(",", ".");
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private int parseIntSafe(String s) {
        try {
            if (s == null || s.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(s.replaceAll("[^0-9]", ""));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void refreshFakturTable() {
        DefaultTableModel model = (DefaultTableModel)this.tableFaktur.getModel();
        model.setRowCount(0);
        for (Faktur f : this.fakturList) {
            model.addRow(new Object[]{f.kdTransaksi, f.nomorFaktur, f.tanggalFaktur, f.npwp, f.nama, this.formatDouble(f.jumlahDpp), this.formatDouble(f.jumlahPpn), f.referensi});
        }
    }

    private void showDetail(int idx) {
        DefaultTableModel model = (DefaultTableModel)this.tableDetail.getModel();
        model.setRowCount(0);
        for (DetailBarang d : this.fakturList.get((int)idx).details) {
            model.addRow(new Object[]{d.kodeObjek, d.namaBarang, this.formatDouble(d.jumlahBarang), this.formatDouble(d.hargaSatuan), this.formatDouble(d.diskon), this.formatDouble(d.dpp), this.formatDouble(d.ppn)});
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new EFakturImporter().setVisible(true));
    }
}

