/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import db.SingletonProxy;
import esindo.net.gui.InvoicePDFPm;
import esindo.net.gui.MDIForm;
import esindo.net.gui.ZImportTemplate;
import esindo.net.model.BacaBarcode;
import esindo.net.model.DAOLinkFaktur;
import esindo.net.model.DAOProfil;
import esindo.net.model.DAOTransaksi;
import esindo.net.model.FileTypeFilter;
import esindo.net.model.ItemTransaksi;
import esindo.net.model.LinkFaktur;
import esindo.net.model.LinkFakturError;
import esindo.net.model.Profil;
import esindo.net.model.TempPdfpm;
import esindo.net.model.ToolGui;
import esindo.net.model.Transaksi;
import esindo.net.model.ZDAOTransaksi;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.MaskFormatter;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.SimpleLayout;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class EFakturForm
extends JInternalFrame {
    DAOLinkFaktur daolink = null;
    DAOTransaksi daotrans = null;
    private MDIForm mdi = null;
    private static JFileChooser fileChooser = new JFileChooser();
    private int waktu = 0;
    private Timer time;
    private Cursor waitCursor = new Cursor(3);
    private Cursor defaultCursor = new Cursor(0);
    private boolean prosesDownload = false;
    org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"MyLog");
    Appender fh = null;
    SimpleDateFormat format = new SimpleDateFormat("YYYY-M-d_HH-mm-ss");
    public static String PATH_APP = "";
    public Profil profil = null;
    ZDAOTransaksi daotrsk = null;
    static JDialog jd;
    public static int jumlah_data;
    public static int counter_data;
    Thread th = null;
    private JButton btnCariURL;
    private JButton btnDownloadFaktur;
    private JButton btnFolderPdf;
    private JButton btnHapus;
    private JButton btnHapusErrorLog;
    private JButton btnImportDataBaru;
    private JButton btnPilihAll;
    private JButton btnPilihSemuaData;
    private JButton btnRefresh;
    private JButton btnSimpanDataLink;
    private JButton btnUploadPdf2;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JTabbedPane jTabbedPane1;
    private JLabel jmlData;
    private JLabel lblNPWP;
    private JLabel lblNamaPerusahaan;
    private JLabel lblNoNpwp;
    private JLabel lblPerusahaan;
    private JPanel panelFakturBelumDownload;
    private JPanel panelFakturError;
    private JPanel panelFakturPajakBaru;
    private JPanel panelFakturPdf;
    private JPanel panelFakturSudahDownload;
    private JProgressBar pb;
    private JProgressBar pb1;
    private JProgressBar pbSimpan;
    private JTable tblDatapdf;
    private JTable tblErrorLog;
    private JTable tblFakturBaru;
    private JTable tblFakturBelumDownload;
    private JTable tblFakturSudahDownload;
    private JTextField txtURL;

    public EFakturForm() {
        this.initComponents();
        DAOProfil daopro = new DAOProfil();
        this.profil = daopro.getProfilUser();
        this.daolink = new DAOLinkFaktur();
        this.daotrans = new DAOTransaksi();
        this.daotrsk = new ZDAOTransaksi();
        this.initFileChooser();
        this.tblFakturBelumDownload.setModel(this.daolink.tableModel(false));
        this.tblFakturSudahDownload.setModel(this.daolink.tableModel(true));
        System.out.println("TES");
        this.initTableFakturBaru();
        PATH_APP = new File("").getAbsolutePath();
        try {
            this.fh = new FileAppender((Layout)new SimpleLayout(), PATH_APP + "/Error_Log/" + this.format.format(Calendar.getInstance().getTime()) + "_Error.log");
            this.logger.addAppender(this.fh);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.txtURL.addActionListener(this.btnCariURL.getActionListeners()[0]);
        this.jTabbedPane1.removeAll();
        this.jTabbedPane1.add("Data dari PDF", this.panelFakturPdf);
        this.tblDatapdf.setModel(this.daotrans.selectallTemp());
        this.kondisikanTableTemp();
    }

    public void initTableFakturBaru() {
        DefaultTableModel model = new DefaultTableModel(){
            Class[] types = new Class[]{String.class, String.class, Boolean.class};

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        };
        Object[] judul = new String[]{"No", "Link efaktur", "Check"};
        model.setColumnIdentifiers(judul);
        this.tblFakturBaru.setModel(model);
        this.kondisikanTableEfakturForm();
    }

    public void setMDI(MDIForm mdi) throws ParseException {
        this.mdi = mdi;
        MaskFormatter mf = new MaskFormatter("##.###.###.#-###.###");
        mf.setValueContainsLiteralCharacters(false);
        this.lblNPWP.setText(mf.valueToString(this.mdi.profil.getNpwp()));
        this.lblPerusahaan.setText(this.mdi.profil.getNama());
        this.panelFakturPajakBaru.setVisible(false);
        this.panelFakturBelumDownload.setVisible(false);
        this.panelFakturError.setVisible(false);
        this.panelFakturSudahDownload.setVisible(false);
    }

    public void initFileChooser() {
        FileNameExtensionFilter ff = new FileNameExtensionFilter("My Files", "xls", "xlsx", "csv");
        fileChooser.addChoosableFileFilter(ff);
        fileChooser.setCurrentDirectory(new File("C:\\Documents and Settings"));
        FileTypeFilter xlssFilter = new FileTypeFilter(".xlsx", "Microsoft Excel Documents");
        FileTypeFilter xlsFilter = new FileTypeFilter(".xls", "Microsoft Excel Documents");
        FileTypeFilter csvFilter = new FileTypeFilter(".csv", "CSV Files");
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Files", "xls", "xlsx", "csv"));
        fileChooser.addChoosableFileFilter(xlsFilter);
        fileChooser.addChoosableFileFilter(xlssFilter);
        fileChooser.addChoosableFileFilter(csvFilter);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.panelFakturPajakBaru = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tblFakturBaru = new JTable();
        this.btnImportDataBaru = new JButton();
        this.btnSimpanDataLink = new JButton();
        this.btnFolderPdf = new JButton();
        this.pbSimpan = new JProgressBar();
        this.panelFakturBelumDownload = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblFakturBelumDownload = new JTable();
        this.btnDownloadFaktur = new JButton();
        this.btnHapus = new JButton();
        this.pb = new JProgressBar();
        this.btnPilihAll = new JButton();
        this.panelFakturSudahDownload = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.tblFakturSudahDownload = new JTable();
        this.btnCariURL = new JButton();
        this.txtURL = new JTextField();
        this.jLabel1 = new JLabel();
        this.btnRefresh = new JButton();
        this.panelFakturError = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.tblErrorLog = new JTable();
        this.btnPilihSemuaData = new JButton();
        this.btnHapusErrorLog = new JButton();
        this.panelFakturPdf = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.tblDatapdf = new JTable();
        this.pb1 = new JProgressBar();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.btnUploadPdf2 = new JButton();
        this.jLabel2 = new JLabel();
        this.jmlData = new JLabel();
        this.lblNoNpwp = new JLabel();
        this.lblNamaPerusahaan = new JLabel();
        this.lblPerusahaan = new JLabel();
        this.lblNPWP = new JLabel();
        this.jTabbedPane1.setCursor(new Cursor(0));
        this.jTabbedPane1.setFont(new Font("Arial Unicode MS", 0, 12));
        this.panelFakturPajakBaru.setBorder(new SoftBevelBorder(1));
        this.tblFakturBaru.setFont(new Font("Arial Unicode MS", 0, 11));
        this.tblFakturBaru.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.tblFakturBaru);
        this.btnImportDataBaru.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnImportDataBaru.setText("Import Dari File XLS / XLSX");
        this.btnImportDataBaru.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnImportDataBaruActionPerformed(evt);
            }
        });
        this.btnSimpanDataLink.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnSimpanDataLink.setText("Simpan Data");
        this.btnSimpanDataLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnSimpanDataLinkActionPerformed(evt);
            }
        });
        this.btnFolderPdf.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnFolderPdf.setText("Import Dari Folder PDF");
        this.btnFolderPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnFolderPdfActionPerformed(evt);
            }
        });
        this.pbSimpan.setStringPainted(true);
        GroupLayout panelFakturPajakBaruLayout = new GroupLayout(this.panelFakturPajakBaru);
        this.panelFakturPajakBaru.setLayout(panelFakturPajakBaruLayout);
        panelFakturPajakBaruLayout.setHorizontalGroup(panelFakturPajakBaruLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 864, Short.MAX_VALUE).addGroup(panelFakturPajakBaruLayout.createSequentialGroup().addContainerGap().addComponent(this.btnImportDataBaru, -2, 171, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnFolderPdf).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSimpanDataLink, -2, 146, -2).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.pbSimpan, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        panelFakturPajakBaruLayout.setVerticalGroup(panelFakturPajakBaruLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFakturPajakBaruLayout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 587, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(panelFakturPajakBaruLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnImportDataBaru, -2, 43, -2).addComponent(this.btnSimpanDataLink, -2, 44, -2).addComponent(this.btnFolderPdf, -2, 43, -2)).addGap(7, 7, 7).addComponent(this.pbSimpan, -2, -1, -2)));
        this.jTabbedPane1.addTab("Faktur Pajak Baru", this.panelFakturPajakBaru);
        this.panelFakturBelumDownload.setBorder(new SoftBevelBorder(1));
        this.tblFakturBelumDownload.setFont(new Font("Arial Unicode MS", 0, 11));
        this.tblFakturBelumDownload.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tblFakturBelumDownload);
        this.btnDownloadFaktur.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnDownloadFaktur.setText("Download Faktur");
        this.btnDownloadFaktur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnDownloadFakturActionPerformed(evt);
            }
        });
        this.btnHapus.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnHapus.setText("Hapus");
        this.btnHapus.setPreferredSize(new Dimension(115, 23));
        this.btnHapus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnHapusActionPerformed(evt);
            }
        });
        this.pb.setStringPainted(true);
        this.btnPilihAll.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnPilihAll.setText("Pilih Semua Data Yang Dihapus");
        this.btnPilihAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnPilihAllActionPerformed(evt);
            }
        });
        GroupLayout panelFakturBelumDownloadLayout = new GroupLayout(this.panelFakturBelumDownload);
        this.panelFakturBelumDownload.setLayout(panelFakturBelumDownloadLayout);
        panelFakturBelumDownloadLayout.setHorizontalGroup(panelFakturBelumDownloadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 864, Short.MAX_VALUE).addGroup(panelFakturBelumDownloadLayout.createSequentialGroup().addContainerGap().addComponent(this.btnDownloadFaktur, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPilihAll, -2, 219, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnHapus, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.pb, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        panelFakturBelumDownloadLayout.setVerticalGroup(panelFakturBelumDownloadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFakturBelumDownloadLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 569, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelFakturBelumDownloadLayout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.btnPilihAll, -2, 48, -2).addComponent(this.btnDownloadFaktur, -2, 48, -2).addComponent(this.btnHapus, -2, 48, -2)).addGap(12, 12, 12).addComponent(this.pb, -2, -1, -2).addGap(20, 20, 20)));
        this.jTabbedPane1.addTab("Faktur Belum Di Download", this.panelFakturBelumDownload);
        this.panelFakturSudahDownload.setBorder(new SoftBevelBorder(1));
        this.tblFakturSudahDownload.setFont(new Font("Arial Unicode MS", 0, 11));
        this.tblFakturSudahDownload.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane3.setViewportView(this.tblFakturSudahDownload);
        this.btnCariURL.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnCariURL.setText("Cari");
        this.btnCariURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnCariURLActionPerformed(evt);
            }
        });
        this.txtURL.setFont(new Font("Arial Unicode MS", 0, 12));
        this.jLabel1.setFont(new Font("Arial Unicode MS", 0, 12));
        this.jLabel1.setText("Cari URL :");
        this.btnRefresh.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnRefresh.setText("Refresh Data");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnRefreshActionPerformed(evt);
            }
        });
        GroupLayout panelFakturSudahDownloadLayout = new GroupLayout(this.panelFakturSudahDownload);
        this.panelFakturSudahDownload.setLayout(panelFakturSudahDownloadLayout);
        panelFakturSudahDownloadLayout.setHorizontalGroup(panelFakturSudahDownloadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addGroup(panelFakturSudahDownloadLayout.createSequentialGroup().addContainerGap().addGroup(panelFakturSudahDownloadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFakturSudahDownloadLayout.createSequentialGroup().addComponent(this.btnCariURL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRefresh)).addComponent(this.jLabel1).addComponent(this.txtURL, -2, 1062, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        panelFakturSudahDownloadLayout.setVerticalGroup(panelFakturSudahDownloadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFakturSudahDownloadLayout.createSequentialGroup().addComponent(this.jScrollPane3, -2, 493, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtURL, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelFakturSudahDownloadLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCariURL).addComponent(this.btnRefresh)).addGap(0, 94, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Faktur Sudah Di Download", this.panelFakturSudahDownload);
        this.tblErrorLog.setFont(new Font("Arial Unicode MS", 0, 11));
        this.tblErrorLog.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane4.setViewportView(this.tblErrorLog);
        this.btnPilihSemuaData.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnPilihSemuaData.setText("Pilih Semua Data Yang Dihapus");
        this.btnPilihSemuaData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnPilihSemuaDataActionPerformed(evt);
            }
        });
        this.btnHapusErrorLog.setFont(new Font("Arial Unicode MS", 0, 11));
        this.btnHapusErrorLog.setText("Hapus");
        this.btnHapusErrorLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnHapusErrorLogActionPerformed(evt);
            }
        });
        GroupLayout panelFakturErrorLayout = new GroupLayout(this.panelFakturError);
        this.panelFakturError.setLayout(panelFakturErrorLayout);
        panelFakturErrorLayout.setHorizontalGroup(panelFakturErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFakturErrorLayout.createSequentialGroup().addGroup(panelFakturErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -1, 855, Short.MAX_VALUE).addGroup(panelFakturErrorLayout.createSequentialGroup().addComponent(this.btnPilihSemuaData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnHapusErrorLog, -2, 98, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        panelFakturErrorLayout.setVerticalGroup(panelFakturErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFakturErrorLayout.createSequentialGroup().addComponent(this.jScrollPane4, -2, 527, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelFakturErrorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnPilihSemuaData, -2, 44, -2).addComponent(this.btnHapusErrorLog, -2, 44, -2)).addGap(0, 97, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Error Log", this.panelFakturError);
        this.panelFakturPdf.setBorder(new SoftBevelBorder(1));
        this.tblDatapdf.setFont(new Font("Arial Unicode MS", 0, 11));
        this.tblDatapdf.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane5.setViewportView(this.tblDatapdf);
        this.pb1.setStringPainted(true);
        this.jButton2.setFont(new Font("Arial", 0, 12));
        this.jButton2.setText("Hapus Data");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setFont(new Font("Arial", 0, 12));
        this.jButton3.setText("Proses Data");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.jButton3ActionPerformed(evt);
            }
        });
        this.btnUploadPdf2.setFont(new Font("Arial Unicode MS", 0, 12));
        this.btnUploadPdf2.setText("Upload PDF");
        this.btnUploadPdf2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EFakturForm.this.btnUploadPdf2btnProsesFakturActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Arial", 0, 12));
        this.jLabel2.setText("Jumlah Data :");
        this.jmlData.setFont(new Font("Arial", 0, 12));
        this.jmlData.setText("-");
        GroupLayout panelFakturPdfLayout = new GroupLayout(this.panelFakturPdf);
        this.panelFakturPdf.setLayout(panelFakturPdfLayout);
        panelFakturPdfLayout.setHorizontalGroup(panelFakturPdfLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pb1, -1, -1, Short.MAX_VALUE).addGroup(panelFakturPdfLayout.createSequentialGroup().addContainerGap().addGroup(panelFakturPdfLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFakturPdfLayout.createSequentialGroup().addComponent(this.jScrollPane5, -1, 835, Short.MAX_VALUE).addContainerGap()).addGroup(panelFakturPdfLayout.createSequentialGroup().addComponent(this.btnUploadPdf2, -2, 149, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jmlData, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3).addGap(3, 3, 3)))));
        panelFakturPdfLayout.setVerticalGroup(panelFakturPdfLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelFakturPdfLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane5, -1, 548, Short.MAX_VALUE).addGap(39, 39, 39).addGroup(panelFakturPdfLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnUploadPdf2, -2, 48, -2).addComponent(this.jLabel2).addComponent(this.jmlData).addComponent(this.jButton2, -2, 48, -2).addComponent(this.jButton3, -2, 49, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pb1, -2, -1, -2)));
        this.jTabbedPane1.addTab("Data dari PDF", this.panelFakturPdf);
        this.lblNoNpwp.setFont(new Font("Arial Unicode MS", 0, 14));
        this.lblNoNpwp.setText("NPWP : ");
        this.lblNamaPerusahaan.setFont(new Font("Arial Unicode MS", 0, 14));
        this.lblNamaPerusahaan.setText("NAMA PERUSAHAAN : ");
        this.lblPerusahaan.setFont(new Font("Arial Unicode MS", 0, 14));
        this.lblPerusahaan.setText("jLabel3");
        this.lblNPWP.setFont(new Font("Arial Unicode MS", 0, 14));
        this.lblNPWP.setText("jLabel1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.lblNoNpwp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblNPWP, -2, 165, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNamaPerusahaan).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblPerusahaan, -2, 467, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -2, 0, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblNoNpwp).addComponent(this.lblNamaPerusahaan).addComponent(this.lblPerusahaan).addComponent(this.lblNPWP)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addContainerGap()));
        this.pack();
    }

    private void btnImportDataBaruActionPerformed(ActionEvent evt) {
        fileChooser.showDialog(this, "Load File eFaktur");
        File file = fileChooser.getSelectedFile();
        if (file.isFile()) {
            System.out.println("File: " + file.getName() + ".");
            String ext = FilenameUtils.getExtension((String)file.getName());
            System.out.println(ext);
            if (ext.equalsIgnoreCase("xls")) {
                this.tblFakturBaru.setModel(ToolGui.tableModelEfaktur(file));
            } else {
                this.tblFakturBaru.setModel(ToolGui.tableModelEfakturXLSX(file));
            }
        }
        this.kondisikanTableEfakturForm();
    }

    public void kondisikanTableEfakturForm() {
        this.tblFakturBaru.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.tblFakturBaru.getColumnModel().getColumn(1).setPreferredWidth(1150);
        this.tblFakturBaru.setAutoResizeMode(3);
        this.tblFakturBelumDownload.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.tblFakturBelumDownload.getColumnModel().getColumn(1).setPreferredWidth(900);
        this.tblFakturBelumDownload.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.tblFakturBelumDownload.setAutoResizeMode(3);
        this.tblFakturSudahDownload.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.tblFakturSudahDownload.getColumnModel().getColumn(1).setPreferredWidth(900);
        this.tblFakturSudahDownload.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.tblFakturSudahDownload.setAutoResizeMode(3);
        this.table1();
    }

    public void table1() {
        this.tblErrorLog.setAutoCreateRowSorter(true);
        this.tblErrorLog.setAutoResizeMode(0);
        for (int i = 0; i < this.tblErrorLog.getColumnCount(); ++i) {
            if (i == 0 || i == 1) {
                this.tblErrorLog.getColumnModel().getColumn(i).setPreferredWidth(60);
                continue;
            }
            if (i == 4) {
                this.tblErrorLog.getColumnModel().getColumn(i).setPreferredWidth(90);
                continue;
            }
            this.tblErrorLog.getColumnModel().getColumn(i).setPreferredWidth(800);
        }
    }

    private void btnSimpanDataLinkActionPerformed(ActionEvent evt) {
        this.th = new Thread(){

            @Override
            public void run() {
                try {
                    EFakturForm.this.simpanData();
                    EFakturForm.this.pbSimpan.setValue(counter_data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EFakturForm.this.th.stop();
                    }
                });
            }
        };
        this.th.start();
    }

    public void simpanData() {
        int jumlah_sudah_ada = 0;
        ArrayList<Integer> lshapus = new ArrayList<Integer>();
        DefaultTableModel dm = (DefaultTableModel)this.tblFakturBaru.getModel();
        int x = this.tblFakturBaru.getRowCount();
        System.out.println("Jumlah Data " + x);
        boolean cek = false;
        LinkFaktur obj = null;
        LinkFakturError obj1 = null;
        String link_utuh = null;
        String link_duplikat = null;
        String info_error = null;
        this.btnImportDataBaru.setEnabled(false);
        this.btnFolderPdf.setEnabled(false);
        this.btnSimpanDataLink.setEnabled(false);
        for (int i = 0; i < x; ++i) {
            jumlah_data = x;
            float bar = 0.0f;
            int tot = 0;
            tot = i + 1;
            float ft = tot;
            counter_data = (int)(ft / (float)jumlah_data * 100.0f);
            Timer t = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EFakturForm.this.pbSimpan.setValue(counter_data);
                    if (EFakturForm.this.pbSimpan.getValue() == 100) {
                        ((Timer)e.getSource()).stop();
                    }
                }
            });
            t.start();
            cek = (Boolean)this.tblFakturBaru.getValueAt(i, 2);
            if (!cek) continue;
            obj = new LinkFaktur();
            link_utuh = this.tblFakturBaru.getValueAt(i, 1).toString();
            link_utuh = link_utuh.replaceAll("\\s", "");
            obj.setLink(link_utuh);
            try {
                this.daolink.save(obj);
            }
            catch (SQLException e) {
                ++jumlah_sudah_ada;
                link_duplikat = this.tblFakturBaru.getValueAt(i, 1).toString();
                link_duplikat = link_duplikat.trim();
                try {
                    obj1 = new LinkFakturError();
                    obj = this.daolink.findByUrl(link_duplikat);
                    info_error = "DUPLIKAT LINK URL ";
                    obj1.setLinkId(obj.getId());
                    obj1.setLink(link_duplikat);
                    obj1.setStatuserror(info_error);
                    this.daolink.saveError(obj1);
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                this.logger.info((Object)("Link : " + this.tblFakturBaru.getValueAt(i, 1).toString()));
            }
            lshapus.add(new Integer(i));
        }
        if (jumlah_sudah_ada > 0) {
            JOptionPane.showMessageDialog(this.rootPane, jumlah_sudah_ada + " LINK FAKTUR SUDAH PERNAH DISIMPAN !!");
        }
        this.tblFakturBelumDownload.setModel(this.daolink.tableModel(false));
        this.tblErrorLog.setModel(this.daolink.tableModelError());
        int rowCount = dm.getRowCount();
        for (int i = rowCount - 1; i >= 0; --i) {
            dm.removeRow(i);
        }
        this.btnImportDataBaru.setEnabled(true);
        this.btnFolderPdf.setEnabled(true);
        this.btnSimpanDataLink.setEnabled(true);
        this.tblFakturBaru.setModel(dm);
        this.table1();
        this.logger.info((Object)(jumlah_sudah_ada + "LINK FAKTUR SUDAH PERNAH DISIMPAN !!"));
    }

    public boolean cekFaktur(String npwp) {
        return npwp.equalsIgnoreCase(this.mdi.profil.getNpwp());
    }

    public void lonlongProcessingTask() {
    }

    private void btnDownloadFakturActionPerformed(ActionEvent evt) {
        this.th = new Thread(){

            @Override
            public void run() {
                try {
                    EFakturForm.this.downloadFaktur();
                    EFakturForm.this.pb.setValue(counter_data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EFakturForm.this.th.stop();
                    }
                });
            }
        };
        this.th.start();
    }

    public void downloadFaktur() {
        int _baris;
        LinkFakturError obj1 = null;
        LinkFaktur obj = null;
        jumlah_data = _baris = this.tblFakturBelumDownload.getRowCount();
        boolean status_download = false;
        if (JOptionPane.showConfirmDialog(null, "PASTIKAN ANDA TERHUBUNG DENGAN INTERNET \nANDA YAKIN INGIN MENGUNDUH DATA ? ", "WARNING", 0) == 0) {
            this.btnDownloadFaktur.setEnabled(false);
            this.btnPilihAll.setEnabled(false);
            this.btnHapus.setEnabled(false);
            boolean pake_proxy = this.mdi.profil.getStatus();
            SingletonProxy singleton = SingletonProxy.getInstance();
            if (pake_proxy) {
                singleton.runProxy();
            } else {
                singleton.removeProxy();
            }
            float bar = 0.0f;
            int tot = 0;
            for (int i = 0; i < _baris; ++i) {
                String info_error;
                tot = i + 1;
                float ft = tot;
                counter_data = (int)(ft / (float)jumlah_data * 100.0f);
                Timer t = new Timer(50, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EFakturForm.this.pb.setValue(counter_data);
                        if (EFakturForm.this.pb.getValue() == 100) {
                            ((Timer)e.getSource()).stop();
                        }
                    }
                });
                t.start();
                String str = this.tblFakturBelumDownload.getValueAt(i, 1).toString();
                int id = (Integer)this.tblFakturBelumDownload.getValueAt(i, 0);
                Transaksi tr = null;
                try {
                    tr = ToolGui.downloadFakturXML(str);
                    status_download = true;
                }
                catch (MalformedURLException e) {
                    JOptionPane.showMessageDialog(null, "URL TIDAK VALID ");
                    try {
                        obj = new LinkFaktur();
                        obj1 = new LinkFakturError();
                        obj = this.daolink.findByUrl(str);
                        info_error = "URL TIDAK VALID ";
                        obj1.setLinkId(obj.getId());
                        obj1.setLink(obj.getLink());
                        obj1.setStatuserror(info_error);
                        this.daolink.saveError(obj1);
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    this.logger.info((Object)"URL TIDAK VALID ");
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "GAGAL DOWNLOAD -- \n PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ");
                    try {
                        obj = new LinkFaktur();
                        obj1 = new LinkFakturError();
                        obj = this.daolink.findByUrl(str);
                        info_error = "GAGAL DOWNLOAD -- PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ";
                        obj1.setLinkId(obj.getId());
                        obj1.setLink(obj.getLink());
                        obj1.setStatuserror(info_error);
                        this.daolink.saveError(obj1);
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    this.logger.info((Object)"GAGAL DOWNLOAD -- PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ");
                    break;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "GAGAL DOWNLOAD -- \n PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ");
                    try {
                        obj = new LinkFaktur();
                        obj1 = new LinkFakturError();
                        obj = this.daolink.findByUrl(str);
                        info_error = "GAGAL DOWNLOAD -- PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ";
                        obj1.setLinkId(obj.getId());
                        obj1.setLink(obj.getLink());
                        obj1.setStatuserror(info_error);
                        this.daolink.saveError(obj1);
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    this.logger.info((Object)"GAGAL DOWNLOAD -- PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ");
                    break;
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "GAGAL DOWNLOAD -- \n PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ");
                    try {
                        obj = new LinkFaktur();
                        obj1 = new LinkFakturError();
                        obj = this.daolink.findByUrl(str);
                        info_error = "GAGAL DOWNLOAD -- PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ";
                        obj1.setLinkId(obj.getId());
                        obj1.setLink(obj.getLink());
                        obj1.setStatuserror(info_error);
                        this.daolink.saveError(obj1);
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    this.logger.info((Object)"GAGAL DOWNLOAD -- PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ");
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "GAGAL DOWNLOAD -- \n PROBLEM AKSES INTERNET / URL TIDAK VALID !!! ");
                    try {
                        obj = new LinkFaktur();
                        obj1 = new LinkFakturError();
                        obj = this.daolink.findByUrl(str);
                        info_error = "GAGAL DOWNLOAD -- PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ";
                        obj1.setLinkId(obj.getId());
                        obj1.setLink(obj.getLink());
                        obj1.setStatuserror(info_error);
                        this.daolink.saveError(obj1);
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    this.logger.info((Object)"GAGAL DOWNLOAD -- PROBLEM AKSES INTERNET / SERVER DJP BERMASALAH / URL TIDAK VALID !!! ");
                    break;
                }
                if (tr != null) {
                    tr.setLinkfakturId(id);
                    boolean valid_pengganti = true;
                    try {
                        if (this.cekFaktur(tr.getNpwpLawan())) {
                            if (tr.getFgPengganti().equals("1") && this.daotrans.findNomorFakturPenggantiDouble(tr.getNomorFaktur()) != null) {
                                JOptionPane.showMessageDialog(this.rootPane, "FAKTUR PENGGANTI UNTUK NO FAKTUR " + tr.getNomorFaktur() + " SUDAH ADA SEBELUMNYA ");
                                obj = new LinkFaktur();
                                obj1 = new LinkFakturError();
                                obj = this.daolink.findByUrl(str);
                                System.out.println(obj.getId());
                                info_error = "FAKTUR PENGGANTI UNTUK NO FAKTUR " + tr.getNomorFaktur() + " SUDAH ADA SEBELUMNYA";
                                obj1.setLinkId(obj.getId());
                                obj1.setLink(obj.getLink());
                                obj1.setStatuserror(info_error);
                                this.daolink.saveError(obj1);
                            }
                            this.daotrans.save(tr);
                            System.out.println("ID TRANSAKSI : " + tr.getId());
                            this.daotrans.setItemList(tr.getListItem());
                            this.daotrans.saveAllItem(tr.getId());
                        } else {
                            JOptionPane.showMessageDialog(this.rootPane, "NPWP FAKTUR TIDAK VALID " + tr.getNpwpLawan() + " NO FAKTUR " + tr.getNomorFaktur() + "\n eFAKTUR AKAN DIHAPUS !!! ID " + tr.getLinkfakturId());
                            obj = new LinkFaktur();
                            obj1 = new LinkFakturError();
                            obj = this.daolink.findByUrl(str);
                            System.out.println(obj.getId());
                            info_error = "NPWP FAKTUR TIDAK VALID " + tr.getNpwpLawan() + " NO FAKTUR " + tr.getNomorFaktur() + "\n eFAKTUR AKAN DIHAPUS !!! ID " + tr.getLinkfakturId();
                            obj1.setLinkId(obj.getId());
                            obj1.setLink(obj.getLink());
                            obj1.setStatuserror(info_error);
                            this.daolink.saveError(obj1);
                            this.logger.info((Object)("NPWP FAKTUR TIDAK VALID " + tr.getNpwpLawan() + " NO FAKTUR " + tr.getNomorFaktur() + "\n eFAKTUR AKAN DIHAPUS !!! ID " + tr.getLinkfakturId()));
                            this.daolink.delete(tr.getLinkfakturId());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this.rootPane, "GAGAL SIMPAN ");
                        this.logger.info((Object)"GAGAL SIMPAN ");
                    }
                    this.daolink.update_status(id, 1);
                    continue;
                }
                this.daolink.update_status(id, 2);
            }
            if (status_download) {
                JOptionPane.showMessageDialog(this.rootPane, "SUKSES SIMPAN DATA ");
            }
            this.btnDownloadFaktur.setEnabled(true);
            this.btnPilihAll.setEnabled(true);
            this.btnHapus.setEnabled(true);
        } else {
            System.out.println("Tidak Menghapus");
        }
        this.tblFakturBelumDownload.setModel(this.daolink.tableModel(false));
        this.tblFakturSudahDownload.setModel(this.daolink.tableModel(true));
        this.tblErrorLog.setModel(this.daolink.tableModelError());
        this.initTableFakturBaru();
    }

    private void btnHapusActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.tblFakturBelumDownload.getSelectedRows();
        if (selectedRows.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selectedRows.length; ++i) {
                sb.append(" " + this.tblFakturBelumDownload.getValueAt(selectedRows[i], 0).toString() + " , ");
            }
            String str = sb.toString().trim();
            str = str.substring(0, str.length() - 1);
            if (JOptionPane.showConfirmDialog(null, "ANDA AKAN HAPUS DATA TERPILIH\nYAKIN INGIN MENGHAPUS ?", "WARNING", 0) == 0) {
                this.daolink.delete(str);
                JOptionPane.showMessageDialog(this.rootPane, "DATA TERHAPUS");
            } else {
                System.out.println("Tidak Menghapus");
            }
        } else {
            JOptionPane.showMessageDialog(this.rootPane, "DATA BELUM DIPILIH !!!");
        }
        this.tblFakturBelumDownload.setModel(this.daolink.tableModel(false));
        this.initTableFakturBaru();
    }

    private void btnFolderPdfActionPerformed(ActionEvent evt) {
        JFileChooser j = new JFileChooser();
        j.setFileSelectionMode(1);
        Integer opt = j.showDialog(this.rootPane, "Pilih Folder");
        JOptionPane.showMessageDialog(this.rootPane, "NAMA FOLDER " + j.getSelectedFile().getPath());
        File folder = new File(j.getSelectedFile().getPath());
        try {
            BacaBarcode.generateImage(folder);
            this.tblFakturBaru.setModel(BacaBarcode.tableModelDirektoryEfaktur(folder));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void btnPilihAllActionPerformed(ActionEvent evt) {
        this.tblFakturBelumDownload.selectAll();
    }

    private void btnCariURLActionPerformed(ActionEvent evt) {
        String kata = this.txtURL.getText();
        this.tblFakturSudahDownload.setModel(this.daolink.tableModelURL(kata));
        this.tblFakturSudahDownload.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.tblFakturSudahDownload.getColumnModel().getColumn(1).setPreferredWidth(900);
        this.tblFakturSudahDownload.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.tblFakturSudahDownload.setAutoResizeMode(3);
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.txtURL.setText("");
        this.tblFakturSudahDownload.setModel(this.daolink.tableModel(true));
        this.initTableFakturBaru();
    }

    private void btnHapusErrorLogActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.tblErrorLog.getSelectedRows();
        if (selectedRows.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selectedRows.length; ++i) {
                sb.append(" " + this.tblErrorLog.getValueAt(selectedRows[i], 0).toString() + " , ");
            }
            String str = sb.toString().trim();
            str = str.substring(0, str.length() - 1);
            if (JOptionPane.showConfirmDialog(null, "ANDA AKAN HAPUS DATA TERPILIH\nYAKIN INGIN MENGHAPUS ?", "WARNING", 0) == 0) {
                this.daolink.deleteError(str);
                JOptionPane.showMessageDialog(this.rootPane, "DATA TERHAPUS");
            } else {
                System.out.println("Tidak Menghapus");
            }
        } else {
            JOptionPane.showMessageDialog(this.rootPane, "DATA BELUM DIPILIH !!!");
        }
        this.tblErrorLog.setModel(this.daolink.tableModelError());
        this.initTableFakturBaru();
    }

    private void btnPilihSemuaDataActionPerformed(ActionEvent evt) {
        this.tblErrorLog.selectAll();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.daotrans.deleteDataPdfTemp();
        JOptionPane.showMessageDialog(null, "Data Sukses Di Hapus");
        this.tblDatapdf.setModel(this.daotrsk.selectallTemp());
        this.kondisikanTableTemp();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this.rootPane, "Memulai proses data");
        this.th = new Thread(){

            @Override
            public void run() {
                try {
                    EFakturForm.this.simpanFakturPdf();
                    EFakturForm.this.pb.setValue(ZImportTemplate.counter_datapdf);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EFakturForm.this.th.stop();
                    }
                });
            }
        };
        this.th.start();
        this.daotrans.deleteDataPdfTemp();
        JOptionPane.showMessageDialog(null, "Data Sudah di proses");
        this.tblDatapdf.setModel(this.daotrsk.selectallTemp());
        this.kondisikanTableTemp();
    }

    private void simpanFakturPdf() {
        DefaultTableModel dm = (DefaultTableModel)this.tblDatapdf.getModel();
        int x = this.tblDatapdf.getRowCount();
        int kolom = this.tblDatapdf.getColumnCount();
        System.out.println("Jumlah Data " + x);
        System.out.println("Jumlah Baris Data " + x);
        System.out.println("Jumlah Kolom Data " + kolom);
        int idFaktur = 0;
        Transaksi z = null;
        Object tr = null;
        ItemTransaksi zi = null;
        Object trd = null;
        String isjson = "";
        String valjson = "";
        ArrayList transactionDetails = new ArrayList();
        ArrayList itransactionDetails = new ArrayList();
        for (int i = 0; i < x; ++i) {
            z = new Transaksi();
            zi = new ItemTransaksi();
            boolean end = false;
            z.setNamaLawan(this.profil.getNama());
            z.setAlamatLawan(this.profil.getAlamat());
            String _npwp = this.profil.getNpwp().toString().replaceAll("[\\s().-]", "");
            z.setNpwpLawan(_npwp);
            z.setFgPengganti("0");
            for (int a1 = 0; a1 < kolom; ++a1) {
                String nameHeader = this.tblDatapdf.getColumnName(a1);
                if (nameHeader.equalsIgnoreCase("No Invoice")) {
                    z.setNoinvoice(this.tblDatapdf.getValueAt(i, a1).toString());
                    zi.setNoinvoice(z.getNoinvoice());
                }
                if (nameHeader.equalsIgnoreCase("Tgl Invoice")) {
                    String tglfak = this.tblDatapdf.getValueAt(i, a1).toString();
                    String[] splited2 = tglfak.split("/");
                    String[] splited = tglfak.split("\\.");
                    String[] splited3 = tglfak.split("-");
                    String[] valSplit = null;
                    System.out.println("---" + tglfak);
                    if (splited.length > 1) {
                        valSplit = splited;
                        tglfak = tglfak.toString().replaceAll("\\.", "-");
                    } else if (splited2.length > 1) {
                        valSplit = splited2;
                    } else if (splited3.length > 1) {
                        valSplit = splited3;
                    }
                    Integer day = 0;
                    Integer month = 0;
                    Integer year = 0;
                    day = Integer.parseInt(valSplit[0]);
                    month = Integer.parseInt(valSplit[1]);
                    year = Integer.parseInt(valSplit[2]);
                    String formattedMonth = month < 10 ? "0" + month : String.valueOf(month);
                    String formattedDay = day < 10 ? "0" + day : String.valueOf(day);
                    String ymd = year + "-" + formattedMonth + "-" + formattedDay;
                    System.out.println("---" + ymd);
                    z.setTanggal(ymd);
                    z.setTglFaktur(ymd);
                    z.setMasaPajak(month);
                    z.setTahunPajak(year);
                }
                if (nameHeader.equalsIgnoreCase("Nama Customer")) {
                    z.setNamaPenjual(this.tblDatapdf.getValueAt(i, a1).toString());
                }
                if (nameHeader.equalsIgnoreCase("Npwp")) {
                    String npwpimport = null;
                    npwpimport = this.tblDatapdf.getValueAt(i, a1).toString();
                    if (npwpimport.length() == 15) {
                        z.setNpwpPenjual('0' + npwpimport);
                    } else {
                        z.setNpwpPenjual(npwpimport);
                    }
                }
                if (nameHeader.equalsIgnoreCase("PPn")) {
                    z.setJumlahPPN(this.tblDatapdf.getValueAt(i, a1).toString());
                    zi.setPpn(this.tblDatapdf.getValueAt(i, a1).toString());
                }
                if (nameHeader.equalsIgnoreCase("PPnBm")) {
                    z.setJumlanPPNBM(this.tblDatapdf.getValueAt(i, a1).toString());
                }
                if (nameHeader.equalsIgnoreCase("Dpp")) {
                    z.setJumlahDPP(this.tblDatapdf.getValueAt(i, a1).toString());
                    zi.setHargaSatuan(z.getJumlahDPP());
                    zi.setJumlahBarang("1");
                    zi.setDpp(z.getJumlahDPP());
                    zi.setDiskon("0");
                }
                if (nameHeader.equalsIgnoreCase("Alamat")) {
                    z.setAlamatPenjual(this.tblDatapdf.getValueAt(i, a1).toString());
                }
                if (nameHeader.equalsIgnoreCase("No Faktur")) {
                    z.setNomorFaktur(this.tblDatapdf.getValueAt(i, a1).toString());
                    String kodefaktur = z.getNomorFaktur().substring(0, 2);
                    z.setKode(kodefaktur);
                }
                if (nameHeader.equalsIgnoreCase("BarangJasa")) {
                    zi.setBarangJasa(this.tblDatapdf.getValueAt(i, a1).toString());
                }
                if (nameHeader.equalsIgnoreCase("SatuanUkur")) {
                    zi.setSatuanUkur(this.tblDatapdf.getValueAt(i, a1).toString());
                }
                if (nameHeader.equalsIgnoreCase("KodeBarang")) {
                    zi.setKodeBarang(this.tblDatapdf.getValueAt(i, a1).toString());
                }
                if (nameHeader.equalsIgnoreCase("Detail")) {
                    zi.setNama(this.tblDatapdf.getValueAt(i, a1).toString());
                }
                if (nameHeader.equalsIgnoreCase("Isjs")) {
                    isjson = this.tblDatapdf.getValueAt(i, a1).toString();
                    System.out.println("isjs");
                }
                if (nameHeader.equalsIgnoreCase("Details")) {
                    valjson = this.tblDatapdf.getValueAt(i, a1).toString();
                }
                if (a1 != 14) continue;
                Transaksi record = null;
                try {
                    record = this.daotrans.findByNomorFakturs(z.getNomorFaktur());
                }
                catch (SQLException ex) {
                    Logger.getLogger(ZImportTemplate.class.getName()).log(Level.SEVERE, null, ex);
                }
                idFaktur = record != null ? record.getId() : 0;
                System.out.println("fakturss " + idFaktur);
                if (idFaktur != 0) continue;
                try {
                    if (z.getNpwpLawan() == null) {
                        z.setNpwpLawan("0000000000000000");
                    }
                    this.daotrans.saveMaster(z);
                    zi.setTransaksiId(z.getId());
                    zi.setNoinvoice(z.getNoinvoice());
                    zi.setSatuanPPn(String.valueOf(this.mdi.profil.getTarif_ppn()));
                    double dpplains = 0.0;
                    if (isjson.equalsIgnoreCase("1")) {
                        JSONObject jsonObject = new JSONObject(valjson);
                        if (jsonObject.has("listBarang")) {
                            JSONArray partOrdersArray = jsonObject.getJSONArray("listBarang");
                            for (int ii = 0; ii < partOrdersArray.length(); ++ii) {
                                JSONObject partOrder = partOrdersArray.getJSONObject(ii);
                                String nama = partOrder.optString("deskripsi", "-");
                                String harga = partOrder.optString("hargaSatuan", "0");
                                String qty = partOrder.optString("qty", "0");
                                String diskon = partOrder.optString("potongan", "0");
                                String ppnbm = partOrder.optString("ppnbm", "0");
                                String dppval = partOrder.optString("netValue", "0");
                                String kodeval = partOrder.optString("kode", "0");
                                zi.setNama(nama);
                                double ppnbmval = Double.parseDouble(EFakturForm.normalizeNumber(ppnbm));
                                double ptongan = Double.parseDouble(EFakturForm.normalizeNumber(diskon));
                                double dpp = Double.parseDouble(EFakturForm.normalizeNumber(dppval));
                                double dppLain = dpp * 11.0 / 12.0;
                                double ppn = dpp * 11.0 / 100.0;
                                zi.setHargaSatuan(EFakturForm.normalizeNumber(harga));
                                zi.setDpp(String.format("%.2f", dpp));
                                zi.setDppLain(String.format("%.2f", dppLain));
                                zi.setPpn(String.format("%.2f", ppn));
                                zi.setJumlahBarang(EFakturForm.normalizeNumber(qty.trim()));
                                zi.setDiskon(String.format("%.2f", ptongan));
                                zi.setPpnbm(String.format("%.2f", ppnbmval));
                                zi.setKodeBarang(kodeval);
                                this.daotrans.saveDetail(zi);
                            }
                            continue;
                        }
                        System.out.println("Key 'listBarang' tidak ditemukan di JSON!");
                        continue;
                    }
                    double dpp = Double.valueOf(EFakturForm.normalizeNumber(zi.getDpp()));
                    double dppLain = dpp * 11.0 / 12.0;
                    zi.setDppLain(String.format("%.2f", dppLain));
                    this.daotrans.saveDetail(zi);
                    continue;
                }
                catch (SQLException ex) {
                    Logger.getLogger(ZImportTemplate.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.btnImportDataBaru.setEnabled(false);
        this.btnSimpanDataLink.setEnabled(false);
    }

    public static String[] extractTanggalDanReferensiAr(String text) {
        Matcher matchernitku;
        String tanggal = "-";
        String referensi = "-";
        String nitku = "-";
        Pattern tanggalPattern = Pattern.compile(",\\s*(\\d{1,2}\\s+[A-Za-z]+\\s+\\d{4})");
        Pattern referensiPattern = Pattern.compile("(?i)Referensi\\s*:?\\s*(.*?)\\)");
        Pattern patternnitku = Pattern.compile("\\d{22}");
        Matcher tanggalMatcher = tanggalPattern.matcher(text);
        Matcher referensiMatcher = referensiPattern.matcher(text);
        if (tanggalMatcher.find()) {
            String tanggalAsli = tanggalMatcher.group(1).replaceAll("\\s+", " ").trim();
            tanggal = EFakturForm.formatTanggal(tanggalAsli);
        }
        if (referensiMatcher.find()) {
            referensi = referensiMatcher.group(1);
        }
        if ((matchernitku = patternnitku.matcher(text)).find()) {
            nitku = matchernitku.group(0);
        }
        return new String[]{tanggal, referensi, nitku};
    }

    public static String extractTanggalDanReferensi(String text) {
        StringBuilder result = new StringBuilder();
        Pattern tanggalPattern = Pattern.compile(",\\s*(\\d{1,2}\\s+[A-Za-z]+\\s+\\d{4})");
        Pattern referensiPattern = Pattern.compile("\\(Referensi:\\s*(\\d+)\\)");
        Matcher tanggalMatcher = tanggalPattern.matcher(text);
        Matcher referensiMatcher = referensiPattern.matcher(text);
        result.append("=== INFORMASI TANGGAL & REFERENSI ===\n");
        if (tanggalMatcher.find()) {
            String tanggalAsli = tanggalMatcher.group(1);
            String tanggalFormatted = EFakturForm.formatTanggal(tanggalAsli);
            result.append("  - Tanggal: ").append(tanggalFormatted).append("\n");
        } else {
            result.append("  - Tanggal: Tidak ditemukan\n");
        }
        if (referensiMatcher.find()) {
            result.append("  - Referensi: ").append(referensiMatcher.group(1)).append("\n");
        } else {
            result.append("  - Referensi: Tidak ditemukan\n");
        }
        result.append("=====================================\n");
        return result.toString();
    }

    private static String formatTanggal(String input) {
        try {
            SimpleDateFormat originalFormat = new SimpleDateFormat("d MMMM yyyy", new Locale("id"));
            Date date = originalFormat.parse(input);
            SimpleDateFormat targetFormat = new SimpleDateFormat("d.MM.yyyy");
            return targetFormat.format(date);
        }
        catch (ParseException e) {
            return input;
        }
    }

    public static String[] extractTotalInfoAr(String text) {
        Pattern pattern = Pattern.compile("Harga Jual / Penggantian / Uang Muka / Termin\\s+([\\d\\.]+,\\d{2})\\s*Dikurangi Potongan Harga\\s+([\\d\\.]+,\\d{2})\\s*Dikurangi Uang Muka yang telah diterima\\s*([\\d\\.]+,\\d{2})?\\s*Dasar Pengenaan Pajak\\s+([\\d\\.]+,\\d{2})\\s*Jumlah PPN .*?\\s+([\\d\\.]+,\\d{2})\\s*Jumlah PPnBM .*?\\s+([\\d\\.]+,\\d{2})", 10);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String hargaJual = matcher.group(1);
            String potongan = matcher.group(2);
            String uangMuka = matcher.group(3) != null ? matcher.group(3) : "0,00";
            String dpp = matcher.group(4);
            String ppn = matcher.group(5);
            String ppnbm = matcher.group(6);
            return new String[]{EFakturForm.normalizeNumber(hargaJual), EFakturForm.normalizeNumber(potongan), EFakturForm.normalizeNumber(uangMuka), EFakturForm.normalizeNumber(dpp), EFakturForm.normalizeNumber(ppn), EFakturForm.normalizeNumber(ppnbm)};
        }
        return new String[]{"-", "-", "-", "-", "-", "-"};
    }

    private static String normalizeNumber(String input) {
        boolean hasDotDecimal;
        if (input == null || input.trim().isEmpty()) {
            return "0.00";
        }
        if ((input = input.trim()).matches("^[,.]?0{0,2}$") || input.matches("^[,.]00$")) {
            return "0.00";
        }
        boolean hasCommaDecimal = input.contains(",") && input.lastIndexOf(",") > input.lastIndexOf(".");
        boolean bl = hasDotDecimal = input.contains(".") && input.lastIndexOf(".") > input.lastIndexOf(",");
        if (hasCommaDecimal) {
            input = input.replaceAll("\\.", "").replace(",", ".");
        } else if (hasDotDecimal) {
            input = input.replaceAll(",", "");
        }
        try {
            double number = Double.parseDouble(input);
            DecimalFormat df = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
            return df.format(number);
        }
        catch (NumberFormatException e) {
            return "0.00";
        }
    }

    private static String normalizeNumberr(String input) {
        boolean hasDotDecimal;
        boolean hasCommaDecimal = input.contains(",") && input.lastIndexOf(",") > input.lastIndexOf(".");
        boolean bl = hasDotDecimal = input.contains(".") && input.lastIndexOf(".") > input.lastIndexOf(",");
        if (hasCommaDecimal) {
            input = input.replaceAll("\\.", "").replace(",", ".");
        } else if (hasDotDecimal) {
            input = input.replaceAll(",", "");
        }
        double number = Double.parseDouble(input);
        DecimalFormat df = new DecimalFormat("##.00", DecimalFormatSymbols.getInstance(Locale.US));
        return df.format(number);
    }

    public static String extractTotalInfo(String text) {
        StringBuilder result = new StringBuilder();
        Pattern pattern = Pattern.compile("Harga Jual / Penggantian / Uang Muka / Termin\\s+([\\d\\.]+,\\d{2})\\s*Dikurangi Potongan Harga\\s+([\\d\\.]+,\\d{2})\\s*Dikurangi Uang Muka yang telah diterima\\s*([\\d\\.]+,\\d{2})?\\s*Dasar Pengenaan Pajak\\s+([\\d\\.]+,\\d{2})\\s*Jumlah PPN .*?\\s+([\\d\\.]+,\\d{2})\\s*Jumlah PPnBM .*?\\s+([\\d\\.]+,\\d{2})", 10);
        Matcher matcher = pattern.matcher(text);
        result.append("=== INFORMASI TOTAL ===\n");
        if (matcher.find()) {
            result.append("  - Harga Jual / Termin: ").append(matcher.group(1)).append("\n");
            result.append("  - Potongan Harga: ").append(matcher.group(2)).append("\n");
            String uangMuka = matcher.group(3) != null ? matcher.group(3) : "0,00";
            result.append("  - Uang Muka Diterima: ").append(uangMuka).append("\n");
            result.append("  - Dasar Pengenaan Pajak: ").append(matcher.group(4)).append("\n");
            result.append("  - Jumlah PPN: ").append(matcher.group(5)).append("\n");
            result.append("  - Jumlah PPnBM: ").append(matcher.group(6)).append("\n");
        } else {
            result.append("  - Data tidak ditemukan\n");
        }
        result.append("========================\n");
        return result.toString();
    }

    private String renamefilepdf(File file, String namafile) {
        System.out.println("dadandkajdkja " + namafile);
        if (namafile == null || namafile.trim().isEmpty()) {
            return "Nama file kosong. Rename dibatalkan.";
        }
        String parentDir = file.getParent();
        String safeFileName = "tes" + namafile.toString() + "FP.pdf";
        File newFile = new File(parentDir, safeFileName);
        if (!file.exists()) {
            return "File sumber tidak ditemukan.";
        }
        if (!file.canWrite()) {
            return "Tidak punya izin untuk mengubah file.";
        }
        if (newFile.exists()) {
            return "File tujuan sudah ada: " + newFile.getName();
        }
        boolean success = file.renameTo(newFile);
        return success ? "Rename berhasil: " + newFile.getName() : "Rename gagal.";
    }

    private String renamefilepdf2(File file, String namafile) {
        System.out.println("dadandkajdkja " + namafile);
        String parentDir = file.getParent();
        System.out.println("parent " + parentDir);
        File newFile = new File(parentDir, namafile + "FP.pdf");
        boolean success = file.renameTo(newFile);
        if (success) {
            return "Rename berhasil: " + newFile.getName();
        }
        return "Rename gagal.";
    }

    private String extractInvoiceDataPM(File file) {
        File newfile = file;
        try (PDDocument document = PDDocument.load((File)file);){
            PDFTextStripper stripper = new PDFTextStripper();
            String text = stripper.getText(document);
            String productRegex = "(?s)(\\d+)\\s+(\\d{5,7})\\s+(.*?)\\s+(\\d+[\\d\\u00A0]*)\\s+(Each|Meter)\\s+([\\d.,]+)\\s+IDR\\s*/\\s*\\d+\\s+(?:Each|Meter).*?(\\d{1,2}\\s?%)\\s+([\\d.,]+)";
            String detailht = ZImportTemplate.detailDataProducHt(text, productRegex);
            String total = EFakturForm.extractTotalInfo(text);
            Object[] totalInfoArray = EFakturForm.extractTotalInfoAr(text);
            System.out.println(Arrays.toString(totalInfoArray));
            String tglDnRefreensi = EFakturForm.extractTanggalDanReferensi(text);
            String[] tglInvoArray = EFakturForm.extractTanggalDanReferensiAr(text);
            String regex = "(\\d+)\\s+(\\d{6})\\s+([\\s\\S]*?)Rp ([\\d\\.]+,\\d{2}) x ([\\d\\.]+,[\\d\\.]+) [^=\\n]+[\\s\\S]*?= Rp ([\\d\\.]+,\\d{2})[\\s\\S]*?= Rp ([\\d\\.]+,\\d{2})\\s+([\\d\\.]+,\\d{2})";
            String detail = EFakturForm.detailPrdkToJson(text, regex);
            String master = InvoicePDFPm.headerInfo(text);
            String[] masterArray = EFakturForm.headerInfoAr(text);
            String[] masterArrayPk = EFakturForm.headerInfoArPK(text);
            TempPdfpm z = null;
            z = new TempPdfpm();
            z.setNo_invoice(tglInvoArray[1]);
            z.setTgl_invoice(tglInvoArray[0]);
            z.setVat((String)totalInfoArray[4]);
            z.setDpp((String)totalInfoArray[0]);
            z.setTotal((String)totalInfoArray[0]);
            z.setPpnbm((String)totalInfoArray[5]);
            z.setCustomer(masterArray[0]);
            z.setNamafile(file.getName());
            z.setPathfilepdf(file.getParent());
            z.setNpwp(tglInvoArray[2]);
            z.setNofaktur(masterArray[4]);
            z.setAlamat(masterArrayPk[1]);
            z.setNitku(masterArrayPk[2]);
            z.setIsjson("1");
            z.setJsonval(detail);
            z.setDetail(z.getNofaktur() == null || !file.getName().contains("InputTaxInvoice") ? "FORMAT_SALAH" : "FORMAT_OK");
            this.daotrans.savePdfTmp(z);
            System.out.println("dddd" + text);
        }
        catch (Exception e) {
            return "Error reading PDF: " + e.getMessage();
        }
        return null;
    }

    public static String detailPrdkToJson(String text, String patternss) {
        Pattern r = Pattern.compile(patternss, 8);
        Matcher m = r.matcher(text);
        StringBuilder result = new StringBuilder();
        boolean found = false;
        result.append("{\n");
        result.append("  \"listBarang\": [\n");
        boolean first = true;
        while (m.find()) {
            found = true;
            if (!first) {
                result.append(",\n");
            }
            String deskripsi = m.group(3).replaceAll("\"", "\\\\\"").replaceAll("\\s+", " ").trim();
            result.append("    {\n").append("      \"line\": \"").append(m.group(1)).append("\",\n").append("      \"kode\": \"").append(m.group(2)).append("\",\n").append("      \"deskripsi\": \"").append(deskripsi).append("\",\n").append("      \"hargaSatuan\": \"").append(m.group(4)).append("\",\n").append("      \"qty\": \"").append(m.group(5)).append("\",\n").append("      \"potongan\": \"").append(m.group(6)).append("\",\n").append("      \"ppnbm\": \"").append(m.group(7)).append("\",\n").append("      \"netValue\": \"").append(m.group(8)).append("\"\n").append("    }");
            first = false;
        }
        result.append("\n  ]\n");
        if (!found) {
            return "{ \"message\": \"Data tidak ditemukan.\" }";
        }
        result.append("}");
        return result.toString();
    }

    public void kondisikanTableTemp() {
        this.tblDatapdf.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.tblDatapdf.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.tblDatapdf.getColumnModel().getColumn(2).setPreferredWidth(250);
        this.tblDatapdf.getColumnModel().getColumn(3).setPreferredWidth(90);
        this.tblDatapdf.getColumnModel().getColumn(4).setPreferredWidth(100);
        this.tblDatapdf.getColumnModel().getColumn(5).setPreferredWidth(80);
        this.tblDatapdf.getColumnModel().getColumn(6).setPreferredWidth(80);
        this.tblDatapdf.getColumnModel().getColumn(7).setPreferredWidth(80);
        this.tblDatapdf.getColumnModel().getColumn(8).setPreferredWidth(80);
        this.tblDatapdf.getColumnModel().getColumn(9).setPreferredWidth(80);
        this.tblDatapdf.getColumnModel().getColumn(10).setPreferredWidth(80);
        this.tblDatapdf.getColumnModel().getColumn(11).setPreferredWidth(80);
        this.tblDatapdf.getColumnModel().getColumn(12).setPreferredWidth(400);
    }

    public static String[] headerInfoArPK(String text) {
        Pattern fakturPattern;
        Matcher mFaktur;
        String nama = "-";
        String alamat = "-";
        String nitku = "-";
        String npwp = "-";
        String nomorFaktur = "-";
        Pattern pembeliPattern = Pattern.compile("Pembeli Barang Kena Pajak/Penerima Jasa Kena Pajak:\\s*Nama\\s*:\\s*(.*?)\\s*Alamat\\s*:\\s*([\\s\\S]*?)\\s*#(\\d+)\\s*NPWP\\s*:\\s*(\\d+)", 8);
        Matcher mPembeli = pembeliPattern.matcher(text);
        if (mPembeli.find()) {
            nama = mPembeli.group(1).replaceAll("\\s+", " ").trim();
            alamat = mPembeli.group(2).replaceAll("\\s+", " ").trim();
            nitku = mPembeli.group(3).trim();
            npwp = mPembeli.group(4).trim();
        }
        if ((mFaktur = (fakturPattern = Pattern.compile("Kode dan Nomor Seri Faktur Pajak:\\s*(\\d+)")).matcher(text)).find()) {
            nomorFaktur = mFaktur.group(1).trim();
        }
        return new String[]{nama, alamat, nitku, npwp, nomorFaktur};
    }

    public static String[] headerInfoAr(String text) {
        String nama = "-";
        String alamat = "-";
        String nitku = "-";
        String npwp = "-";
        String nomorFaktur = "-";
        Pattern alamatDanNitkuPattern = Pattern.compile("Alamat:\\s*([\\s\\S]*?)#([^\\s]+)\\s*Kode dan Nomor Seri Faktur Pajak", 8);
        Matcher matcherAlamatNitku = alamatDanNitkuPattern.matcher(text);
        Pattern fakturPattern = Pattern.compile("Kode dan Nomor Seri Faktur Pajak:\\s*(\\d+)");
        Pattern namaPattern = Pattern.compile("Nama\\s*:\\s*(.*)");
        Pattern npwpPattern = Pattern.compile("NPWP\\s*:\\s*(\\d+)");
        Matcher mFaktur = fakturPattern.matcher(text);
        Matcher mNama = namaPattern.matcher(text);
        Matcher mNpwp = npwpPattern.matcher(text);
        if (matcherAlamatNitku.find()) {
            alamat = matcherAlamatNitku.group(1).replaceAll("\\s+", " ").trim();
            nitku = matcherAlamatNitku.group(2).trim();
        }
        if (mFaktur.find()) {
            nomorFaktur = mFaktur.group(1);
        }
        if (mNama.find()) {
            nama = mNama.group(1).trim();
        }
        if (mNpwp.find()) {
            npwp = mNpwp.group(1).trim();
        }
        return new String[]{nama, alamat, nitku, npwp, nomorFaktur};
    }

    private void btnUploadPdf2btnProsesFakturActionPerformed(ActionEvent evt) {
        JFileChooser j = new JFileChooser();
        j.setFileSelectionMode(0);
        j.setMultiSelectionEnabled(true);
        Integer opt = j.showDialog(this.rootPane, "Pilih File");
        File[] file = j.getSelectedFiles();
        boolean data = false;
        this.setCursor(this.waitCursor);
        Object z = null;
        for (File f : file) {
            String namaFilepdf = f.getName();
            this.extractInvoiceDataPM(f);
        }
        this.setCursor(this.defaultCursor);
        this.tblDatapdf.setModel(this.daotrans.selectallTemp());
        this.hitungData();
        this.kondisikanTableTemp();
        JOptionPane.showMessageDialog(null, "Data Sukses Di Simpan");
    }

    public void hitungData() {
        this.jmlData.setText(String.valueOf(this.tblDatapdf.getRowCount()));
    }

    static {
        jumlah_data = 0;
        counter_data = 0;
    }
}

