/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CekErrorTaxInvoice {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Pilih File XML");
            int result = chooser.showOpenDialog(null);
            if (result == 0) {
                File xmlFile = chooser.getSelectedFile();
                String input = JOptionPane.showInputDialog(null, "Masukkan nomor baris error dari Coretax (pisahkan dengan koma jika lebih dari 1):", "Input Line Error", 3);
                if (input != null && !input.trim().isEmpty()) {
                    try {
                        String[] parts = input.split(",");
                        HashSet<Integer> targetLines = new HashSet<Integer>();
                        for (String p : parts) {
                            targetLines.add(Integer.parseInt(p.trim()));
                        }
                        CekErrorTaxInvoice.cekError(xmlFile, targetLines);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(null, "Nomor baris tidak valid!", "Error", 0);
                    }
                }
            }
        });
    }

    public static void cekError(File file, Set<Integer> targetLines) {
        String currentRefDesc = "";
        boolean insideTaxInvoice = false;
        LinkedHashMap<Integer, String> errorResults = new LinkedHashMap<Integer, String>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                ++lineNumber;
                if (line.contains("<TaxInvoice>")) {
                    insideTaxInvoice = true;
                    currentRefDesc = "";
                }
                if (insideTaxInvoice && line.contains("<RefDesc>")) {
                    currentRefDesc = line.replaceAll(".*<RefDesc>(.*?)</RefDesc>.*", "$1").trim();
                }
                if (targetLines.contains(lineNumber)) {
                    errorResults.put(lineNumber, "Baris " + lineNumber + ":\n" + line.trim() + "\nRefDesc: " + currentRefDesc);
                }
                if (!line.contains("</TaxInvoice>")) continue;
                insideTaxInvoice = false;
            }
            if (errorResults.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Tidak ditemukan data untuk baris yang dimasukkan.", "Hasil", 1);
            } else {
                StringBuilder sb = new StringBuilder();
                for (String info : errorResults.values()) {
                    sb.append(info).append("\n\n");
                }
                JOptionPane.showMessageDialog(null, sb.toString(), "Hasil Pencarian", 1);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Gagal membaca file: " + e.getMessage(), "Error", 0);
        }
    }
}

