/*
 * Decompiled with CFR 0.152.
 */
package esindo.net.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CekErrorCoretax {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(CekErrorCoretax::pilihFileDanLine);
    }

    private static void pilihFileDanLine() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Pilih File XML");
        chooser.setFileFilter(new FileNameExtensionFilter("File XML (*.xml)", "xml"));
        int result = chooser.showOpenDialog(null);
        if (result == 0) {
            File xmlFile = chooser.getSelectedFile();
            CekErrorCoretax.prosesLine(xmlFile);
        }
    }

    private static void prosesLine(File xmlFile) {
        String input = JOptionPane.showInputDialog(null, "Masukkan nomor baris error dari Coretax:", "Input Line Error", 3);
        if (input != null && !input.trim().isEmpty()) {
            try {
                int targetLine = Integer.parseInt(input.trim());
                boolean ulang = CekErrorCoretax.cariError(xmlFile, targetLine);
                if (ulang) {
                    CekErrorCoretax.prosesLine(xmlFile);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Nomor baris tidak valid!", "Error", 0);
                CekErrorCoretax.prosesLine(xmlFile);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean cariError(File file, int targetLine) {
        String currentRefDesc = "";
        String errorLineContent = "";
        boolean insideTaxInvoice = false;
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                ++lineNumber;
                if (line.contains("<TaxInvoice>")) {
                    insideTaxInvoice = true;
                    currentRefDesc = "";
                }
                if (insideTaxInvoice && line.contains("<RefDesc>")) {
                    currentRefDesc = line.replaceAll(".*<RefDesc>(.*?)</RefDesc>.*", "$1").trim();
                }
                if (lineNumber == targetLine) {
                    errorLineContent = line.trim();
                }
                if (!line.contains("</TaxInvoice>")) continue;
                if (!errorLineContent.isEmpty()) break;
                insideTaxInvoice = false;
            }
            if (!errorLineContent.isEmpty()) {
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                panel.add(new JLabel("Baris " + targetLine + ":"));
                panel.add(new JLabel(errorLineContent));
                panel.add(Box.createVerticalStrut(10));
                panel.add(new JLabel("RefDesc:"));
                JTextField refField = new JTextField(currentRefDesc);
                refField.setEditable(false);
                panel.add(refField);
                Object[] options = new Object[]{"Pilih Line Lagi", "Tutup"};
                int pilih = JOptionPane.showOptionDialog(null, panel, "Hasil Pencarian", -1, 1, null, options, options[0]);
                boolean bl2 = pilih == 0;
                return bl2;
            }
            JOptionPane.showMessageDialog(null, "Tidak ditemukan data untuk baris " + targetLine, "Error", 0);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Gagal membaca file: " + e.getMessage(), "Error", 0);
            return false;
        }
    }
}

