/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view.appearance.custom;

import datechooser.view.appearance.CellAppearance;
import datechooser.view.appearance.CellRenderer;
import datechooser.view.appearance.custom.CustomCellAttributes;
import datechooser.view.appearance.custom.CustomCellRenderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.border.Border;

public class CustomCellAppearance
extends CellAppearance
implements CustomCellAttributes {
    private Color cursorColor;
    private Font font;
    private Color textColor;
    private Color backgroundColor;
    private Border cellBorder;
    private float transparency;
    private transient float transparencyCash = -1.0f;
    private transient Composite composite;
    private CustomCellRenderer renderer;

    public CustomCellAppearance(Color backgroundColor, Color textColor, Border cellBorder, Font font, Color cursorColor, float transparency, Image texture) {
        this.setBackgroundColor(backgroundColor);
        this.setTextColor(textColor);
        this.setCellBorder(cellBorder);
        this.setFont(font);
        this.setCursorColor(cursorColor);
        this.setTransparency(transparency);
        this.renderer = new CustomCellRenderer(this);
    }

    public CustomCellAppearance(Color backgroundColor, Color textColor, Border cellBorder, Font font, Color cursorColor, float transparency) {
        this(backgroundColor, textColor, cellBorder, font, cursorColor, transparency, null);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Border getCellBorder() {
        return this.cellBorder;
    }

    public void setCellBorder(Border cellBorder) {
        this.cellBorder = cellBorder;
    }

    public Object clone() {
        CustomCellAppearance newInst = new CustomCellAppearance(this.getBackgroundColor(), this.getTextColor(), this.getCellBorder(), this.getFont(), this.getCursorColor(), this.getTransparency());
        newInst.setSelectable(this.isSelectable());
        return newInst;
    }

    public void assign(CellAppearance newAppearance) {
        if (newAppearance == null) {
            return;
        }
        CustomCellAppearance customAppearance = (CustomCellAppearance)newAppearance;
        this.setBackgroundColor(customAppearance.getBackgroundColor());
        this.setTextColor(customAppearance.getTextColor());
        this.setCellBorder(customAppearance.getCellBorder());
        this.setFont(customAppearance.getFont());
        this.setCursorColor(customAppearance.getCursorColor());
        this.setSelectable(customAppearance.isSelectable());
        this.setTransparency(customAppearance.getTransparency());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomCellAppearance value = (CustomCellAppearance)obj;
        return this.getBackgroundColor().equals(value.getBackgroundColor()) && this.getTextColor().equals(value.getTextColor()) && this.getCursorColor().equals(value.getCursorColor()) && this.getCellBorder().equals(value.getCellBorder()) && this.getFont().equals(value.getFont()) && this.getTransparency() == value.getTransparency();
    }

    protected CellRenderer getRenderer() {
        return this.renderer;
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(Color cursorColor) {
        this.cursorColor = cursorColor;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
    }

    public Composite getComposite() {
        if (this.transparency != this.transparencyCash) {
            this.transparencyCash = this.transparency;
            this.composite = AlphaComposite.getInstance(3, this.transparency);
        }
        return this.composite;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.transparencyCash = -1.0f;
    }
}

