/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.locale;

import java.util.ResourceBundle;
import javax.swing.UIManager;

public class LocaleUtils {
    private static final int EDITOR_BUNDLE = 0;
    private static final int CALENDAR_BUNDLE = 1;
    private static final int ERROR_BUNDLE = 2;
    private static final int CONFIG_BUNDLE = 3;
    private static final int GLOBAL_BUNDLE = 4;
    private static final int BUNDLES_COUNT = 5;
    private static ResourceBundle[] bundles = null;

    public static void prepareStandartDialogButtonText() {
        UIManager.put("OptionPane.cancelButtonText", LocaleUtils.getConfigLocaleString("Cancel"));
        UIManager.put("OptionPane.yesButtonText", LocaleUtils.getConfigLocaleString("Yes"));
        UIManager.put("OptionPane.noButtonText", LocaleUtils.getConfigLocaleString("No"));
        UIManager.put("FileChooser.cancelButtonText", LocaleUtils.getConfigLocaleString("Cancel"));
        UIManager.put("FileChooser.directoryOpenButtonText", LocaleUtils.getConfigLocaleString("Open"));
        UIManager.put("FileChooser.updateButtonText", LocaleUtils.getConfigLocaleString("Update"));
    }

    public static void reset() {
        bundles = null;
    }

    public static String getEditorLocaleString(String key) {
        return LocaleUtils.getLocaleString(0, key);
    }

    public static String getCalendarLocaleString(String key) {
        return LocaleUtils.getLocaleString(1, key);
    }

    public static String getErrorsLocaleString(String key) {
        return LocaleUtils.getLocaleString(2, key);
    }

    public static String getConfigLocaleString(String key) {
        return LocaleUtils.getLocaleString(3, key);
    }

    private LocaleUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String tryGetGlobal(String key) {
        String result = null;
        try {
            result = bundles[4].getString(key);
            return result;
        }
        finally {
            return result;
        }
    }

    private static String getLocaleString(int bundle, String key) {
        String result;
        if (bundles == null) {
            LocaleUtils.initBundles();
        }
        if ((result = LocaleUtils.tryGetGlobal(key)) == null) {
            result = bundles[bundle].getString(key);
        }
        return result;
    }

    private static void initBundles() {
        bundles = new ResourceBundle[5];
        LocaleUtils.bundles[0] = ResourceBundle.getBundle("datechooser/beans/locale/editors");
        LocaleUtils.bundles[1] = ResourceBundle.getBundle("datechooser/beans/locale/calendar");
        LocaleUtils.bundles[2] = ResourceBundle.getBundle("datechooser/beans/locale/errors");
        LocaleUtils.bundles[3] = ResourceBundle.getBundle("datechooser/beans/locale/config");
        LocaleUtils.bundles[4] = ResourceBundle.getBundle("datechooser/beans/locale/global");
    }
}

