/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.utils;

import datechooser.beans.locale.LocaleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class EditorDialog
extends JDialog {
    private PropertyEditorSupport propertyEditor;
    private JButton bOK;
    private JButton bCancel;
    private Object value;
    private Object defaultValue;
    private JPanel bPane;
    private boolean canceled;

    public EditorDialog(Frame owner, PropertyEditorSupport editor) {
        super(owner, true);
        this.propertyEditor = this.getClonedEditor(editor);
        this.setCanceled(false);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        OnClick onClick = new OnClick();
        this.bOK = new JButton(LocaleUtils.getEditorLocaleString("OK"));
        this.bOK.addActionListener(onClick);
        this.bCancel = new JButton(LocaleUtils.getEditorLocaleString("Cancel"));
        this.bCancel.addActionListener(onClick);
        this.bPane = new JPanel(new FlowLayout(2));
        this.bPane.add(this.bOK);
        this.bPane.add(this.bCancel);
        pane.add((Component)this.bPane, "South");
        this.tryToCreateEditorPanel(false);
        this.pack();
    }

    private PropertyEditorSupport getClonedEditor(PropertyEditorSupport editor) {
        PropertyEditorSupport newInst = null;
        try {
            newInst = (PropertyEditorSupport)editor.getClass().newInstance();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        newInst.setValue(editor.getValue());
        return newInst;
    }

    private void tryToCreateEditorPanel(boolean forceCreation) {
        if (this.getEditor().getValue() == null && !forceCreation) {
            return;
        }
        this.getContentPane().add(this.getEditor().getCustomEditor(), "Center");
    }

    private void setEditorToDefault() {
        this.getEditor().setValue(this.getDefaultValue());
        this.getEditor().firePropertyChange();
    }

    public Object getValue() {
        return this.value;
    }

    private void setValue(Object value) {
        this.value = value;
    }

    public Object showDialog(Object defaultValue, String prompt) {
        this.setDefaultValue(defaultValue);
        this.setEditorToDefault();
        this.tryToCreateEditorPanel(true);
        this.setTitle(prompt);
        this.setCanceled(true);
        this.showCentered();
        return this.getValue();
    }

    private void showCentered() {
        Dimension dim = this.getContentPane().getPreferredSize();
        this.setSize(dim.width + 100, dim.height + 80);
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        if (dim.width > screenSize.width || dim.height > screenSize.height) {
            this.setLocation(0, 0);
        } else {
            this.setLocation((screenSize.width - dim.width) / 2, (screenSize.height - dim.height) / 2);
        }
        this.setVisible(true);
    }

    public PropertyEditorSupport getEditor() {
        return this.propertyEditor;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    private class OnClick
    implements ActionListener {
        private OnClick() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == EditorDialog.this.bCancel) {
                EditorDialog.this.setValue(null);
                EditorDialog.this.setEditorToDefault();
                EditorDialog.this.setCanceled(true);
            }
            if (e.getSource() == EditorDialog.this.bOK) {
                EditorDialog.this.setValue(EditorDialog.this.getEditor().getValue());
                EditorDialog.this.setCanceled(false);
            }
            EditorDialog.this.setVisible(false);
        }
    }
}

