/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.font;

import datechooser.beans.editor.font.FontPreviewPane;
import datechooser.beans.editor.font.FontSelectPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JPanel;

class FontEditorPane
extends JPanel
implements PropertyChangeListener {
    private PropertyEditorSupport editor;
    private FontSelectPane selector;
    private FontPreviewPane preview;

    public FontEditorPane(PropertyEditorSupport editor) {
        this.setEditor(editor);
        this.selector = new FontSelectPane((Font)editor.getValue());
        this.preview = new FontPreviewPane((Font)editor.getValue());
        this.setLayout(new BorderLayout());
        this.add((Component)this.selector, "North");
        this.add((Component)this.preview, "Center");
        this.selector.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (!"font".equals(evt.getPropertyName())) {
                    return;
                }
                Font newFont = FontEditorPane.this.selector.getSelectedFont();
                FontEditorPane.this.preview.setFont(newFont);
                FontEditorPane.this.getEditor().setValue(newFont);
                FontEditorPane.this.getEditor().firePropertyChange();
            }
        });
    }

    public PropertyEditorSupport getEditor() {
        return this.editor;
    }

    public void setEditor(PropertyEditorSupport editor) {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this);
        }
        this.editor = editor;
        editor.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Font font = (Font)this.getEditor().getValue();
        this.selector.setSelectedFont(font);
        this.preview.setFont(font);
    }
}

