/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.descriptor;

import datechooser.beans.editor.descriptor.ClassDescriptor;
import datechooser.beans.editor.descriptor.DescriptionManager;
import datechooser.beans.locale.LocaleUtils;
import datechooser.model.multiple.Period;
import datechooser.model.multiple.PeriodSet;
import java.util.Locale;

public class PeriodSetDescriptor
extends ClassDescriptor {
    public Class getDescriptedClass() {
        return PeriodSet.class;
    }

    public String getJavaDescription(Object value) {
        PeriodSet pList = (PeriodSet)value;
        if (pList.getCount() == 0) {
            return "new " + this.getClassName() + "()";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("new " + this.getClassName() + "(");
        for (Period period : pList.getPeriods()) {
            buf.append(DescriptionManager.describeJava(period, Period.class));
            buf.append(this.getSeparator());
        }
        buf.delete(buf.length() - this.getSeparator().length(), buf.length());
        buf.append(")");
        return buf.toString();
    }

    public String getDescription(Object value) {
        return this.getDescription(value, Locale.getDefault());
    }

    public String getDescription(Object value, Locale locale) {
        PeriodSet pList = (PeriodSet)value;
        if (pList.getCount() == 0) {
            return LocaleUtils.getEditorLocaleString("null");
        }
        return DescriptionManager.describe(pList.getFirstPeriod(), locale) + (pList.getCount() > 1 ? " ..." : "");
    }
}

