/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.border.types;

import datechooser.beans.editor.border.types.AbstractBorderEditor;
import datechooser.beans.editor.utils.ColorChooseAction;
import datechooser.beans.editor.utils.ColorHolder;
import datechooser.beans.editor.utils.RiseLowPanel;
import datechooser.beans.locale.LocaleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class EtchedBorderEditor
extends AbstractBorderEditor
implements PropertyChangeListener {
    private int etchType;
    private ColorHolder highlight;
    private ColorHolder shadow;
    private RiseLowPanel selType;

    public EtchedBorderEditor() {
        this.initialize();
        this.highlight = new ColorHolder();
        this.shadow = new ColorHolder();
        this.setCaption(LocaleUtils.getEditorLocaleString("Etched"));
        this.assignValueToParameters();
        this.selType = new RiseLowPanel(this.etchType, 0, 1);
        this.selType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EtchedBorderEditor.this.etchType = EtchedBorderEditor.this.selType.getType();
                EtchedBorderEditor.this.fireChange();
            }
        });
        JButton bHigh = new JButton(LocaleUtils.getEditorLocaleString("Highlight"));
        ColorChooseAction colorChooseAction = new ColorChooseAction(this.highlight, LocaleUtils.getEditorLocaleString("Highlight"), this);
        colorChooseAction.addPropertyChangeListener(this);
        bHigh.addActionListener(colorChooseAction);
        JButton bShadow = new JButton(LocaleUtils.getEditorLocaleString("Shadow"));
        colorChooseAction = new ColorChooseAction(this.shadow, LocaleUtils.getEditorLocaleString("Shadow"), this);
        colorChooseAction.addPropertyChangeListener(this);
        bShadow.addActionListener(colorChooseAction);
        this.setLayout(new BorderLayout());
        JPanel totalPane = new JPanel(new GridLayout(2, 1));
        totalPane.add(this.selType);
        JPanel buttonPane = new JPanel(new GridLayout(1, 2));
        buttonPane.add(this.getCenteredPane(bHigh));
        buttonPane.add(this.getCenteredPane(bShadow));
        totalPane.add(buttonPane);
        this.add((Component)totalPane, "North");
        this.refreshInterface();
    }

    protected void prepareSelection() {
        this.setValue(new EtchedBorder(this.etchType, this.highlight.getColor(), this.shadow.getColor()));
    }

    private void assignValueToParameters() {
        this.etchType = this.getValue().getEtchType();
        this.highlight.setColor(this.getValue().getHighlightColor());
        this.shadow.setColor(this.getValue().getShadowColor());
    }

    protected EtchedBorder getValue() {
        return (EtchedBorder)this.value;
    }

    public void refreshInterface() {
        this.assignValueToParameters();
    }

    protected Border getDefaultValue() {
        return new EtchedBorder();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!"color".equals(evt.getPropertyName())) {
            return;
        }
        this.fireChange();
    }
}

