/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.border.types;

import datechooser.beans.editor.border.types.AbstractBorderEditor;
import datechooser.beans.editor.utils.ColorChooseAction;
import datechooser.beans.editor.utils.ColorHolder;
import datechooser.beans.editor.utils.RiseLowPanel;
import datechooser.beans.locale.LocaleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public abstract class AbstractBevelBorderEditor
extends AbstractBorderEditor
implements PropertyChangeListener {
    protected int bevelType;
    protected ColorHolder highlightOuter;
    protected ColorHolder highlightInner = new ColorHolder();
    protected ColorHolder shadowOuter;
    protected ColorHolder shadowInner;
    private RiseLowPanel selType;
    private JButton bHighOut;
    private JButton bHighIn;
    private JButton bShadowOut;
    private JButton bShadowIn;

    protected abstract Border getBorderByParams();

    public AbstractBevelBorderEditor() {
        this.highlightOuter = new ColorHolder();
        this.shadowInner = new ColorHolder();
        this.shadowOuter = new ColorHolder();
        this.initialize();
        this.selType = new RiseLowPanel(this.bevelType, 0, 1);
        this.selType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractBevelBorderEditor.this.bevelType = AbstractBevelBorderEditor.this.selType.getType();
                AbstractBevelBorderEditor.this.fireChange();
            }
        });
        this.bHighIn = new JButton(LocaleUtils.getEditorLocaleString("Highlight_innner"));
        ColorChooseAction colorChooseAction = new ColorChooseAction(this.highlightInner, LocaleUtils.getEditorLocaleString("Highlight_innner"), this);
        colorChooseAction.addPropertyChangeListener(this);
        this.bHighIn.addActionListener(colorChooseAction);
        this.bHighOut = new JButton(LocaleUtils.getEditorLocaleString("Highlight_outher"));
        colorChooseAction = new ColorChooseAction(this.highlightOuter, LocaleUtils.getEditorLocaleString("Highlight_outher"), this);
        colorChooseAction.addPropertyChangeListener(this);
        this.bHighOut.addActionListener(colorChooseAction);
        this.bShadowIn = new JButton(LocaleUtils.getEditorLocaleString("Shadow_innner"));
        colorChooseAction = new ColorChooseAction(this.shadowInner, LocaleUtils.getEditorLocaleString("Shadow_innner"), this);
        this.bShadowIn.addActionListener(colorChooseAction);
        this.bShadowOut = new JButton(LocaleUtils.getEditorLocaleString("Shadow_outher"));
        colorChooseAction = new ColorChooseAction(this.shadowOuter, LocaleUtils.getEditorLocaleString("Shadow_outher"), this);
        this.bShadowOut.addActionListener(colorChooseAction);
        this.setLayout(new BorderLayout());
        JPanel confPane = new JPanel(new BorderLayout());
        confPane.add((Component)this.selType, "North");
        JPanel buttonPane = new JPanel(new GridLayout(2, 2));
        buttonPane.add(this.getCenteredPane(this.bHighIn));
        buttonPane.add(this.getCenteredPane(this.bHighOut));
        buttonPane.add(this.getCenteredPane(this.bShadowIn));
        buttonPane.add(this.getCenteredPane(this.bShadowOut));
        confPane.add((Component)buttonPane, "South");
        this.add((Component)confPane, "North");
        this.refreshInterface();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!"color".equals(evt.getPropertyName())) {
            return;
        }
        this.firePropertyChange("border", null, null);
    }

    public void prepareSelection() {
        this.setValue(this.getBorderByParams());
    }

    private void assignValueToParameters() {
        this.bevelType = this.getValue().getBevelType();
        this.highlightOuter.setColor(this.getValue().getHighlightOuterColor());
        this.highlightInner.setColor(this.getValue().getHighlightInnerColor());
        this.shadowOuter.setColor(this.getValue().getShadowOuterColor());
        this.shadowInner.setColor(this.getValue().getShadowInnerColor());
    }

    protected BevelBorder getValue() {
        return (BevelBorder)this.value;
    }

    public void refreshInterface() {
        this.assignValueToParameters();
        this.selType.setType(this.bevelType);
    }
}

