/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedDataGenerator;

class CMSSignedHelper {
    static final CMSSignedHelper INSTANCE = new CMSSignedHelper();

    CMSSignedHelper() {
    }

    String getDigestAlgName(String string) {
        if (PKCSObjectIdentifiers.md5.getId().equals(string)) {
            return "MD5";
        }
        if (OIWObjectIdentifiers.idSHA1.getId().equals(string)) {
            return "SHA1";
        }
        if (NISTObjectIdentifiers.id_sha224.getId().equals(string)) {
            return "SHA224";
        }
        if (NISTObjectIdentifiers.id_sha256.getId().equals(string)) {
            return "SHA256";
        }
        if (NISTObjectIdentifiers.id_sha384.getId().equals(string)) {
            return "SHA384";
        }
        if (NISTObjectIdentifiers.id_sha512.getId().equals(string)) {
            return "SHA512";
        }
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equals(string)) {
            return "SHA1";
        }
        if (PKCSObjectIdentifiers.sha224WithRSAEncryption.getId().equals(string)) {
            return "SHA224";
        }
        if (PKCSObjectIdentifiers.sha256WithRSAEncryption.getId().equals(string)) {
            return "SHA256";
        }
        if (PKCSObjectIdentifiers.sha384WithRSAEncryption.getId().equals(string)) {
            return "SHA384";
        }
        if (PKCSObjectIdentifiers.sha512WithRSAEncryption.getId().equals(string)) {
            return "SHA512";
        }
        if (TeleTrusTObjectIdentifiers.ripemd128.getId().equals(string)) {
            return "RIPEMD128";
        }
        if (TeleTrusTObjectIdentifiers.ripemd160.getId().equals(string)) {
            return "RIPEMD160";
        }
        if (TeleTrusTObjectIdentifiers.ripemd256.getId().equals(string)) {
            return "RIPEMD256";
        }
        if (CryptoProObjectIdentifiers.gostR3411.getId().equals(string)) {
            return "GOST3411";
        }
        return string;
    }

    String getEncryptionAlgName(String string) {
        if (X9ObjectIdentifiers.id_dsa_with_sha1.getId().equals(string)) {
            return "DSA";
        }
        if (X9ObjectIdentifiers.id_dsa.getId().equals(string)) {
            return "DSA";
        }
        if (OIWObjectIdentifiers.dsaWithSHA1.getId().equals(string)) {
            return "DSA";
        }
        if (PKCSObjectIdentifiers.rsaEncryption.getId().equals(string)) {
            return "RSA";
        }
        if (PKCSObjectIdentifiers.sha1WithRSAEncryption.getId().equals(string)) {
            return "RSA";
        }
        if ("1.3.36.3.3.1".equals(string)) {
            return "RSA";
        }
        if (CMSSignedDataGenerator.ENCRYPTION_ECDSA.equals(string)) {
            return "ECDSA";
        }
        if (CMSSignedDataGenerator.ENCRYPTION_RSA_PSS.equals(string)) {
            return "RSAandMGF1";
        }
        if (CryptoProObjectIdentifiers.gostR3410_94.getId().equals(string)) {
            return "GOST3410";
        }
        if (CryptoProObjectIdentifiers.gostR3410_2001.getId().equals(string)) {
            return "ECGOST3410";
        }
        return string;
    }

    MessageDigest getDigestInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 != null) {
            try {
                return MessageDigest.getInstance(string, string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return MessageDigest.getInstance(string);
            }
        }
        return MessageDigest.getInstance(string);
    }

    Signature getSignatureInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 != null) {
            return Signature.getInstance(string, string2);
        }
        return Signature.getInstance(string);
    }
}

