/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.sasn1.Asn1Integer;
import org.bouncycastle.sasn1.Asn1ObjectIdentifier;
import org.bouncycastle.sasn1.BerGenerator;
import org.bouncycastle.sasn1.BerOctetStringGenerator;
import org.bouncycastle.sasn1.BerSequenceGenerator;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private List _certs = new ArrayList();
    private List _crls = new ArrayList();
    private List _signerInfs = new ArrayList();
    private List _signers = new ArrayList();
    private List _digests = new ArrayList();
    private int _bufferSize;

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, null, null, string2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        String string3 = this.getEncOID(privateKey, string);
        String string4 = CMSSignedHelper.INSTANCE.getDigestAlgName(string);
        String string5 = string4 + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(string3);
        Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance(string5, string2);
        MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string4, string2);
        signature.initSign(privateKey);
        this._signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string3, attributeTable, attributeTable2, messageDigest, signature));
        this._digests.add(messageDigest);
    }

    public void addSigners(SignerInformationStore signerInformationStore) {
        Iterator iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            this._signers.add(iterator.next());
        }
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, CMSException {
        try {
            for (X509Certificate x509Extension : certStore.getCertificates(null)) {
                this._certs.add(new X509CertificateStructure((ASN1Sequence)this.makeObj(x509Extension.getEncoded())));
            }
        }
        catch (IOException iOException) {
            throw new CMSException("error processing certs", iOException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CMSException("error encoding certs", certificateEncodingException);
        }
        try {
            for (X509CRL x509CRL : certStore.getCRLs(null)) {
                this._crls.add(new CertificateList((ASN1Sequence)this.makeObj(x509CRL.getEncoded())));
            }
        }
        catch (IOException iOException) {
            throw new CMSException("error processing crls", iOException);
        }
        catch (CRLException cRLException) {
            throw new CMSException("error encoding crls", cRLException);
        }
    }

    private DERObject makeObj(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        return aSN1InputStream.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)this.makeObj(byArray));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)new DERNull());
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        return this.open(outputStream, false);
    }

    public OutputStream open(OutputStream outputStream, boolean bl) throws IOException {
        return this.open(outputStream, DATA, bl);
    }

    public OutputStream open(OutputStream outputStream, String string, boolean bl) throws IOException {
        Object object;
        Object object22;
        BerSequenceGenerator berSequenceGenerator = new BerSequenceGenerator(outputStream);
        berSequenceGenerator.addObject(new Asn1ObjectIdentifier(CMSObjectIdentifiers.signedData.getId()));
        BerSequenceGenerator berSequenceGenerator2 = new BerSequenceGenerator(berSequenceGenerator.getRawOutputStream(), 0, true);
        berSequenceGenerator2.addObject(this.getVersion(string));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (Object object22 : this._signers) {
            object = this.makeAlgId(((SignerInformation)object22).getDigestAlgOID(), ((SignerInformation)object22).getDigestAlgParams());
            aSN1EncodableVector.add((DEREncodable)object);
        }
        for (Object object22 : this._signerInfs) {
            object = this.makeAlgId(((SignerInf)object22).getDigestAlgOID(), ((SignerInf)object22).getDigestAlgParams());
            aSN1EncodableVector.add((DEREncodable)object);
        }
        berSequenceGenerator2.getRawOutputStream().write(new DERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
        object22 = new BerSequenceGenerator(berSequenceGenerator2.getRawOutputStream());
        ((BerSequenceGenerator)object22).addObject(new Asn1ObjectIdentifier(string));
        if (bl) {
            BerOctetStringGenerator berOctetStringGenerator = new BerOctetStringGenerator(((BerGenerator)object22).getRawOutputStream(), 0, true);
            object = this._bufferSize != 0 ? berOctetStringGenerator.getOctetOutputStream(new byte[this._bufferSize]) : berOctetStringGenerator.getOctetOutputStream();
        } else {
            object = new NullOutputStream();
        }
        Iterator iterator = this._digests.iterator();
        while (iterator.hasNext()) {
            object = new DigestOutputStream((OutputStream)object, (MessageDigest)iterator.next());
        }
        return new CmsSignedDataOutputStream((OutputStream)object, string, berSequenceGenerator, berSequenceGenerator2, (BerSequenceGenerator)object22);
    }

    private Asn1Integer getVersion(String string) {
        int n = 0;
        n = this.anyCertHasTypeOther() || this.anyCrlHasTypeOther() ? 5 : (this.anyCertHasV2Attribute() ? 4 : (this.anyCertHasV1Attribute() || !string.equals(DATA) ? 3 : 1));
        return new Asn1Integer(n);
    }

    private boolean anyCertHasTypeOther() {
        return false;
    }

    private boolean anyCertHasV1Attribute() {
        return false;
    }

    private boolean anyCertHasV2Attribute() {
        return false;
    }

    private boolean anyCrlHasTypeOther() {
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private DERObjectIdentifier _contentOID;
        private BerSequenceGenerator _sGen;
        private BerSequenceGenerator _sigGen;
        private BerSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream outputStream, String string, BerSequenceGenerator berSequenceGenerator, BerSequenceGenerator berSequenceGenerator2, BerSequenceGenerator berSequenceGenerator3) {
            this._out = outputStream;
            this._contentOID = new DERObjectIdentifier(string);
            this._sGen = berSequenceGenerator;
            this._sigGen = berSequenceGenerator2;
            this._eiGen = berSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        public void close() throws IOException {
            Iterator iterator;
            ASN1EncodableVector aSN1EncodableVector;
            this._out.close();
            this._eiGen.close();
            if (CMSSignedDataStreamGenerator.this._certs.size() != 0) {
                aSN1EncodableVector = new ASN1EncodableVector();
                iterator = CMSSignedDataStreamGenerator.this._certs.iterator();
                while (iterator.hasNext()) {
                    aSN1EncodableVector.add((DEREncodable)iterator.next());
                }
                this._sigGen.getRawOutputStream().write(new DERTaggedObject(false, 0, (DEREncodable)new DERSet((DEREncodableVector)aSN1EncodableVector)).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this._crls.size() != 0) {
                aSN1EncodableVector = new ASN1EncodableVector();
                iterator = CMSSignedDataStreamGenerator.this._crls.iterator();
                while (iterator.hasNext()) {
                    aSN1EncodableVector.add((DEREncodable)iterator.next());
                }
                this._sigGen.getRawOutputStream().write(new DERTaggedObject(false, 1, (DEREncodable)new DERSet((DEREncodableVector)aSN1EncodableVector)).getEncoded());
            }
            aSN1EncodableVector = new ASN1EncodableVector();
            for (Object object : CMSSignedDataStreamGenerator.this._signers) {
                aSN1EncodableVector.add((DEREncodable)((SignerInformation)object).toSignerInfo());
            }
            for (Object object : CMSSignedDataStreamGenerator.this._signerInfs) {
                try {
                    aSN1EncodableVector.add((DEREncodable)((SignerInf)object).toSignerInfo(this._contentOID, true));
                }
                catch (IOException iOException) {
                    throw new IOException("encoding error." + iOException);
                }
                catch (SignatureException signatureException) {
                    throw new IOException("error creating signature." + signatureException);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("error creating sid." + certificateEncodingException);
                }
            }
            this._sigGen.getRawOutputStream().write(new DERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int n) throws IOException {
        }
    }

    private class SignerInf {
        PrivateKey _key;
        X509Certificate _cert;
        String _digestOID;
        String _encOID;
        AttributeTable _sAttr;
        AttributeTable _unsAttr;
        MessageDigest _digest;
        Signature _signature;

        SignerInf(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2, MessageDigest messageDigest, Signature signature) {
            this._key = privateKey;
            this._cert = x509Certificate;
            this._digestOID = string;
            this._encOID = string2;
            this._sAttr = attributeTable;
            this._unsAttr = attributeTable2;
            this._digest = messageDigest;
            this._signature = signature;
        }

        PrivateKey getKey() {
            return this._key;
        }

        X509Certificate getCertificate() {
            return this._cert;
        }

        String getDigestAlgOID() {
            return this._digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this._encOID;
        }

        AttributeTable getSignedAttributes() {
            return this._sAttr;
        }

        AttributeTable getUnsignedAttributes() {
            return this._unsAttr;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier dERObjectIdentifier, boolean bl) throws IOException, SignatureException, CertificateEncodingException {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), (DEREncodable)new DERNull());
            AlgorithmIdentifier algorithmIdentifier2 = this.getEncryptionAlgOID().equals(CMSSignedGenerator.ENCRYPTION_DSA) ? new AlgorithmIdentifier(new DERObjectIdentifier(this.getEncryptionAlgOID())) : new AlgorithmIdentifier(new DERObjectIdentifier(this.getEncryptionAlgOID()), (DEREncodable)new DERNull());
            byte[] byArray = this._digest.digest();
            ASN1Set aSN1Set = CMSSignedDataStreamGenerator.this.getSignedAttributeSet(dERObjectIdentifier, byArray, this.getSignedAttributes(), bl);
            ASN1Set aSN1Set2 = CMSSignedDataStreamGenerator.this.getUnsignedAttributeSet(this.getUnsignedAttributes());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (aSN1Set == null) {
                throw new RuntimeException("signatures without signed attributes not implemented.");
            }
            DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)byteArrayOutputStream);
            dEROutputStream.writeObject((Object)aSN1Set);
            this._signature.update(byteArrayOutputStream.toByteArray());
            dEROutputStream = new DEROctetString(this._signature.sign());
            X509Certificate x509Certificate = this.getCertificate();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate.getTBSCertificate());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)aSN1InputStream.readObject());
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(tBSCertificateStructure.getIssuer(), tBSCertificateStructure.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(issuerAndSerialNumber), algorithmIdentifier, aSN1Set, algorithmIdentifier2, (ASN1OctetString)dEROutputStream, aSN1Set2);
        }
    }

    static class SigOutputStream
    extends OutputStream {
        Signature sig;

        public SigOutputStream(Signature signature) {
            this.sig = signature;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.sig.update(byArray, n, n2);
            }
            catch (SignatureException signatureException) {
                throw new IOException("signature problem: " + signatureException);
            }
        }

        public void write(int n) throws IOException {
            try {
                this.sig.update((byte)n);
            }
            catch (SignatureException signatureException) {
                throw new IOException("signature problem: " + signatureException);
            }
        }
    }

    static class DigOutputStream
    extends OutputStream {
        MessageDigest dig;

        public DigOutputStream(MessageDigest messageDigest) {
            this.dig = messageDigest;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }
    }
}

