/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFXref;
import java.lang.ref.SoftReference;

public class PDFXrefEntry {
    private static final PDFXrefEntry FREED_OBJECT = new PDFXrefEntry(Type.FREE, -1, -1, null);
    private Type type;
    private int generation;
    private int offset;
    private PDFXref stream;
    private int[] objectIndexOffsets = null;
    private SoftReference<PDFObject> target = null;

    static PDFXrefEntry toBodyObject(int generation, int offset) {
        return new PDFXrefEntry(Type.OBJ_IN_BODY, generation, offset, null);
    }

    static PDFXrefEntry toStreamObject(PDFXref stream, int index) {
        return new PDFXrefEntry(Type.OBJ_IN_STREAM, 0, index, stream);
    }

    static PDFXrefEntry forFreedObject() {
        return FREED_OBJECT;
    }

    public boolean resolves(PDFXref ref) {
        return this.type != Type.FREE && this.generation == ref.getGeneration();
    }

    private PDFXrefEntry(Type type, int generation, int offset, PDFXref stream) {
        this.type = type;
        this.generation = generation;
        this.offset = offset;
        this.stream = stream;
    }

    public int getOffset() {
        return this.offset;
    }

    public PDFXref getStream() {
        return this.stream;
    }

    public Type getType() {
        return this.type;
    }

    public int getGeneration() {
        return this.generation;
    }

    public PDFObject getObject() {
        if (this.target != null) {
            return this.target.get();
        }
        return null;
    }

    public void setObject(PDFObject obj) {
        this.target = new SoftReference<PDFObject>(obj);
    }

    public int[] getObjectIndexOffsets() {
        return this.objectIndexOffsets;
    }

    public void setObjectIndexOffsets(int[] objectIndexOffsets) {
        this.objectIndexOffsets = objectIndexOffsets;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        FREE,
        OBJ_IN_BODY,
        OBJ_IN_STREAM;


        public static Type forTypeField(int i) {
            if (i > 0 && i < 3) {
                return Type.values()[i];
            }
            return FREE;
        }

        public PDFXrefEntry makeXrefStreamEntry(int field2, int field3) {
            switch (this) {
                case FREE: {
                    return PDFXrefEntry.forFreedObject();
                }
                case OBJ_IN_BODY: {
                    return PDFXrefEntry.toBodyObject(field3, field2);
                }
                case OBJ_IN_STREAM: {
                    return PDFXrefEntry.toStreamObject(new PDFXref(field2, 0), field3);
                }
            }
            throw new UnsupportedOperationException("Unhandled xref entry type " + (Object)((Object)this));
        }
    }
}

